/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateApplicationVersionRequestMarshaller
implements Marshaller<Request<CreateApplicationVersionRequest>, CreateApplicationVersionRequest> {
    @Override
    public Request<CreateApplicationVersionRequest> marshall(CreateApplicationVersionRequest createApplicationVersionRequest) {
        DefaultRequest<CreateApplicationVersionRequest> request = new DefaultRequest<CreateApplicationVersionRequest>(createApplicationVersionRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        if (createApplicationVersionRequest != null && createApplicationVersionRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(createApplicationVersionRequest.getApplicationName()));
        }
        if (createApplicationVersionRequest != null && createApplicationVersionRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString(createApplicationVersionRequest.getVersionLabel()));
        }
        if (createApplicationVersionRequest != null && createApplicationVersionRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createApplicationVersionRequest.getDescription()));
        }
        if (createApplicationVersionRequest != null) {
            S3Location sourceBundle = createApplicationVersionRequest.getSourceBundle();
            if (sourceBundle != null && sourceBundle.getS3Bucket() != null) {
                request.addParameter("SourceBundle.S3Bucket", StringUtils.fromString(sourceBundle.getS3Bucket()));
            }
            if (sourceBundle != null && sourceBundle.getS3Key() != null) {
                request.addParameter("SourceBundle.S3Key", StringUtils.fromString(sourceBundle.getS3Key()));
            }
        }
        if (createApplicationVersionRequest != null && createApplicationVersionRequest.isAutoCreateApplication() != null) {
            request.addParameter("AutoCreateApplication", StringUtils.fromBoolean(createApplicationVersionRequest.isAutoCreateApplication()));
        }
        return request;
    }
}

