/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class MIDletScanner
implements Runnable {
    private final J2MEProjectProperties props;
    private J2MEPlatform activePlatform;
    private final HashMap<FileObject, HashSet<String>> roots2icons = new HashMap();
    private final HashMap<FileObject, HashSet<String>> roots2midlets = new HashMap();
    private final HashMap<FileObject, HashSet<DefaultComboBoxModel>> roots2iconModels = new HashMap();
    private final HashMap<FileObject, HashSet<DefaultComboBoxModel>> roots2midletModelts = new HashMap();
    private final HashSet<ChangeListener> listeners = new HashSet();
    private boolean parsing = false;
    private static Reference<MIDletScanner> cache = new WeakReference<Object>(null);
    private static Pattern p = Pattern.compile("\\s+extends\\s+(javax\\.microedition\\.midlet\\.)?MIDlet");

    public static MIDletScanner getDefault(J2MEProjectProperties props) {
        MIDletScanner sc = cache.get();
        if (sc == null || sc.props != props) {
            sc = new MIDletScanner(props);
            cache = new WeakReference<MIDletScanner>(sc);
        }
        return sc;
    }

    private MIDletScanner(J2MEProjectProperties props) {
        this.props = props;
    }

    public boolean isScanning() {
        return this.parsing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(DefaultComboBoxModel midlets, DefaultComboBoxModel icons, ChangeListener l) {
        MIDletScanner mIDletScanner = this;
        synchronized (mIDletScanner) {
            for (FileObject root : this.getRootsFor()) {
                HashSet models;
                if (icons != null) {
                    icons.removeAllElements();
                    models = this.roots2iconModels.get(root);
                    if (models == null) {
                        models = new HashSet();
                        this.roots2iconModels.put(root, models);
                    }
                    models.add(icons);
                }
                if (midlets == null) continue;
                midlets.removeAllElements();
                models = this.roots2midletModelts.get(root);
                if (models == null) {
                    models = new HashSet();
                    this.roots2midletModelts.put(root, models);
                }
                models.add(midlets);
            }
            String platform = this.props.getEvaluator().getProperty("platform.active");
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
            for (int i = 0; platform != null && i < platforms.length; ++i) {
                J2MEPlatform pl = (J2MEPlatform)platforms[i];
                if (!platform.equals(pl.getName())) continue;
                this.activePlatform = pl;
                break;
            }
            this.listeners.add(l);
            if (!this.parsing) {
                this.parsing = true;
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }
    }

    private void fireStateChanged() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener chl : this.listeners) {
            chl.stateChanged(e);
        }
        this.listeners.clear();
    }

    private Collection<FileObject> getArchiveRoots(FileObject[] fo) {
        ArrayList<FileObject> files = new ArrayList<FileObject>(fo.length);
        for (FileObject foi : fo) {
            files.add(FileUtil.isArchiveFile((FileObject)foi) ? FileUtil.getArchiveRoot((FileObject)foi) : foi);
        }
        return files;
    }

    private HashSet<FileObject> getRootsFor() {
        HashSet<FileObject> roots = new HashSet<FileObject>();
        roots.addAll(Arrays.asList(this.props.getProject().getSourceRoots().getRoots()));
        return roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileObject root = null;
        while (true) {
            HashSet<String> midlets;
            HashSet<String> icons;
            MIDletScanner mIDletScanner = this;
            synchronized (mIDletScanner) {
                HashSet<DefaultComboBoxModel> models = this.roots2iconModels.remove(root);
                if (models != null) {
                    this.fillModels(models, this.roots2icons.get(root));
                }
                if ((models = this.roots2midletModelts.remove(root)) != null) {
                    this.fillModels(models, this.roots2midlets.get(root));
                }
                if ((root = this.getNextRoot()) == null) {
                    this.parsing = false;
                    this.fireStateChanged();
                    return;
                }
                if (this.roots2icons.containsKey(root)) {
                    continue;
                }
                icons = new HashSet<String>();
                midlets = new HashSet<String>();
                this.roots2icons.put(root, icons);
                this.roots2midlets.put(root, midlets);
            }
            try {
                this.scanForMIDletsAndIcons(root, icons, midlets);
            }
            catch (Exception exception) {
            }
        }
    }

    private FileObject getNextRoot() {
        if (!this.roots2iconModels.isEmpty()) {
            return this.roots2iconModels.keySet().iterator().next();
        }
        if (!this.roots2midletModelts.isEmpty()) {
            return this.roots2midletModelts.keySet().iterator().next();
        }
        return null;
    }

    private void fillModels(HashSet<DefaultComboBoxModel> models, HashSet<String> elements) {
        for (DefaultComboBoxModel m : models) {
            for (String s : elements) {
                if (m.getIndexOf(s) >= 0) continue;
                m.addElement(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForMIDletsAndIcons(FileObject root, HashSet<String> icons, HashSet<String> midlets) {
        String rootPath = root.getPath();
        int rootLength = rootPath.length();
        Enumeration en = root.getChildren(true);
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            if (!fo.isData()) continue;
            String ext = fo.getExt().toLowerCase();
            if ("png".equals(ext)) {
                String name = fo.getPath().substring(rootLength);
                if (!name.startsWith("/")) {
                    name = "/" + name;
                }
                MIDletScanner mIDletScanner = this;
                synchronized (mIDletScanner) {
                    icons.add(name);
                    continue;
                }
            }
            if (!"java".equals(ext) && !"class".equals(ext) || this.activePlatform == null || !this.isMIDlet(fo)) continue;
            MIDletScanner mIDletScanner = this;
            synchronized (mIDletScanner) {
                String name = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
                midlets.add(name.substring(0, name.length() - ext.length() - 1).replace('/', '.').replace('\\', '.'));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMIDlet(FileObject fo) {
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new InputStreamReader(fo.getInputStream()));
            while ((s = br.readLine()) != null) {
                if (s.indexOf("javax/microedition/midlet/MIDlet") < 0 && !p.matcher(s).find()) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

