/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.services.strikeiron.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.websvc.saas.services.strikeiron.ui.HeaderPanel;
import org.netbeans.modules.websvc.saas.spi.ServiceData;
import org.openide.awt.HtmlBrowser;

public class ServiceDetailPanel
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private JScrollPane scrollPane;
    private HeaderPanel header = new HeaderPanel();
    private ServiceData currentData;

    public ServiceDetailPanel() {
        MatteBorder outsideBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray);
        Border insideBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outsideBorder, insideBorder);
        this.header.setBorder(compoundBorder);
        this.initHtmlKit();
        this.header.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (10 == evt.getKeyCode() && ServiceDetailPanel.this.currentData != null) {
                    ServiceDetailPanel.this.currentData.setPackageName(ServiceDetailPanel.this.header.getPackageName());
                }
            }
        });
        this.header.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                if (ServiceDetailPanel.this.currentData != null) {
                    ServiceDetailPanel.this.currentData.setPackageName(ServiceDetailPanel.this.header.getPackageName());
                }
            }
        });
    }

    private void initHtmlKit() {
        HTMLEditorKit htmlkit = new HTMLEditorKit();
        StyleSheet css = htmlkit.getStyleSheet();
        if (css.getStyleSheets() == null) {
            StyleSheet css2 = new StyleSheet();
            Font f = new JList().getFont();
            int size = f.getSize();
            css2.addRule(new StringBuffer("body { font-size: ").append(size).append("; font-family: ").append(f.getName()).append("; }").toString());
            css2.addStyleSheet(css);
            htmlkit.setStyleSheet(css2);
        }
        this.setEditorKit(htmlkit);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hlevt) {
                if (HyperlinkEvent.EventType.ACTIVATED == hlevt.getEventType()) {
                    assert (hlevt.getURL() != null);
                    ServiceDetailPanel.showURL(hlevt.getURL());
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getScrollPane();
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    private JScrollPane getScrollPane() {
        Container gp;
        Container p;
        if (this.scrollPane == null && (p = this.getParent()) instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            this.scrollPane = (JScrollPane)gp;
        }
        return this.scrollPane;
    }

    void clear() {
        this.setCurrentService(null);
    }

    void setCurrentService(ServiceData service) {
        if (this.currentData != null) {
            this.currentData.setPackageName(this.header.getPackageName());
        }
        this.currentData = service;
        if (this.currentData != null) {
            this.getScrollPane().setColumnHeaderView(this.header);
            this.header.setPackageName(this.currentData.getPackageName());
            this.setTitle(this.currentData.getServiceName());
            this.setDetails();
        } else {
            this.setTitle("");
            this.header.setPackageName("");
            this.setText("");
        }
    }

    public void setTitle(String value) {
        if (value != null) {
            this.header.setTitle("<html><h3>" + value + "</h3></html>");
        } else {
            this.header.setTitle("");
        }
    }

    private void setDetails() {
        StringBuilder details = new StringBuilder();
        if (this.currentData != null) {
            String wsdl = this.currentData.getUrl();
            String info = this.currentData.getInfoPage();
            String link = this.currentData.getPurchaseLink();
            details.append("<b>Version: </b>" + this.currentData.getVersion() + "<br>");
            details.append("<b>Provider: </b>" + this.currentData.getProviderName() + "<br>");
            details.append("<h3>Description: </h3>" + this.currentData.getDescription() + "<br>");
            details.append("<br>");
            details.append("<b>WSDL Location: </b><br><a href=\"" + wsdl + "\">" + wsdl + "</a><br>");
            details.append("<br>");
            details.append("<b>Info Page: </b><br><a href=\"" + info + "\">" + info + "</a><br>");
            details.append("<br>");
            details.append("<b>Purchase Link: </b><br><a href=\"" + link + "\">" + link + "</a><br>");
        }
        this.setText(details.toString());
        this.setCaretPosition(0);
    }

    public static void showURL(URL href) {
        HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
        assert (displayer != null) : "HtmlBrowser.URLDisplayer found.";
        if (displayer != null) {
            displayer.showURL(href);
        } else {
            Logger.global.log(Level.INFO, "No URLDisplayer found.");
        }
    }
}

