/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.MagicSurroundWithTryCatchFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

class OrigSurroundWithTryCatchFix
implements Fix {
    private static final Logger LOG = Logger.getLogger(OrigSurroundWithTryCatchFix.class.getName());
    private JavaSource javaSource;
    private List<TypeMirrorHandle> thandles;
    private TreePathHandle path;
    private List<String> fqns;

    public OrigSurroundWithTryCatchFix(JavaSource javaSource, List<TypeMirrorHandle> thandles, TreePathHandle path, List<String> fqns) {
        this.javaSource = javaSource;
        this.thandles = thandles;
        this.path = path;
        this.fqns = fqns;
    }

    public String getText() {
        return NbBundle.getMessage(MagicSurroundWithTryCatchFix.class, (String)"LBL_SurroundStatementWithTryCatch");
    }

    public ChangeInfo implement() throws Exception {
        ModificationResult mr = this.javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy parameter) throws Exception {
                Tree pl;
                StatementTree stat;
                parameter.toPhase(JavaSource.Phase.RESOLVED);
                TreePath p = OrigSurroundWithTryCatchFix.this.path.resolve((CompilationInfo)parameter);
                if (p == null) {
                    return;
                }
                if ((p = OrigSurroundWithTryCatchFix.this.findStatement(p)) == null) {
                    return;
                }
                Tree leaf = p.getLeaf();
                if (leaf.getKind() == Tree.Kind.VARIABLE && p.getParentPath().getLeaf().getKind() == Tree.Kind.FOR_LOOP) {
                    p = p.getParentPath();
                    leaf = (StatementTree)p.getLeaf();
                }
                GeneratorUtilities.get((WorkingCopy)parameter).importComments(p.getParentPath().getLeaf(), parameter.getCompilationUnit());
                TreeMaker make = parameter.getTreeMaker();
                if (leaf.getKind() == Tree.Kind.VARIABLE) {
                    TreePath block;
                    Element e = parameter.getTrees().getElement(p);
                    VariableTree vt = (VariableTree)leaf;
                    if (e != null && e.getKind() == ElementKind.LOCAL_VARIABLE && (block = OrigSurroundWithTryCatchFix.this.findBlockOrCase(p)) != null) {
                        boolean sep;
                        boolean bl = sep = new FindUsages(leaf, (CompilationInfo)parameter).scan(block, (VariableElement)e) == Boolean.TRUE;
                        if (sep) {
                            StatementTree assignment = make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.Identifier((CharSequence)vt.getName()), vt.getInitializer()));
                            StatementTree declaration = make.Variable(vt.getModifiers(), (CharSequence)vt.getName(), vt.getType(), null);
                            declaration = Utilities.copyComments(parameter, vt, declaration, true);
                            assignment = Utilities.copyComments(parameter, vt, assignment, false);
                            TryTree tryTree = make.Try(make.Block(Collections.singletonList(assignment), false), MagicSurroundWithTryCatchFix.createCatches(parameter, make, OrigSurroundWithTryCatchFix.this.thandles, p), null);
                            Utilities.replaceStatement(parameter, p, Arrays.asList(declaration, tryTree));
                            return;
                        }
                    }
                }
                if (StatementTree.class.isAssignableFrom(leaf.getKind().asInterface())) {
                    stat = (StatementTree)leaf;
                } else if (ExpressionTree.class.isAssignableFrom(leaf.getKind().asInterface())) {
                    stat = make.ExpressionStatement((ExpressionTree)leaf);
                } else {
                    LOG.log(Level.WARNING, "Unexpected statement to surround: {0}, {1}", new Object[]{leaf.getKind(), leaf});
                    return;
                }
                StatementTree tryTree = make.Try(make.Block(Collections.singletonList(stat), false), MagicSurroundWithTryCatchFix.createCatches(parameter, make, OrigSurroundWithTryCatchFix.this.thandles, p), null);
                if (p.getParentPath() != null && !StatementTree.class.isAssignableFrom((pl = p.getParentPath().getLeaf()).getKind().asInterface())) {
                    tryTree = make.Block(Collections.singletonList(tryTree), false);
                }
                parameter.rewrite(leaf, (Tree)tryTree);
            }
        });
        return Utilities.commitAndComputeChangeInfo((FileObject)this.javaSource.getFileObjects().iterator().next(), mr);
    }

    private TreePath findStatement(TreePath path) {
        while (!(path == null || StatementTree.class.isAssignableFrom(path.getLeaf().getKind().asInterface()) || path.getParentPath() != null && path.getParentPath().getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION)) {
            path = path.getParentPath();
        }
        return path;
    }

    private TreePath findBlockOrCase(TreePath path) {
        while (path != null && path.getLeaf().getKind() != Tree.Kind.BLOCK && path.getLeaf().getKind() != Tree.Kind.CASE) {
            path = path.getParentPath();
        }
        return path;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrigSurroundWithTryCatchFix other = (OrigSurroundWithTryCatchFix)obj;
        if (!(this.javaSource == other.javaSource || this.javaSource != null && this.javaSource.equals(other.javaSource))) {
            return false;
        }
        if (!this.path.equals((Object)other.path)) {
            return false;
        }
        return this.fqns.equals(other.fqns);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.javaSource != null ? this.javaSource.hashCode() : 0);
        return hash;
    }

    private static final class FindUsages
    extends TreePathScanner<Boolean, VariableElement> {
        private Tree ignore;
        private CompilationInfo info;

        public FindUsages(Tree ignore, CompilationInfo info) {
            this.ignore = ignore;
            this.info = info;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree node, VariableElement p) {
            return p.equals(this.info.getTrees().getElement(this.getCurrentPath()));
        }

        @Override
        public Boolean scan(Tree tree, VariableElement p) {
            if (tree == this.ignore) {
                return false;
            }
            return (Boolean)super.scan(tree, p);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
        }
    }
}

