/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mobility.e2e.classdata.ClassDataRegistry;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.e2e.mapping.JavonMappingImpl;
import org.netbeans.modules.mobility.end2end.E2EDataNode;
import org.netbeans.modules.mobility.end2end.classdata.AbstractService;
import org.netbeans.modules.mobility.end2end.classdata.ClassData;
import org.netbeans.modules.mobility.end2end.classdata.OperationData;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.ConfigurationReader;
import org.netbeans.modules.mobility.end2end.client.config.ConfigurationWriter;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.modules.xml.multiview.XmlMultiViewElement;
import org.netbeans.spi.mobility.end2end.E2EServiceProvider;
import org.netbeans.spi.mobility.end2end.ServiceGeneratorResult;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class E2EDataObject
extends XmlMultiViewDataObject {
    public static final String PROP_GENERATING = "generating";
    public static final String ICON_BASE = "org/netbeans/modules/mobility/end2end/DDDataIcon.gif";
    public static final String MIME_TYPE_CLASS = "text/x-wsclient.class";
    public static final String MIME_TYPE_WSDL = "text/x-wsclient.wsdl";
    public static final String MIME_TYPE_JSR172 = "text/x-wsclient.jsr172";
    private static final String TRUE = "true";
    public static RequestProcessor rp;
    protected Configuration configuration;
    private Project clientProject;
    private Project serverProject;
    protected Set<SaveCallback> saveCallbacks;
    private ModelSynchronizer synchronizer = new ModelSynchronizer(this);
    protected volatile boolean generating;
    private volatile XmlMultiViewEditorSupport xmlEditorSupport;

    public E2EDataObject(FileObject file, MultiFileLoader ldr) throws DataObjectExistsException {
        super(file, ldr);
        this.saveCallbacks = new HashSet<SaveCallback>();
    }

    public void addSaveCallback(SaveCallback callBack) {
        this.saveCallbacks.add(callBack);
    }

    public void removeSaveCallback(SaveCallback callBack) {
        this.saveCallbacks.remove(callBack);
    }

    protected Node createNodeDelegate() {
        return new E2EDataNode(this);
    }

    public void setModified(boolean modif) {
        super.setModified(modif);
        if (modif) {
            this.synchronizer.requestUpdateData();
        }
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            try {
                this.configuration = ConfigurationReader.read((DataObject)this);
            }
            catch (Exception e) {
                this.configuration = null;
                ErrorManager.getDefault().log(e.getMessage());
            }
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.setModified(true);
    }

    public Project getClientProject() {
        if (this.clientProject == null) {
            this.clientProject = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        }
        return this.clientProject;
    }

    public Project getServerProject() {
        Configuration config = this.getConfiguration();
        if (this.serverProject == null) {
            OpenProjects openProject = OpenProjects.getDefault();
            Project[] openedProjects = openProject.getOpenProjects();
            if (config.getServerConfigutation() == null) {
                return null;
            }
            String serverProjectName = config.getServerConfigutation().getProjectName();
            for (Project p : openedProjects) {
                ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
                String webProjectName = pi.getName();
                if (!serverProjectName.equals(webProjectName)) continue;
                this.serverProject = p;
                break;
            }
            if (this.serverProject == null) {
                // empty if block
            }
        }
        return this.serverProject;
    }

    public JavonMappingImpl getMapping() {
        FileObject projectFO;
        Configuration config = this.getConfiguration();
        ArrayList<String> classPath = new ArrayList<String>();
        ServerConfiguration sc = config.getServerConfigutation();
        Sources ssources = (Sources)this.getServerProject().getLookup().lookup(Sources.class);
        SourceGroup[] ssg = ssources.getSourceGroups("java");
        ArrayList<ClasspathInfo> classpaths = new ArrayList<ClasspathInfo>();
        for (int i = 0; i < ssg.length; ++i) {
            ClassPath cp = ClassPath.getClassPath((FileObject)ssg[i].getRootFolder(), (String)"classpath/source");
            FileObject[] roots = cp.getRoots();
            for (int j = 0; j < roots.length; ++j) {
                File f = FileUtil.toFile((FileObject)roots[j]);
                if (f != null) {
                    classPath.add(f.getAbsolutePath());
                }
                classpaths.add(ClasspathInfo.create((FileObject)roots[j]));
            }
        }
        ArrayList<ClasspathInfo> classpathInfos = new ArrayList<ClasspathInfo>();
        classpathInfos.add(ClasspathInfo.create((FileObject)ssg[0].getRootFolder()));
        if (config.getServiceType().equals("wsdlClass") && (projectFO = this.getServerProject().getProjectDirectory().getFileObject("build/generated/wsimport/client")) != null) {
            classpathInfos.add(ClasspathInfo.create((FileObject)projectFO));
        }
        ClassDataRegistry registry = ClassDataRegistry.getRegistry("default", classpathInfos);
        JavonMappingImpl mapping = new JavonMappingImpl(registry);
        ClientConfiguration cc = config.getClientConfiguration();
        JavonMappingImpl.Client jcc = new JavonMappingImpl.Client();
        Properties cprops = cc.getProperties();
        jcc.setClassName(cc.getClassDescriptor().getLeafClassName());
        jcc.setPackageName(cc.getClassDescriptor().getPackageName());
        Sources csources = (Sources)this.getClientProject().getLookup().lookup(Sources.class);
        SourceGroup csg = Util.getPreselectedGroup(csources.getSourceGroups("java"), cc.getClassDescriptor().getLocation());
        jcc.setOutputDirectory(FileUtil.toFile((FileObject)csg.getRootFolder()).getPath());
        mapping.setProperty("create-stubs", cprops.getProperty("createStubs").equals(TRUE));
        mapping.setProperty("databinding", cprops.getProperty("DataBinding"));
        mapping.setProperty("floatingPoint", cprops.getProperty("floatingPoint").equals(TRUE));
        mapping.setClientMapping(jcc);
        ProjectInformation pi = (ProjectInformation)this.getServerProject().getLookup().lookup(ProjectInformation.class);
        JavonMappingImpl.Server jsc = new JavonMappingImpl.Server();
        jsc.setProjectName(pi.getName());
        jsc.setClassName(sc.getClassDescriptor().getLeafClassName());
        jsc.setPackageName(sc.getClassDescriptor().getPackageName());
        jsc.setOutputDirectory(FileUtil.toFile((FileObject)Util.getPreselectedGroup(ssg, sc.getClassDescriptor().getLocation()).getRootFolder()).getPath());
        jsc.setLocation(Util.getServerLocation(this.getServerProject()));
        jsc.setPort(Util.getServerPort(this.getServerProject()));
        jsc.setServletLocation(this.configuration.getServerConfigutation().getProjectName() + "/servlet/" + this.configuration.getServerConfigutation().getClassDescriptor().getType());
        mapping.setServerMapping(jsc);
        int methodID = 1;
        List<AbstractService> services = config.getServices();
        List<ClassData> classes = services.get(0).getData();
        for (ClassData ccd : classes) {
            JavonMappingImpl.Service javonService = new JavonMappingImpl.Service();
            javonService.setPackageName(ccd.getPackageName());
            if ("wsdlClass".equals(config.getServiceType())) {
                WSDLService wsdlService = (WSDLService)services.get(0);
                javonService.setClassName(wsdlService.getType());
            } else {
                javonService.setClassName(ccd.getClassName());
            }
            String className = ccd.getProxyClassType();
            if (className == null) {
                className = ccd.getType();
            }
            mapping.setProperty("instance", className);
            while (SourceUtils.isScanInProgress()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            registry.updateClassDataTree();
            org.netbeans.modules.mobility.e2e.classdata.ClassData classData = registry.getClassData(className);
            if (classData == null) continue;
            List<OperationData> methods = ccd.getOperations();
            List<MethodData> methodsData = classData.getMethods();
            for (int j = 0; j < methods.size(); ++j) {
                String methodName = null;
                methodName = "wsdlClass".equals(config.getServiceType()) ? methods.get(j).getMethodName() : methods.get(j).getName();
                int methodIndex = this.findMethodIndex(methodsData, methodName);
                if (methodIndex < 0) continue;
                MethodData mmd = methodsData.get(methodIndex);
                mmd.setRequestID(methodID++);
                javonService.addMethod(mmd);
            }
            mapping.addServiceMaping(javonService);
        }
        mapping.setServletURL(Util.getServerURL(this.getServerProject(), this.getConfiguration()));
        return mapping;
    }

    private int findMethodIndex(List<MethodData> methods, String methodName) {
        int result = 0;
        for (MethodData method : methods) {
            if (method.getName().equals(methodName)) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    protected String getPrefixMark() {
        return null;
    }

    public synchronized void generate() {
        this.generating = true;
        try {
            this.getEditorSupport().saveDocument();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.firePropertyChange(PROP_GENERATING, Boolean.FALSE, Boolean.TRUE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (rp == null) {
                    rp = new RequestProcessor("End2EndGenerator", 5);
                }
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(E2EServiceProvider.class));
                        for (E2EServiceProvider elem : result.allInstances()) {
                            if (!E2EDataObject.this.getConfiguration().getServiceType().equals(elem.getServiceType())) continue;
                            ServiceGeneratorResult serviceGeneratorResult = elem.generateStubs(Lookups.singleton((Object)((Object)E2EDataObject.this)));
                        }
                        E2EDataObject.this.generating = false;
                        E2EDataObject.this.firePropertyChange(E2EDataObject.PROP_GENERATING, Boolean.TRUE, Boolean.FALSE);
                    }
                });
            }
        });
    }

    public boolean isGenerating() {
        return this.generating;
    }

    protected String getEditorMimeType() {
        String serviceType = this.getConfiguration().getServiceType();
        if ("wsdlClass".equals(serviceType)) {
            return MIME_TYPE_WSDL;
        }
        if ("jsr-172".equals(serviceType)) {
            return MIME_TYPE_JSR172;
        }
        return MIME_TYPE_CLASS;
    }

    public static XmlMultiViewElement createClassSourceViewElement(Lookup lookup) {
        return new XmlMultiViewElement((XmlMultiViewDataObject)lookup.lookup(XmlMultiViewDataObject.class));
    }

    public static XmlMultiViewElement createWsdlSourceViewElement(Lookup lookup) {
        return new XmlMultiViewElement((XmlMultiViewDataObject)lookup.lookup(XmlMultiViewDataObject.class));
    }

    public static XmlMultiViewElement createJsr172SourceViewElement(Lookup lookup) {
        return new XmlMultiViewElement((XmlMultiViewDataObject)lookup.lookup(XmlMultiViewDataObject.class));
    }

    protected synchronized XmlMultiViewEditorSupport getEditorSupport() {
        if (this.xmlEditorSupport == null) {
            this.xmlEditorSupport = new ValidatedXmlMultiViewEditorSupport(this);
        }
        return this.xmlEditorSupport;
    }

    private class ModelSynchronizer
    extends XmlMultiViewDataSynchronizer {
        public ModelSynchronizer(XmlMultiViewDataObject dataObject) {
            super(dataObject, 100);
        }

        protected boolean mayUpdateData(boolean allowDialog) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateDataFromModel(Object model, FileLock lock, boolean modify) {
            if (model == null) {
                return;
            }
            for (SaveCallback callBack : E2EDataObject.this.saveCallbacks) {
                callBack.save();
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (E2EDataObject.this.configuration != null) {
                    try {
                        ConfigurationWriter.write(out, (Configuration)model);
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                out.close();
                OutputStream outputStream = E2EDataObject.this.getDataCache().createOutputStream(lock, modify);
                try {
                    outputStream.write(out.toByteArray());
                }
                finally {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        protected Object getModel() {
            return E2EDataObject.this.getConfiguration();
        }

        protected void reloadModelFromData() {
            E2EDataObject.this.getConfiguration();
        }
    }

    private static class ValidatedXmlMultiViewEditorSupport
    extends XmlMultiViewEditorSupport {
        protected final E2EDataObject dataObject;

        public ValidatedXmlMultiViewEditorSupport(XmlMultiViewDataObject dObj) {
            super(dObj);
            this.dataObject = (E2EDataObject)dObj;
        }

        public void open() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Configuration configuration = ValidatedXmlMultiViewEditorSupport.this.dataObject.getConfiguration();
                    if (configuration == null) {
                        NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(E2EDataObject.class, (String)"ERR_ConfigurationFileCorrupted"));
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                        return;
                    }
                    if (ValidatedXmlMultiViewEditorSupport.this.dataObject.getConfiguration().getServerConfigutation() != null && ValidatedXmlMultiViewEditorSupport.this.dataObject.getServerProject() == null) {
                        NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(E2EDataObject.class, (String)"ERR_ServerProjectNotOpened", (Object)configuration.getServerConfigutation().getProjectName()));
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                        if (Util.openProject(ValidatedXmlMultiViewEditorSupport.this.dataObject.getConfiguration().getServerConfigutation().getProjectPath()) == null) {
                            return;
                        }
                        return;
                    }
                    ValidatedXmlMultiViewEditorSupport.this.openme();
                }
            });
        }

        protected void openme() {
            super.open();
        }
    }

    public static interface SaveCallback {
        public void save();
    }
}

