/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.css.lib.api.FilterableError;
import org.netbeans.modules.javascript2.doc.spi.DocumentationContainer;
import org.netbeans.modules.javascript2.model.spi.ModelContainer;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class BaseParserResult
extends ParserResult {
    private static final Set<String> MIME_TYPES;
    private final ModelContainer modelContainer = new ModelContainer();
    private final DocumentationContainer documentationContainer = new DocumentationContainer();
    private final boolean embedded;
    private final boolean success;
    private final Lookup lookup;
    private List<? extends FilterableError> errors = Collections.emptyList();

    BaseParserResult(Snapshot snapshot, boolean success, @NonNull Lookup additionalLkp) {
        super(snapshot);
        this.success = success;
        this.embedded = BaseParserResult.isEmbedded(snapshot);
        Lookup baseLkp = Lookups.fixed((Object[])new Object[]{this, this.modelContainer, this.documentationContainer});
        this.lookup = new ProxyLookup(new Lookup[]{baseLkp, additionalLkp});
    }

    public final Lookup getLookup() {
        return this.lookup;
    }

    @NonNull
    public final List<? extends FilterableError> getDiagnostics() {
        return this.getErrors(false);
    }

    @NonNull
    public final List<? extends FilterableError> getErrors(boolean includeFiltered) {
        if (includeFiltered) {
            return Collections.unmodifiableList(this.errors);
        }
        ArrayList<FilterableError> result = new ArrayList<FilterableError>(this.errors.size());
        for (FilterableError filterableError : this.errors) {
            if (filterableError.isFiltered()) continue;
            result.add(filterableError);
        }
        return result;
    }

    public final void setErrors(@NonNull List<? extends FilterableError> errors) {
        Parameters.notNull((CharSequence)"errors", errors);
        this.errors = errors;
    }

    public final boolean isEmbedded() {
        return this.embedded;
    }

    protected void invalidate() {
    }

    public static boolean isEmbedded(@NonNull Snapshot snapshot) {
        return !MIME_TYPES.contains(snapshot.getMimePath().getPath());
    }

    boolean success() {
        return this.success;
    }

    static {
        HashSet s = new HashSet();
        Collections.addAll(s, "text/javascript", "text/gulp+javascript", "text/grunt+javascript", "text/karmaconf+javascript", "text/x-json", "text/package+x-json", "text/bower+x-json", "text/bowerrc+x-json", "text/jshintrc+x-json");
        MIME_TYPES = Collections.unmodifiableSet(s);
    }
}

