/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.VersionsCache;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNLogMessage;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnClientFactory;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.history.HistoryActionVCSProxyBased;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HistoryProvider
implements VCSHistoryProvider {
    private final List<VCSHistoryProvider.HistoryChangeListener> listeners = new LinkedList<VCSHistoryProvider.HistoryChangeListener>();
    private Action[] actions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public VCSHistoryProvider.HistoryEntry[] getHistory(VCSFileProxy[] files, Date fromDate) {
        try {
            SvnClient client = Subversion.getInstance().getClient(files[0]);
            LinkedList<VCSHistoryProvider.HistoryEntry> ret = new LinkedList<VCSHistoryProvider.HistoryEntry>();
            HashMap<String, HashSet<VCSFileProxy>> rev2FileMap = new HashMap<String, HashSet<VCSFileProxy>>();
            HashMap<String, ISVNLogMessage> rev2LMMap = new HashMap<String, ISVNLogMessage>();
            HashMap<VCSFileProxy, SVNUrl> file2Copy = new HashMap<VCSFileProxy, SVNUrl>();
            SVNUrl repoUrl = null;
            for (VCSFileProxy file : files) {
                FileInformation fi = Subversion.getInstance().getStatusCache().getStatus(file);
                if ((fi.getStatus() & 0x15DF8) == 0) continue;
                ISVNLogMessage[] messages = null;
                if (fi.getStatus() == 4096 && fi.getEntry(file).isCopied()) {
                    ISVNInfo info = SvnUtils.getInfoFromWorkingCopy(client, file);
                    SVNUrl copyUrl = info.getCopyUrl();
                    repoUrl = info.getRepository();
                    if (copyUrl != null) {
                        messages = client.getLogMessages(copyUrl, fromDate == null ? new SVNRevision.Number(1L) : new SVNRevision.DateSpec(fromDate), SVNRevision.HEAD);
                        file2Copy.put(file, copyUrl);
                    }
                }
                if (messages == null) {
                    messages = client.getLogMessages(file, fromDate == null ? new SVNRevision.Number(1L) : new SVNRevision.DateSpec(fromDate), SVNRevision.HEAD);
                }
                for (ISVNLogMessage m : messages) {
                    String r = m.getRevision().toString();
                    rev2LMMap.put(r, m);
                    HashSet<VCSFileProxy> s = (HashSet<VCSFileProxy>)rev2FileMap.get(r);
                    if (s == null) {
                        s = new HashSet<VCSFileProxy>();
                        rev2FileMap.put(r, s);
                    }
                    s.add(file);
                }
            }
            for (ISVNLogMessage m : rev2LMMap.values()) {
                Set s = (Set)rev2FileMap.get(m.getRevision().toString());
                VCSFileProxy[] involvedFiles = s.toArray(new VCSFileProxy[s.size()]);
                VCSHistoryProvider.HistoryEntry e = new VCSHistoryProvider.HistoryEntry(involvedFiles, m.getDate(), m.getMessage(), m.getAuthor(), m.getAuthor(), m.getRevision().toString(), m.getRevision().toString(), this.getActions(), (VCSHistoryProvider.RevisionProvider)new RevisionProviderImpl(m.getRevision(), repoUrl, file2Copy));
                ret.add(e);
            }
            return ret.toArray(new VCSHistoryProvider.HistoryEntry[ret.size()]);
        }
        catch (SVNClientException e) {
            if (SvnClientExceptionHandler.isCancelledAction(e.getMessage())) {
                if (Subversion.LOG.isLoggable(Level.FINE)) {
                    Subversion.LOG.log(Level.FINE, null, e);
                }
            } else {
                SvnClientExceptionHandler.notifyException(new Context(files), e, true, true);
            }
            return null;
        }
    }

    public Action createShowHistoryAction(VCSFileProxy[] files) {
        return new OpenHistoryAction(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHistoryChange(final VCSFileProxy[] files) {
        VCSHistoryProvider.HistoryChangeListener[] la;
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            la = this.listeners.toArray(new VCSHistoryProvider.HistoryChangeListener[this.listeners.size()]);
        }
        Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                for (VCSHistoryProvider.HistoryChangeListener l : la) {
                    l.fireHistoryChanged(new VCSHistoryProvider.HistoryEvent((VCSHistoryProvider)HistoryProvider.this, files));
                }
            }
        });
    }

    private synchronized Action[] getActions() {
        if (this.actions == null) {
            this.actions = new Action[]{new RollbackAction(), new ViewAction(), new AnnotateAction()};
        }
        return this.actions;
    }

    private void view(final SVNRevision revision, final boolean showAnnotations, final VCSFileProxy ... files) {
        if (files == null || files.length == 0) {
            return;
        }
        Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                try {
                    SVNUrl repoUrl = SvnUtils.getRepositoryRootUrl(files[0]);
                    for (VCSFileProxy file : files) {
                        SvnClient client = Subversion.getInstance().getClient(false, new Context(files));
                        ISVNInfo info = client.getInfo(file);
                        SVNUrl fileUrl = info.getUrl();
                        SvnUtils.openInRevision(file, repoUrl, fileUrl, revision, revision, showAnnotations);
                    }
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException(new Context(files), ex, false, false);
                }
            }
        });
    }

    private static class RollbackAction
    extends HistoryActionVCSProxyBased {
        private RollbackAction() {
        }

        protected void perform(final VCSHistoryProvider.HistoryEntry entry, final Set<VCSFileProxy> files) {
            SVNUrl repository;
            final VCSFileProxy file = files.iterator().next();
            Context context = new Context(file);
            try {
                repository = ContextAction.getSvnUrl(context);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(context, ex, false, false);
                return;
            }
            RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
            SvnProgressSupport support = new SvnProgressSupport(context.getFileSystem()){

                @Override
                public void perform() {
                    try {
                        SVNUrl repoUrl = SvnUtils.getRepositoryRootUrl(file);
                        for (VCSFileProxy file2 : files) {
                            SvnClient client = Subversion.getInstance().getClient(false, new Context(file2));
                            ISVNInfo info = client.getInfo(file2);
                            SVNUrl fileUrl = info.getUrl();
                            SVNRevision.Number svnRevision = new SVNRevision.Number(Long.parseLong(entry.getRevision()));
                            SvnUtils.rollback(file2, repoUrl, fileUrl, svnRevision, false, this.getLogger());
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException(new Context(file), ex, false, false);
                    }
                }
            };
            support.start(rp, repository, NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_Rollback_Progress"));
        }

        protected boolean isMultipleHistory() {
            return false;
        }

        public String getName() {
            String rev = this.getRevisionShort();
            if (rev == null) {
                rev = "";
            }
            return NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SummaryView_RollbackTo", (Object)rev);
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }

    private class AnnotateAction
    extends HistoryActionVCSProxyBased {
        public AnnotateAction() {
            super(NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SummaryView_ShowAnnotations"));
        }

        protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<VCSFileProxy> files) {
            SVNRevision.Number svnRevision = new SVNRevision.Number(Long.parseLong(entry.getRevision()));
            HistoryProvider.this.view(svnRevision, true, files.toArray(new VCSFileProxy[files.size()]));
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }

    private class ViewAction
    extends HistoryActionVCSProxyBased {
        public ViewAction() {
            super(NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SummaryView_View"));
        }

        protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<VCSFileProxy> files) {
            SVNRevision.Number svnRevision = new SVNRevision.Number(Long.parseLong(entry.getRevision()));
            HistoryProvider.this.view(svnRevision, false, files.toArray(new VCSFileProxy[files.size()]));
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }

    private static class OpenHistoryAction
    extends AbstractAction {
        private final VCSFileProxy[] files;

        public OpenHistoryAction(VCSFileProxy[] files) {
            this.files = files;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.openHistory(this.files);
        }

        public void openHistory(final VCSFileProxy[] files) {
            if (files == null || files.length == 0) {
                return;
            }
            if (!SvnClientFactory.isClientAvailable(new Context(files))) {
                Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchHistoryAction.openHistory(files);
                }
            });
        }
    }

    private static class RevisionProviderImpl
    implements VCSHistoryProvider.RevisionProvider {
        private final SVNRevision revision;
        private final Map<VCSFileProxy, SVNUrl> file2Copy;
        private final SVNUrl repoUrl;

        public RevisionProviderImpl(SVNRevision svnRevision, SVNUrl repoUrl, Map<VCSFileProxy, SVNUrl> file2Copy) {
            this.revision = svnRevision;
            this.file2Copy = file2Copy;
            this.repoUrl = repoUrl;
        }

        public void getRevisionFile(VCSFileProxy originalFile, VCSFileProxy revisionFile) {
            try {
                VCSFileProxy file;
                SVNUrl copyUrl;
                SVNUrl sVNUrl = copyUrl = this.repoUrl != null ? this.file2Copy.get(originalFile) : null;
                if (copyUrl != null) {
                    file = VCSFileProxy.createFileProxy((File)VersionsCache.getInstance(VCSFileProxySupport.getFileSystem((VCSFileProxy)originalFile)).getFileRevision(this.repoUrl, copyUrl, this.revision.toString(), originalFile.getName()));
                } else {
                    file = VersionsCache.getInstance(VCSFileProxySupport.getFileSystem((VCSFileProxy)originalFile)).getFileRevision(originalFile, this.revision.toString());
                    VCSFileProxySupport.copyFile((VCSFileProxy)file, (VCSFileProxy)revisionFile);
                }
                VCSFileProxySupport.copyFile((VCSFileProxy)file, (VCSFileProxy)revisionFile);
            }
            catch (IOException e) {
                Exception ex = e;
                if (e.getCause() instanceof SVNClientException) {
                    ex = (SVNClientException)e.getCause();
                }
                if (SvnClientExceptionHandler.isCancelledAction(ex.getMessage())) {
                    if (Subversion.LOG.isLoggable(Level.FINE)) {
                        Subversion.LOG.log(Level.FINE, null, e);
                    }
                }
                SvnClientExceptionHandler.notifyException(new Context(revisionFile), ex, true, true);
            }
        }
    }
}

