/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.checkout;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.wizards.CheckoutWizard;
import org.netbeans.modules.subversion.remote.util.CheckoutCompleted;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class CheckoutAction
implements ActionListener,
HelpCtx.Provider {
    private static final String WORKING_COPY_FORMAT_PROP = "svnkit.wc.17";

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.subversion.ui.checkout.CheckoutAction");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Utils.logVCSActionEvent((String)"SVN");
        this.performCheckout(false);
    }

    private VCSFileProxy performCheckout(final boolean wait) {
        assert (!wait || !EventQueue.isDispatchThread());
        final FileSystem defaultFileSystem = VCSFileProxySupport.getDefaultFileSystem();
        if (defaultFileSystem == null || !VCSFileProxySupport.isConnectedFileSystem((FileSystem)defaultFileSystem)) {
            return null;
        }
        CheckoutWizard wizard = new CheckoutWizard(defaultFileSystem);
        if (!wizard.show()) {
            return null;
        }
        final SVNUrl repository = wizard.getRepositoryRoot();
        final RepositoryFile[] repositoryFiles = wizard.getRepositoryFiles();
        final VCSFileProxy workDir = wizard.getWorkdir();
        if (!Subversion.getInstance().checkClientAvailable(new Context(workDir))) {
            return null;
        }
        final boolean atWorkingDirLevel = wizard.isAtWorkingDirLevel();
        final boolean doExport = wizard.isExport();
        final boolean showCheckoutCompleted = SvnModuleConfig.getDefault(defaultFileSystem).getShowCheckoutCompleted();
        final boolean old16Format = wizard.isOldFormatPreferred();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SvnClient client;
                final String oldPreference = System.getProperty(CheckoutAction.WORKING_COPY_FORMAT_PROP);
                System.setProperty(CheckoutAction.WORKING_COPY_FORMAT_PROP, Boolean.toString(!old16Format));
                Context context = new Context(workDir);
                try {
                    client = Subversion.getInstance().getClient(context, repository);
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException(context, ex, true, true);
                    return;
                }
                RequestProcessor.Task t = CheckoutAction.this.performCheckout(defaultFileSystem, repository, client, repositoryFiles, workDir, atWorkingDirLevel, doExport, showCheckoutCompleted);
                t.addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        if (oldPreference == null) {
                            System.clearProperty(CheckoutAction.WORKING_COPY_FORMAT_PROP);
                        } else {
                            System.setProperty(CheckoutAction.WORKING_COPY_FORMAT_PROP, oldPreference);
                        }
                    }
                });
                if (wait) {
                    t.waitFinished();
                }
            }
        };
        if (wait) {
            run.run();
        } else {
            Subversion.getInstance().getRequestProcessor().post(run);
        }
        return wizard.getWorkdir();
    }

    private RequestProcessor.Task performCheckout(FileSystem fileSystem, final SVNUrl repository, final SvnClient client, final RepositoryFile[] repositoryFiles, final VCSFileProxy workingDir, final boolean atWorkingDirLevel, final boolean doExport, final boolean showCheckoutCompleted) {
        SvnProgressSupport support = new SvnProgressSupport(fileSystem){

            @Override
            public void perform() {
                try {
                    this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/remote/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
                    this.setCancellableDelegate(client);
                    client.addNotifyListener(this);
                    CheckoutAction.checkout(client, repository, repositoryFiles, workingDir, atWorkingDirLevel, doExport, this);
                }
                catch (SVNClientException ex) {
                    this.annotate(ex);
                    return;
                }
                finally {
                    Subversion.getInstance().versionedFilesChanged();
                    client.removeNotifyListener(this);
                }
                if (this.isCanceled()) {
                    return;
                }
                this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/remote/ui/checkout/Bundle").getString("LBL_ScanFolders_Progress"));
                if (showCheckoutCompleted) {
                    CheckoutAction.showCheckoutCompletet(repositoryFiles, workingDir, atWorkingDirLevel, doExport, this);
                }
            }
        };
        return support.start(Subversion.getInstance().getRequestProcessor(repository), repository, ResourceBundle.getBundle("org/netbeans/modules/subversion/remote/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
    }

    public static void checkout(final SvnClient client, SVNUrl repository, final RepositoryFile[] repositoryFiles, VCSFileProxy workingDir, boolean atWorkingDirLevel, final boolean doExport, final SvnProgressSupport support) throws SVNClientException {
        final VCSFileProxy[] destinations = new VCSFileProxy[repositoryFiles.length];
        for (int i = 0; i < repositoryFiles.length; ++i) {
            VCSFileProxy destination;
            if (!atWorkingDirLevel) {
                destination = VCSFileProxy.createFileProxy((VCSFileProxy)workingDir, (String)repositoryFiles[i].getName());
                destination = destination.normalizeFile();
                VCSFileProxySupport.mkdir((VCSFileProxy)destination);
            } else {
                destination = workingDir;
            }
            destinations[i] = destination;
        }
        SvnUtils.runWithoutIndexing(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (int i = 0; i < repositoryFiles.length; ++i) {
                    VCSFileProxy destination = destinations[i];
                    if (support != null && support.isCanceled()) {
                        return null;
                    }
                    if (doExport) {
                        client.doExport(repositoryFiles[i].getFileUrl(), destination, repositoryFiles[i].getRevision(), true);
                        continue;
                    }
                    client.checkout(repositoryFiles[i].getFileUrl(), destination, repositoryFiles[i].getRevision(), true);
                }
                return null;
            }
        }, destinations);
    }

    private static void showCheckoutCompletet(RepositoryFile[] repositoryFiles, VCSFileProxy workingDir, boolean atWorkingDirLevel, boolean doExport, SvnProgressSupport support) {
        String[] folders;
        if (atWorkingDirLevel) {
            folders = new String[]{"."};
        } else {
            folders = new String[repositoryFiles.length];
            for (int i = 0; i < repositoryFiles.length; ++i) {
                if (support != null && support.isCanceled()) {
                    return;
                }
                folders[i] = repositoryFiles[i].isRepositoryRoot() ? "." : repositoryFiles[i].getFileUrl().getLastPathSegment();
            }
        }
        CheckoutCompleted cc = new CheckoutCompleted(workingDir, folders);
        if (support != null && support.isCanceled()) {
            return;
        }
        cc.scanForProjects(support, doExport ? CheckoutCompleted.Type.EXPORT : CheckoutCompleted.Type.CHECKOUT);
    }
}

