/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClientCheckSupport {
    private static ClientCheckSupport instance;
    private final RequestProcessor rp = new RequestProcessor("SvnClientCheckRP", 1, true);
    private static final Logger LOG;

    public static synchronized ClientCheckSupport getInstance() {
        if (instance == null) {
            instance = new ClientCheckSupport();
        }
        return instance;
    }

    private ClientCheckSupport() {
    }

    public void runInAWTIfAvailable(Node[] nodes, final String progressName, final Runnable runnable) {
        final Context ctx = SvnUtils.getCurrentContext(nodes);
        SvnProgressSupport supp = new SvnProgressSupport(ctx.getFileSystem()){

            @Override
            protected void perform() {
                this.setDisplayName(NbBundle.getMessage(ClientCheckSupport.class, (String)"MSG_ClientCheckSupport.progressDescription"));
                if (!Subversion.getInstance().checkClientAvailable(ctx)) {
                    LOG.log(Level.FINE, "Client is unavailable, cannot perform {0}", progressName);
                    return;
                }
                if (!this.isCanceled()) {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
        supp.start(this.rp, null, progressName == null ? NbBundle.getMessage(ClientCheckSupport.class, (String)"MSG_ClientCheckSupport.progressDescription") : progressName);
    }

    static {
        LOG = Logger.getLogger(ClientCheckSupport.class.getName());
    }
}

