/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

public class NativeMessageHeaderAccessor
extends MessageHeaderAccessor {
    public static final String NATIVE_HEADERS = "nativeHeaders";
    private final Map<String, List<String>> originalNativeHeaders;
    private final MultiValueMap<String, String> nativeHeaders = new LinkedMultiValueMap(4);

    protected NativeMessageHeaderAccessor(Map<String, List<String>> nativeHeaders) {
        this.originalNativeHeaders = nativeHeaders;
    }

    protected NativeMessageHeaderAccessor(Message<?> message) {
        super(message);
        this.originalNativeHeaders = NativeMessageHeaderAccessor.initNativeHeaders(message);
    }

    private static Map<String, List<String>> initNativeHeaders(Message<?> message) {
        Map headers;
        if (message != null && (headers = (Map)message.getHeaders().get(NATIVE_HEADERS)) != null) {
            return headers;
        }
        return null;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> result = super.toMap();
        result.put(NATIVE_HEADERS, this.toNativeHeaderMap());
        return result;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || !this.nativeHeaders.isEmpty();
    }

    public Map<String, List<String>> toNativeHeaderMap() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (this.originalNativeHeaders != null) {
            result.putAll(this.originalNativeHeaders);
        }
        for (String key : this.nativeHeaders.keySet()) {
            List value = (List)this.nativeHeaders.get((Object)key);
            if (value == null) {
                result.remove(key);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public List<String> getNativeHeader(String headerName) {
        if (this.nativeHeaders.containsKey((Object)headerName)) {
            return (List)this.nativeHeaders.get((Object)headerName);
        }
        if (this.originalNativeHeaders != null) {
            return this.originalNativeHeaders.get(headerName);
        }
        return null;
    }

    public String getFirstNativeHeader(String headerName) {
        List<String> values = this.getNativeHeader(headerName);
        return CollectionUtils.isEmpty(values) ? null : values.get(0);
    }

    public void setNativeHeader(String name, String value) {
        if (!ObjectUtils.nullSafeEquals((Object)value, (Object)this.getHeader(name))) {
            this.nativeHeaders.set((Object)name, (Object)value);
        }
    }

    public void addNativeHeader(String name, String value) {
        this.nativeHeaders.add((Object)name, (Object)value);
    }
}

