/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.fold;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.editor.base.semantic.Utilities;

public final class JavaElementFoldVisitor<T>
extends CancellableTreePathScanner<Object, Object> {
    private final List<Integer> anchors = new ArrayList<Integer>();
    private final List<T> folds = new ArrayList<T>();
    private final CompilationInfo info;
    private final CompilationUnitTree cu;
    private final SourcePositions sp;
    private boolean stopped;
    private int initialCommentStopPos = Integer.MAX_VALUE;
    private final Document doc;
    private final FoldCreator<T> creator;

    public JavaElementFoldVisitor(CompilationInfo info, CompilationUnitTree cu, SourcePositions sp, Document doc, FoldCreator<T> creator) {
        this.info = info;
        this.cu = cu;
        this.sp = sp;
        this.doc = doc;
        this.creator = creator;
    }

    private void addFold(T f, int anchor) {
        if (f != null) {
            this.folds.add(f);
            this.anchors.add(anchor);
        }
    }

    public List<Integer> getAnchors() {
        return this.anchors;
    }

    public List<T> getFolds() {
        return this.folds;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void checkInitialFold() {
        try {
            TokenHierarchy th = this.info.getTokenHierarchy();
            TokenSequence ts = th.tokenSequence(JavaTokenId.language());
            while (ts.moveNext() && ts.offset() < this.initialCommentStopPos) {
                Token token = ts.token();
                if (token.id() != JavaTokenId.BLOCK_COMMENT && token.id() != JavaTokenId.JAVADOC_COMMENT) continue;
                int startOffset = ts.offset();
                this.addFold(this.creator.createInitialCommentFold(startOffset, startOffset + token.length()), startOffset);
                break;
            }
        }
        catch (ConcurrentModificationException e) {
            this.stopped = true;
        }
    }

    private void handleJavadoc(Tree t) throws BadLocationException, ConcurrentModificationException {
        TokenHierarchy th;
        TokenSequence ts;
        int start = (int)this.sp.getStartPosition(this.cu, t);
        if (start == -1) {
            return;
        }
        if (start < this.initialCommentStopPos) {
            this.initialCommentStopPos = start;
        }
        if ((ts = (th = this.info.getTokenHierarchy()).tokenSequence(JavaTokenId.language())).move(start) == Integer.MAX_VALUE) {
            return;
        }
        while (ts.movePrevious()) {
            Token token = ts.token();
            if (token.id() == JavaTokenId.JAVADOC_COMMENT) {
                int startOffset = ts.offset();
                this.addFold(this.creator.createJavadocFold(startOffset, startOffset + token.length()), startOffset);
                if (startOffset < this.initialCommentStopPos) {
                    this.initialCommentStopPos = startOffset;
                }
            }
            if (token.id() == JavaTokenId.WHITESPACE || token.id() == JavaTokenId.BLOCK_COMMENT || token.id() == JavaTokenId.LINE_COMMENT) continue;
            break;
        }
    }

    private void handleTree(Tree node, Tree javadocTree, boolean handleOnlyJavadoc) {
        this.handleTree((int)this.sp.getStartPosition(this.cu, node), node, javadocTree, handleOnlyJavadoc);
    }

    private void handleTree(int symStart, Tree node, Tree javadocTree, boolean handleOnlyJavadoc) {
        try {
            if (!handleOnlyJavadoc) {
                int start = (int)this.sp.getStartPosition(this.cu, node);
                int end = (int)this.sp.getEndPosition(this.cu, node);
                if (start != -1 && start < end) {
                    this.addFold(this.creator.createCodeBlockFold(start, end), symStart);
                }
            }
            this.handleJavadoc(javadocTree != null ? javadocTree : node);
        }
        catch (BadLocationException e) {
            this.stopped = true;
        }
        catch (ConcurrentModificationException e) {
            this.stopped = true;
        }
    }

    public Object visitMethod(MethodTree node, Object p) {
        super.visitMethod(node, p);
        this.handleTree((int)this.sp.getStartPosition(this.cu, node), node.getBody(), node, false);
        return null;
    }

    public Object visitClass(ClassTree node, Object p) {
        super.visitClass(node, (Object)Boolean.TRUE);
        try {
            if (p == Boolean.TRUE) {
                int start = Utilities.findBodyStart(this.info, node, this.cu, this.sp, this.doc);
                int end = (int)this.sp.getEndPosition(this.cu, node);
                if (start != -1 && start < end) {
                    this.addFold(this.creator.createInnerClassFold(start, end), (int)this.sp.getStartPosition(this.cu, node));
                }
            }
            this.handleJavadoc(node);
        }
        catch (BadLocationException e) {
            this.stopped = true;
        }
        catch (ConcurrentModificationException e) {
            this.stopped = true;
        }
        return null;
    }

    public Object visitVariable(VariableTree node, Object p) {
        super.visitVariable(node, p);
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)this.getCurrentPath().getParentPath().getLeaf().getKind())) {
            this.handleTree(node, null, true);
        }
        return null;
    }

    public Object visitBlock(BlockTree node, Object p) {
        super.visitBlock(node, p);
        TreePath path = this.getCurrentPath();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind())) {
            this.handleTree(node, null, false);
        }
        return null;
    }

    public Object visitCompilationUnit(CompilationUnitTree node, Object p) {
        int importsStart = Integer.MAX_VALUE;
        int importsEnd = -1;
        TokenHierarchy th = this.info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        block6: for (ImportTree importTree : node.getImports()) {
            int identPos;
            Tree qualIdent = importTree.getQualifiedIdentifier();
            if (qualIdent == null) continue;
            while (qualIdent.getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree mst = (MemberSelectTree)qualIdent;
                if (mst.getIdentifier().contentEquals("<error>")) continue block6;
                qualIdent = mst.getExpression();
            }
            int start = (int)this.sp.getStartPosition(this.cu, importTree);
            int end = identPos = (int)this.sp.getStartPosition(this.cu, qualIdent);
            boolean firstNewline = true;
            ts.move(identPos);
            block8: while (ts.moveNext()) {
                Token tukac = ts.token();
                switch ((JavaTokenId)tukac.id()) {
                    case IDENTIFIER: 
                    case DOT: 
                    case STAR: {
                        firstNewline = false;
                        end = ts.offset() + tukac.length();
                        continue block8;
                    }
                    case SEMICOLON: {
                        end = (int)this.sp.getEndPosition(this.cu, importTree);
                        break;
                    }
                    case WHITESPACE: {
                        int endl;
                        if (firstNewline && (endl = tukac.text().toString().indexOf("\n")) > -1) {
                            end = ts.offset() + endl;
                            firstNewline = true;
                        }
                    }
                    case LINE_COMMENT: 
                    case BLOCK_COMMENT: {
                        continue block8;
                    }
                }
                break;
            }
            if (importsStart > start) {
                importsStart = start;
            }
            if (end <= importsEnd) continue;
            importsEnd = end;
        }
        if (importsEnd != -1 && importsStart != -1) {
            if (importsStart < this.initialCommentStopPos) {
                this.initialCommentStopPos = importsStart;
            }
            if ((importsStart += 7) < importsEnd) {
                this.addFold(this.creator.createImportsFold(importsStart, importsEnd), importsStart);
            }
        }
        return super.visitCompilationUnit(node, p);
    }

    public static interface FoldCreator<T> {
        public T createImportsFold(int var1, int var2);

        public T createInnerClassFold(int var1, int var2);

        public T createCodeBlockFold(int var1, int var2);

        public T createJavadocFold(int var1, int var2);

        public T createInitialCommentFold(int var1, int var2);
    }
}

