/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.Icon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.java.j2seproject.api.J2SEProjectPlatform;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.platform.api.JavaFxRuntimeInclusion;
import org.netbeans.modules.javafx2.project.JFXProjectConfigurations;
import org.netbeans.modules.javafx2.project.JFXProjectIconAnnotator;
import org.netbeans.modules.javafx2.project.JFXProjectOpenedHook;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JavaFXProjectWizardIterator;
import org.netbeans.modules.javafx2.project.ui.JSEApplicationClassChooser;
import org.netbeans.spi.project.ProjectIconAnnotator;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.cookies.CloseCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JFXProjectUtils {
    private static Set<ClassIndex.SearchKind> kinds = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
    private static Set<ClassIndex.SearchScope> scopes = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE));
    private static final String JFX_BUILD_TEMPLATE = "Templates/JFX/jfx-impl.xml";
    private static final String CURRENT_EXTENSION = "jfx3";
    private static final String[] OLD_EXTENSIONS = new String[]{"jfx", "jfx2"};
    private static final String NBPROJECT = "nbproject";
    private static final String JFX_BUILD_IMPL_NAME = "jfx-impl";
    private static final String JFX_BUILD_IMPL_PATH = "nbproject/jfx-impl.xml";
    private static volatile String currentJfxImplCRCCache;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String J2SEDEPLOY_EXTENSION = "j2sedeploy";
    private static final String EXTENSION_BUILD_SCRIPT_PATH = "nbproject/build-native.xml";
    @Deprecated
    public static final String PROPERTY_JAVAFX_RUNTIME = "javafx.runtime";
    @Deprecated
    public static final String PROPERTY_JAVAFX_SDK = "javafx.sdk";
    private static final Logger LOGGER;

    public static String getCurrentExtensionName() {
        return CURRENT_EXTENSION;
    }

    public static Iterable<? extends String> getOldExtensionNames() {
        return Arrays.asList(OLD_EXTENSIONS);
    }

    public static Map<String, List<String>> getJSCallbacks(String platformName) {
        String[][] c = new String[][]{{"onDeployError", "app", "mismatchEvent"}, {"onGetNoPluginMessage", "app"}, {"onGetSplash", "app"}, {"onInstallFinished", "placeholder", "component", "status", "relaunchNeeded"}, {"onInstallNeeded", "app", "platform", "cb", "isAutoinstall", "needRelaunch", "launchFunc"}, {"onInstallStarted", "placeholder", "component", "isAuto", "restartNeeded"}, {"onJavascriptReady", "id"}, {"onRuntimeError", "id", "code"}};
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        for (int i = 0; i < c.length; ++i) {
            String[] s = c[i];
            assert (s.length > 0);
            ArrayList<String> l = null;
            if (s.length > 1) {
                l = new ArrayList<String>();
                for (int j = 1; j < s.length; ++j) {
                    l.add(s[j]);
                }
            }
            m.put(s[0], l);
        }
        return m;
    }

    public static Map<FileObject, List<ClassPath>> getClassPathMap(@NonNull Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] srcGroups = sources.getSourceGroups("java");
        HashMap<FileObject, List<ClassPath>> classpathMap = new HashMap<FileObject, List<ClassPath>>();
        for (SourceGroup srcGroup : srcGroups) {
            FileObject srcRoot = srcGroup.getRootFolder();
            ClassPath bootCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/boot");
            ClassPath executeCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/execute");
            ClassPath sourceCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/source");
            ArrayList<ClassPath> cpList = new ArrayList<ClassPath>();
            if (bootCP != null) {
                cpList.add(bootCP);
            }
            if (executeCP != null) {
                cpList.add(executeCP);
            }
            if (sourceCP != null) {
                cpList.add(sourceCP);
            }
            if (cpList.size() != 3) continue;
            classpathMap.put(srcRoot, cpList);
        }
        return classpathMap;
    }

    public static Set<FileObject> getSourceRoots(@NonNull Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] srcGroups = sources.getSourceGroups("java");
        HashSet<FileObject> sourceRoots = new HashSet<FileObject>();
        for (SourceGroup srcGroup : srcGroups) {
            sourceRoots.add(srcGroup.getRootFolder());
        }
        return sourceRoots;
    }

    public static Set<String> getMainClassNames(@NonNull Project project) {
        HashSet<String> mainClassNames = new HashSet<String>();
        FileObject[] sourceRoots = JFXProjectUtils.getSourceRoots(project).toArray(new FileObject[0]);
        for (ElementHandle elemHandle : SourceUtils.getMainClasses((FileObject[])sourceRoots)) {
            mainClassNames.add(elemHandle.getQualifiedName());
        }
        return mainClassNames;
    }

    public static Set<String> getAppClassNames(@NonNull Map<FileObject, List<ClassPath>> classpathMap, final @NonNull String classType) {
        final HashSet<String> appClassNames = new HashSet<String>();
        for (FileObject fo : classpathMap.keySet()) {
            List<ClassPath> paths = classpathMap.get(fo);
            ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)paths.get(0), (ClassPath)paths.get(1), (ClassPath)paths.get(2));
            final ClassIndex classIndex = cpInfo.getClassIndex();
            JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        Elements elems = controller.getElements();
                        TypeElement fxAppElement = elems.getTypeElement(classType);
                        ElementHandle appHandle = ElementHandle.create((javax.lang.model.element.Element)fxAppElement);
                        Set appHandles = classIndex.getElements(appHandle, kinds, scopes);
                        for (ElementHandle elemHandle : appHandles) {
                            appClassNames.add(elemHandle.getQualifiedName());
                        }
                    }

                    public void cancel() {
                    }
                }, true);
            }
            catch (Exception exception) {}
        }
        return appClassNames;
    }

    public static Set<String> getAppClassNamesInJar(@NonNull FileObject jarFile, String classType, String fxrtJarPath) {
        JarFile jf;
        File jarF = FileUtil.toFile((FileObject)jarFile);
        if (jarF == null) {
            return null;
        }
        boolean jfxrtExists = false;
        ArrayList<URL> toLoad = new ArrayList<URL>();
        try {
            assert (jarF.exists());
            toLoad.add(jarF.toURI().toURL());
            File jfxrt = new File(fxrtJarPath);
            if (jfxrt.exists()) {
                jfxrtExists = true;
            }
            toLoad.add(jfxrt.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            return null;
        }
        URLClassLoader clazzLoader = URLClassLoader.newInstance(toLoad.toArray(new URL[0]));
        HashSet<String> appClassNames = new HashSet<String>();
        try {
            jf = new JarFile(jarF);
        }
        catch (IOException x) {
            return null;
        }
        Enumeration<JarEntry> entries = jf.entries();
        if (entries == null) {
            return null;
        }
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String classFileName = entry.getName();
            if (!classFileName.endsWith(".class") || classFileName.contains("$")) continue;
            String className = classFileName.replace(".class", "").replace('\\', '/').replace('/', '.');
            if (clazzLoader != null && jfxrtExists) {
                try {
                    Class<?> clazz = Class.forName(className, true, clazzLoader);
                    Type t = clazz.getGenericSuperclass();
                    if (!t.toString().contains(classType)) continue;
                    if (className.startsWith(".")) {
                        className = className.substring(1);
                    }
                    appClassNames.add(className);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }
            if (className.startsWith(".")) {
                className = className.substring(1);
            }
            appClassNames.add(className);
        }
        return appClassNames;
    }

    public static boolean isFXProject(@NonNull Project prj) {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (ep == null) {
            return false;
        }
        return JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.enabled"));
    }

    public static boolean isFXinSwingProject(@NonNull Project prj) {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (ep == null) {
            return false;
        }
        return JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.enabled")) && JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.swing"));
    }

    public static boolean isFXPreloaderProject(@NonNull Project prj) {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (ep == null) {
            return false;
        }
        return JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.enabled")) && JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.preloader")) && !JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.swing"));
    }

    public static boolean isMavenProject(@NonNull Project prj) {
        FileObject fo = prj.getProjectDirectory();
        if (fo == null || !fo.isValid()) {
            return false;
        }
        return (fo = fo.getFileObject("pom.xml")) != null;
    }

    public static boolean isGradleProject(@NonNull Project prj) {
        FileObject fo = prj.getProjectDirectory();
        if (fo == null || !fo.isValid()) {
            return false;
        }
        return (fo = fo.getFileObject("build.gradle")) != null;
    }

    public static boolean isMavenFXProject(@NonNull Project prj) {
        if (JFXProjectUtils.isMavenProject(prj)) {
            try {
                FileObject pomXml = prj.getProjectDirectory().getFileObject("pom.xml");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(FileUtil.toFile((FileObject)pomXml));
                XPathFactory xPathfactory = XPathFactory.newInstance();
                XPath xpath = xPathfactory.newXPath();
                XPathExpression exprJfxrt = xpath.compile("//bootclasspath[contains(text(),'jfxrt')]");
                XPathExpression exprFxPackager = xpath.compile("//executable[contains(text(),'javafxpackager')]");
                XPathExpression exprPackager = xpath.compile("//executable[contains(text(),'javapackager')]");
                boolean jfxrt = (Boolean)exprJfxrt.evaluate(doc, XPathConstants.BOOLEAN);
                boolean packager = (Boolean)exprPackager.evaluate(doc, XPathConstants.BOOLEAN);
                boolean fxPackager = (Boolean)exprFxPackager.evaluate(doc, XPathConstants.BOOLEAN);
                return jfxrt && (packager || fxPackager);
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
                LOGGER.log(Level.INFO, "Error while parsing pom.xml.", ex);
                return false;
            }
        }
        return false;
    }

    public static String getFXProjectRunAs(@NonNull Project prj) {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (ep == null) {
            return null;
        }
        return ep.evaluator().getProperty("javafx.run.as");
    }

    public static String getRelativePath(@NonNull FileObject sourceFO, @NonNull FileObject targetFO) {
        String path = "";
        FileObject src = sourceFO;
        FileObject tgt = targetFO;
        String targetName = null;
        if (!src.isFolder()) {
            src = src.getParent();
        }
        if (!tgt.isFolder()) {
            targetName = tgt.getNameExt();
            tgt = tgt.getParent();
        }
        LinkedList<String> srcSplit = new LinkedList<String>();
        LinkedList<String> tgtSplit = new LinkedList<String>();
        while (!src.isRoot()) {
            srcSplit.addFirst(src.getName());
            src = src.getParent();
        }
        while (!tgt.isRoot()) {
            tgtSplit.addFirst(tgt.getName());
            tgt = tgt.getParent();
        }
        boolean share = false;
        while (!srcSplit.isEmpty() && !tgtSplit.isEmpty() && ((String)srcSplit.getFirst()).equals(tgtSplit.getFirst())) {
            srcSplit.removeFirst();
            tgtSplit.removeFirst();
            share = true;
        }
        if (!share) {
            return null;
        }
        for (int left = 0; left < srcSplit.size(); ++left) {
            path = left == 0 ? path + ".." : path + "/..";
        }
        while (!tgtSplit.isEmpty()) {
            path = path.isEmpty() ? path + (String)tgtSplit.getFirst() : path + "/" + (String)tgtSplit.getFirst();
            tgtSplit.removeFirst();
        }
        if (targetName != null) {
            path = !path.isEmpty() ? path + "/" + targetName : path + targetName;
        }
        return path;
    }

    public static FileObject getFileObject(@NonNull FileObject sourceDir, @NonNull String relPath) {
        File f;
        String[] split = relPath.split("[\\\\/]+");
        FileObject src = sourceDir;
        String path = "";
        boolean back = true;
        if (split[0].equals("..")) {
            for (int i = 0; i < split.length; ++i) {
                if (back && split[i].equals("..")) {
                    if ((src = src.getParent()) != null) continue;
                    return null;
                }
                if (back) {
                    back = false;
                    path = src.getPath();
                }
                path = path + "/" + split[i];
            }
        } else {
            path = relPath;
        }
        if ((f = new File(path)).exists()) {
            return FileUtil.toFileObject((File)f);
        }
        return null;
    }

    static void initializeJavaFXProperties(@NonNull EditableProperties ep, @NonNull JavaFXProjectWizardIterator.WizardType type, String targetPlatformName, @NonNull String mainClass, String preloader) throws MissingResourceException {
        Set extensions;
        ep.setProperty("javafx.enabled", TRUE);
        ep.setComment("javafx.enabled", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_javafx")}, false);
        ep.setProperty("jnlp.enabled", FALSE);
        ep.setComment("jnlp.enabled", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_oldjnlp")}, false);
        ep.setProperty("compile.on.save", TRUE);
        ep.setProperty("compile.on.save.unsupported.javafx", TRUE);
        ep.setProperty("javafx.binarycss", FALSE);
        ep.setProperty("javafx.deploy.includeDT", TRUE);
        ep.setProperty("javafx.deploy.embedJNLP", TRUE);
        ep.setProperty("javafx.rebase.libs", FALSE);
        ep.setComment("javafx.rebase.libs", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_rebase_libs")}, false);
        ep.setProperty("javafx.disable.concurrent.runs", FALSE);
        ep.setComment("javafx.disable.concurrent.runs", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_disable_concurrent_runs")}, false);
        ep.setProperty("javafx.enable.concurrent.external.runs", FALSE);
        ep.setComment("javafx.enable.concurrent.external.runs", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_enable_concurrent_external_runs")}, false);
        ep.setProperty("javafx.deploy.backgroundupdate", FALSE);
        ep.setComment("javafx.deploy.backgroundupdate", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)(type == JavaFXProjectWizardIterator.WizardType.SWING ? "COMMENT_updatemode_swing" : "COMMENT_updatemode"))}, false);
        ep.setProperty("javafx.deploy.allowoffline", TRUE);
        if (targetPlatformName == null) {
            targetPlatformName = ep.getProperty("platform.active");
        }
        if ((extensions = JavaFxRuntimeInclusion.getProjectClassPathExtension((JavaPlatform)JavaFXPlatformUtils.findJavaPlatform((String)targetPlatformName))) != null && !extensions.isEmpty()) {
            ep.setProperty("javafx.classpath.extension", JFXProjectUtils.getPaths(extensions));
            ep.setProperty("javac.classpath", new String[]{JavaFXPlatformUtils.getClassPathExtensionProperty()});
        }
        ep.setProperty("endorsed.classpath", "");
        ep.setProperty("javafx.run.width", "800");
        ep.setProperty("javafx.run.height", "600");
        if (type == JavaFXProjectWizardIterator.WizardType.PRELOADER) {
            ep.setProperty("javafx.preloader", TRUE);
            ep.setComment("javafx.preloader", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_preloader")}, false);
            ep.setProperty("javafx.preloader.enabled", FALSE);
            ep.setComment("javafx.preloader.enabled", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_prepreloader")}, false);
        } else {
            ep.setProperty("jar.archive.disabled", TRUE);
            ep.setComment("jar.archive.disabled", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_oldjar")}, false);
            ep.setProperty("main.class", type == JavaFXProjectWizardIterator.WizardType.SWING ? (mainClass == null ? "" : mainClass) : "com.javafx.main.Main");
            ep.setComment("main.class", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_main.class")}, false);
            if (type != JavaFXProjectWizardIterator.WizardType.LIBRARY) {
                ep.setProperty("javafx.main.class", mainClass == null ? "" : mainClass);
                ep.setComment("javafx.main.class", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_main.fxclass")}, false);
            }
            if (preloader != null && preloader.length() > 0) {
                String preloaderProjRelative = "../" + preloader;
                String preloaderJarFileName = preloader + ".jar";
                String copiedPreloaderJarPath = "${dist.dir}/lib/${javafx.preloader.jar.filename}";
                ep.setProperty("javafx.preloader.enabled", TRUE);
                ep.setProperty("javafx.preloader.type", JFXProjectProperties.PreloaderSourceType.PROJECT.getString());
                ep.setComment("javafx.preloader.enabled", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_use_preloader")}, false);
                ep.setProperty("javafx.preloader.project.path", preloaderProjRelative);
                ep.setProperty("javafx.preloader.class", JavaFXProjectWizardIterator.generatePreloaderClassName(preloader));
                ep.setProperty("javafx.preloader.jar.path", copiedPreloaderJarPath);
                ep.setProperty("javafx.preloader.jar.filename", preloaderJarFileName);
            } else {
                ep.setProperty("javafx.preloader.enabled", FALSE);
                ep.setProperty("javafx.preloader.type", JFXProjectProperties.PreloaderSourceType.NONE.getString());
                ep.setComment("javafx.preloader.enabled", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_dontuse_preloader")}, false);
                ep.setProperty("javafx.preloader.project.path", "");
                ep.setProperty("javafx.preloader.class", "");
                ep.setProperty("javafx.preloader.jar.path", "");
                ep.setProperty("javafx.preloader.jar.filename", "");
            }
            if (type == JavaFXProjectWizardIterator.WizardType.SWING) {
                ep.setProperty("javafx.swing", TRUE);
                ep.setComment("javafx.swing", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_use_swing")}, false);
            }
        }
        ep.setProperty("javafx.application.implementation.version", "1.0");
        ep.setProperty("javafx.fallback.class", "com.javafx.main.NoJavaFXFallback");
        ep.setProperty("manifest.custom.codebase", "*");
        ep.setComment("manifest.custom.codebase", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_manifest_custom_codebase")}, false);
        ep.setProperty("manifest.custom.permissions", "");
        ep.setComment("manifest.custom.permissions", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_manifest_custom_permissions")}, false);
        ep.remove((Object)"keep.javafx.runtime.on.classpath");
    }

    public static void resetJavaFXProjectProperties(final @NonNull Project project, final @NonNull JavaFXProjectWizardIterator.WizardType type, final String targetPlatformName, final @NonNull String mainClass, final String preloader) throws IOException {
        final EditableProperties ep = new EditableProperties(true);
        final FileObject projPropsFO = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    Lookup lookup = project.getLookup();
                    J2SEPropertyEvaluator eval = (J2SEPropertyEvaluator)lookup.lookup(J2SEPropertyEvaluator.class);
                    String platformNameToCheck = null;
                    if (eval != null) {
                        J2SEProjectPlatform platformSetter;
                        String currentPlatformName;
                        platformNameToCheck = currentPlatformName = eval.evaluator().getProperty("platform.active");
                        JavaPlatform platform = null;
                        platform = targetPlatformName == null ? JavaFXPlatformUtils.findJavaPlatform((String)currentPlatformName) : JavaFXPlatformUtils.findJavaPlatform((String)targetPlatformName);
                        if (platform == null || !JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)platform)) {
                            platform = JavaFXPlatformUtils.findJavaFXPlatform();
                        }
                        if (platform != null && !JFXProjectProperties.isEqual(currentPlatformName, JavaFXPlatformUtils.getPlatformAntName((JavaPlatform)platform)) && (platformSetter = (J2SEProjectPlatform)lookup.lookup(J2SEProjectPlatform.class)) != null) {
                            platformSetter.setProjectPlatform(platform);
                            platformNameToCheck = JavaFXPlatformUtils.getPlatformAntName((JavaPlatform)platform);
                        }
                    }
                    try (InputStream is = projPropsFO.getInputStream();){
                        ep.load(is);
                    }
                    JFXProjectUtils.initializeJavaFXProperties(ep, type, platformNameToCheck, mainClass, preloader);
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        lock = projPropsFO.lock();
                        os = projPropsFO.getOutputStream(lock);
                        ep.store(os);
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    static void createJfxExtension(Project p, FileObject dirFO, JavaFXProjectWizardIterator.WizardType type) throws IOException {
        FileObject templateFO = FileUtil.getConfigFile((String)JFX_BUILD_TEMPLATE);
        if (templateFO != null) {
            FileObject nbprojectFO = dirFO.getFileObject(NBPROJECT);
            FileObject jfxBuildFile = FileUtil.copyFile((FileObject)templateFO, (FileObject)nbprojectFO, (String)JFX_BUILD_IMPL_NAME);
            if (type == JavaFXProjectWizardIterator.WizardType.SWING) {
                FileObject swingTemplateFO1;
                FileObject templatesFO = nbprojectFO.getFileObject("templates");
                if (templatesFO == null) {
                    templatesFO = nbprojectFO.createFolder("templates");
                }
                if ((swingTemplateFO1 = FileUtil.getConfigFile((String)"Templates/JFX/FXSwingTemplate.html")) != null) {
                    FileUtil.copyFile((FileObject)swingTemplateFO1, (FileObject)templatesFO, (String)"FXSwingTemplate");
                }
                FileObject swingTemplateFO2 = FileUtil.getConfigFile((String)"Templates/JFX/FXSwingTemplateApplet.jnlp");
                if (swingTemplateFO1 != null) {
                    FileUtil.copyFile((FileObject)swingTemplateFO2, (FileObject)templatesFO, (String)"FXSwingTemplateApplet");
                }
                FileObject swingTemplateFO3 = FileUtil.getConfigFile((String)"Templates/JFX/FXSwingTemplateApplication.jnlp");
                if (swingTemplateFO1 != null) {
                    FileUtil.copyFile((FileObject)swingTemplateFO3, (FileObject)templatesFO, (String)"FXSwingTemplateApplication");
                }
            }
            JFXProjectUtils.addExtension(p);
        }
    }

    static boolean addExtension(@NonNull Project proj) throws IOException {
        boolean res = false;
        FileObject projDir = proj.getProjectDirectory();
        FileObject jfxBuildFile = projDir.getFileObject(JFX_BUILD_IMPL_PATH);
        AntBuildExtender extender = (AntBuildExtender)proj.getLookup().lookup(AntBuildExtender.class);
        if (extender != null) {
            assert (jfxBuildFile != null);
            if (extender.getExtension(CURRENT_EXTENSION) == null) {
                AntBuildExtender.Extension ext = extender.addExtension(CURRENT_EXTENSION, jfxBuildFile);
                ext.addDependency("-post-jar", "-jfx-copylibs");
                ext.addDependency("-post-jar", "-rebase-libs");
                ext.addDependency("-post-jar", "jfx-deployment");
                ext.addDependency("run", "jar");
                ext.addDependency("debug", "jar");
                ext.addDependency("profile", "jar");
                res = true;
            }
        }
        return res;
    }

    static void removeSENativeBundlerExtension(@NonNull Project project) throws IOException {
        AntBuildExtender extender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
        if (extender != null) {
            FileObject buildExFo;
            AntBuildExtender.Extension extension = extender.getExtension(J2SEDEPLOY_EXTENSION);
            if (extension != null) {
                extender.removeExtension(J2SEDEPLOY_EXTENSION);
            }
            if ((buildExFo = project.getProjectDirectory().getFileObject(EXTENSION_BUILD_SCRIPT_PATH)) != null) {
                buildExFo.delete();
            }
        }
    }

    public static void switchProjectToFX(final @NonNull Project project, final @NonNull JSEApplicationClassChooser chooser) throws IOException {
        final FileObject dirFO = project.getProjectDirectory();
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                JFXProjectUtils.removeSENativeBundlerExtension(project);
                JFXProjectUtils.createJfxExtension(project, dirFO, JavaFXProjectWizardIterator.WizardType.APPLICATION);
                ProjectManager.getDefault().saveProject(project);
                JFXProjectUtils.updateJFXExtension(project);
                String appClass = chooser.getSelectedExistingClass();
                if (appClass == null) {
                    FileObject dirController = chooser.getCurrentPackageFolder(true);
                    DataFolder packageDataFolder = DataFolder.findFolder((FileObject)dirController);
                    String newClassName = chooser.getCurrentFileName();
                    if (packageDataFolder != null) {
                        FileObject javaTemplate = FileUtil.getConfigFile((String)"Templates/javafx/FXMain.java");
                        DataObject dJavaTemplate = DataObject.find((FileObject)javaTemplate);
                        DataObject dataObject = dJavaTemplate.createFromTemplate(packageDataFolder, newClassName);
                    }
                    appClass = chooser.getPackageName() + "." + newClassName;
                }
                JFXProjectUtils.resetJavaFXProjectProperties(project, JavaFXProjectWizardIterator.WizardType.APPLICATION, null, appClass, null);
                for (ProjectIconAnnotator annotator : Lookup.getDefault().lookupAll(ProjectIconAnnotator.class)) {
                    if (!(annotator instanceof JFXProjectIconAnnotator)) continue;
                    JFXProjectIconAnnotator fxAnnotator = (JFXProjectIconAnnotator)annotator;
                    fxAnnotator.fireChange(project, true);
                }
            }
        });
        String headerTemplate = NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_SWITCHED_SE_TO_FX_HEADER");
        String header = MessageFormat.format(headerTemplate, ProjectUtils.getInformation((Project)project).getDisplayName());
        String content = NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_SWITCHED_SE_TO_FX_CONTENT");
        Notification notePlatformChange = NotificationDisplayer.getDefault().notify(header, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javafx2/project/ui/resources/jfx_project.png", (boolean)true), content, null, NotificationDisplayer.Priority.LOW, NotificationDisplayer.Category.INFO);
        JFXProjectOpenedHook.addNotification(project, notePlatformChange);
    }

    public static boolean updateJFXExtension(Project project) throws IOException {
        boolean changed = JFXProjectUtils.modifyBuildXml(project);
        return changed;
    }

    private static boolean modifyBuildXml(Project proj) throws IOException {
        boolean res = false;
        final FileObject buildXmlFO = JFXProjectUtils.getBuildXml(proj);
        if (buildXmlFO == null) {
            LOGGER.warning("The project build script does not exist, the project cannot be extended by JFX.");
            return res;
        }
        Document xmlDoc = null;
        try {
            xmlDoc = XMLUtil.parse((InputSource)new InputSource(buildXmlFO.toURL().toExternalForm()), (boolean)false, (boolean)true, null, null);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!JFXProjectUtils.addExtension(proj)) {
            LOGGER.log(Level.INFO, "Trying to include JFX build snippet in project type that doesn't support AntBuildExtender API contract.");
        }
        Element docElem = xmlDoc.getDocumentElement();
        NodeList nl = docElem.getElementsByTagName("target");
        boolean changed = false;
        nl = docElem.getElementsByTagName("import");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            if (e.getAttribute("file") == null || !JFX_BUILD_IMPL_PATH.equals(e.getAttribute("file"))) continue;
            e.getParentNode().removeChild(e);
            changed = true;
            break;
        }
        if (changed) {
            final Document fdoc = xmlDoc;
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void run() throws Exception {
                        FileLock lock = buildXmlFO.lock();
                        try (OutputStream os = buildXmlFO.getOutputStream(lock);){
                            XMLUtil.write((Document)fdoc, (OutputStream)os, (String)"UTF-8");
                        }
                        finally {
                            lock.releaseLock();
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mex) {
                throw (IOException)mex.getException();
            }
        }
        return res;
    }

    private static FileObject getBuildXml(Project prj) {
        J2SEPropertyEvaluator j2sepe = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        assert (j2sepe != null);
        PropertyEvaluator eval = j2sepe.evaluator();
        String buildScriptPath = eval.getProperty("buildfile");
        if (buildScriptPath == null) {
            buildScriptPath = "build.xml";
        }
        return prj.getProjectDirectory().getFileObject(buildScriptPath);
    }

    public static FileObject updateJfxImpl(final @NonNull Project proj) throws IOException {
        final FileObject projDir = proj.getProjectDirectory();
        final ArrayList updates = new ArrayList();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    projDir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        public void run() throws IOException {
                            FileObject updated;
                            if (!JFXProjectUtils.isJFXImplCurrent(proj) && (updated = JFXProjectUtils.doUpdateJfxImpl(proj)) != null) {
                                updates.add(updated);
                            }
                        }
                    });
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return updates.isEmpty() ? null : (FileObject)updates.get(0);
    }

    public static boolean isJFXImplCurrent(@NonNull Project proj) throws IOException {
        Boolean isJfxCurrent = true;
        final FileObject projDir = proj.getProjectDirectory();
        try {
            isJfxCurrent = (Boolean)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Boolean run() throws Exception {
                    InputStream in;
                    FileObject jfxBuildFile = projDir.getFileObject(JFXProjectUtils.JFX_BUILD_IMPL_PATH);
                    Boolean isCurrent = false;
                    if (jfxBuildFile != null && (in = jfxBuildFile.getInputStream()) != null) {
                        try {
                            isCurrent = JFXProjectUtils.isJfxImplCurrentVer(JFXProjectUtils.computeCrc32(in));
                        }
                        finally {
                            in.close();
                        }
                    }
                    return isCurrent;
                }
            });
        }
        catch (MutexException mux) {
            isJfxCurrent = false;
            LOGGER.log(Level.INFO, "Problem reading nbproject/jfx-impl.xml", mux.getException());
        }
        return isJfxCurrent;
    }

    static FileObject doUpdateJfxImpl(final @NonNull Project proj) throws IOException {
        FileObject returnFO = null;
        final FileObject projDir = proj.getProjectDirectory();
        try {
            returnFO = (FileObject)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<FileObject>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public FileObject run() throws Exception {
                    FileObject templateFO;
                    FileObject returnFO = null;
                    FileObject jfxBuildFile = projDir.getFileObject(JFXProjectUtils.JFX_BUILD_IMPL_PATH);
                    if (jfxBuildFile != null) {
                        DataObject dobj = DataObject.find((FileObject)jfxBuildFile);
                        CloseCookie closeCookie = (CloseCookie)dobj.getLookup().lookup(CloseCookie.class);
                        if (closeCookie != null) {
                            closeCookie.close();
                        }
                        closeCookie = null;
                        dobj = null;
                        FileObject nbproject = projDir.getFileObject(JFXProjectUtils.NBPROJECT);
                        String backupName = FileUtil.findFreeFileName((FileObject)nbproject, (String)"jfx-impl_backup", (String)"xml");
                        FileUtil.moveFile((FileObject)jfxBuildFile, (FileObject)nbproject, (String)backupName);
                        LOGGER.log(Level.INFO, "Old build script file jfx-impl.xml has been renamed to: {0}.xml", backupName);
                        jfxBuildFile = null;
                        try {
                            FileObject readmeFO;
                            File readme = new File(FileUtil.toFile((FileObject)nbproject), NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_UPDATED_README_FILE_NAME"));
                            if (!readme.exists()) {
                                readme.createNewFile();
                            }
                            returnFO = readmeFO = FileUtil.toFileObject((File)readme);
                            OutputStream os = null;
                            FileLock lock = null;
                            try {
                                lock = readmeFO.lock();
                                os = readmeFO.getOutputStream(lock);
                                try (PrintWriter out = new PrintWriter(os);){
                                    String headerTemplate = NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_UPDATED_README_FILE_CONTENT_HEADER");
                                    String header = MessageFormat.format(headerTemplate, ProjectUtils.getInformation((Project)proj).getDisplayName());
                                    char[] underline = new char[header.length()];
                                    Arrays.fill(underline, '=');
                                    String content = NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_UPDATED_README_FILE_CONTENT");
                                    out.println(underline);
                                    out.println(header);
                                    out.println(underline);
                                    out.println(MessageFormat.format(content, backupName + ".xml"));
                                }
                            }
                            finally {
                                if (os != null) {
                                    os.close();
                                }
                                if (lock != null) {
                                    lock.releaseLock();
                                }
                            }
                        }
                        catch (IOException ioe) {
                            LOGGER.log(Level.INFO, "Cannot create file readme file. ", ioe);
                        }
                    }
                    if (jfxBuildFile == null && (templateFO = FileUtil.getConfigFile((String)JFXProjectUtils.JFX_BUILD_TEMPLATE)) != null) {
                        FileUtil.copyFile((FileObject)templateFO, (FileObject)projDir.getFileObject(JFXProjectUtils.NBPROJECT), (String)JFXProjectUtils.JFX_BUILD_IMPL_NAME);
                        LOGGER.log(Level.INFO, "Build script jfx-impl.xml has been updated to the latest version supported by this NetBeans installation.");
                    }
                    return returnFO;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
        return returnFO;
    }

    public static String computeCrc32(InputStream is) throws IOException {
        int curr;
        CRC32 crc = new CRC32();
        int last = -1;
        while ((curr = is.read()) != -1) {
            if (curr != 10 && last == 13) {
                crc.update(10);
            }
            if (curr != 13) {
                crc.update(curr);
            }
            last = curr;
        }
        if (last == 13) {
            crc.update(10);
        }
        int val = (int)crc.getValue();
        String hex = Integer.toHexString(val);
        while (hex.length() < 8) {
            hex = "0" + hex;
        }
        return hex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJfxImplCurrentVer(String crc) throws IOException {
        FileObject template;
        InputStream in;
        String _currentJfxImplCRC = currentJfxImplCRCCache;
        if (_currentJfxImplCRC == null && (in = (template = FileUtil.getConfigFile((String)JFX_BUILD_TEMPLATE)).getInputStream()) != null) {
            try {
                currentJfxImplCRCCache = _currentJfxImplCRC = JFXProjectUtils.computeCrc32(in);
            }
            finally {
                in.close();
            }
        }
        return _currentJfxImplCRC.equals(crc);
    }

    public static boolean isProjectOpen(@NonNull Project project) {
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        if (projects != null) {
            for (Project p : Arrays.asList(projects)) {
                if (!p.getProjectDirectory().getPath().equals(project.getProjectDirectory().getPath())) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateClassPathExtension(final @NonNull Project project) throws IOException {
        final boolean[] hasDefaultJavaFXPlatform = new boolean[1];
        final EditableProperties ep = new EditableProperties(true);
        final FileObject projPropsFO = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        if (projPropsFO != null) {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void run() throws Exception {
                        J2SEProjectPlatform platformSetter;
                        Lookup lookup = project.getLookup();
                        J2SEPropertyEvaluator eval = (J2SEPropertyEvaluator)lookup.lookup(J2SEPropertyEvaluator.class);
                        if (eval != null) {
                            String platformName = eval.evaluator().getProperty("platform.active");
                            hasDefaultJavaFXPlatform[0] = JFXProjectProperties.isEqual(platformName, "Default_JavaFX_Platform");
                        }
                        if (hasDefaultJavaFXPlatform[0] && (platformSetter = (J2SEProjectPlatform)lookup.lookup(J2SEProjectPlatform.class)) != null) {
                            platformSetter.setProjectPlatform(JavaPlatformManager.getDefault().getDefaultPlatform());
                        }
                        try (InputStream is = projPropsFO.getInputStream();){
                            ep.load(is);
                        }
                        boolean cpExtUpdated = JFXProjectUtils.updateClassPathExtensionProperties(ep);
                        if (cpExtUpdated) {
                            FileLock lock = projPropsFO.lock();
                            try (OutputStream os = projPropsFO.getOutputStream(lock);){
                                ep.store(os);
                            }
                            finally {
                                lock.releaseLock();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mux) {
                throw (IOException)mux.getException();
            }
            if (hasDefaultJavaFXPlatform[0]) {
                String headerTemplate = NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_UPDATED_DEFAULT_PLATFORM_HEADER");
                String header = MessageFormat.format(headerTemplate, ProjectUtils.getInformation((Project)project).getDisplayName());
                String content = NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_UPDATED_DEFAULT_PLATFORM_CONTENT");
                Notification notePlatformChange = NotificationDisplayer.getDefault().notify(header, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javafx2/project/ui/resources/jfx_project.png", (boolean)true), content, null, NotificationDisplayer.Priority.LOW, NotificationDisplayer.Category.INFO);
                JFXProjectOpenedHook.addNotification(project, notePlatformChange);
            }
        } else {
            LOGGER.warning("Project metafiles inaccessible - classpath extension could not be verified and updated if needed.");
        }
    }

    public static void updatePropertyInActiveConfig(@NonNull Project project, final @NonNull String propName, final @NonNull String propValue) throws IOException {
        final FileObject projectDir = project.getProjectDirectory();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    String config;
                    FileObject projPropsFO;
                    EditableProperties cep = new EditableProperties(true);
                    FileObject configFO = projectDir.getFileObject("nbproject/private/config.properties");
                    if (configFO != null) {
                        try (InputStream cis = configFO.getInputStream();){
                            cep.load(cis);
                        }
                    }
                    FileObject fileObject = projPropsFO = (config = cep.getProperty("config")) == null ? projectDir.getFileObject("nbproject/project.properties") : projectDir.getFileObject("nbproject/configs/" + config + "." + "properties");
                    assert (projPropsFO != null) : "Inaccessible file nbproject/configs/" + config + "." + "properties";
                    EditableProperties ep = new EditableProperties(true);
                    try (InputStream is = projPropsFO.getInputStream();){
                        ep.load(is);
                    }
                    ep.setProperty(propName, propValue);
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        lock = projPropsFO.lock();
                        os = projPropsFO.getOutputStream(lock);
                        ep.store(os);
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    public static String[] getPaths(@NonNull Collection<String> artifacts) {
        ArrayList<String> l = new ArrayList<String>();
        Iterator<String> i = artifacts.iterator();
        while (i.hasNext()) {
            String s = i.next();
            if (i.hasNext()) {
                if (s.endsWith(":")) {
                    l.add(s);
                    continue;
                }
                l.add(s + ":");
                continue;
            }
            if (s.endsWith(":")) {
                l.add(s.substring(0, s.length() - 1));
                continue;
            }
            l.add(s);
        }
        return l.toArray(new String[0]);
    }

    @NonNull
    public static Set<String> getPaths(@NonNull String[] artifacts) {
        LinkedHashSet<String> l = new LinkedHashSet<String>();
        for (String artifact : artifacts) {
            if (artifact.endsWith(":")) {
                l.add(artifact.substring(0, artifact.length() - 1));
                continue;
            }
            l.add(artifact);
        }
        return l;
    }

    private static Set<String> filterOutArtifacts(@NonNull Collection<String> artifacts, @NonNull String subString) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String artifact : artifacts) {
            if (artifact.contains(subString)) continue;
            result.add(artifact);
        }
        return result;
    }

    @CheckForNull
    public static Set<String> getExistingProperty(@NonNull EditableProperties ep, @NonNull String propName) {
        String currentPropVal = ep.getProperty(propName);
        if (currentPropVal != null) {
            return Collections.unmodifiableSet(JFXProjectUtils.getPaths(PropertyUtils.tokenizePath((String)currentPropVal)));
        }
        return null;
    }

    public static Set<String> getUpdatedCPProperty(@NonNull EditableProperties ep, boolean extensionPropertyEmpty) {
        boolean extensionNeeded = JFXProjectProperties.isTrue(ep.getProperty("javafx.enabled")) || JFXProjectProperties.isTrue(ep.getProperty("keep.javafx.runtime.on.classpath"));
        Set<String> existing = JFXProjectUtils.getExistingProperty(ep, "javac.classpath");
        Set<Object> updated = new LinkedHashSet();
        if (existing != null) {
            updated = JFXProjectUtils.filterOutArtifacts(existing, "${javafx.runtime}");
            updated = JFXProjectUtils.filterOutArtifacts(updated, JavaFXPlatformUtils.getClassPathExtensionProperty());
        }
        if (extensionNeeded && !extensionPropertyEmpty) {
            updated.add(JavaFXPlatformUtils.getClassPathExtensionProperty());
        }
        return Collections.unmodifiableSet(updated);
    }

    @NonNull
    public static String removeFromPath(@NonNull String path, @NonNull String toRemove) {
        Parameters.notNull((CharSequence)"path", (Object)path);
        Parameters.notNull((CharSequence)"toRemove", (Object)toRemove);
        StringBuilder sb = new StringBuilder();
        for (String entry : PropertyUtils.tokenizePath((String)path)) {
            if (toRemove.equals(entry)) continue;
            sb.append(entry);
            sb.append(':');
        }
        return sb.length() == 0 ? sb.toString() : sb.substring(0, sb.length() - 1);
    }

    public static Set<String> getUpdatedExtensionProperty(@NonNull EditableProperties ep) throws IllegalArgumentException {
        boolean propertyNeeded = JFXProjectProperties.isTrue(ep.getProperty("javafx.enabled")) || JFXProjectProperties.isTrue(ep.getProperty("keep.javafx.runtime.on.classpath"));
        Set updated = null;
        if (propertyNeeded) {
            String platformName = ep.getProperty("platform.active");
            JavaPlatform platform = JavaFXPlatformUtils.findJavaPlatform((String)platformName);
            if (platform == null) {
                return null;
            }
            updated = JavaFxRuntimeInclusion.getProjectClassPathExtension((JavaPlatform)platform);
        }
        return updated == null ? null : Collections.unmodifiableSet(updated);
    }

    public static boolean pathPropertiesEqual(Set<String> set1, Set<String> set2) {
        if (set1 == null && set2 == null) {
            return true;
        }
        if (set1 == null || set2 == null) {
            return false;
        }
        return set1.containsAll(set2) && set2.containsAll(set1);
    }

    public static boolean hasCorrectClassPathExtension(@NonNull Project project) throws IOException, IllegalArgumentException {
        EditableProperties ep = JFXProjectUtils.readFromFile(project.getProjectDirectory().getFileObject("nbproject/project.properties"));
        String platformName = ep.getProperty("platform.active");
        if (JFXProjectProperties.isEqual(platformName, "Default_JavaFX_Platform")) {
            return false;
        }
        Set<String> existingExt = JFXProjectUtils.getExistingProperty(ep, "javafx.classpath.extension");
        Set<String> updatedExt = JFXProjectUtils.getUpdatedExtensionProperty(ep);
        Set<String> existingCP = JFXProjectUtils.getExistingProperty(ep, "javac.classpath");
        Set<String> updatedCP = JFXProjectUtils.getUpdatedCPProperty(ep, updatedExt == null || updatedExt.isEmpty());
        return JFXProjectUtils.pathPropertiesEqual(existingExt, updatedExt) && JFXProjectUtils.pathPropertiesEqual(existingCP, updatedCP);
    }

    public static boolean updateClassPathExtensionProperties(@NonNull EditableProperties ep) {
        String endorsedCp;
        Set<String> currentJavacCp;
        boolean changed = false;
        changed = ep.remove((Object)PROPERTY_JAVAFX_RUNTIME) != null ? true : changed;
        changed = ep.remove((Object)PROPERTY_JAVAFX_SDK) != null ? true : changed;
        Set<String> extendExtProp = JFXProjectUtils.getUpdatedExtensionProperty(ep);
        if (extendExtProp != null && !extendExtProp.isEmpty()) {
            Set<String> currentCpExt = JFXProjectUtils.getExistingProperty(ep, "javafx.classpath.extension");
            if (!extendExtProp.equals(currentCpExt)) {
                ep.setProperty("javafx.classpath.extension", JFXProjectUtils.getPaths(extendExtProp));
                changed = true;
            }
        } else {
            changed = ep.remove((Object)"javafx.classpath.extension") != null ? true : changed;
        }
        Set<String> extendCPProp = JFXProjectUtils.getUpdatedCPProperty(ep, extendExtProp == null || extendExtProp.isEmpty());
        if (extendCPProp != null && !extendCPProp.equals(currentJavacCp = JFXProjectUtils.getExistingProperty(ep, "javac.classpath"))) {
            ep.setProperty("javac.classpath", JFXProjectUtils.getPaths(extendCPProp));
            changed = true;
        }
        if ((endorsedCp = ep.get((Object)"endorsed.classpath")) != null && !endorsedCp.isEmpty()) {
            String[] cpElements = PropertyUtils.tokenizePath((String)endorsedCp);
            ArrayList<String> updatedEndorsedCpList = new ArrayList<String>();
            for (String element : cpElements) {
                if (element.startsWith("${javafx.runtime}/")) continue;
                updatedEndorsedCpList.add(element);
            }
            String[] updatedEndorsedCp = updatedEndorsedCpList.toArray(new String[0]);
            int i = 0;
            while (i < updatedEndorsedCp.length - 1) {
                int n = i++;
                updatedEndorsedCp[n] = updatedEndorsedCp[n] + ":";
            }
            ep.setProperty("endorsed.classpath", updatedEndorsedCp);
            changed = true;
        }
        return changed;
    }

    public static boolean updateDefaultRunAsConfigFile(@NonNull FileObject projDir, JFXProjectProperties.RunAsType runAs, boolean setBrowserProps) throws IOException {
        String privatePath;
        FileObject privateCfgFO;
        EditableProperties privateCfgProps;
        EditableProperties sharedCfgProps;
        boolean updated = false;
        String configName = runAs.getDefaultConfig();
        String configFile = JFXProjectUtils.makeSafe(configName);
        String sharedPath = JFXProjectConfigurations.getSharedConfigFilePath(configFile);
        FileObject sharedCfgFO = projDir.getFileObject(sharedPath);
        EditableProperties editableProperties = sharedCfgProps = sharedCfgFO != null ? JFXProjectUtils.readFromFile(sharedCfgFO) : new EditableProperties(true);
        assert (sharedCfgProps != null);
        if (sharedCfgProps.isEmpty()) {
            sharedCfgProps.setProperty("$label", configName);
            sharedCfgProps.setComment("$label", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_run_as_defaults")}, false);
            JFXProjectUtils.saveToFile(projDir, sharedPath, sharedCfgProps);
            updated = true;
        }
        EditableProperties editableProperties2 = privateCfgProps = (privateCfgFO = projDir.getFileObject(privatePath = JFXProjectConfigurations.getPrivateConfigFilePath(configFile))) != null ? JFXProjectUtils.readFromFile(projDir, privatePath) : new EditableProperties(true);
        assert (privateCfgProps != null);
        if (privateCfgProps.isEmpty() || setBrowserProps) {
            Iterator<Map.Entry<String, String>> iterator;
            Map<String, String> browserInfo;
            privateCfgProps.setProperty("javafx.run.as", runAs.getString());
            privateCfgProps.setComment("javafx.run.as", new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_run_as_defaults")}, false);
            if (setBrowserProps && (browserInfo = JFXProjectUtils.getDefaultBrowserInfo()) != null && !browserInfo.isEmpty() && (iterator = browserInfo.entrySet().iterator()).hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                privateCfgProps.setProperty("javafx.run.inbrowser", entry.getKey());
                privateCfgProps.setProperty("javafx.run.inbrowser.path", entry.getValue());
            }
            JFXProjectUtils.saveToFile(projDir, privatePath, privateCfgProps);
            updated = true;
        }
        return updated;
    }

    public static Map<String, String> getDefaultBrowserInfo() {
        Lookup.Result allBrowsers = Lookup.getDefault().lookupResult(ExtWebBrowser.class);
        HashMap<String, String> browserPaths = new HashMap<String, String>();
        for (Lookup.Item browser : allBrowsers.allItems()) {
            String name = browser.getDisplayName();
            if (name == null || !name.toLowerCase().contains("default")) continue;
            NbProcessDescriptor proc = ((ExtWebBrowser)browser.getInstance()).getBrowserExecutable();
            String path = proc.getProcessName();
            if (!JFXProjectProperties.isNonEmpty(path)) break;
            browserPaths.put(name, path);
            break;
        }
        return browserPaths;
    }

    public static List<Map<String, String>> copyList(List<Map<String, String>> list2Copy) {
        ArrayList<Map<String, String>> list2Return = new ArrayList<Map<String, String>>();
        if (list2Copy != null) {
            for (Map<String, String> map : list2Copy) {
                list2Return.add(JFXProjectUtils.copyMap(map));
            }
        }
        return list2Return;
    }

    public static Map<String, String> copyMap(Map<String, String> map2Copy) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        if (map2Copy != null) {
            for (String key : map2Copy.keySet()) {
                String value = map2Copy.get(key);
                newMap.put(key, value);
            }
        }
        return newMap;
    }

    public static String makeSafe(@NonNull String name) {
        return name.replaceAll("[^a-zA-Z0-9_.-]", "_");
    }

    public static EditableProperties readFromFile(@NonNull Project project, @NonNull String relativePath) throws IOException {
        FileObject dirFO = project.getProjectDirectory();
        return JFXProjectUtils.readFromFile(dirFO, relativePath);
    }

    public static EditableProperties readFromFile(@NonNull FileObject dirFO, @NonNull String relativePath) throws IOException {
        assert (dirFO.isFolder());
        FileObject propsFO = dirFO.getFileObject(relativePath);
        return JFXProjectUtils.readFromFile(propsFO);
    }

    public static EditableProperties readFromFile(final @NonNull FileObject propsFO) throws IOException {
        final EditableProperties ep = new EditableProperties(true);
        if (propsFO != null) {
            assert (propsFO.isData());
            try {
                ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        try (InputStream is = propsFO.getInputStream();){
                            ep.load(is);
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mux) {
                throw (IOException)mux.getException();
            }
        }
        return ep;
    }

    public static void deleteFile(@NonNull Project project, @NonNull String relativePath) throws IOException {
        FileObject propsFO = project.getProjectDirectory().getFileObject(relativePath);
        JFXProjectUtils.deleteFile(propsFO);
    }

    public static void deleteFile(@NonNull FileObject dirFO, @NonNull String relativePath) throws IOException {
        assert (dirFO.isFolder());
        FileObject propsFO = dirFO.getFileObject(relativePath);
        JFXProjectUtils.deleteFile(propsFO);
    }

    public static void deleteFile(final @NonNull FileObject propsFO) throws IOException {
        if (propsFO != null) {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        propsFO.delete();
                        return null;
                    }
                });
            }
            catch (MutexException mux) {
                throw (IOException)mux.getException();
            }
        }
    }

    public static void saveToFile(@NonNull Project project, @NonNull String relativePath, @NonNull EditableProperties ep) throws IOException {
        FileObject dirFO = project.getProjectDirectory();
        JFXProjectUtils.saveToFile(dirFO, relativePath, ep);
    }

    public static void saveToFile(@NonNull FileObject dirFO, @NonNull String relativePath, @NonNull EditableProperties ep) throws IOException {
        FileObject propsFO;
        assert (dirFO.isFolder());
        FileObject f = dirFO.getFileObject(relativePath);
        if (f == null) {
            propsFO = FileUtil.createData((FileObject)dirFO, (String)relativePath);
            assert (propsFO != null) : "FU.cD must not return null; called on " + dirFO + " + " + relativePath;
        } else {
            propsFO = f;
        }
        JFXProjectUtils.saveToFile(propsFO, ep);
    }

    public static void saveToFile(final @NonNull FileObject propsFO, final @NonNull EditableProperties ep) throws IOException {
        if (propsFO != null) {
            assert (propsFO.isData());
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        OutputStream os = null;
                        FileLock lock = null;
                        try {
                            lock = propsFO.lock();
                            os = propsFO.getOutputStream(lock);
                            ep.store(os);
                        }
                        finally {
                            if (os != null) {
                                os.close();
                            }
                            if (lock != null) {
                                lock.releaseLock();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mux) {
                throw (IOException)mux.getException();
            }
        }
    }

    static {
        LOGGER = Logger.getLogger("javafx");
    }
}

