/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.locks.AbstractLockDataFrameProcessor;

public class CPUDataFrameProcessor
extends AbstractLockDataFrameProcessor {
    private boolean hasMonitorInfo;
    private Map methodParameters = new HashMap();

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doProcessDataFrame(ByteBuffer buffer) {
        this.hasMonitorInfo = this.client != null ? this.client.getSettings().isLockContentionMonitoringEnabled() : false;
lbl2:
        // 22 sources

        try {
            block34: while (buffer.hasRemaining()) {
                block77: {
                    eventType = buffer.get();
                    if ((eventType & -128) != 0) {
                        charEvent = (char)((eventType & 255) << 8 | buffer.get() & 255);
                        if ((byte)(eventType & -64) == -64) {
                            this.fireMethodExitUnstamped(charEvent & 16383, this.currentThreadId, 1);
                            continue;
                        }
                        this.fireMethodEntryUnstamped(charEvent & 16383, this.currentThreadId, 1, null, null);
                        continue;
                    }
                    if (eventType == 29 || eventType == 30 || eventType == 13 || eventType == 11 || eventType == 10 || eventType == 28 || eventType == 35) break block77;
                    methodId = -1;
                    timeStamp0 = 0L;
                    timeStamp1 = 0L;
                    hash = -1;
                    ownerThreadId = -1;
                    if (eventType != 5 && eventType != 20 && eventType != 21 && eventType != 26 && eventType != 27 && eventType != 22 && eventType != 23 && eventType != 24 && eventType != 25) {
                        methodId = buffer.getChar();
                    }
                    if (eventType != 16 && eventType != 17 && eventType != 18 && eventType != 19) {
                        timeStamp0 = CPUDataFrameProcessor.getTimeStamp(buffer);
                        if (eventType != 20 && eventType != 21 && eventType != 26 && eventType != 27 && eventType != 22 && eventType != 23 && eventType != 24 && eventType != 25 && this.collectingTwoTimeStamps) {
                            timeStamp1 = CPUDataFrameProcessor.getTimeStamp(buffer);
                        }
                        if (this.hasMonitorInfo && (eventType == 22 || eventType == 23)) {
                            hash = buffer.getInt();
                            if (eventType == 22) {
                                ownerThreadId = buffer.getInt();
                            }
                        }
                    }
                    switch (eventType) {
                        case 18: {
                            parameters = (List)this.methodParameters.get(this.currentThreadId);
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Marker entry unstamped, tId={0}, mId={1}, pars={2}", new Object[]{this.currentThreadId, methodId, parameters.toString()});
                            }
                            this.fireMethodEntryUnstamped(methodId, this.currentThreadId, 3, parameters, null);
                            this.methodParameters.remove(this.currentThreadId);
                            ** GOTO lbl2
                        }
                        case 16: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Method entry unstamped, tId={0}, mId={1}", new Object[]{this.currentThreadId, methodId});
                            }
                            this.fireMethodEntryUnstamped(methodId, this.currentThreadId, 1, null, null);
                            ** GOTO lbl2
                        }
                        case 19: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Marker exit unstamped, tId={0}, mId={1}", new Object[]{this.currentThreadId, methodId});
                            }
                            this.fireMethodExitUnstamped(methodId, this.currentThreadId, 3);
                            ** GOTO lbl2
                        }
                        case 17: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Method exit unstamped, tId={0}, mId={1}", new Object[]{this.currentThreadId, methodId});
                            }
                            this.fireMethodExitUnstamped(methodId, this.currentThreadId, 1);
                            ** GOTO lbl2
                        }
                        case 3: {
                            parameters = (List)this.methodParameters.get(this.currentThreadId);
                            depth = CPUDataFrameProcessor.getDepth(buffer);
                            methodIds = new int[depth];
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Marker entry , tId={0}, mId={1}, pars={2} depth={3}", new Object[]{this.currentThreadId, methodId, parameters.toString(), depth});
                            }
                            for (i = 0; i < depth; ++i) {
                                methodIds[i] = buffer.getInt();
                            }
                            this.fireMethodEntry(methodId, this.currentThreadId, 3, timeStamp0, timeStamp1, parameters, methodIds);
                            this.methodParameters.remove(this.currentThreadId);
                            ** GOTO lbl2
                        }
                        case 1: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Root entry , tId={0}, mId={1}", new Object[]{this.currentThreadId, methodId});
                            }
                            this.fireMethodEntry(methodId, this.currentThreadId, 2, timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                        case 6: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Method entry , tId={0}, mId={1}", new Object[]{this.currentThreadId, methodId});
                            }
                            this.fireMethodEntry(methodId, this.currentThreadId, 1, timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                        case 4: {
                            parameters = (List)this.methodParameters.get(this.currentThreadId);
                            v0 = retVal = parameters == null ? null : parameters.get(0);
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                if (retVal != null) {
                                    CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Marker exit , tId={0}, mId={1}, retVal={2}", new Object[]{this.currentThreadId, methodId, retVal});
                                } else {
                                    CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Marker exit , tId={0}, mId={1}", new Object[]{this.currentThreadId, methodId});
                                }
                            }
                            this.fireMethodExit(methodId, this.currentThreadId, 3, timeStamp0, timeStamp1, retVal);
                            this.methodParameters.remove(this.currentThreadId);
                            ** GOTO lbl2
                        }
                        case 2: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Root exit , tId={0}, mId={1}", new Object[]{this.currentThreadId, methodId});
                            }
                            this.fireMethodExit(methodId, this.currentThreadId, 2, timeStamp0, timeStamp1, null);
                            ** GOTO lbl2
                        }
                        case 7: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Method exit , tId={0}, mId={1}", new Object[]{this.currentThreadId, methodId});
                            }
                            this.fireMethodExit(methodId, this.currentThreadId, 1, timeStamp0, timeStamp1, null);
                            ** GOTO lbl2
                        }
                        case 5: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Adjust time , tId={0}", this.currentThreadId);
                            }
                            this.fireAdjustTime(this.currentThreadId, timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                        case 22: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Monitor entry , tId={0} , monitorId={1}, ownerId={2}", new Object[]{this.currentThreadId, Integer.toHexString(hash), ownerThreadId});
                            }
                            this.fireMonitorEntry(this.currentThreadId, timeStamp0, timeStamp1, hash, ownerThreadId);
                            ** GOTO lbl2
                        }
                        case 23: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Monitor exit , tId={0} , monitorId={1}", new Object[]{this.currentThreadId, Integer.toHexString(hash)});
                            }
                            this.fireMonitorExit(this.currentThreadId, timeStamp0, timeStamp1, hash);
                            ** GOTO lbl2
                        }
                        case 24: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Sleep entry , tId={0}", this.currentThreadId);
                            }
                            this.fireSleepEntry(this.currentThreadId, timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                        case 25: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Sleep exit , tId={0}", this.currentThreadId);
                            }
                            this.fireSleepExit(this.currentThreadId, timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                        case 20: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Wait entry , tId={0}", this.currentThreadId);
                            }
                            this.fireWaitEntry(this.currentThreadId, timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                        case 21: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Wait exit , tId={0}", this.currentThreadId);
                            }
                            this.fireWaitExit(this.currentThreadId, timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                        case 26: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Park entry , tId={0}", this.currentThreadId);
                            }
                            this.fireParkEntry(this.currentThreadId, timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                        case 27: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Park exit , tId={0}", this.currentThreadId);
                            }
                            this.fireParkExit(this.currentThreadId, timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                        case 8: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.finest("Threads suspend");
                            }
                            this.fireThreadsSuspend(timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                        case 9: {
                            if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                                CPUDataFrameProcessor.LOGGER.finest("Threads resume");
                            }
                            this.fireThreadsResumed(timeStamp0, timeStamp1);
                            ** GOTO lbl2
                        }
                    }
                    CPUDataFrameProcessor.LOGGER.log(Level.SEVERE, "*** Profiler Engine: internal error: got unknown event type in CPUDataFrameProcessor: {0} at {1}", new Object[]{(int)eventType, buffer.position()});
                    sb = new StringBuilder();
                    sb.append("dataframe [");
                    buffer.rewind();
                    while (buffer.hasRemaining()) {
                        sb.append(buffer.get()).append(",");
                    }
                    sb.append("]\n");
                    CPUDataFrameProcessor.LOGGER.severe(sb.toString());
                    continue;
                }
                switch (eventType) {
                    case 29: {
                        id = buffer.getChar();
                        timeStamp = CPUDataFrameProcessor.getTimeStamp(buffer);
                        threadId = buffer.getChar();
                        if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                            CPUDataFrameProcessor.LOGGER.finest("Profile Point Hit " + id + ", threadId=" + id + ", timeStamp=" + timeStamp);
                        }
                        this.fireProfilingPoint(threadId, id, timeStamp);
                        continue block34;
                    }
                    case 13: {
                        this.currentThreadId = buffer.getChar();
                        if (!CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) continue block34;
                        CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Change current thread , tId={0}", this.currentThreadId);
                        continue block34;
                    }
                    case 11: {
                        threadId = buffer.getChar();
                        threadName = CPUDataFrameProcessor.getString(buffer);
                        threadClassName = CPUDataFrameProcessor.getString(buffer);
                        if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                            CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Creating new thread , tId={0}", threadId);
                        }
                        this.fireNewThread(threadId, threadName, threadClassName);
                        this.currentThreadId = threadId;
                        continue block34;
                    }
                    case 28: {
                        hash = buffer.getInt();
                        className = CPUDataFrameProcessor.getString(buffer);
                        if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                            CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Creating new monitor , monitorId={0} , className={1}", new Object[]{Integer.toHexString(hash), className});
                        }
                        this.fireNewMonitor(hash, className);
                        continue block34;
                    }
                    case 30: {
                        if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                            CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Servlet track start , tId={0}", this.currentThreadId);
                        }
                        requestType = buffer.get();
                        servletPath = CPUDataFrameProcessor.getString(buffer);
                        sessionId = buffer.getInt();
                        this.fireServletRequest(this.currentThreadId, requestType, servletPath, sessionId);
                        continue block34;
                    }
                    case 35: {
                        if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                            CPUDataFrameProcessor.LOGGER.log(Level.FINEST, "Marker method parameters , tId={0}", this.currentThreadId);
                        }
                        parameters = new ArrayList<Object>();
                        pars = buffer.get();
                        for (i = 0; i < pars; ++i) {
                            parameters.add(this.readParameter(buffer));
                        }
                        this.methodParameters.put(this.currentThreadId, parameters);
                        continue block34;
                    }
                    case 10: {
                        if (CPUDataFrameProcessor.LOGGER.isLoggable(Level.FINEST)) {
                            CPUDataFrameProcessor.LOGGER.finest("Profiling data reset");
                        }
                        this.fireReset();
                        continue block34;
                    }
                }
                CPUDataFrameProcessor.LOGGER.log(Level.SEVERE, "*** Profiler Engine: internal error: got unknown event type in CPUDataFrameProcessor: {0} at {1}", new Object[]{(int)eventType, buffer.position()});
                sb = new StringBuilder();
                sb.append("dataframe [");
                buffer.rewind();
                while (buffer.hasRemaining()) {
                    sb.append(buffer.get()).append(",");
                }
                sb.append("]\n");
                CPUDataFrameProcessor.LOGGER.severe(sb.toString());
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            sb = new StringBuilder();
            sb.append("AIOOBE in dataframe [");
            buffer.rewind();
            while (true) {
                if (!buffer.hasRemaining()) {
                    sb.append("]\n");
                    CPUDataFrameProcessor.LOGGER.severe(sb.toString());
                    throw aioobe;
                }
                sb.append(buffer.get()).append(",");
            }
        }
    }

    private Object readParameter(ByteBuffer buffer) {
        char type = (char)buffer.get();
        switch (type) {
            case 'Z': {
                byte val = buffer.get();
                if (val == 0) {
                    return Boolean.FALSE;
                }
                if (val == 1) {
                    return Boolean.TRUE;
                }
                throw new IllegalArgumentException(Byte.toString(val));
            }
            case 'C': {
                return Character.valueOf(buffer.getChar());
            }
            case 'B': {
                return buffer.get();
            }
            case 'S': {
                return buffer.getShort();
            }
            case 'I': {
                return buffer.getInt();
            }
            case 'J': {
                return buffer.getLong();
            }
            case 'F': {
                return Float.valueOf(Float.intBitsToFloat(buffer.getInt()));
            }
            case 'D': {
                return Double.longBitsToDouble(buffer.getLong());
            }
            case 'L': {
                int lengthChars = buffer.getShort() / 2;
                StringBuilder string = new StringBuilder(lengthChars);
                for (int i = 0; i < lengthChars; ++i) {
                    string.append(buffer.getChar());
                }
                return string.toString();
            }
        }
        throw new IllegalArgumentException(Integer.toString(type));
    }

    private void fireMethodEntry(int methodId, int threadId, int methodType, long timeStamp0, long timeStamp1) {
        this.fireMethodEntry(methodId, threadId, methodType, timeStamp0, timeStamp1, null, null);
    }

    private void fireMethodEntry(final int methodId, final int threadId, final int methodType, final long timeStamp0, final long timeStamp1, final List parameters, final int[] methodIds) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).methodEntry(methodId, threadId, methodType, timeStamp0, timeStamp1, parameters, methodIds);
            }
        });
    }

    private void fireMethodEntryUnstamped(final int methodId, final int threadId, final int methodType, final List parameters, final int[] methodIds) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).methodEntryUnstamped(methodId, threadId, methodType, parameters, methodIds);
            }
        });
    }

    private void fireMethodExit(final int methodId, final int threadId, final int methodType, final long timeStamp0, final long timeStamp1, final Object retVal) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).methodExit(methodId, threadId, methodType, timeStamp0, timeStamp1, retVal);
            }
        });
    }

    private void fireMethodExitUnstamped(final int methodId, final int threadId, final int methodType) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).methodExitUnstamped(methodId, threadId, methodType);
            }
        });
    }

    private void fireServletRequest(final int threadId, final int requestType, final String servletPath, final int sessionId) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).servletRequest(threadId, requestType, servletPath, sessionId);
            }
        });
    }

    private void fireSleepEntry(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).sleepEntry(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireSleepExit(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).sleepExit(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireThreadsResumed(final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).threadsSuspend(timeStamp0, timeStamp1);
            }
        });
    }

    private void fireThreadsSuspend(final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).threadsSuspend(timeStamp0, timeStamp1);
            }
        });
    }

    private void fireWaitEntry(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).waitEntry(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireWaitExit(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).waitExit(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireParkEntry(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).parkEntry(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireParkExit(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).parkExit(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private static int getDepth(ByteBuffer buffer) {
        int depth = (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
        return depth;
    }
}

