/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.results.locks.ThreadInfo;
import org.netbeans.lib.profiler.utils.StringUtils;

class MonitorInfo {
    private final int monitorId;
    private String className;
    private Map<ThreadInfo, OpenThread> openThreads;
    private Map<ThreadInfo, ThreadDetail> waitThreads;
    private Map<ThreadInfo, ThreadDetail> ownerThreads;

    MonitorInfo(int id) {
        this.monitorId = id;
        this.waitThreads = new HashMap<ThreadInfo, ThreadDetail>();
        this.ownerThreads = new HashMap<ThreadInfo, ThreadDetail>();
        this.openThreads = new HashMap<ThreadInfo, OpenThread>();
        this.className = "*unknown*";
    }

    MonitorInfo(int id, String cname) {
        this(id);
        this.className = StringUtils.userFormClassName(cname);
    }

    void setClassName(String cname) {
        this.className = StringUtils.userFormClassName(cname);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MonitorInfo) {
            MonitorInfo mi = (MonitorInfo)obj;
            return mi.monitorId == this.monitorId;
        }
        return false;
    }

    public int hashCode() {
        return this.monitorId;
    }

    void openThread(ThreadInfo ti, ThreadInfo owner, long timeStamp0) {
        assert (this.openThreads.get(ti) == null);
        this.openThreads.put(ti, new OpenThread(ti, owner, timeStamp0));
    }

    void closeThread(ThreadInfo ti, long timeStamp0) {
        OpenThread openThread = this.openThreads.remove(ti);
        assert (openThread != null);
        long wait = timeStamp0 - openThread.timeStamp;
        MonitorInfo.addThread(this.waitThreads, ti, openThread.owner, wait);
        MonitorInfo.addThread(this.ownerThreads, openThread.owner, ti, wait);
    }

    private static void addThread(Map<ThreadInfo, ThreadDetail> threads, ThreadInfo master, ThreadInfo detail, long wait) {
        ThreadDetail td = threads.get(master);
        if (td == null) {
            td = new ThreadDetail(master);
            threads.put(master, td);
        }
        td.addWait(detail, wait);
    }

    void timeAdjust(ThreadInfo ti, long timeDiff) {
        OpenThread openThread = this.openThreads.get(ti);
        assert (openThread != null);
        openThread.timeAdjust(timeDiff);
    }

    List<ThreadDetail> cloneWaitThreadDetails() {
        return MonitorInfo.cloneThreadDetails(this.waitThreads);
    }

    List<ThreadDetail> cloneOwnerThreadDetails() {
        return MonitorInfo.cloneThreadDetails(this.ownerThreads);
    }

    static List<ThreadDetail> cloneThreadDetails(Map<ThreadInfo, ThreadDetail> threads) {
        ArrayList<ThreadDetail> details = new ArrayList<ThreadDetail>(threads.size());
        for (ThreadDetail d : threads.values()) {
            details.add(new ThreadDetail(d));
        }
        return details;
    }

    String getName() {
        return new StringBuffer(this.className).append('(').append(Integer.toHexString(this.monitorId)).append(')').toString();
    }

    static class ThreadDetail {
        final ThreadInfo threadInfo;
        private Map<ThreadInfo, ThreadDetail> threads;
        long count;
        long waitTime;

        ThreadDetail(ThreadInfo ti) {
            this.threadInfo = ti;
            this.threads = new HashMap<ThreadInfo, ThreadDetail>();
        }

        ThreadDetail(ThreadDetail d) {
            this.threadInfo = d.threadInfo;
            this.count = d.count;
            this.waitTime = d.waitTime;
            this.threads = new HashMap<ThreadInfo, ThreadDetail>();
            for (ThreadDetail td : d.threads.values()) {
                this.threads.put(td.threadInfo, new ThreadDetail(td));
            }
        }

        List<ThreadDetail> cloneThreadDetails() {
            return MonitorInfo.cloneThreadDetails(this.threads);
        }

        void addWait(ThreadInfo ti, long wait) {
            this.waitTime += wait;
            ++this.count;
            if (ti != null) {
                this.addThread(ti, wait);
            }
        }

        private void addThread(ThreadInfo ti, long wait) {
            ThreadDetail td = this.threads.get(ti);
            if (td == null) {
                td = new ThreadDetail(ti);
                this.threads.put(ti, td);
            }
            td.addWait(null, wait);
        }
    }

    private static class OpenThread {
        private final ThreadInfo threadInfo;
        private final ThreadInfo owner;
        private long timeStamp;

        OpenThread(ThreadInfo ti, ThreadInfo ownerTi, long ts) {
            this.threadInfo = ti;
            this.owner = ownerTi;
            this.timeStamp = ts;
        }

        private void timeAdjust(long timeDiff) {
            this.timeStamp += timeDiff;
        }
    }
}

