/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints.infrastructure;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public abstract class HintAction
extends TextAction
implements PropertyChangeListener {
    protected HintAction() {
        this(null);
    }

    protected HintAction(String key) {
        super(key);
        this.putValue("noIconInMenu", Boolean.TRUE);
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.setEnabled(false);
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.setEnabled(this.getCurrentDocument(new int[]{0, 0, 0}) != null);
    }

    @Override
    public boolean isEnabled() {
        this.updateEnabled();
        return super.isEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String error = this.doPerform();
        if (error != null) {
            String errorText = NbBundle.getMessage(HintAction.class, (String)error);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)errorText, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
    }

    private String doPerform() {
        int[] span = new int[3];
        Document doc = this.getCurrentDocument(span);
        if (doc == null) {
            if (span[0] != span[1]) {
                return "ERR_Not_Selected";
            }
            return "ERR_No_Selection";
        }
        CsmContext editorContext = CsmContext.create(doc, span[0], span[1], span[2]);
        if (editorContext == null) {
            return "ERR_Not_Supported";
        }
        this.perform(editorContext);
        return null;
    }

    protected abstract void perform(CsmContext var1);

    private Document getCurrentDocument(int[] span) {
        Document doc;
        Object stream;
        JTextComponent pane = EditorRegistry.lastFocusedComponent();
        if (pane == null) {
            return null;
        }
        if (span != null) {
            if (pane.getCaret() == null) {
                return null;
            }
            span[0] = pane.getSelectionStart();
            span[1] = pane.getSelectionEnd();
            span[2] = pane.getCaretPosition();
            if (span[0] == span[1] && this.requiresSelection()) {
                return null;
            }
        }
        Object object = stream = (doc = pane.getDocument()) != null ? doc.getProperty("stream") : null;
        if (!(stream instanceof DataObject)) {
            return null;
        }
        DataObject dObj = (DataObject)stream;
        FileObject result = dObj.getPrimaryFile();
        if (MIMENames.isHeaderOrCppOrC((String)FileUtil.getMIMEType((FileObject)result))) {
            return doc;
        }
        return null;
    }

    protected boolean requiresSelection() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateEnabled();
    }
}

