/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.impl;

import org.clang.basic.CudaVersion;
import org.clang.driver.Driver;
import org.clang.driver.Multilib;
import org.clang.driver.MultilibSet;
import org.clang.driver.impl.DetectedMultilibs;
import org.clang.driver.impl.Distro;
import org.clang.driver.impl.FilterNonExistent;
import org.clang.driver.java.DriverFunctionPointers;
import org.clang.driver.options;
import org.clang.driver.tools.impl.MipsStatics;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_functional;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.StringSwitchCharPtr;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.ARM;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public final class ToolChainsStatics {
    public static char.ptr ArmMachOArchName(StringRef Arch) {
        return new StringSwitchCharPtr(Arch).Case("armv6k", "armv6").Case("armv6m", "armv6m").Case("armv5tej", "armv5").Case("xscale", "xscale").Case("armv4t", "armv4t").Case("armv7", "armv7").Cases("armv7a", "armv7-a", "armv7").Cases("armv7r", "armv7-r", "armv7").Cases("armv7em", "armv7e-m", "armv7em").Cases("armv7k", "armv7-k", "armv7k").Cases("armv7m", "armv7-m", "armv7m").Cases("armv7s", "armv7-s", "armv7s").Default((char.ptr)null);
    }

    public static char.ptr ArmMachOArchNameCPU(StringRef CPU) {
        int ArchKind2 = ARM.parseCPUArch((StringRef)CPU);
        if (ArchKind2 == ARM.ArchKind.AK_INVALID.getValue()) {
            return null;
        }
        StringRef Arch = ARM.getArchName((int)ArchKind2);
        if (Arch.startswith("armv5")) {
            Arch.$assignMove(Arch.substr(0, 5));
        } else if (Arch.startswith("armv6") && !Arch.endswith("6m")) {
            Arch.$assignMove(Arch.substr(0, 5));
        } else if (Arch.endswith("v7a")) {
            Arch.$assignMove(Arch.substr(0, 5));
        }
        return Arch.data();
    }

    public static boolean isSoftFloatABI(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_msoft_float.getValue()), new OptSpecifier(options.ID.OPT_mhard_float.getValue()), new OptSpecifier(options.ID.OPT_mfloat_abi_EQ.getValue()));
        if (A == null) {
            return false;
        }
        return A.getOption().matches(new OptSpecifier(options.ID.OPT_msoft_float.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_mfloat_abi_EQ.getValue())) && llvm.$eq_StringRef((char.ptr)A.getValue(), (String)"soft");
    }

    public static boolean isObjCAutoRefCount(ArgList Args) {
        return Args.hasFlag(new OptSpecifier(options.ID.OPT_fobjc_arc.getValue()), new OptSpecifier(options.ID.OPT_fno_objc_arc.getValue()), false);
    }

    public static StringRef getGCCToolchainDir(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_gcc_toolchain.getValue()));
        if (A != null) {
            return new StringRef(A.getValue());
        }
        return new StringRef(NativePointer.$EMPTY);
    }

    public static CudaVersion ParseCudaVersionFile(StringRef V) {
        if (!V.startswith("CUDA Version ")) {
            return CudaVersion.UNKNOWN;
        }
        V.$assignMove(V.substr(std.strlen((char.ptr)NativePointer.$((String)"CUDA Version "))));
        int.ref $Major = NativePointer.create_int$ref((int)-1);
        int.ref $Minor = NativePointer.create_int$ref((int)-1);
        std_pair.pair First = V.split((byte)46);
        std_pair.pair Second = ((StringRef)First.second).split((byte)46);
        if (!((StringRef)First.first).getAsInteger$Signed(10, $Major) || !((StringRef)Second.first).getAsInteger$Signed(10, $Minor)) {
            return CudaVersion.UNKNOWN;
        }
        int Major = $Major.$deref();
        int Minor = $Minor.$deref();
        if (Major == 7 && Minor == 0) {
            return CudaVersion.CUDA_70;
        }
        if (Major == 7 && Minor == 5) {
            return CudaVersion.CUDA_75;
        }
        if (Major == 8 && Minor == 0) {
            return CudaVersion.CUDA_80;
        }
        return CudaVersion.UNKNOWN;
    }

    public static void addMultilibFlag(boolean Enabled, char.ptr Flag, std.vectorString Flags) {
        if (Enabled) {
            Flags.push_back(std.$add_string_T((std.string)new std.string(NativePointer.$PLUS), (char.ptr)Flag));
        } else {
            Flags.push_back(std.$add_string_T((std.string)new std.string(NativePointer.$MINUS), (char.ptr)Flag));
        }
    }

    public static boolean isArmOrThumbArch(Triple.ArchType Arch) {
        return Arch == Triple.ArchType.arm || Arch == Triple.ArchType.thumb;
    }

    public static boolean isMipsArch(Triple.ArchType Arch) {
        return Arch == Triple.ArchType.mips || Arch == Triple.ArchType.mipsel || Arch == Triple.ArchType.mips64 || Arch == Triple.ArchType.mips64el;
    }

    public static boolean isMips32(Triple.ArchType Arch) {
        return Arch == Triple.ArchType.mips || Arch == Triple.ArchType.mipsel;
    }

    public static boolean isMips64(Triple.ArchType Arch) {
        return Arch == Triple.ArchType.mips64 || Arch == Triple.ArchType.mips64el;
    }

    public static boolean isMipsEL(Triple.ArchType Arch) {
        return Arch == Triple.ArchType.mipsel || Arch == Triple.ArchType.mips64el;
    }

    public static boolean isMips16(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mips16.getValue()), new OptSpecifier(options.ID.OPT_mno_mips16.getValue()));
        return A != null && A.getOption().matches(new OptSpecifier(options.ID.OPT_mips16.getValue()));
    }

    public static boolean isMicroMips(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mmicromips.getValue()), new OptSpecifier(options.ID.OPT_mno_micromips.getValue()));
        return A != null && A.getOption().matches(new OptSpecifier(options.ID.OPT_mmicromips.getValue()));
    }

    public static Multilib makeMultilib(StringRef commonSuffix) {
        return new Multilib(new StringRef(commonSuffix), new StringRef(commonSuffix), new StringRef(commonSuffix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findMipsCsMultilibs(std.vectorString Flags, FilterNonExistent NonExistent, DetectedMultilibs Result) {
        MultilibSet CSMipsMultilibs = null;
        MultilibSet DebianMipsMultilibs = null;
        try {
            CSMipsMultilibs = new MultilibSet();
            Multilib MArchMips16 = null;
            Multilib MArchMicroMips = null;
            Multilib MArchDefault = null;
            Multilib UCLibc = null;
            Multilib SoftFloat = null;
            Multilib Nan2008 = null;
            Multilib DefaultFloat = null;
            Multilib BigEndian = null;
            Multilib LittleEndian = null;
            Multilib MAbi64 = null;
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                MArchMips16 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips16")))).flag(new StringRef("+m32")).flag(new StringRef("+mips16"))));
                MArchMicroMips = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/micromips")))).flag(new StringRef("+m32")).flag(new StringRef("+mmicromips"))));
                MArchDefault = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$EMPTY)))).flag(new StringRef("-mips16")).flag(new StringRef("-mmicromips"))));
                UCLibc = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/uclibc")))).flag(new StringRef("+muclibc"))));
                SoftFloat = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/soft-float")))).flag(new StringRef("+msoft-float"))));
                Nan2008 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/nan2008")))).flag(new StringRef("+mnan=2008"))));
                DefaultFloat = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$EMPTY)))).flag(new StringRef("-msoft-float")).flag(new StringRef("-mnan=2008"))));
                BigEndian = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$EMPTY)))).flag(new StringRef("+EB")).flag(new StringRef("-EL"))));
                LittleEndian = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/el")))).flag(new StringRef("+EL")).flag(new StringRef("-EB"))));
                MAbi64 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$EMPTY)))).gccSuffix(new StringRef("/64")).includeSuffix(new StringRef("/64")).flag(new StringRef("+mabi=n64")).flag(new StringRef("-mabi=n32")).flag(new StringRef("-m32"))));
                $c$.clean((Object)CSMipsMultilibs.$assign(((MultilibSet)$c$.track((Object)new MultilibSet())).Either(MArchMips16, MArchMicroMips, MArchDefault).Maybe(UCLibc).Either(SoftFloat, Nan2008, DefaultFloat).FilterOut(NativePointer.$((String)"/micromips/nan2008")).FilterOut(NativePointer.$((String)"/mips16/nan2008")).Either(BigEndian, LittleEndian).Maybe(MAbi64).FilterOut(NativePointer.$((String)"/mips16.*/64")).FilterOut(NativePointer.$((String)"/micromips.*/64")).FilterOut(new DriverFunctionPointers.FilterCallback(JavaDifferentiators.JD$NotSame2Callable.INSTANCE, NonExistent)).setIncludeDirsCallback((std_functional.function<DriverFunctionPointers.IncludeDirsFunc>)((std_functional.function)$c$.track((Object)new std_functional.function(M -> {
                    std.vectorString Dirs = null;
                    try {
                        Dirs = (std.vectorString)$c$.clean((Object)new std.vectorString((std.string[])$c$.track((Object)new std.string[]{new std.string((CharSequence)"/include")}), std.string.EMPTY));
                        if (new StringRef(M.includeSuffix()).startswith("/uclibc")) {
                            Dirs.push_back(new std.string((CharSequence)"/../../../../mips-linux-gnu/libc/uclibc/usr/include"));
                        } else {
                            Dirs.push_back(new std.string((CharSequence)"/../../../../mips-linux-gnu/libc/usr/include"));
                        }
                        std.vectorString vectorString2 = new std.vectorString(JavaDifferentiators.JD.Move.INSTANCE, Dirs);
                        return vectorString2;
                    }
                    finally {
                        if (Dirs != null) {
                            Dirs.$destroy();
                        }
                    }
                }))))));
            }
            finally {
                if (MAbi64 != null) {
                    MAbi64.$destroy();
                }
                if (LittleEndian != null) {
                    LittleEndian.$destroy();
                }
                if (BigEndian != null) {
                    BigEndian.$destroy();
                }
                if (DefaultFloat != null) {
                    DefaultFloat.$destroy();
                }
                if (Nan2008 != null) {
                    Nan2008.$destroy();
                }
                if (SoftFloat != null) {
                    SoftFloat.$destroy();
                }
                if (UCLibc != null) {
                    UCLibc.$destroy();
                }
                if (MArchDefault != null) {
                    MArchDefault.$destroy();
                }
                if (MArchMicroMips != null) {
                    MArchMicroMips.$destroy();
                }
                if (MArchMips16 != null) {
                    MArchMips16.$destroy();
                }
                $c$.$destroy();
            }
            DebianMipsMultilibs = new MultilibSet();
            Multilib MAbiN32 = null;
            Multilib M64 = null;
            Multilib M32 = null;
            JavaCleaner $c$2 = Native.$createJavaCleaner();
            try {
                MAbiN32 = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)new Multilib())).gccSuffix(new StringRef("/n32")).includeSuffix(new StringRef("/n32")).flag(new StringRef("+mabi=n32"))));
                M64 = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)new Multilib())).gccSuffix(new StringRef("/64")).includeSuffix(new StringRef("/64")).flag(new StringRef("+m64")).flag(new StringRef("-m32")).flag(new StringRef("-mabi=n32"))));
                M32 = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)new Multilib())).flag(new StringRef("-m64")).flag(new StringRef("+m32")).flag(new StringRef("-mabi=n32"))));
                $c$2.clean((Object)DebianMipsMultilibs.$assign(((MultilibSet)$c$2.track((Object)new MultilibSet())).Either(M32, M64, MAbiN32).FilterOut(new DriverFunctionPointers.FilterCallback(JavaDifferentiators.JD$NotSame2Callable.INSTANCE, NonExistent))));
            }
            finally {
                if (M32 != null) {
                    M32.$destroy();
                }
                if (M64 != null) {
                    M64.$destroy();
                }
                if (MAbiN32 != null) {
                    MAbiN32.$destroy();
                }
                $c$2.$destroy();
            }
            Object[] Candidates = new MultilibSet[]{CSMipsMultilibs, DebianMipsMultilibs};
            if (Unsigned.$less_uint((int)CSMipsMultilibs.size(), (int)DebianMipsMultilibs.size())) {
                std.iter_swap((Object[])Candidates, (int)0, (int)1);
            }
            for (Object Candidate : Candidates) {
                if (!((MultilibSet)Candidate).select(Flags, Result.SelectedMultilib)) continue;
                if (Candidate == DebianMipsMultilibs) {
                    JavaCleaner $c$3 = Native.$createJavaCleaner();
                    try {
                        $c$3.clean((Object)Result.BiarchSibling.$assign($c$3.track((Object)new Multilib())));
                    }
                    finally {
                        $c$3.$destroy();
                    }
                }
                Result.Multilibs.$assign((MultilibSet)Candidate);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (DebianMipsMultilibs != null) {
                DebianMipsMultilibs.$destroy();
            }
            if (CSMipsMultilibs != null) {
                CSMipsMultilibs.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findMipsAndroidMultilibs(std.vectorString Flags, FilterNonExistent NonExistent, DetectedMultilibs Result) {
        MultilibSet AndroidMipsMultilibs = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            AndroidMipsMultilibs = (MultilibSet)$c$.clean((Object)new MultilibSet(((MultilibSet)$c$.track((Object)new MultilibSet())).Maybe(((Multilib)$c$.track((Object)new Multilib(new StringRef("/mips-r2")))).flag(new StringRef("+march=mips32r2"))).Maybe(((Multilib)$c$.track((Object)new Multilib(new StringRef("/mips-r6")))).flag(new StringRef("+march=mips32r6"))).FilterOut(new DriverFunctionPointers.FilterCallback(JavaDifferentiators.JD$NotSame2Callable.INSTANCE, NonExistent))));
            if (AndroidMipsMultilibs.select(Flags, Result.SelectedMultilib)) {
                Result.Multilibs.$assign(AndroidMipsMultilibs);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (AndroidMipsMultilibs != null) {
                AndroidMipsMultilibs.$destroy();
            }
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findMipsMuslMultilibs(std.vectorString Flags, FilterNonExistent NonExistent, DetectedMultilibs Result) {
        MultilibSet MuslMipsMultilibs = null;
        try {
            MuslMipsMultilibs = new MultilibSet();
            Multilib MArchMipsR2 = null;
            Multilib MArchMipselR2 = null;
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                MArchMipsR2 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$EMPTY)))).osSuffix(new StringRef("/mips-r2-hard-musl")).flag(new StringRef("+EB")).flag(new StringRef("-EL")).flag(new StringRef("+march=mips32r2"))));
                MArchMipselR2 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mipsel-r2-hard-musl")))).flag(new StringRef("-EB")).flag(new StringRef("+EL")).flag(new StringRef("+march=mips32r2"))));
                $c$.clean((Object)MuslMipsMultilibs.$assign(((MultilibSet)$c$.track((Object)new MultilibSet())).Either(MArchMipsR2, MArchMipselR2)));
                $c$.clean((Object)MuslMipsMultilibs.setIncludeDirsCallback((std_functional.function<DriverFunctionPointers.IncludeDirsFunc>)((std_functional.function)$c$.track((Object)new std_functional.function(M -> (std.vectorString)$c$.clean((Object)new std.vectorString((std.string[])$c$.track((Object)new std.string[]{std.$add_string_T((std.string)std.$add_T_string$C((String)"/../sysroot", (std.string)M.osSuffix()), (String)"/usr/include")}), std.string.EMPTY)))))));
            }
            finally {
                if (MArchMipselR2 != null) {
                    MArchMipselR2.$destroy();
                }
                if (MArchMipsR2 != null) {
                    MArchMipsR2.$destroy();
                }
                $c$.$destroy();
            }
            if (MuslMipsMultilibs.select(Flags, Result.SelectedMultilib)) {
                Result.Multilibs.$assign(MuslMipsMultilibs);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (MuslMipsMultilibs != null) {
                MuslMipsMultilibs.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findMipsMtiMultilibs(std.vectorString Flags, FilterNonExistent NonExistent, DetectedMultilibs Result) {
        MultilibSet MtiMipsMultilibsV1 = null;
        MultilibSet MtiMipsMultilibsV2 = null;
        try {
            MtiMipsMultilibsV1 = new MultilibSet();
            Multilib MArchMips32 = null;
            Multilib MArchMicroMips = null;
            Multilib MArchMips64r2 = null;
            Multilib MArchMips64 = null;
            Multilib MArchDefault = null;
            Multilib Mips16 = null;
            Multilib UCLibc = null;
            Multilib MAbi64 = null;
            Multilib BigEndian = null;
            Multilib LittleEndian = null;
            Multilib SoftFloat = null;
            Multilib Nan2008 = null;
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                MArchMips32 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips32")))).flag(new StringRef("+m32")).flag(new StringRef("-m64")).flag(new StringRef("-mmicromips")).flag(new StringRef("+march=mips32"))));
                MArchMicroMips = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/micromips")))).flag(new StringRef("+m32")).flag(new StringRef("-m64")).flag(new StringRef("+mmicromips"))));
                MArchMips64r2 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips64r2")))).flag(new StringRef("-m32")).flag(new StringRef("+m64")).flag(new StringRef("+march=mips64r2"))));
                MArchMips64 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips64")))).flag(new StringRef("-m32")).flag(new StringRef("+m64")).flag(new StringRef("-march=mips64r2"))));
                MArchDefault = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$EMPTY)))).flag(new StringRef("+m32")).flag(new StringRef("-m64")).flag(new StringRef("-mmicromips")).flag(new StringRef("+march=mips32r2"))));
                Mips16 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips16")))).flag(new StringRef("+mips16"))));
                UCLibc = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/uclibc")))).flag(new StringRef("+muclibc"))));
                MAbi64 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/64")))).flag(new StringRef("+mabi=n64")).flag(new StringRef("-mabi=n32")).flag(new StringRef("-m32"))));
                BigEndian = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$EMPTY)))).flag(new StringRef("+EB")).flag(new StringRef("-EL"))));
                LittleEndian = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/el")))).flag(new StringRef("+EL")).flag(new StringRef("-EB"))));
                SoftFloat = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/sof")))).flag(new StringRef("+msoft-float"))));
                Nan2008 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/nan2008")))).flag(new StringRef("+mnan=2008"))));
                $c$.clean((Object)MtiMipsMultilibsV1.$assign(((MultilibSet)$c$.track((Object)new MultilibSet())).Either(MArchMips32, MArchMicroMips, MArchMips64r2, MArchMips64, MArchDefault).Maybe(UCLibc).Maybe(Mips16).FilterOut(NativePointer.$((String)"/mips64/mips16")).FilterOut(NativePointer.$((String)"/mips64r2/mips16")).FilterOut(NativePointer.$((String)"/micromips/mips16")).Maybe(MAbi64).FilterOut(NativePointer.$((String)"/micromips/64")).FilterOut(NativePointer.$((String)"/mips32/64")).FilterOut(NativePointer.$((String)"^/64")).FilterOut(NativePointer.$((String)"/mips16/64")).Either(BigEndian, LittleEndian).Maybe(SoftFloat).Maybe(Nan2008).FilterOut(NativePointer.$((String)".*sof/nan2008")).FilterOut(NonExistent).setIncludeDirsCallback((std_functional.function<DriverFunctionPointers.IncludeDirsFunc>)((std_functional.function)$c$.track((Object)new std_functional.function(M -> {
                    std.vectorString Dirs = null;
                    try {
                        Dirs = (std.vectorString)$c$.clean((Object)new std.vectorString((std.string[])$c$.track((Object)new std.string[]{new std.string((CharSequence)"/include")}), std.string.EMPTY));
                        if (new StringRef(M.includeSuffix()).startswith("/uclibc")) {
                            Dirs.push_back(new std.string((CharSequence)"/../../../../sysroot/uclibc/usr/include"));
                        } else {
                            Dirs.push_back(new std.string((CharSequence)"/../../../../sysroot/usr/include"));
                        }
                        std.vectorString vectorString2 = new std.vectorString(JavaDifferentiators.JD.Move.INSTANCE, Dirs);
                        return vectorString2;
                    }
                    finally {
                        if (Dirs != null) {
                            Dirs.$destroy();
                        }
                    }
                }))))));
            }
            finally {
                if (Nan2008 != null) {
                    Nan2008.$destroy();
                }
                if (SoftFloat != null) {
                    SoftFloat.$destroy();
                }
                if (LittleEndian != null) {
                    LittleEndian.$destroy();
                }
                if (BigEndian != null) {
                    BigEndian.$destroy();
                }
                if (MAbi64 != null) {
                    MAbi64.$destroy();
                }
                if (UCLibc != null) {
                    UCLibc.$destroy();
                }
                if (Mips16 != null) {
                    Mips16.$destroy();
                }
                if (MArchDefault != null) {
                    MArchDefault.$destroy();
                }
                if (MArchMips64 != null) {
                    MArchMips64.$destroy();
                }
                if (MArchMips64r2 != null) {
                    MArchMips64r2.$destroy();
                }
                if (MArchMicroMips != null) {
                    MArchMicroMips.$destroy();
                }
                if (MArchMips32 != null) {
                    MArchMips32.$destroy();
                }
                $c$.$destroy();
            }
            MtiMipsMultilibsV2 = new MultilibSet();
            Multilib BeHard = null;
            Multilib BeSoft = null;
            Multilib ElHard = null;
            Multilib ElSoft = null;
            Multilib BeHardNan = null;
            Multilib ElHardNan = null;
            Multilib BeHardNanUclibc = null;
            Multilib ElHardNanUclibc = null;
            Multilib BeHardUclibc = null;
            Multilib ElHardUclibc = null;
            Multilib ElMicroHardNan = null;
            Multilib ElMicroSoft = null;
            Multilib O32 = null;
            Multilib N32 = null;
            Multilib N64 = null;
            JavaCleaner $c$2 = Native.$createJavaCleaner();
            try {
                BeHard = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips-r2-hard")))).flag(new StringRef("+EB")).flag(new StringRef("-msoft-float")).flag(new StringRef("-mnan=2008")).flag(new StringRef("-muclibc"))));
                BeSoft = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips-r2-soft")))).flag(new StringRef("+EB")).flag(new StringRef("+msoft-float")).flag(new StringRef("-mnan=2008"))));
                ElHard = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mipsel-r2-hard")))).flag(new StringRef("+EL")).flag(new StringRef("-msoft-float")).flag(new StringRef("-mnan=2008")).flag(new StringRef("-muclibc"))));
                ElSoft = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mipsel-r2-soft")))).flag(new StringRef("+EL")).flag(new StringRef("+msoft-float")).flag(new StringRef("-mnan=2008")).flag(new StringRef("-mmicromips"))));
                BeHardNan = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips-r2-hard-nan2008")))).flag(new StringRef("+EB")).flag(new StringRef("-msoft-float")).flag(new StringRef("+mnan=2008")).flag(new StringRef("-muclibc"))));
                ElHardNan = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mipsel-r2-hard-nan2008")))).flag(new StringRef("+EL")).flag(new StringRef("-msoft-float")).flag(new StringRef("+mnan=2008")).flag(new StringRef("-muclibc")).flag(new StringRef("-mmicromips"))));
                BeHardNanUclibc = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips-r2-hard-nan2008-uclibc")))).flag(new StringRef("+EB")).flag(new StringRef("-msoft-float")).flag(new StringRef("+mnan=2008")).flag(new StringRef("+muclibc"))));
                ElHardNanUclibc = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mipsel-r2-hard-nan2008-uclibc")))).flag(new StringRef("+EL")).flag(new StringRef("-msoft-float")).flag(new StringRef("+mnan=2008")).flag(new StringRef("+muclibc"))));
                BeHardUclibc = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips-r2-hard-uclibc")))).flag(new StringRef("+EB")).flag(new StringRef("-msoft-float")).flag(new StringRef("-mnan=2008")).flag(new StringRef("+muclibc"))));
                ElHardUclibc = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mipsel-r2-hard-uclibc")))).flag(new StringRef("+EL")).flag(new StringRef("-msoft-float")).flag(new StringRef("-mnan=2008")).flag(new StringRef("+muclibc"))));
                ElMicroHardNan = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/micromipsel-r2-hard-nan2008")))).flag(new StringRef("+EL")).flag(new StringRef("-msoft-float")).flag(new StringRef("+mnan=2008")).flag(new StringRef("+mmicromips"))));
                ElMicroSoft = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/micromipsel-r2-soft")))).flag(new StringRef("+EL")).flag(new StringRef("+msoft-float")).flag(new StringRef("-mnan=2008")).flag(new StringRef("+mmicromips"))));
                O32 = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/lib")))).osSuffix(new StringRef(NativePointer.$EMPTY)).flag(new StringRef("-mabi=n32")).flag(new StringRef("-mabi=n64"))));
                N32 = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/lib32")))).osSuffix(new StringRef(NativePointer.$EMPTY)).flag(new StringRef("+mabi=n32")).flag(new StringRef("-mabi=n64"))));
                N64 = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/lib64")))).osSuffix(new StringRef(NativePointer.$EMPTY)).flag(new StringRef("-mabi=n32")).flag(new StringRef("+mabi=n64"))));
                $c$2.clean((Object)MtiMipsMultilibsV2.$assign(((MultilibSet)$c$2.track((Object)new MultilibSet())).Either((ArrayRef<Multilib>)new ArrayRef((Object[])$c$2.track((Object)new Multilib[]{BeHard, BeSoft, ElHard, ElSoft, BeHardNan, ElHardNan, BeHardNanUclibc, ElHardNanUclibc, BeHardUclibc, ElHardUclibc, ElMicroHardNan, ElMicroSoft}))).Either(O32, N32, N64).FilterOut(new DriverFunctionPointers.FilterCallback(JavaDifferentiators.JD$NotSame2Callable.INSTANCE, NonExistent)).setIncludeDirsCallback((std_functional.function<DriverFunctionPointers.IncludeDirsFunc>)((std_functional.function)$c$2.track((Object)new std_functional.function(M -> (std.vectorString)$c$2.clean((Object)new std.vectorString((std.string[])$c$2.track((Object)new std.string[]{std.$add_string_T((std.string)std.$add_T_string$C((String)"/../../../../sysroot", (std.string)M.includeSuffix()), (String)"/../usr/include")}), std.string.EMPTY)))))).setFilePathsCallback((std_functional.function<DriverFunctionPointers.IncludeDirsFunc>)((std_functional.function)$c$2.track((Object)new std_functional.function(M -> (std.vectorString)$c$2.clean((Object)new std.vectorString((std.string[])$c$2.track((Object)new std.string[]{std.$add_T_string$C((String)"/../../../../mips-mti-linux-gnu/lib", (std.string)M.gccSuffix())}), std.string.EMPTY))))))));
            }
            finally {
                if (N64 != null) {
                    N64.$destroy();
                }
                if (N32 != null) {
                    N32.$destroy();
                }
                if (O32 != null) {
                    O32.$destroy();
                }
                if (ElMicroSoft != null) {
                    ElMicroSoft.$destroy();
                }
                if (ElMicroHardNan != null) {
                    ElMicroHardNan.$destroy();
                }
                if (ElHardUclibc != null) {
                    ElHardUclibc.$destroy();
                }
                if (BeHardUclibc != null) {
                    BeHardUclibc.$destroy();
                }
                if (ElHardNanUclibc != null) {
                    ElHardNanUclibc.$destroy();
                }
                if (BeHardNanUclibc != null) {
                    BeHardNanUclibc.$destroy();
                }
                if (ElHardNan != null) {
                    ElHardNan.$destroy();
                }
                if (BeHardNan != null) {
                    BeHardNan.$destroy();
                }
                if (ElSoft != null) {
                    ElSoft.$destroy();
                }
                if (ElHard != null) {
                    ElHard.$destroy();
                }
                if (BeSoft != null) {
                    BeSoft.$destroy();
                }
                if (BeHard != null) {
                    BeHard.$destroy();
                }
                $c$2.$destroy();
            }
            for (MultilibSet Candidate : new MultilibSet[]{MtiMipsMultilibsV1, MtiMipsMultilibsV2}) {
                if (!Candidate.select(Flags, Result.SelectedMultilib)) continue;
                Result.Multilibs.$assign(Candidate);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (MtiMipsMultilibsV2 != null) {
                MtiMipsMultilibsV2.$destroy();
            }
            if (MtiMipsMultilibsV1 != null) {
                MtiMipsMultilibsV1.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findMipsImgMultilibs(std.vectorString Flags, FilterNonExistent NonExistent, DetectedMultilibs Result) {
        MultilibSet ImgMultilibsV1 = null;
        MultilibSet ImgMultilibsV2 = null;
        try {
            ImgMultilibsV1 = new MultilibSet();
            Multilib Mips64r6 = null;
            Multilib LittleEndian = null;
            Multilib MAbi64 = null;
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                Mips64r6 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips64r6")))).flag(new StringRef("+m64")).flag(new StringRef("-m32"))));
                LittleEndian = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/el")))).flag(new StringRef("+EL")).flag(new StringRef("-EB"))));
                MAbi64 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/64")))).flag(new StringRef("+mabi=n64")).flag(new StringRef("-mabi=n32")).flag(new StringRef("-m32"))));
                $c$.clean((Object)ImgMultilibsV1.$assign(((MultilibSet)$c$.track((Object)new MultilibSet())).Maybe(Mips64r6).Maybe(MAbi64).Maybe(LittleEndian).FilterOut(new DriverFunctionPointers.FilterCallback(JavaDifferentiators.JD$NotSame2Callable.INSTANCE, NonExistent)).setIncludeDirsCallback((std_functional.function<DriverFunctionPointers.IncludeDirsFunc>)((std_functional.function)$c$.track((Object)new std_functional.function(M -> (std.vectorString)$c$.clean((Object)new std.vectorString((std.string[])$c$.track((Object)new std.string[]{new std.string((CharSequence)"/include"), new std.string((CharSequence)"/../../../../sysroot/usr/include")}), std.string.EMPTY))))))));
            }
            finally {
                if (MAbi64 != null) {
                    MAbi64.$destroy();
                }
                if (LittleEndian != null) {
                    LittleEndian.$destroy();
                }
                if (Mips64r6 != null) {
                    Mips64r6.$destroy();
                }
                $c$.$destroy();
            }
            ImgMultilibsV2 = new MultilibSet();
            Multilib BeHard = null;
            Multilib BeSoft = null;
            Multilib ElHard = null;
            Multilib ElSoft = null;
            Multilib BeMicroHard = null;
            Multilib BeMicroSoft = null;
            Multilib ElMicroHard = null;
            Multilib ElMicroSoft = null;
            Multilib O32 = null;
            Multilib N32 = null;
            Multilib N64 = null;
            JavaCleaner $c$2 = Native.$createJavaCleaner();
            try {
                BeHard = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips-r6-hard")))).flag(new StringRef("+EB")).flag(new StringRef("-msoft-float")).flag(new StringRef("-mmicromips"))));
                BeSoft = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mips-r6-soft")))).flag(new StringRef("+EB")).flag(new StringRef("+msoft-float")).flag(new StringRef("-mmicromips"))));
                ElHard = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mipsel-r6-hard")))).flag(new StringRef("+EL")).flag(new StringRef("-msoft-float")).flag(new StringRef("-mmicromips"))));
                ElSoft = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/mipsel-r6-soft")))).flag(new StringRef("+EL")).flag(new StringRef("+msoft-float")).flag(new StringRef("-mmicromips"))));
                BeMicroHard = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/micromips-r6-hard")))).flag(new StringRef("+EB")).flag(new StringRef("-msoft-float")).flag(new StringRef("+mmicromips"))));
                BeMicroSoft = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/micromips-r6-soft")))).flag(new StringRef("+EB")).flag(new StringRef("+msoft-float")).flag(new StringRef("+mmicromips"))));
                ElMicroHard = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/micromipsel-r6-hard")))).flag(new StringRef("+EL")).flag(new StringRef("-msoft-float")).flag(new StringRef("+mmicromips"))));
                ElMicroSoft = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/micromipsel-r6-soft")))).flag(new StringRef("+EL")).flag(new StringRef("+msoft-float")).flag(new StringRef("+mmicromips"))));
                O32 = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/lib")))).osSuffix(new StringRef(NativePointer.$EMPTY)).flag(new StringRef("-mabi=n32")).flag(new StringRef("-mabi=n64"))));
                N32 = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/lib32")))).osSuffix(new StringRef(NativePointer.$EMPTY)).flag(new StringRef("+mabi=n32")).flag(new StringRef("-mabi=n64"))));
                N64 = (Multilib)$c$2.clean((Object)new Multilib(((Multilib)$c$2.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/lib64")))).osSuffix(new StringRef(NativePointer.$EMPTY)).flag(new StringRef("-mabi=n32")).flag(new StringRef("+mabi=n64"))));
                $c$2.clean((Object)ImgMultilibsV2.$assign(((MultilibSet)$c$2.track((Object)new MultilibSet())).Either((ArrayRef<Multilib>)new ArrayRef((Object[])$c$2.track((Object)new Multilib[]{BeHard, BeSoft, ElHard, ElSoft, BeMicroHard, BeMicroSoft, ElMicroHard, ElMicroSoft}))).Either(O32, N32, N64).FilterOut(new DriverFunctionPointers.FilterCallback(JavaDifferentiators.JD$NotSame2Callable.INSTANCE, NonExistent)).setIncludeDirsCallback((std_functional.function<DriverFunctionPointers.IncludeDirsFunc>)((std_functional.function)$c$2.track((Object)new std_functional.function(M -> (std.vectorString)$c$2.clean((Object)new std.vectorString((std.string[])$c$2.track((Object)new std.string[]{std.$add_string_T((std.string)std.$add_T_string$C((String)"/../../../../sysroot", (std.string)M.includeSuffix()), (String)"/../usr/include")}), std.string.EMPTY)))))).setFilePathsCallback((std_functional.function<DriverFunctionPointers.IncludeDirsFunc>)((std_functional.function)$c$2.track((Object)new std_functional.function(M -> (std.vectorString)$c$2.clean((Object)new std.vectorString((std.string[])$c$2.track((Object)new std.string[]{std.$add_T_string$C((String)"/../../../../mips-img-linux-gnu/lib", (std.string)M.gccSuffix())}), std.string.EMPTY))))))));
            }
            finally {
                if (N64 != null) {
                    N64.$destroy();
                }
                if (N32 != null) {
                    N32.$destroy();
                }
                if (O32 != null) {
                    O32.$destroy();
                }
                if (ElMicroSoft != null) {
                    ElMicroSoft.$destroy();
                }
                if (ElMicroHard != null) {
                    ElMicroHard.$destroy();
                }
                if (BeMicroSoft != null) {
                    BeMicroSoft.$destroy();
                }
                if (BeMicroHard != null) {
                    BeMicroHard.$destroy();
                }
                if (ElSoft != null) {
                    ElSoft.$destroy();
                }
                if (ElHard != null) {
                    ElHard.$destroy();
                }
                if (BeSoft != null) {
                    BeSoft.$destroy();
                }
                if (BeHard != null) {
                    BeHard.$destroy();
                }
                $c$2.$destroy();
            }
            for (MultilibSet Candidate : new MultilibSet[]{ImgMultilibsV1, ImgMultilibsV2}) {
                if (!Candidate.select(Flags, Result.SelectedMultilib)) continue;
                Result.Multilibs.$assign(Candidate);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (ImgMultilibsV2 != null) {
                ImgMultilibsV2.$destroy();
            }
            if (ImgMultilibsV1 != null) {
                ImgMultilibsV1.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findMIPSMultilibs(Driver D, Triple TargetTriple, StringRef Path, ArgList Args, DetectedMultilibs Result) {
        std.vectorString Flags = null;
        Multilib Default = null;
        try {
            FilterNonExistent NonExistent = new FilterNonExistent(new StringRef(Path), new StringRef("/crtbegin.o"), D.getVFS());
            StringRef CPUName = new StringRef();
            StringRef ABIName = new StringRef();
            MipsStatics.getMipsCPUAndABI(Args, TargetTriple, CPUName, ABIName);
            Triple.ArchType TargetArch = TargetTriple.getArch();
            Flags = new std.vectorString(std.string.EMPTY);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isMips32(TargetArch), NativePointer.$((String)"m32"), Flags);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isMips64(TargetArch), NativePointer.$((String)"m64"), Flags);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isMips16(Args), NativePointer.$((String)"mips16"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)CPUName, (String)"mips32"), NativePointer.$((String)"march=mips32"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)CPUName, (String)"mips32r2") || llvm.$eq_StringRef((StringRef)CPUName, (String)"mips32r3") || llvm.$eq_StringRef((StringRef)CPUName, (String)"mips32r5") || llvm.$eq_StringRef((StringRef)CPUName, (String)"p5600"), NativePointer.$((String)"march=mips32r2"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)CPUName, (String)"mips32r6"), NativePointer.$((String)"march=mips32r6"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)CPUName, (String)"mips64"), NativePointer.$((String)"march=mips64"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)CPUName, (String)"mips64r2") || llvm.$eq_StringRef((StringRef)CPUName, (String)"mips64r3") || llvm.$eq_StringRef((StringRef)CPUName, (String)"mips64r5") || llvm.$eq_StringRef((StringRef)CPUName, (String)"octeon"), NativePointer.$((String)"march=mips64r2"), Flags);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isMicroMips(Args), NativePointer.$((String)"mmicromips"), Flags);
            ToolChainsStatics.addMultilibFlag(MipsStatics.isUCLibc(Args), NativePointer.$((String)"muclibc"), Flags);
            ToolChainsStatics.addMultilibFlag(MipsStatics.isNaN2008(Args, TargetTriple), NativePointer.$((String)"mnan=2008"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)ABIName, (String)"n32"), NativePointer.$((String)"mabi=n32"), Flags);
            ToolChainsStatics.addMultilibFlag(llvm.$eq_StringRef((StringRef)ABIName, (String)"n64"), NativePointer.$((String)"mabi=n64"), Flags);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isSoftFloatABI(Args), NativePointer.$((String)"msoft-float"), Flags);
            ToolChainsStatics.addMultilibFlag(!ToolChainsStatics.isSoftFloatABI(Args), NativePointer.$((String)"mhard-float"), Flags);
            ToolChainsStatics.addMultilibFlag(ToolChainsStatics.isMipsEL(TargetArch), NativePointer.$((String)"EL"), Flags);
            ToolChainsStatics.addMultilibFlag(!ToolChainsStatics.isMipsEL(TargetArch), NativePointer.$((String)"EB"), Flags);
            if (TargetTriple.isAndroid()) {
                boolean bl = ToolChainsStatics.findMipsAndroidMultilibs(Flags, NonExistent, Result);
                return bl;
            }
            if (TargetTriple.getVendor() == Triple.VendorType.MipsTechnologies && TargetTriple.getOS() == Triple.OSType.Linux && TargetTriple.getEnvironment() == Triple.EnvironmentType.UnknownEnvironment) {
                boolean bl = ToolChainsStatics.findMipsMuslMultilibs(Flags, NonExistent, Result);
                return bl;
            }
            if (TargetTriple.getVendor() == Triple.VendorType.MipsTechnologies && TargetTriple.getOS() == Triple.OSType.Linux && TargetTriple.getEnvironment() == Triple.EnvironmentType.GNU) {
                boolean bl = ToolChainsStatics.findMipsMtiMultilibs(Flags, NonExistent, Result);
                return bl;
            }
            if (TargetTriple.getVendor() == Triple.VendorType.ImaginationTechnologies && TargetTriple.getOS() == Triple.OSType.Linux && TargetTriple.getEnvironment() == Triple.EnvironmentType.GNU) {
                boolean bl = ToolChainsStatics.findMipsImgMultilibs(Flags, NonExistent, Result);
                return bl;
            }
            if (ToolChainsStatics.findMipsCsMultilibs(Flags, NonExistent, Result)) {
                boolean bl = true;
                return bl;
            }
            Default = new Multilib();
            Result.Multilibs.push_back(Default);
            Result.Multilibs.FilterOut(new DriverFunctionPointers.FilterCallback(JavaDifferentiators.JD$NotSame2Callable.INSTANCE, NonExistent));
            if (Result.Multilibs.select(Flags, Result.SelectedMultilib)) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)Result.BiarchSibling.$assign($c$.track((Object)new Multilib())));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    $c$.$destroy();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (Default != null) {
                Default.$destroy();
            }
            if (Flags != null) {
                Flags.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void findAndroidArmMultilibs(Driver D, Triple TargetTriple, StringRef Path, ArgList Args, DetectedMultilibs Result) {
        Multilib ArmV7Multilib = null;
        Multilib ThumbMultilib = null;
        Multilib ArmV7ThumbMultilib = null;
        Multilib DefaultMultilib = null;
        MultilibSet AndroidArmMultilibs = null;
        std.vectorString Flags = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            FilterNonExistent NonExistent = new FilterNonExistent(new StringRef(Path), new StringRef("/crtbegin.o"), D.getVFS());
            ArmV7Multilib = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/armv7-a")))).flag(new StringRef("+armv7")).flag(new StringRef("-thumb"))));
            ThumbMultilib = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/thumb")))).flag(new StringRef("-armv7")).flag(new StringRef("+thumb"))));
            ArmV7ThumbMultilib = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef("/armv7-a/thumb")))).flag(new StringRef("+armv7")).flag(new StringRef("+thumb"))));
            DefaultMultilib = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)ToolChainsStatics.makeMultilib(new StringRef(NativePointer.$EMPTY)))).flag(new StringRef("-armv7")).flag(new StringRef("-thumb"))));
            AndroidArmMultilibs = (MultilibSet)$c$.clean((Object)new MultilibSet(((MultilibSet)$c$.track((Object)new MultilibSet())).Either(ThumbMultilib, ArmV7Multilib, ArmV7ThumbMultilib, DefaultMultilib).FilterOut(new DriverFunctionPointers.FilterCallback(JavaDifferentiators.JD$NotSame2Callable.INSTANCE, NonExistent))));
            Flags = new std.vectorString(std.string.EMPTY);
            StringRef Arch = Args.getLastArgValue(new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
            boolean IsArmArch = TargetTriple.getArch() == Triple.ArchType.arm;
            boolean IsThumbArch = TargetTriple.getArch() == Triple.ArchType.thumb;
            boolean IsV7SubArch = TargetTriple.getSubArch() == Triple.SubArchType.ARMSubArch_v7;
            boolean IsThumbMode = IsThumbArch || Args.hasFlag(new OptSpecifier(options.ID.OPT_mthumb.getValue()), new OptSpecifier(options.ID.OPT_mno_thumb.getValue()), false) || IsArmArch && ARM.parseArchISA((StringRef)Arch) == ARM.ISAKind.IK_THUMB.getValue();
            boolean IsArmV7Mode = (IsArmArch || IsThumbArch) && (ARM.parseArchVersion((StringRef)Arch) == 7 || IsArmArch && llvm.$eq_StringRef((StringRef)Arch, (String)"") && IsV7SubArch);
            ToolChainsStatics.addMultilibFlag(IsArmV7Mode, NativePointer.$((String)"armv7"), Flags);
            ToolChainsStatics.addMultilibFlag(IsThumbMode, NativePointer.$((String)"thumb"), Flags);
            if (AndroidArmMultilibs.select(Flags, Result.SelectedMultilib)) {
                Result.Multilibs.$assign(AndroidArmMultilibs);
            }
        }
        finally {
            if (Flags != null) {
                Flags.$destroy();
            }
            if (AndroidArmMultilibs != null) {
                AndroidArmMultilibs.$destroy();
            }
            if (DefaultMultilib != null) {
                DefaultMultilib.$destroy();
            }
            if (ArmV7ThumbMultilib != null) {
                ArmV7ThumbMultilib.$destroy();
            }
            if (ThumbMultilib != null) {
                ThumbMultilib.$destroy();
            }
            if (ArmV7Multilib != null) {
                ArmV7Multilib.$destroy();
            }
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findBiarchMultilibs(Driver D, Triple TargetTriple, StringRef Path, ArgList Args, boolean NeedsBiarchSuffix, DetectedMultilibs Result) {
        Multilib Default = null;
        Multilib Alt64 = null;
        Multilib Alt32 = null;
        Multilib Altx32 = null;
        std.vectorString Flags = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            boolean IsX32;
            Default = new Multilib();
            Alt64 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)new Multilib())).gccSuffix(new StringRef("/64")).includeSuffix(new StringRef("/64")).flag(new StringRef("-m32")).flag(new StringRef("+m64")).flag(new StringRef("-mx32"))));
            Alt32 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)new Multilib())).gccSuffix(new StringRef("/32")).includeSuffix(new StringRef("/32")).flag(new StringRef("+m32")).flag(new StringRef("-m64")).flag(new StringRef("-mx32"))));
            Altx32 = (Multilib)$c$.clean((Object)new Multilib(((Multilib)$c$.track((Object)new Multilib())).gccSuffix(new StringRef("/x32")).includeSuffix(new StringRef("/x32")).flag(new StringRef("-m32")).flag(new StringRef("-m64")).flag(new StringRef("+mx32"))));
            FilterNonExistent NonExistent = new FilterNonExistent(new StringRef(Path), new StringRef(TargetTriple.isOSIAMCU() ? NativePointer.$((String)"/libgcc.a") : NativePointer.$((String)"/crtbegin.o")), D.getVFS());
            boolean UNKNOWN = false;
            boolean WANT32 = true;
            int WANT64 = 2;
            int WANTX32 = 3;
            int Want = 0;
            boolean bl = IsX32 = TargetTriple.getEnvironment() == Triple.EnvironmentType.GNUX32;
            if (TargetTriple.isArch32Bit() && !NonExistent.$call(Alt32)) {
                Want = 2;
            } else if (TargetTriple.isArch64Bit() && IsX32 && !NonExistent.$call(Altx32)) {
                Want = 2;
            } else if (TargetTriple.isArch64Bit() && !IsX32 && !NonExistent.$call(Alt64)) {
                Want = 1;
            } else if (TargetTriple.isArch32Bit()) {
                Want = NeedsBiarchSuffix ? 2 : 1;
            } else if (IsX32) {
                Want = NeedsBiarchSuffix ? 2 : 3;
            } else {
                int n = Want = NeedsBiarchSuffix ? 1 : 2;
            }
            if (Want == 1) {
                Default.flag(new StringRef("+m32")).flag(new StringRef("-m64")).flag(new StringRef("-mx32"));
            } else if (Want == 2) {
                Default.flag(new StringRef("-m32")).flag(new StringRef("+m64")).flag(new StringRef("-mx32"));
            } else if (Want == 3) {
                Default.flag(new StringRef("-m32")).flag(new StringRef("-m64")).flag(new StringRef("+mx32"));
            } else {
                boolean bl2 = false;
                return bl2;
            }
            Result.Multilibs.push_back(Default);
            Result.Multilibs.push_back(Alt64);
            Result.Multilibs.push_back(Alt32);
            Result.Multilibs.push_back(Altx32);
            Result.Multilibs.FilterOut(NonExistent);
            Flags = new std.vectorString(std.string.EMPTY);
            ToolChainsStatics.addMultilibFlag(TargetTriple.isArch64Bit() && !IsX32, NativePointer.$((String)"m64"), Flags);
            ToolChainsStatics.addMultilibFlag(TargetTriple.isArch32Bit(), NativePointer.$((String)"m32"), Flags);
            ToolChainsStatics.addMultilibFlag(TargetTriple.isArch64Bit() && IsX32, NativePointer.$((String)"mx32"), Flags);
            if (!Result.Multilibs.select(Flags, Result.SelectedMultilib)) {
                boolean bl3 = false;
                return bl3;
            }
            if (Result.SelectedMultilib.$eq(Alt64) || Result.SelectedMultilib.$eq(Alt32) || Result.SelectedMultilib.$eq(Altx32)) {
                Result.BiarchSibling.$assign((Object)Default);
            }
            boolean bl4 = true;
            return bl4;
        }
        finally {
            if (Flags != null) {
                Flags.$destroy();
            }
            if (Altx32 != null) {
                Altx32.$destroy();
            }
            if (Alt32 != null) {
                Alt32.$destroy();
            }
            if (Alt64 != null) {
                Alt64.$destroy();
            }
            if (Default != null) {
                Default.$destroy();
            }
            $c$.$destroy();
        }
    }

    public static void addPathIfExists(Driver D, Twine Path, SmallVector<std.string> Paths) {
        if (D.getVFS().exists(Path)) {
            Paths.push_back((Object)Path.str());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean IsRedhat(Distro Distro2) {
        if (Distro2 == Distro.Fedora) return true;
        if (Distro2.getValue() < Distro.RHEL5.getValue()) return false;
        if (Distro2.getValue() > Distro.RHEL7.getValue()) return false;
        return true;
    }

    public static boolean IsOpenSUSE(Distro Distro2) {
        return Distro2 == Distro.OpenSUSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean IsDebian(Distro Distro2) {
        if (Distro2.getValue() < Distro.DebianLenny.getValue()) return false;
        if (Distro2.getValue() > Distro.DebianStretch.getValue()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean IsUbuntu(Distro Distro2) {
        if (Distro2.getValue() < Distro.UbuntuHardy.getValue()) return false;
        if (Distro2.getValue() > Distro.UbuntuXenial.getValue()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Distro DetectDistro(Driver D, Triple.ArchType Arch) {
        ErrorOr File = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            Distro distro;
            Distro distro2;
            StringRef Data;
            File = MemoryBuffer.getFile((Twine)new Twine("/etc/lsb-release"));
            if (File.$bool()) {
                Data = ((MemoryBuffer)((std_ptr.unique_ptr)File.get()).$arrow()).getBuffer();
                SmallVector Lines = new SmallVector(16, (Object)new StringRef());
                Data.split((SmallVectorImpl)Lines, "\n");
                Distro Version = Distro.UnknownDistro;
                for (StringRef Line : Lines) {
                    if (Version != Distro.UnknownDistro || !Line.startswith("DISTRIB_CODENAME=")) continue;
                    Version = (Distro)((Object)new StringSwitch(Line.substr(17)).Case("hardy", (Object)Distro.UbuntuHardy).Case("intrepid", (Object)Distro.UbuntuIntrepid).Case("jaunty", (Object)Distro.UbuntuJaunty).Case("karmic", (Object)Distro.UbuntuKarmic).Case("lucid", (Object)Distro.UbuntuLucid).Case("maverick", (Object)Distro.UbuntuMaverick).Case("natty", (Object)Distro.UbuntuNatty).Case("oneiric", (Object)Distro.UbuntuOneiric).Case("precise", (Object)Distro.UbuntuPrecise).Case("quantal", (Object)Distro.UbuntuQuantal).Case("raring", (Object)Distro.UbuntuRaring).Case("saucy", (Object)Distro.UbuntuSaucy).Case("trusty", (Object)Distro.UbuntuTrusty).Case("utopic", (Object)Distro.UbuntuUtopic).Case("vivid", (Object)Distro.UbuntuVivid).Case("wily", (Object)Distro.UbuntuWily).Case("xenial", (Object)Distro.UbuntuXenial).Default((Object)Distro.UnknownDistro));
                }
                if (Version != Distro.UnknownDistro) {
                    Object object = Version;
                    return object;
                }
            }
            $c$.clean((Object)File.$assignMove((ErrorOr)$c$.track((Object)MemoryBuffer.getFile((Twine)new Twine("/etc/redhat-release")))));
            if (File.$bool()) {
                Data = ((MemoryBuffer)((std_ptr.unique_ptr)File.get()).$arrow()).getBuffer();
                if (Data.startswith("Fedora release")) {
                    distro2 = Distro.Fedora;
                    return distro2;
                }
                if (Data.startswith("Red Hat Enterprise Linux") || Data.startswith("CentOS") || Data.startswith("Scientific Linux")) {
                    if (Data.find("release 7") != StringRef.npos) {
                        distro2 = Distro.RHEL7;
                        return distro2;
                    }
                    if (Data.find("release 6") != StringRef.npos) {
                        distro2 = Distro.RHEL6;
                        return distro2;
                    }
                    if (Data.find("release 5") != StringRef.npos) {
                        distro2 = Distro.RHEL5;
                        return distro2;
                    }
                }
                distro2 = Distro.UnknownDistro;
                return distro2;
            }
            $c$.clean((Object)File.$assignMove((ErrorOr)$c$.track((Object)MemoryBuffer.getFile((Twine)new Twine("/etc/debian_version")))));
            if (File.$bool()) {
                Data = ((MemoryBuffer)((std_ptr.unique_ptr)File.get()).$arrow()).getBuffer();
                if (Data.$at(0) == 53) {
                    distro2 = Distro.DebianLenny;
                    return distro2;
                }
                if (Data.startswith("squeeze/sid") || Data.$at(0) == 54) {
                    distro2 = Distro.DebianSqueeze;
                    return distro2;
                }
                if (Data.startswith("wheezy/sid") || Data.$at(0) == 55) {
                    distro2 = Distro.DebianWheezy;
                    return distro2;
                }
                if (Data.startswith("jessie/sid") || Data.$at(0) == 56) {
                    distro2 = Distro.DebianJessie;
                    return distro2;
                }
                if (Data.startswith("stretch/sid") || Data.$at(0) == 57) {
                    distro2 = Distro.DebianStretch;
                    return distro2;
                }
                distro2 = Distro.UnknownDistro;
                return distro2;
            }
            if (D.getVFS().exists(new Twine("/etc/SuSE-release"))) {
                distro = Distro.OpenSUSE;
                return distro;
            }
            if (D.getVFS().exists(new Twine("/etc/exherbo-release"))) {
                distro = Distro.Exherbo;
                return distro;
            }
            if (D.getVFS().exists(new Twine("/etc/arch-release"))) {
                distro = Distro.ArchLinux;
                return distro;
            }
            distro = Distro.UnknownDistro;
            return distro;
        }
        finally {
            if (File != null) {
                File.$destroy();
            }
            $c$.$destroy();
        }
    }

    public static std.string getMultiarchTriple(Driver D, Triple TargetTriple, StringRef SysRoot) {
        Triple.EnvironmentType TargetEnvironment = TargetTriple.getEnvironment();
        switch (TargetTriple.getArch()) {
            default: {
                break;
            }
            case arm: 
            case thumb: {
                if (TargetEnvironment == Triple.EnvironmentType.GNUEABIHF) {
                    if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/arm-linux-gnueabihf"))) break;
                    return new std.string((CharSequence)"arm-linux-gnueabihf");
                }
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/arm-linux-gnueabi"))) break;
                return new std.string((CharSequence)"arm-linux-gnueabi");
            }
            case armeb: 
            case thumbeb: {
                if (TargetEnvironment == Triple.EnvironmentType.GNUEABIHF) {
                    if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/armeb-linux-gnueabihf"))) break;
                    return new std.string((CharSequence)"armeb-linux-gnueabihf");
                }
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/armeb-linux-gnueabi"))) break;
                return new std.string((CharSequence)"armeb-linux-gnueabi");
            }
            case x86: {
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/i386-linux-gnu"))) break;
                return new std.string((CharSequence)"i386-linux-gnu");
            }
            case x86_64: {
                if (TargetEnvironment == Triple.EnvironmentType.GNUX32 || !D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/x86_64-linux-gnu"))) break;
                return new std.string((CharSequence)"x86_64-linux-gnu");
            }
            case aarch64: {
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/aarch64-linux-gnu"))) break;
                return new std.string((CharSequence)"aarch64-linux-gnu");
            }
            case aarch64_be: {
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/aarch64_be-linux-gnu"))) break;
                return new std.string((CharSequence)"aarch64_be-linux-gnu");
            }
            case mips: {
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/mips-linux-gnu"))) break;
                return new std.string((CharSequence)"mips-linux-gnu");
            }
            case mipsel: {
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/mipsel-linux-gnu"))) break;
                return new std.string((CharSequence)"mipsel-linux-gnu");
            }
            case mips64: {
                if (D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/mips64-linux-gnu"))) {
                    return new std.string((CharSequence)"mips64-linux-gnu");
                }
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/mips64-linux-gnuabi64"))) break;
                return new std.string((CharSequence)"mips64-linux-gnuabi64");
            }
            case mips64el: {
                if (D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/mips64el-linux-gnu"))) {
                    return new std.string((CharSequence)"mips64el-linux-gnu");
                }
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/mips64el-linux-gnuabi64"))) break;
                return new std.string((CharSequence)"mips64el-linux-gnuabi64");
            }
            case ppc: {
                if (D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/powerpc-linux-gnuspe"))) {
                    return new std.string((CharSequence)"powerpc-linux-gnuspe");
                }
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/powerpc-linux-gnu"))) break;
                return new std.string((CharSequence)"powerpc-linux-gnu");
            }
            case ppc64: {
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/powerpc64-linux-gnu"))) break;
                return new std.string((CharSequence)"powerpc64-linux-gnu");
            }
            case ppc64le: {
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/powerpc64le-linux-gnu"))) break;
                return new std.string((CharSequence)"powerpc64le-linux-gnu");
            }
            case sparc: {
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/sparc-linux-gnu"))) break;
                return new std.string((CharSequence)"sparc-linux-gnu");
            }
            case sparcv9: {
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/sparc64-linux-gnu"))) break;
                return new std.string((CharSequence)"sparc64-linux-gnu");
            }
            case systemz: {
                if (!D.getVFS().exists(llvm.$add_StringRef_char$ptr$C((StringRef)SysRoot, (String)"/lib/s390x-linux-gnu"))) break;
                return new std.string((CharSequence)"s390x-linux-gnu");
            }
        }
        return new std.string(TargetTriple.str());
    }

    public static StringRef getOSLibDir(Triple _Triple, ArgList Args) {
        if (ToolChainsStatics.isMipsArch(_Triple.getArch())) {
            if (MipsStatics.hasMipsAbiArg(Args, NativePointer.$((String)"n32"))) {
                return new StringRef("lib32");
            }
            return new StringRef(_Triple.isArch32Bit() ? NativePointer.$((String)"lib") : NativePointer.$((String)"lib64"));
        }
        if (_Triple.getArch() == Triple.ArchType.x86 || _Triple.getArch() == Triple.ArchType.ppc) {
            return new StringRef("lib32");
        }
        if (_Triple.getArch() == Triple.ArchType.x86_64 && _Triple.getEnvironment() == Triple.EnvironmentType.GNUX32) {
            return new StringRef("libx32");
        }
        return new StringRef(_Triple.isArch32Bit() ? NativePointer.$((String)"lib") : NativePointer.$((String)"lib64"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMultilibsFilePaths(Driver D, MultilibSet Multilibs, Multilib Multilib2, StringRef InstallPath, SmallVector<std.string> Paths) {
        std_functional.function<DriverFunctionPointers.IncludeDirsFunc> PathsCallback = Multilibs.filePathsCallback();
        if (PathsCallback.$bool()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                for (std.string Path : (std.vectorString)$c$.clean($c$.track((Object)((DriverFunctionPointers.IncludeDirsFunc)PathsCallback.$star()).$call(Multilib2)))) {
                    ToolChainsStatics.addPathIfExists(D, llvm.$add_Twine((Twine)new Twine(InstallPath), (Twine)new Twine(Path)), Paths);
                }
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string DetectLibcxxIncludePath(StringRef base) {
        std_errors.error_code EC = new std_errors.error_code();
        int MaxVersion = 0;
        std.string MaxVersionString = new std.string(NativePointer.$EMPTY);
        fs.directory_iterator LI = null;
        fs.directory_iterator LE = null;
        try {
            LI = new fs.directory_iterator(new Twine(base), EC);
            LE = new fs.directory_iterator();
            while (!EC.$bool() && LI.$noteq(LE)) {
                StringRef VersionText = path.filename((StringRef)new StringRef(LI.$arrow().path()));
                int.ref Version = NativePointer.create_int$ref();
                if (VersionText.$at(0) == 118 && !VersionText.slice(1, StringRef.npos).getAsInteger$Signed(10, Version) && Version.$deref() > MaxVersion) {
                    MaxVersion = Version.$deref();
                    MaxVersionString.$assignMove(VersionText.$basic_string());
                }
                LI.$assign(LI.increment(EC));
            }
        }
        finally {
            if (LE != null) {
                LE.$destroy();
            }
            if (LI != null) {
                LI.$destroy();
            }
        }
        return MaxVersion != 0 ? llvm.$add_Twine((Twine)llvm.$add_StringRef_char$ptr$C((StringRef)base, (char.ptr)NativePointer.$SLASH), (Twine)new Twine(MaxVersionString)).str() : new std.string(NativePointer.$EMPTY);
    }
}

