/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.toolchains.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.driver.Action;
import org.clang.driver.Driver;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.ToolChainsStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.ArmStatics;
import org.clang.driver.tools.impl.DarwinStatics;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.option.Option;
import org.llvm.support.llvm;
import org.llvm.support.sys.path;

public class MachO
extends ToolChain
implements Destructors.ClassWithDestructor {
    private std_ptr.unique_ptr<DarwinStatics.Lipo> Lipo = new std_ptr.unique_ptr();
    private std_ptr.unique_ptr<DarwinStatics.Dsymutil> Dsymutil = new std_ptr.unique_ptr();
    private std_ptr.unique_ptr<DarwinStatics.VerifyDebug> VerifyDebug = new std_ptr.unique_ptr();

    @Override
    protected Tool buildAssembler() {
        return new DarwinStatics.Assembler(this);
    }

    @Override
    protected Tool buildLinker() {
        return new DarwinStatics.Linker(this);
    }

    @Override
    protected Tool getTool(Action.ActionClass AC) {
        switch (AC) {
            case LipoJobClass: {
                if (!this.Lipo.$bool()) {
                    this.Lipo.reset((Object)new DarwinStatics.Lipo(this));
                }
                return (Tool)this.Lipo.get();
            }
            case DsymutilJobClass: {
                if (!this.Dsymutil.$bool()) {
                    this.Dsymutil.reset((Object)new DarwinStatics.Dsymutil(this));
                }
                return (Tool)this.Dsymutil.get();
            }
            case VerifyDebugInfoJobClass: {
                if (!this.VerifyDebug.$bool()) {
                    this.VerifyDebug.reset((Object)new DarwinStatics.VerifyDebug(this));
                }
                return (Tool)this.VerifyDebug.get();
            }
        }
        return super.getTool(AC);
    }

    public MachO(Driver D, Triple Triple2, ArgList Args) {
        super(D, Triple2, Args);
        this.getProgramPaths().push_back((Object)new std.string(this.getDriver().getInstalledDir()));
        if (std.$noteq_T_str$C((char.iterator)this.getDriver().getInstalledDir(), (std.string)this.getDriver().Dir)) {
            this.getProgramPaths().push_back((Object)this.getDriver().Dir);
        }
    }

    @Override
    public void $destroy() {
        this.VerifyDebug.$destroy();
        this.Dsymutil.$destroy();
        this.Lipo.$destroy();
        super.$destroy();
    }

    public StringRef getMachOArchName(ArgList Args) {
        char.ptr Arch;
        switch (this.getTriple().getArch()) {
            default: {
                return this.getDefaultUniversalArchName();
            }
            case aarch64: {
                return new StringRef("arm64");
            }
            case thumb: 
            case arm: 
        }
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
        if (A != null && (Arch = Native.$tryClone((char.ptr)ToolChainsStatics.ArmMachOArchName(new StringRef(A.getValue())))) != null) {
            return new StringRef(Arch);
        }
        A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
        if (A != null && (Arch = Native.$tryClone((char.ptr)ToolChainsStatics.ArmMachOArchNameCPU(new StringRef(A.getValue())))) != null) {
            return new StringRef(Arch);
        }
        return new StringRef("arm");
    }

    public void AddLinkARCArgs(ArgList Args, ArgStringList CmdArgs) {
    }

    public void AddLinkRuntimeLibArgs(ArgList Args, ArgStringList CmdArgs) {
        SmallString CompilerRT = new SmallString(new StringRef("libclang_rt."), 32);
        CompilerRT.$addassign(ArmStatics.getARMFloatABI(this, Args) == ArmStatics.FloatABI.Hard ? NativePointer.$((String)"hard") : NativePointer.$((String)"soft"));
        CompilerRT.$addassign(Args.hasArg(new OptSpecifier(options.ID.OPT_fPIC.getValue())) ? NativePointer.$((String)"_pic.a") : NativePointer.$((String)"_static.a"));
        this.AddLinkRuntimeLib(Args, CmdArgs, CompilerRT.$StringRef(), false, true);
    }

    public void addStartObjectFileArgs(ArgList Args, ArgStringList CmdArgs) {
    }

    public void addMinVersionArgs(ArgList Args, ArgStringList CmdArgs) {
    }

    public boolean isKernelStatic() {
        return false;
    }

    public boolean isTargetIOSBased() {
        return false;
    }

    public void AddLinkRuntimeLib(ArgList Args, ArgStringList CmdArgs, StringRef DarwinLibName) {
        this.AddLinkRuntimeLib(Args, CmdArgs, DarwinLibName, false, false, false);
    }

    public void AddLinkRuntimeLib(ArgList Args, ArgStringList CmdArgs, StringRef DarwinLibName, boolean AlwaysLink) {
        this.AddLinkRuntimeLib(Args, CmdArgs, DarwinLibName, AlwaysLink, false, false);
    }

    public void AddLinkRuntimeLib(ArgList Args, ArgStringList CmdArgs, StringRef DarwinLibName, boolean AlwaysLink, boolean IsEmbedded) {
        this.AddLinkRuntimeLib(Args, CmdArgs, DarwinLibName, AlwaysLink, IsEmbedded, false);
    }

    public void AddLinkRuntimeLib(ArgList Args, ArgStringList CmdArgs, StringRef DarwinLibName, boolean AlwaysLink, boolean IsEmbedded, boolean AddRPath) {
        SmallString Dir = new SmallString(new StringRef(this.getDriver().ResourceDir), 128);
        path.append((SmallString)Dir, (Twine)new Twine("lib"), (Twine)new Twine(IsEmbedded ? NativePointer.$((String)"macho_embedded") : NativePointer.$((String)"darwin")));
        SmallString P = new SmallString(Dir);
        path.append((SmallString)P, (Twine)new Twine(DarwinLibName));
        if (AlwaysLink || this.getVFS().exists(new Twine(P))) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(P)));
        }
        if (AddRPath) {
            assert (DarwinLibName.endswith(".dylib")) : "must be a dynamic library";
            CmdArgs.push_back((Object)NativePointer.$((String)"-rpath"));
            CmdArgs.push_back((Object)NativePointer.$((String)"@executable_path"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-rpath"));
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Dir)));
        }
    }

    @Override
    public void addProfileRTLibs(ArgList Args, ArgStringList CmdArgs) {
    }

    @Override
    public std.string ComputeEffectiveClangTriple(ArgList Args, types.ID InputType) {
        Triple Triple2 = new Triple(new Twine(this.ComputeLLVMTriple(Args, InputType)));
        return new std.string(Triple2.getTriple());
    }

    @Override
    public types.ID LookupTypeForExtension(char.ptr Ext) {
        types.ID Ty = types.lookupTypeForExtension(Ext);
        if (Ty == types.ID.TY_PP_Asm) {
            return types.ID.TY_Asm;
        }
        return Ty;
    }

    @Override
    public boolean HasNativeLLVMSupport() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DerivedArgList TranslateArgs(DerivedArgList Args, char.ptr BoundArch) {
        DerivedArgList DAL = new DerivedArgList(Args.getBaseArgs());
        OptTable Opts = this.getDriver().getOpts();
        block25: for (Arg A : Args) {
            block91: {
                Arg OriginalArg;
                std_ptr.unique_ptr XarchArg;
                block90: {
                    JavaCleaner $c$;
                    if (!A.getOption().matches(new OptSpecifier(options.ID.OPT_Xarch__.getValue()))) break block91;
                    XarchArg = null;
                    Triple.ArchType XarchArch = DarwinStatics.getArchTypeForMachOArchName(new StringRef(A.getValue(0)));
                    if (XarchArch != this.getArch() && (BoundArch == null || XarchArch != DarwinStatics.getArchTypeForMachOArchName(new StringRef(BoundArch)))) continue;
                    OriginalArg = A;
                    uint.ref Index = NativePointer.create_uint$ref((int)Args.getBaseArgs().MakeIndex(new StringRef(A.getValue(1))));
                    int Prev = Index.$deref();
                    XarchArg = new std_ptr.unique_ptr((Object)Opts.ParseOneArg((ArgList)Args, Index));
                    if (!XarchArg.$bool() || Unsigned.$greater_uint((uint.ref)Index, (int)(Prev + 1))) {
                        $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(321))), (StringRef)new StringRef(A.getAsString((ArgList)Args))));
                            continue;
                        }
                        finally {
                            $c$.$destroy();
                            continue;
                        }
                    }
                    if (!((Arg)XarchArg.$arrow()).getOption().hasFlag(16)) break block90;
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(320))), (StringRef)new StringRef(A.getAsString((ArgList)Args))));
                        continue;
                    }
                    finally {
                        $c$.$destroy();
                        continue;
                    }
                }
                ((Arg)XarchArg.$arrow()).setBaseArg(A);
                A = (Arg)XarchArg.release();
                DAL.AddSynthesizedArg(A);
                if (A.getOption().hasFlag(32)) {
                    for (char.ptr Value : A.getValues()) {
                        DAL.AddSeparateArg(OriginalArg, Opts.getOption(new OptSpecifier(options.ID.OPT_Zlinker_input.getValue())), new StringRef(Value));
                    }
                    continue;
                }
                break block91;
                finally {
                    if (XarchArg == null) continue;
                    XarchArg.$destroy();
                    continue;
                }
            }
            switch (options.ID.valueOf(A.getOption().getID())) {
                default: {
                    DAL.append(A);
                    continue block25;
                }
                case OPT_mkernel: 
                case OPT_fapple_kext: {
                    DAL.append(A);
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_static.getValue())));
                    continue block25;
                }
                case OPT_dependency_file: {
                    DAL.AddSeparateArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_MF.getValue())), new StringRef(A.getValue()));
                    continue block25;
                }
                case OPT_gfull: {
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_g_Flag.getValue())));
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_fno_eliminate_unused_debug_symbols.getValue())));
                    continue block25;
                }
                case OPT_gused: {
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_g_Flag.getValue())));
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_feliminate_unused_debug_symbols.getValue())));
                    continue block25;
                }
                case OPT_shared: {
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_dynamiclib.getValue())));
                    continue block25;
                }
                case OPT_fconstant_cfstrings: {
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_mconstant_cfstrings.getValue())));
                    continue block25;
                }
                case OPT_fno_constant_cfstrings: {
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_mno_constant_cfstrings.getValue())));
                    continue block25;
                }
                case OPT_Wnonportable_cfstrings: {
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_mwarn_nonportable_cfstrings.getValue())));
                    continue block25;
                }
                case OPT_Wno_nonportable_cfstrings: {
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_mno_warn_nonportable_cfstrings.getValue())));
                    continue block25;
                }
                case OPT_fpascal_strings: {
                    DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_mpascal_strings.getValue())));
                    continue block25;
                }
                case OPT_fno_pascal_strings: 
            }
            DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier(options.ID.OPT_mno_pascal_strings.getValue())));
        }
        if (!(this.getTriple().getArch() != Triple.ArchType.x86 && this.getTriple().getArch() != Triple.ArchType.x86_64 || Args.hasArgNoClaim(new OptSpecifier(options.ID.OPT_mtune_EQ.getValue())))) {
            DAL.AddJoinedArg((Arg)null, Opts.getOption(new OptSpecifier(options.ID.OPT_mtune_EQ.getValue())), new StringRef("core2"));
        }
        if (BoundArch != null) {
            StringRef Name = new StringRef(BoundArch);
            Option MCpu = Opts.getOption(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
            Option MArch = Opts.getOption(new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
            if (!llvm.$eq_StringRef((StringRef)Name, (String)"ppc")) {
                if (llvm.$eq_StringRef((StringRef)Name, (String)"ppc601")) {
                    DAL.AddJoinedArg((Arg)null, MCpu, new StringRef("601"));
                } else if (llvm.$eq_StringRef((StringRef)Name, (String)"ppc603")) {
                    DAL.AddJoinedArg((Arg)null, MCpu, new StringRef("603"));
                } else if (llvm.$eq_StringRef((StringRef)Name, (String)"ppc604")) {
                    DAL.AddJoinedArg((Arg)null, MCpu, new StringRef("604"));
                } else if (llvm.$eq_StringRef((StringRef)Name, (String)"ppc604e")) {
                    DAL.AddJoinedArg((Arg)null, MCpu, new StringRef("604e"));
                } else if (llvm.$eq_StringRef((StringRef)Name, (String)"ppc750")) {
                    DAL.AddJoinedArg((Arg)null, MCpu, new StringRef("750"));
                } else if (llvm.$eq_StringRef((StringRef)Name, (String)"ppc7400")) {
                    DAL.AddJoinedArg((Arg)null, MCpu, new StringRef("7400"));
                } else if (llvm.$eq_StringRef((StringRef)Name, (String)"ppc7450")) {
                    DAL.AddJoinedArg((Arg)null, MCpu, new StringRef("7450"));
                } else if (llvm.$eq_StringRef((StringRef)Name, (String)"ppc970")) {
                    DAL.AddJoinedArg((Arg)null, MCpu, new StringRef("970"));
                } else if (llvm.$eq_StringRef((StringRef)Name, (String)"ppc64") || llvm.$eq_StringRef((StringRef)Name, (String)"ppc64le")) {
                    DAL.AddFlagArg((Arg)null, Opts.getOption(new OptSpecifier(options.ID.OPT_m64.getValue())));
                } else if (!llvm.$eq_StringRef((StringRef)Name, (String)"i386")) {
                    if (llvm.$eq_StringRef((StringRef)Name, (String)"i486")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("i486"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"i586")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("i586"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"i686")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("i686"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"pentium")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("pentium"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"pentium2")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("pentium2"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"pentpro")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("pentiumpro"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"pentIIm3")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("pentium2"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"x86_64")) {
                        DAL.AddFlagArg((Arg)null, Opts.getOption(new OptSpecifier(options.ID.OPT_m64.getValue())));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"x86_64h")) {
                        DAL.AddFlagArg((Arg)null, Opts.getOption(new OptSpecifier(options.ID.OPT_m64.getValue())));
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("x86_64h"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"arm")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("armv4t"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"armv4t")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("armv4t"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"armv5")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("armv5tej"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"xscale")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("xscale"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"armv6")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("armv6k"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"armv6m")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("armv6m"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"armv7")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("armv7a"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"armv7em")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("armv7em"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"armv7k")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("armv7k"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"armv7m")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("armv7m"));
                    } else if (llvm.$eq_StringRef((StringRef)Name, (String)"armv7s")) {
                        DAL.AddJoinedArg((Arg)null, MArch, new StringRef("armv7s"));
                    }
                }
            }
        }
        return DAL;
    }

    @Override
    public boolean IsBlocksDefault() {
        return true;
    }

    @Override
    public boolean IsIntegratedAssemblerDefault() {
        return true;
    }

    @Override
    public boolean IsMathErrnoDefault() {
        return false;
    }

    @Override
    public boolean IsEncodeExtendedBlockSignatureDefault() {
        return true;
    }

    @Override
    public boolean IsObjCNonFragileABIDefault() {
        return this.getTriple().getArch() != Triple.ArchType.x86;
    }

    @Override
    public boolean UseObjCMixedDispatch() {
        return true;
    }

    @Override
    public boolean IsUnwindTablesDefault() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public ToolChain.RuntimeLibType GetDefaultRuntimeLibType() {
        return ToolChain.RuntimeLibType.RLT_CompilerRT;
    }

    @Override
    public boolean isPICDefault() {
        return true;
    }

    @Override
    public boolean isPIEDefault() {
        return false;
    }

    @Override
    public boolean isPICDefaultForced() {
        return this.getArch() == Triple.ArchType.x86_64 || this.getArch() == Triple.ArchType.aarch64;
    }

    @Override
    public boolean SupportsProfiling() {
        return this.getArch() == Triple.ArchType.x86 || this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public boolean SupportsObjCGC() {
        return false;
    }

    @Override
    public boolean UseDwarfDebugFlags() {
        char.ptr S = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"RC_DEBUG_OPTIONS")));
        if (S != null) {
            return S.$at(0) != 0;
        }
        return false;
    }

    @Override
    public boolean UseSjLjExceptions(ArgList Args) {
        return false;
    }

    @Override
    public String toString() {
        return "Lipo=" + this.Lipo + ", Dsymutil=" + this.Dsymutil + ", VerifyDebug=" + this.VerifyDebug + super.toString();
    }
}

