/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons.treelist;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.Timer;
import org.netbeans.modules.team.commons.treelist.TreeLabel;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.netbeans.modules.team.ide.spi.IDEServices;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public final class ProgressLabel
extends TreeLabel {
    private Timer t;
    private IDEServices.BusyIcon busyIcon;
    private Reference<TreeListNode> refNode = new WeakReference<Object>(null);
    private Reference<Component> refComp = new WeakReference<Object>(null);

    public ProgressLabel(String text, Component comp) {
        super(text);
        this.refComp = new WeakReference<Component>(comp);
        this.setupProgress();
    }

    public ProgressLabel(String text, TreeListNode nd) {
        super(text);
        this.refNode = new WeakReference<TreeListNode>(nd);
        this.setupProgress();
    }

    private void setupProgress() {
        this.setIcon(this.createProgressIcon());
        this.t = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component comp = (Component)ProgressLabel.this.refComp.get();
                TreeListNode nd = (TreeListNode)ProgressLabel.this.refNode.get();
                if (nd == null && comp == null) {
                    ProgressLabel.this.t.stop();
                    Container p = ProgressLabel.this.getParent();
                    if (p != null) {
                        p.remove(ProgressLabel.this);
                    }
                } else {
                    ProgressLabel.this.busyIcon.tick();
                    ProgressLabel.this.repaint();
                    if (nd != null) {
                        nd.fireContentChanged();
                    } else {
                        comp.repaint();
                    }
                }
            }
        });
        this.t.setRepeats(true);
        super.setVisible(false);
    }

    private Icon createProgressIcon() {
        this.busyIcon = ((IDEServices)Lookup.getDefault().lookup(IDEServices.class)).createBusyIcon();
        if (this.busyIcon == null) {
            this.busyIcon = new RotatingImageBusyIcon(ImageUtilities.loadImage((String)"org/netbeans/swing/tabcontrol/resources/busy_icon.png"));
        }
        return this.busyIcon;
    }

    @Override
    public void setVisible(boolean visible) {
        boolean old = this.isVisible();
        super.setVisible(visible);
        if (old != visible) {
            if (visible) {
                this.t.start();
            } else {
                this.t.stop();
            }
        }
    }

    public void stop() {
        this.t.stop();
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    private static class RotatingImageBusyIcon
    implements IDEServices.BusyIcon {
        private final Image img;
        private final int width;
        private final int height;
        private int state = 0;
        private AffineTransform at;
        private static final int STEP = 15;

        public RotatingImageBusyIcon(Image img) {
            this.img = img;
            this.width = img.getWidth(null);
            this.height = img.getHeight(null);
        }

        @Override
        public void tick() {
            this.state += 15;
            if (this.state >= 360) {
                this.state = 0;
            }
            this.at = new AffineTransform();
            this.at.rotate((double)this.state * Math.PI / 180.0, this.width / 2, this.height / 2);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g2d.translate(x, y);
                g2d.drawImage(this.img, this.at, null);
                g2d.translate(-x, -y);
            }
        }

        @Override
        public final int getIconWidth() {
            return this.width;
        }

        @Override
        public final int getIconHeight() {
            return this.height;
        }
    }
}

