/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.ui.MulticastValidationUI;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;

public abstract class ValidationItem {
    private Problem currentLeadProblem = null;
    private Problem currentProblemInUI = null;
    private ValidationGroup parentValidationGroup = null;
    private int suspendCount = 0;
    private boolean uiEnabled = true;
    private final MulticastValidationUI multicastValidationUI = new MulticastValidationUI(new ValidationUI[0]);

    ValidationItem(ValidationUI ... uis) {
        for (ValidationUI ui : uis) {
            this.multicastValidationUI.add(ui);
        }
    }

    void addUI(ValidationUI ui) {
        if (!this.containsUI(ui)) {
            this.multicastValidationUI.add(ui);
            if (this.uiEnabled) {
                if (this.currentProblemInUI == null) {
                    ui.clearProblem();
                } else {
                    ui.showProblem(this.currentProblemInUI);
                }
            }
        }
    }

    void removeUI(ValidationUI ui) {
        if (this.containsUI(ui)) {
            this.multicastValidationUI.remove(ui);
            ui.clearProblem();
        }
    }

    final void showIfUIEnabled(Problem problem) {
        if (this.uiEnabled && (this.currentProblemInUI != null && !this.currentProblemInUI.equals(problem) || this.currentProblemInUI == null && problem != null)) {
            this.currentProblemInUI = problem;
            if (problem == null) {
                this.multicastValidationUI.clearProblem();
            } else {
                this.multicastValidationUI.showProblem(problem);
            }
        }
    }

    private boolean containsUI(ValidationUI ui) {
        return this.multicastValidationUI.contains(ui);
    }

    public final Problem performValidation() {
        if (this.isSuspended()) {
            return this.getCurrentLeadProblem();
        }
        this.subtreeRevalidation();
        if (this.getParentValidationGroup() != null) {
            this.getParentValidationGroup().validationTriggered(this);
        } else {
            this.showIfUIEnabled(this.getCurrentLeadProblem());
        }
        return this.getCurrentLeadProblem();
    }

    abstract void subtreeRevalidation();

    final Problem getCurrentLeadProblem() {
        return this.currentLeadProblem;
    }

    final void setCurrentLeadProblem(Problem problem) {
        this.currentLeadProblem = problem;
    }

    final boolean isSuspended() {
        return this.suspendCount > 0 || this.getParentValidationGroup() != null && this.getParentValidationGroup().isSuspended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runWithValidationSuspended(Runnable run) {
        ++this.suspendCount;
        try {
            run.run();
        }
        finally {
            --this.suspendCount;
            if (!this.isSuspended()) {
                this.performValidation();
            }
        }
    }

    final ValidationGroup getParentValidationGroup() {
        return this.parentValidationGroup;
    }

    final void setParentValidationGroup(ValidationGroup parentGroup, boolean setUIEnabled) {
        this.parentValidationGroup = parentGroup;
        this.uiEnabled = setUIEnabled;
    }
}

