/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.LabelUI;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.ui.swing.MultilineLabel;

final class MultilineLabelUI
extends LabelUI {
    private static final int MIN_CHARS = 100;
    private static final boolean antialias = Boolean.getBoolean("nb.cellrenderer.antialiasing") || Boolean.getBoolean("swing.aatext") || MultilineLabelUI.isGTK() && MultilineLabelUI.gtkShouldAntialias() || MultilineLabelUI.isAqua();
    static Map<Object, Object> hintsMap;
    private static Boolean gtkAA;

    MultilineLabelUI() {
    }

    private static Graphics2D createOffscreenGraphics(JComponent c) {
        if (c == null || c.getGraphicsConfiguration() == null) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1).createGraphics();
        }
        return c.getGraphicsConfiguration().createCompatibleImage(1, 1).createGraphics();
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        return c.getInsets().top + MultilineLabelUI.createOffscreenGraphics(null).getFontMetrics(c.getFont()).getMaxAscent();
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        ((JLabel)c).setIconTextGap(5);
        ((JLabel)c).setOpaque(false);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension result;
        int parentWidth;
        GraphicsConfiguration gc = c.getGraphicsConfiguration();
        if (gc == null) {
            return super.getMaximumSize(c);
        }
        int maxw = gc.getDevice().getDisplayMode().getWidth();
        String s = ((JLabel)c).getText();
        Insets ins = c.getInsets();
        Graphics2D g = MultilineLabelUI.createOffscreenGraphics(c);
        int txtWidth = ins.left + g.getFontMetrics(c.getFont()).stringWidth(s);
        if (txtWidth > (parentWidth = (c.getParent() == null ? maxw - maxw / 4 : c.getParent().getWidth() - c.getParent().getWidth() / 4) - ins.right)) {
            int ht = MultilineLabelUI.renderPlainString((JComponent)c, (String)s, (Graphics2D)g, (int)ins.left, (int)ins.top, (int)parentWidth, (Font)c.getFont(), (Color)Color.BLACK, (boolean)false).requiredHeight;
            result = new Dimension(parentWidth, ht);
        } else {
            result = new Dimension(txtWidth, g.getFontMetrics(c.getFont()).getHeight());
        }
        Icon icon = ((JLabel)c).getIcon();
        if (icon != null) {
            result.width += icon.getIconWidth();
            result.height += icon.getIconHeight();
        }
        result.width += ins.left + ins.right;
        result.height += ins.top + ins.bottom;
        return result;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        JLabel lbl = (JLabel)c;
        char[] dummy = new char[80];
        Arrays.fill(dummy, 'X');
        Graphics2D g = MultilineLabelUI.createOffscreenGraphics(c);
        int testWidth = g.getFontMetrics(c.getFont()).stringWidth(new String(dummy));
        GraphicsConfiguration gc = c.getGraphicsConfiguration();
        if (gc == null) {
            return super.getMinimumSize(c);
        }
        int maxw = gc.getDevice().getDisplayMode().getWidth();
        Insets ins = c.getInsets();
        int parentWidth = c.getWidth();
        if (parentWidth == 0 && c.getParent() != null) {
            for (Container parent = c.getParent(); parentWidth == 0 && parent != null; parent = parent.getParent()) {
                parentWidth = parent.getWidth();
                if (!(parent instanceof JScrollPane)) continue;
                JScrollPane pane = (JScrollPane)parent;
                JViewport port = pane.getViewport();
                parentWidth = port.getWidth();
                Insets paneInsets = pane.getInsets();
                Insets portInsets = port.getInsets();
                parentWidth -= paneInsets.left + paneInsets.right + portInsets.left + portInsets.right;
            }
        }
        if (parentWidth == 0) {
            parentWidth = maxw + maxw / 4;
        }
        boolean needWrap = (parentWidth -= ins.left + ins.right) < testWidth;
        int ht = Math.max(16, g.getFontMetrics(c.getFont()).getHeight());
        if (!needWrap) {
            ht *= 2;
        }
        int w = g.getFontMetrics(c.getFont()).stringWidth(lbl.getText());
        Dimension result = new Dimension(ins.left + ins.right + w, ins.bottom + ins.top + ht);
        return result;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        boolean popup;
        JLabel lbl = (JLabel)c;
        String s = lbl.getText();
        boolean bl = popup = c instanceof MultilineLabel && ((MultilineLabel)c).isPopup();
        if (!(popup || s != null && s.length() >= 100)) {
            char[] dummy = new char[100];
            Arrays.fill(dummy, 'X');
            s = new String(dummy);
        }
        int maxw = c.getGraphicsConfiguration() == null ? Toolkit.getDefaultToolkit().getScreenSize().width : c.getGraphicsConfiguration().getDevice().getDisplayMode().getWidth();
        Insets ins = c.getInsets();
        int parentWidth = c.getWidth();
        if (parentWidth == 0 && c.getParent() != null) {
            for (Container parent = c.getParent(); parentWidth == 0 && parent != null; parent = parent.getParent()) {
                parentWidth = parent.getWidth();
            }
        }
        if (parentWidth <= 0) {
            parentWidth = maxw + maxw / 4;
        }
        return MultilineLabelUI.getPreferredSize((JLabel)lbl, (int)(parentWidth -= ins.left + ins.right)).dim;
    }

    static Metrics getPreferredSize(JLabel lbl, int parentWidth) {
        Icon icon = lbl.getIcon();
        if (icon != null) {
            parentWidth -= icon.getIconWidth();
        }
        Insets ins = lbl.getInsets();
        int iconW = icon == null ? 0 : icon.getIconWidth() + lbl.getIconTextGap();
        Graphics2D g = MultilineLabelUI.createOffscreenGraphics(lbl);
        Metrics metrics = MultilineLabelUI.renderPlainString(lbl, lbl.getText(), g, ins.left, ins.top, parentWidth, lbl.getFont(), Color.BLACK, false, iconW);
        int ht = metrics.requiredHeight;
        Dimension result = new Dimension();
        result.height = icon != null ? Math.max(metrics.lineheight * metrics.linecount, icon.getIconHeight()) : metrics.lineheight * metrics.linecount;
        result.width = metrics.widestLine;
        result.width += ins.left + ins.right;
        result.height += ins.top + ins.bottom;
        metrics.dim = result;
        return metrics;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        String txt;
        Insets ins = c.getInsets();
        Graphics2D gg = (Graphics2D)g;
        JLabel lbl = (JLabel)c;
        Icon icon = lbl.getIcon();
        int gap = lbl.getIconTextGap();
        int startX = ins.left + gap;
        int startY = ins.top;
        if (icon != null) {
            icon.paintIcon(c, g, ins.top, ins.left);
            startX = icon.getIconWidth() + gap;
            boolean popup = c instanceof MultilineLabel && ((MultilineLabel)c).isPopup();
            int yHeight = popup ? g.getFontMetrics(c.getFont()).getHeight() : g.getFontMetrics(c.getFont()).getMaxAscent();
            startY += icon.getIconHeight() / 2 - yHeight / 2;
        }
        if ((txt = ((JLabel)c).getText()) != null) {
            MultilineLabelUI.renderPlainString(c, txt, gg, ins.left, startY, c.getWidth() - (ins.left + ins.right), c.getFont(), c.getForeground(), true, startX);
        }
    }

    private static Metrics renderPlainString(JComponent c, String s, Graphics2D g, int x, int y, int w, Font f, Color foreground, boolean paint) {
        return MultilineLabelUI.renderPlainString(c, s, g, x, y, w, f, foreground, paint, 0);
    }

    private static Metrics renderPlainString(JComponent comp, String s, Graphics2D g, int x, int y, int w, Font f, Color foreground, boolean paint, int startX) {
        if (g == null) {
            g = MultilineLabelUI.createOffscreenGraphics(comp);
        }
        if (f == null && (f = UIManager.getFont("controlFont")) == null) {
            int fs = 11;
            Object cfs = UIManager.get("customFontSize");
            if (cfs instanceof Integer) {
                fs = (Integer)cfs;
            }
            f = new Font("Dialog", 0, fs);
        }
        if (paint) {
            g.setRenderingHints(MultilineLabelUI.getHints());
            g.setFont(f);
            g.setColor(foreground);
        }
        FontMetrics fm = g.getFontMetrics(f);
        int baseline = y + fm.getMaxAscent();
        int ht = fm.getHeight();
        Metrics result = new Metrics(ht);
        int dx = x + startX;
        result.lineLength(dx);
        String[] words = s.split(" ");
        int spaceWidth = fm.stringWidth(" ");
        block0: for (int i = 0; i < words.length; ++i) {
            boolean brutalWrap;
            String word = words[i];
            int wordWidth = fm.stringWidth(word);
            boolean wrap = dx + wordWidth > w && i > 0;
            boolean bl = brutalWrap = wordWidth > w;
            if (brutalWrap) {
                char[] chars = word.toCharArray();
                for (int j = 0; j < chars.length; ++j) {
                    char c = chars[j];
                    int cwidth = fm.charWidth(c);
                    if (dx + cwidth > w) {
                        result.lineLength(dx);
                        dx = x;
                        baseline += ht;
                        result.wrap();
                    }
                    if (paint) {
                        g.drawChars(chars, j, 1, dx, baseline);
                    }
                    result.lineLength(dx += cwidth);
                    if (j != chars.length - 1) continue;
                    result.lineLength(dx += spaceWidth);
                    continue block0;
                }
            }
            if (wrap) {
                result.lineLength(dx);
                result.wrap();
                dx = x;
                baseline += ht;
            }
            if (paint) {
                g.drawString(word, dx, baseline);
            }
            result.lineLength(dx += spaceWidth + wordWidth);
        }
        result.finished(baseline + y);
        return result;
    }

    static final Map<?, ?> getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap<Object, Object>();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        Map<Object, Object> ret = hintsMap;
        assert (ret != null);
        return ret;
    }

    static boolean isAqua() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    static boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    static final boolean gtkShouldAntialias() {
        if (gtkAA == null) {
            Object o = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/Antialias");
            gtkAA = new Integer(1).equals(o) ? Boolean.TRUE : Boolean.FALSE;
        }
        return gtkAA;
    }

    static Popup showPopup(Problem problem, Component parent, int x, int y) {
        Severity severity = problem.severity();
        Color bg = UIManager.getColor("white") == null ? Color.WHITE : UIManager.getColor("white");
        CompoundBorder b = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(severity.color(), 1), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        MultilineLabel lbl = new MultilineLabel(true);
        lbl.createUI().showProblem(problem);
        lbl.setBorder(b);
        lbl.setForeground(severity.color());
        lbl.setBackground(bg);
        Point screenLoc = parent.getLocationOnScreen();
        int screenWidth = parent.getGraphicsConfiguration().getDevice().getDisplayMode().getWidth();
        int screenX = screenLoc.x + x;
        int screenY = screenLoc.y + y;
        int availWidth = screenWidth - screenX;
        Popup popup = PopupFactory.getSharedInstance().getPopup(parent, lbl, screenX, screenY);
        Insets ins = b.getBorderInsets(lbl);
        Metrics mm = MultilineLabelUI.getPreferredSize(lbl, availWidth);
        System.err.println("METRICS:\n" + mm);
        Dimension d = mm.dim;
        d.width = mm.widestLine + ins.left + ins.right + severity.icon().getIconWidth() + lbl.getIconTextGap();
        lbl.setPreferredSize(d);
        return new WrapPopup(parent, popup);
    }

    public static void main(String[] args) throws Exception {
        JFrame jf = new JFrame();
        final JLabel lbl = new JLabel("Hello");
        jf.setDefaultCloseOperation(3);
        jf.setContentPane(lbl);
        String err = "This is a big honkin long error message, in fact its so long it will probably have to be wrapped to multiple lines whether we want it to or not - otherwise there will be much trouble.";
        lbl.addMouseListener(new MouseAdapter(){
            Popup popup;

            @Override
            public void mouseEntered(MouseEvent e) {
                if (this.popup != null) {
                    this.popup.hide();
                }
                this.popup = MultilineLabelUI.showPopup(new Problem("This is a big honkin long error message, in fact its so long it will probably have to be wrapped to multiple lines whether we want it to or not - otherwise there will be much trouble.", Severity.FATAL), lbl, e.getX(), e.getY());
                this.popup.show();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.popup != null) {
                    this.popup.hide();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.mouseEntered(e);
            }
        });
        jf.pack();
        jf.setVisible(true);
    }

    private static final class Metrics {
        int linecount = 1;
        int widestLine;
        int requiredHeight;
        final int lineheight;
        Dimension dim;

        Metrics(int lineheight) {
            this.lineheight = lineheight;
        }

        void wrap() {
            ++this.linecount;
        }

        void finished(int bottom) {
            this.requiredHeight = bottom;
        }

        void lineLength(int pixels) {
            this.widestLine = Math.max(pixels, this.widestLine);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Line Count: " + this.linecount);
            sb.append("\nWidest Line: " + this.widestLine);
            sb.append("\nRequired Height " + this.requiredHeight);
            sb.append("\nLine Height: " + this.lineheight);
            return sb.toString();
        }
    }

    private static final class WrapPopup
    extends Popup
    implements HierarchyListener,
    HierarchyBoundsListener {
        private final Popup realPopup;
        private final Component target;

        WrapPopup(Component target, Popup realPopup) {
            this.realPopup = realPopup;
            this.target = target;
        }

        @Override
        public void hide() {
            this.realPopup.hide();
            this.detach();
        }

        @Override
        public void show() {
            this.attach();
            this.realPopup.show();
        }

        private void attach() {
            this.target.addHierarchyListener(this);
            this.target.addHierarchyBoundsListener(this);
        }

        private void detach() {
            this.target.removeHierarchyListener(this);
            this.target.removeHierarchyBoundsListener(this);
        }

        @Override
        public void ancestorMoved(HierarchyEvent e) {
            this.hide();
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            this.hide();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            this.hide();
        }
    }
}

