/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteLogger;
import org.netbeans.modules.cnd.remote.sync.FileCollector;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.remote.sync.RfsListenerSupportImpl;
import org.netbeans.modules.cnd.remote.sync.RfsSyncWorker;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.setup.support.RemoteSyncNotifier;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class RfsLocalController
extends NamedRunnable {
    public static final int SKEW_THRESHOLD = Integer.getInteger("cnd.remote.skew.threshold", 1);
    private final RfsSyncWorker.RemoteProcessController remoteController;
    private final BufferedReader requestReader;
    private final PrintWriter responseStream;
    private final ExecutionEnvironment execEnv;
    private final PrintWriter err;
    private final FileData fileData;
    private final RemotePathMap mapper;
    private final RemoteUtil.PrefixedLogger logger;
    private final SharabilityFilter filter;
    private final FileCollector fileCollector;
    private static final boolean USE_TIMESTAMPS = DebugUtils.getBoolean((String)"cnd.rfs.timestamps", (boolean)true);
    private static final char VERSION = (char)(USE_TIMESTAMPS ? 53 : 51);
    private static final boolean CHECK_ALIVE = DebugUtils.getBoolean((String)"cnd.rfs.check.alive", (boolean)true);
    private static final RequestProcessor RP = new RequestProcessor("RfsLocalController", 1);
    private final AtomicReference<CountDownLatch> shutDownLatch = new AtomicReference();

    public RfsLocalController(ExecutionEnvironment executionEnvironment, File[] files, List<File> buildResults, RfsSyncWorker.RemoteProcessController remoteController, BufferedReader requestStreamReader, PrintWriter responseStreamWriter, PrintWriter err, FileObject privProjectStorageDir) throws IOException {
        super("RFS local controller thread " + executionEnvironment);
        this.execEnv = executionEnvironment;
        this.remoteController = remoteController;
        this.requestReader = requestStreamReader;
        this.responseStream = responseStreamWriter;
        this.err = err;
        this.mapper = RemotePathMap.getPathMap(this.execEnv);
        this.fileData = FileData.get(privProjectStorageDir, executionEnvironment);
        this.logger = new RemoteUtil.PrefixedLogger("LC[" + executionEnvironment + "]");
        this.filter = new SharabilityFilter();
        this.fileCollector = new FileCollector(files, buildResults, this.logger, this.mapper, this.filter, this.fileData, this.execEnv, err);
    }

    private void respond_ok() {
        this.responseStream.printf("1\n", new Object[0]);
        this.responseStream.flush();
    }

    private void respond_err(String tail) {
        this.responseStream.printf("0 %s\n", tail);
        this.responseStream.flush();
    }

    private RequestKind getRequestKind(String request) {
        switch (request.charAt(0)) {
            case 'r': {
                return RequestKind.REQUEST;
            }
            case 'w': {
                return RequestKind.WRITTEN;
            }
            case 'p': {
                return RequestKind.PING;
            }
        }
        if ("Killed".equals(request) && this.remoteController.isStopped()) {
            return RequestKind.KILLED;
        }
        return RequestKind.UNKNOWN;
    }

    void waitShutDownFinished() {
        CountDownLatch latch = this.shutDownLatch.get();
        if (latch != null) {
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                RemoteLogger.getInstance().log(Level.FINE, "That's just FYI: interrupted", ex);
            }
        }
    }

    protected void runImpl() {
        try {
            this.shutDownLatch.set(new CountDownLatch(1));
            this.work();
        }
        finally {
            this.shutDownLatch.get().countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        long totalCopyingTime = 0L;
        block9: while (true) {
            try {
                while (true) {
                    String localFilePath;
                    String request = this.requestReader.readLine();
                    this.logger.log(Level.FINEST, "REQ %s", request);
                    if (request == null) break block9;
                    RequestKind kind = this.getRequestKind(request);
                    if (kind == RequestKind.KILLED) {
                        this.err.append("\nRemote process is killed");
                        break block9;
                    }
                    if (kind == RequestKind.UNKNOWN) {
                        this.err.append("\nProtocol error: " + request);
                        continue;
                    }
                    if (kind == RequestKind.PING) {
                        this.logger.log(Level.FINEST, "PING from remote controller", new Object[0]);
                        continue;
                    }
                    if (request.charAt(1) != ' ') {
                        throw new IllegalArgumentException("Protocol error: " + request);
                    }
                    String remoteFile = request.substring(2);
                    String realPath = this.fileCollector.getCanonicalToAbsolute(remoteFile);
                    if (realPath != null) {
                        remoteFile = realPath;
                    }
                    if ((localFilePath = this.mapper.getLocalPath(remoteFile)) != null) {
                        File localFile = CndFileUtils.createLocalFile((String)localFilePath);
                        if (kind == RequestKind.WRITTEN) {
                            this.fileData.setState(localFile, FileState.UNCONTROLLED);
                            this.fileCollector.addUpdate(localFile);
                            RfsListenerSupportImpl.getInstanmce(this.execEnv).fireFileChanged(localFile, remoteFile);
                            this.logger.log(Level.FINEST, "uncontrolled %s", localFile);
                            continue;
                        }
                        CndUtils.assertTrue((kind == RequestKind.REQUEST ? 1 : 0) != 0, (String)"kind should be RequestKind.REQUEST, but is ", (Object)((Object)kind));
                        if (localFile.exists() && !localFile.isDirectory()) {
                            this.logger.log(Level.FINEST, "uploading %s to %s started", localFile, remoteFile);
                            long fileTime = System.currentTimeMillis();
                            Future task = CommonTasksSupport.uploadFile((String)localFile.getAbsolutePath(), (ExecutionEnvironment)this.execEnv, (String)remoteFile, (int)511);
                            try {
                                CommonTasksSupport.UploadStatus uploadStatus = (CommonTasksSupport.UploadStatus)task.get();
                                fileTime = System.currentTimeMillis() - fileTime;
                                this.logger.log(Level.FINEST, "uploading %s to %s finished; rc=%d time = %d total time = %d ms", localFile, remoteFile, uploadStatus.getExitCode(), fileTime, totalCopyingTime += fileTime);
                                if (uploadStatus.isOK()) {
                                    this.fileData.setState(localFile, FileState.COPIED);
                                    this.respond_ok();
                                    continue;
                                }
                                if (this.err != null) {
                                    this.err.println(uploadStatus.getError());
                                }
                                this.respond_err("1");
                                continue;
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                                break block9;
                            }
                            catch (ExecutionException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                                this.respond_err("2 execution exception\n");
                                continue;
                            }
                            finally {
                                this.responseStream.flush();
                                continue;
                            }
                        }
                        this.respond_ok();
                        continue;
                    }
                    this.respond_ok();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            break;
        }
        this.shutdown();
    }

    private void shutdown() {
        this.logger.log(Level.FINEST, "shutdown", new Object[0]);
        try {
            this.fileCollector.runNewFilesDiscovery(true);
            this.fileCollector.shutDownNewFilesDiscovery();
            this.fileData.store();
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    private boolean checkVersion() throws IOException {
        String[] versionsArray;
        String versionsString = this.requestReader.readLine();
        String controllerVersionPattern = "CONTROLLER VERSION ";
        if (versionsString != null && versionsString.startsWith("CONTROLLER VERSION ")) {
            RemoteLogger.fine("rfs_controller at {0} has version {1}", this.execEnv, versionsString.substring("CONTROLLER VERSION ".length()));
            versionsString = this.requestReader.readLine();
        }
        if (versionsString == null) {
            return false;
        }
        String versionsPattern = "VERSIONS ";
        if (!versionsString.startsWith(versionsPattern)) {
            if (this.err != null) {
                this.err.printf("Protocol error, expected %s, got %s%n", versionsPattern, versionsString);
            }
            return false;
        }
        for (String v : versionsArray = versionsString.substring(versionsPattern.length()).split(" ")) {
            if (v.length() != 1) {
                if (this.err != null) {
                    this.err.printf("Protocol error: incorrect version format: %s%n", versionsString);
                }
                return false;
            }
            if (v.charAt(0) != VERSION) continue;
            return true;
        }
        return true;
    }

    static char testGetVersion() {
        return VERSION;
    }

    private long getTimeSkew() throws IOException, ConnectionManager.CancellationException, FormatException {
        int cnt = 10;
        this.responseStream.printf("SKEW_COUNT=%d\n", 10);
        this.responseStream.flush();
        long[] deltas = new long[10];
        for (int i = 0; i < 10; ++i) {
            long localTime1 = System.currentTimeMillis();
            this.responseStream.printf("SKEW %d\n", i);
            this.responseStream.flush();
            String line = this.requestReader.readLine();
            long localTime2 = System.currentTimeMillis();
            try {
                long remoteTime = Long.parseLong(line);
                deltas[i] = remoteTime - (localTime1 + localTime2) / 2L;
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new FormatException("Wrong skew format: " + line, nfe);
            }
        }
        this.responseStream.printf("SKEW_END\n", new Object[0]);
        this.responseStream.flush();
        long skew = 0L;
        for (int i = 0; i < 10; ++i) {
            skew += deltas[i];
        }
        skew /= 10L;
        String line = this.requestReader.readLine();
        if (!line.startsWith("FS_SKEW ")) {
            throw new FormatException("Wrong file system skew response: " + line);
        }
        try {
            long fsSkew = Long.parseLong(line.substring(8));
            if (Math.abs(fsSkew /= 1000L) > (long)SKEW_THRESHOLD) {
                RemoteSyncNotifier.getInstance().notify(this.execEnv, fsSkew);
            }
            return skew + fsSkew;
        }
        catch (NumberFormatException nfe) {
            throw new FormatException("Wrong file system skew format: " + line, nfe);
        }
    }

    boolean init() throws IOException, ConnectionManager.CancellationException {
        long timeTotal;
        block16: {
            long clockSkew;
            if (!this.checkVersion()) {
                return false;
            }
            this.logger.log(Level.FINE, "Initialization. Version=%c", Character.valueOf(VERSION));
            if (CHECK_ALIVE && !this.remoteController.isAlive()) {
                if (this.err != null) {
                    this.err.printf("Process exited unexpectedly when initializing%n", new Object[0]);
                }
                return false;
            }
            this.responseStream.printf("VERSION=%c\n", Character.valueOf(VERSION));
            this.responseStream.flush();
            try {
                clockSkew = this.getTimeSkew();
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "HostInfo skew=%d calculated skew=%d", HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getClockSkew(), clockSkew);
                }
            }
            catch (FormatException ex) {
                if (this.err != null) {
                    this.err.printf("protocol error: %s%n", ex.getMessage());
                }
                return false;
            }
            timeTotal = System.currentTimeMillis();
            this.fileCollector.gatherFiles();
            List<FileCollector.FileCollectorInfo> filesToFeed = this.fileCollector.getFiles();
            long time = System.currentTimeMillis();
            for (FileCollector.FileCollectorInfo info : filesToFeed) {
                try {
                    this.sendFileInitRequest(info, clockSkew);
                }
                catch (IOException ex) {
                    if (this.err != null) {
                        this.err.printf("Process exited unexpectedly while file info was being sent%n", new Object[0]);
                    }
                    return false;
                }
            }
            if (CHECK_ALIVE && !this.remoteController.isAlive()) {
                if (this.err != null) {
                    this.err.printf("Process exited unexpectedly%n", new Object[0]);
                }
                return false;
            }
            this.responseStream.printf("\n", new Object[0]);
            this.responseStream.flush();
            this.logger.log(Level.FINE, "sending file list took %d ms", System.currentTimeMillis() - time);
            try {
                time = System.currentTimeMillis();
                this.readFileInitResponse();
                this.logger.log(Level.FINE, "reading initial response took %d ms", System.currentTimeMillis() - time);
            }
            catch (IOException ex) {
                if (this.err == null) break block16;
                this.err.printf("%s%n", ex.getMessage());
                return false;
            }
        }
        this.fileData.store();
        if (!this.fileCollector.initNewFilesDiscovery()) {
            return false;
        }
        this.logger.log(Level.FINE, "the entire initialization took %d ms", System.currentTimeMillis() - timeTotal);
        return true;
    }

    private void readFileInitResponse() throws IOException {
        String request;
        while ((request = this.requestReader.readLine()) != null && request.length() != 0) {
            if (request.length() < 3) {
                throw new IllegalArgumentException("Protocol error: " + request);
            }
            if (request.startsWith("*")) {
                char charState = request.charAt(1);
                FileState state = FileState.fromId(charState);
                if (state == null) {
                    throw new IllegalArgumentException("Protocol error: unexpected state: '" + charState + "'");
                }
                String remotePath = request.substring(2);
                String remoteCanonicalPath = this.requestReader.readLine();
                if (remoteCanonicalPath == null) {
                    throw new IllegalArgumentException("Protocol error: no canoical path for " + remotePath);
                }
                String localFilePath = this.mapper.getLocalPath(remotePath);
                if (localFilePath != null) {
                    this.fileCollector.putCanonicalToAbsolute(remoteCanonicalPath, remotePath);
                    File localFile = CndFileUtils.createLocalFile((String)localFilePath);
                    this.fileData.setState(localFile, state);
                    continue;
                }
                this.logger.log(Level.FINEST, "ERROR no local file for %s", remotePath);
                continue;
            }
            if (request.length() < 3 || !request.startsWith("t ")) {
                throw new IllegalArgumentException("Protocol error: " + request);
            }
            String remoteFile = request.substring(2);
            String localFilePath = this.mapper.getLocalPath(remoteFile);
            if (localFilePath != null) {
                File localFile = CndFileUtils.createLocalFile((String)localFilePath);
                this.fileData.setState(localFile, FileState.TOUCHED);
                continue;
            }
            this.logger.log(Level.FINEST, "ERROR no local file for %s", remoteFile);
        }
    }

    private void sendFileInitRequest(FileCollector.FileCollectorInfo fgi, long timeSkew) throws IOException {
        block10: {
            FileState newState;
            String remotePath;
            File file;
            block13: {
                FileData.FileStateInfo info;
                block12: {
                    block11: {
                        block9: {
                            if (CHECK_ALIVE && !this.remoteController.isAlive()) {
                                throw new IOException("process already exited");
                            }
                            if (!fgi.isLink()) break block9;
                            this.responseStream.printf("L %s\n%s\n", fgi.remotePath, fgi.getLinkTarget());
                            break block10;
                        }
                        if (!fgi.file.isDirectory()) break block11;
                        this.responseStream.printf("D %s\n", fgi.remotePath);
                        this.responseStream.flush();
                        break block10;
                    }
                    file = fgi.file;
                    remotePath = fgi.remotePath;
                    info = this.fileData.getFileInfo(file);
                    if (!file.exists()) break block12;
                    switch (info == null ? FileState.INITIAL : info.state) {
                        case COPIED: 
                        case TOUCHED: {
                            newState = info.timestamp == file.lastModified() ? info.state : FileState.INITIAL;
                            break block13;
                        }
                        case ERROR: 
                        case INITIAL: {
                            newState = FileState.INITIAL;
                            break block13;
                        }
                        case UNCONTROLLED: 
                        case INEXISTENT: {
                            newState = info.state;
                            break block13;
                        }
                        default: {
                            CndUtils.assertTrue((boolean)false, (String)("Unexpected state: " + (Object)((Object)info.state)));
                            return;
                        }
                    }
                }
                newState = info != null && info.state == FileState.UNCONTROLLED ? FileState.UNCONTROLLED : FileState.INEXISTENT;
            }
            CndUtils.assertTrue((newState == FileState.INITIAL || newState == FileState.COPIED || newState == FileState.TOUCHED || newState == FileState.UNCONTROLLED || newState == FileState.INEXISTENT ? 1 : 0) != 0, (String)"State shouldn't be ", (Object)((Object)newState));
            if (USE_TIMESTAMPS) {
                long fileTime = file.exists() ? Math.max(0L, file.lastModified() + timeSkew) : 0L;
                long seconds = fileTime / 1000L;
                long microseconds = fileTime % 1000L * 1000L;
                this.responseStream.printf("%c %d %d %d %s\n", Character.valueOf(newState.id), file.length(), seconds, microseconds, remotePath);
            } else {
                this.responseStream.printf("%c %d %s\n", Character.valueOf(newState.id), file.length(), remotePath);
            }
            this.responseStream.flush();
            if (newState == FileState.INITIAL) {
                newState = FileState.TOUCHED;
            }
            this.fileData.setState(file, newState);
        }
    }

    private static class FormatException
    extends Exception {
        public FormatException(String message) {
            super(message);
        }

        public FormatException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static enum RequestKind {
        REQUEST,
        WRITTEN,
        PING,
        UNKNOWN,
        KILLED;

    }
}

