/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class RemoteFileUrlMapper
extends URLMapper {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final boolean[] charsToEscape = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true};

    public FileObject[] getFileObjects(URL url) {
        if (url.getProtocol().equals("rfs")) {
            ExecutionEnvironment env;
            String user = url.getUserInfo();
            if (user != null) {
                env = ExecutionEnvironmentFactory.createNew((String)user, (String)url.getHost(), (int)url.getPort());
            } else {
                RemoteLogger.assertTrue(false, "Trying to access remote file system without user name", new Object[0]);
                env = RemoteFileSystemUtils.getExecutionEnvironment(url.getHost(), url.getPort());
                if (env == null && (user = System.getProperty("user.name")) != null) {
                    env = ExecutionEnvironmentFactory.createNew((String)user, (String)url.getHost(), (int)url.getPort());
                }
            }
            if (env != null) {
                RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
                RemoteFileObject fo = fs.findResource(RemoteFileUrlMapper.unescapePath(url));
                return new FileObject[]{fo};
            }
        }
        return null;
    }

    public URL getURL(FileObject fo, int type) {
        if (fo instanceof RemoteFileObject) {
            RemoteFileObject rfo = (RemoteFileObject)fo;
            try {
                ExecutionEnvironment env = rfo.getExecutionEnvironment();
                return RemoteFileUrlMapper.toURL(env, rfo.getPath(), rfo.isFolder());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static URI toURI(ExecutionEnvironment env, String path, boolean folder) throws URISyntaxException {
        return new URI(RemoteFileUrlMapper.toURLString(env, path, folder));
    }

    public static URL toURL(ExecutionEnvironment env, String path, boolean folder) throws MalformedURLException {
        return new URL(RemoteFileUrlMapper.toURLString(env, path, folder));
    }

    private static String toURLString(ExecutionEnvironment env, String path, boolean folder) {
        StringBuilder sb = new StringBuilder("rfs");
        sb.append("://");
        sb.append(env.getUser()).append('@').append(env.getHost());
        sb.append(':').append(env.getSSHPort()).append(RemoteFileUrlMapper.escapePath(path));
        if (folder && !path.endsWith("/")) {
            sb.append('/');
        }
        return sb.toString();
    }

    private static void appendEscaped(StringBuilder sb, char c) {
        byte b = (byte)c;
        sb.append('%');
        sb.append(hexDigits[b >> 4 & 0xF]);
        sb.append(hexDigits[b >> 0 & 0xF]);
    }

    private static CharSequence escapeImpl(String path, int firstSpecial) {
        StringBuilder sb = firstSpecial == 0 ? new StringBuilder() : new StringBuilder(path.subSequence(0, firstSpecial));
        for (int i = firstSpecial; i < path.length(); ++i) {
            RemoteFileUrlMapper.appendEscaped(sb, path.charAt(i));
        }
        return sb;
    }

    private static boolean needToEscape(char c) {
        if (c < charsToEscape.length) {
            return charsToEscape[c];
        }
        return false;
    }

    private static CharSequence escapePath(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (!RemoteFileUrlMapper.needToEscape(path.charAt(i))) continue;
            return RemoteFileUrlMapper.escapeImpl(path, i);
        }
        return path;
    }

    private static String unescapePath(URL url) {
        String path = url.getFile();
        if (path.contains("%")) {
            try {
                return url.toURI().getPath();
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return path;
    }
}

