/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class FilePreprocessorConditionState {
    public static final int ERROR_DIRECTIVE_MARKER = Integer.MAX_VALUE;
    public static final int PRAGMA_ONCE_DIRECTIVE_MARKER = 0x7FFFFFFE;
    private static final int[] ALL_INCLUDED = new int[0];
    public static final FilePreprocessorConditionState PARSING = new FilePreprocessorConditionState("PARSING", new int[]{0, Integer.MAX_VALUE});
    private final int[] offsets;
    private final transient CharSequence fileName;

    private FilePreprocessorConditionState(CharSequence fileName, int[] offsets) {
        this.offsets = offsets != null && offsets.length == 0 ? ALL_INCLUDED : offsets;
        this.fileName = fileName;
    }

    public FilePreprocessorConditionState(RepositoryDataInput input) throws IOException {
        int size = input.readInt();
        if (size > 0) {
            this.offsets = new int[size];
            for (int i = 0; i < size; ++i) {
                this.offsets[i] = input.readInt();
            }
        } else {
            this.offsets = ALL_INCLUDED;
        }
        this.fileName = null;
    }

    public void write(RepositoryDataOutput output) throws IOException {
        int size = this.offsets.length;
        output.writeInt(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                output.writeInt(this.offsets[i]);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilePreprocessorConditionState other = (FilePreprocessorConditionState)obj;
        return Arrays.equals(this.offsets, other.offsets);
    }

    public int hashCode() {
        int hash = 5 + Arrays.hashCode(this.offsets);
        return hash;
    }

    public String toString() {
        return FilePreprocessorConditionState.toStringBrief(this);
    }

    static String toStringBrief(FilePreprocessorConditionState state) {
        if (state == PARSING) {
            return FilePreprocessorConditionState.PARSING.fileName.toString();
        }
        if (state == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < state.offsets.length; i += 2) {
            if (i > 0) {
                sb.append("][");
            }
            if (state.offsets[i + 1] == Integer.MAX_VALUE) {
                sb.append(Integer.MAX_VALUE - state.offsets[i]);
                sb.append("#error");
                continue;
            }
            if (state.offsets[i + 1] == 0x7FFFFFFE) {
                sb.append(state.offsets[i]);
                sb.append("#pragma once");
                continue;
            }
            sb.append(state.offsets[i]);
            sb.append("-");
            sb.append(state.offsets[i + 1]);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isInActiveBlock(int startContext, int endContext) {
        if (this.offsets.length == 0 || startContext == 0) {
            return true;
        }
        for (int i = 0; i < this.offsets.length; i += 2) {
            int start = this.offsets[i];
            int end = this.offsets[i + 1];
            if (start <= startContext && startContext <= end) {
                return false;
            }
            if (start > endContext || endContext > end) continue;
            return false;
        }
        return true;
    }

    public final boolean isBetterOrEqual(FilePreprocessorConditionState other) {
        if (other == null) {
            return false;
        }
        if (this.offsets.length == 0) {
            return true;
        }
        if (other.offsets.length == 0) {
            return false;
        }
        for (int i = 0; i < this.offsets.length; i += 2) {
            int start = this.offsets[i];
            int end = this.offsets[i + 1];
            boolean active = true;
            for (int j = 0; j < other.offsets.length; j += 2) {
                int secondStart = other.offsets[j];
                int secondEnd = other.offsets[j + 1];
                if (secondStart <= start && end <= secondEnd) {
                    active = false;
                } else if (start < secondStart && secondEnd < end) {
                    return false;
                }
                if (!active || end < secondStart) break;
            }
            if (!active) continue;
            return false;
        }
        return true;
    }

    public final List<CsmOffsetable> createBlocksForFile(CsmFile file) {
        ArrayList<CsmOffsetable> blocks = new ArrayList<CsmOffsetable>();
        for (int i = 0; i < this.offsets.length; i += 2) {
            blocks.add(Utils.createOffsetable(file, this.offsets[i], this.offsets[i + 1]));
        }
        return blocks;
    }

    public boolean isFromErrorDirective() {
        if (this.offsets.length == 0 || this == PARSING) {
            return false;
        }
        return this.offsets[this.offsets.length - 1] == Integer.MAX_VALUE;
    }

    public static FilePreprocessorConditionState build(CharSequence name, int[] offsets) {
        FilePreprocessorConditionState pcState = new FilePreprocessorConditionState(name, offsets);
        if (CndUtils.isDebugMode()) {
            FilePreprocessorConditionState.checkConsistency(pcState);
        }
        return pcState;
    }

    static int[] getDeadBlocks(FilePreprocessorConditionState pcState) {
        return pcState.offsets;
    }

    private static void checkConsistency(FilePreprocessorConditionState pcState) {
        if (pcState.offsets != null) {
            for (int i = 0; i < pcState.offsets.length; ++i) {
                if (i + 1 >= pcState.offsets.length || pcState.offsets[i] < pcState.offsets[i + 1]) continue;
                CndUtils.assertTrue((boolean)false, (String)("inconsistent state " + pcState));
            }
        }
    }

    boolean isAllIncluded() {
        return this.offsets == ALL_INCLUDED;
    }
}

