/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.modules.cnd.debugger.common2.debugger.Error;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeSession;
import org.netbeans.modules.cnd.debugger.common2.debugger.RoutingToken;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Gen;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Handler;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerCommand;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerExpert;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.FallbackBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.ItemSelectorResult;

public final class BreakpointManager {
    private final NativeDebugger debugger;
    private final BreakpointProvider provider;
    private final Handlers handlers = new Handlers();
    private final BreakpointJobs breakpointJobs = new BreakpointJobs();

    public BreakpointManager(NativeDebugger nd, BreakpointProvider provider) {
        this.debugger = nd;
        this.provider = provider;
    }

    public BreakpointProvider provider() {
        return this.provider;
    }

    private NativeDebuggerManager manager() {
        return NativeDebuggerManager.get();
    }

    private NativeDebugger debugger() {
        return this.debugger;
    }

    public boolean hasBreakpointJobAt(String fileName, int lineNo) {
        Map map = this.breakpointJobs.map;
        for (BreakpointJob breakpointJob : map.values()) {
            NativeBreakpoint bp = breakpointJob.template();
            if (bp == null || !bp.matchesLine(fileName, lineNo)) continue;
            return true;
        }
        return false;
    }

    private BreakpointJob getBreakpointJob(int rt) {
        return this.breakpointJobs.get(rt);
    }

    private void reinstateBreakpointJob(BreakpointJob originalJob) {
        int rt = originalJob.getRoutingToken();
        assert (rt != 0);
        this.breakpointJobs.put(rt, originalJob);
    }

    public void postEnableAllHandlers(boolean enable) {
        this.provider().postEnableAllHandlersImpl(enable);
    }

    public void postDeleteAllHandlers() {
        this.provider().postDeleteAllHandlersImpl();
    }

    public boolean noteBreakpointError(int rt, Error error) {
        boolean replace;
        boolean convert;
        boolean beSilent;
        BreakpointJob bj = this.getBreakpointJob(rt);
        NativeBreakpoint template = bj.template();
        switch (bj.kind()) {
            default: {
                assert (false) : "spontaneous breakpointError";
                beSilent = false;
                convert = false;
                replace = false;
                break;
            }
            case CHANGE: 
            case REPAIR: {
                if (bj.gen().isPrimary()) {
                    beSilent = error.isCancelled();
                    convert = false;
                    replace = false;
                    break;
                }
                beSilent = true;
                convert = false;
                replace = true;
                break;
            }
            case RESTORE1: 
            case RESTORE2: 
            case RESTORE3: {
                beSilent = true;
                convert = true;
                replace = false;
                break;
            }
            case NEW: {
                beSilent = true;
                convert = true;
                replace = false;
                break;
            }
            case DEFUNCT: {
                beSilent = true;
                convert = false;
                replace = false;
                bj.target().getHandler().setError(error.first());
            }
        }
        if (NativeDebuggerManager.isPerTargetBpts() && bj.kind() != BreakpointJob.Kind.RESTORE1 && bj.kind() != BreakpointJob.Kind.RESTORE2 && bj.kind() != BreakpointJob.Kind.RESTORE3 && bj.kind() != BreakpointJob.Kind.DEFUNCT) {
            convert = false;
            beSilent = false;
            if (bj.kind() != BreakpointJob.Kind.REPAIR && bj.kind() != BreakpointJob.Kind.CHANGE) {
                template.removeOnlyChild();
            }
        }
        if (replace) {
            this.replaceBrokenHandler(template, bj.target(), error.first(), bj);
        } else if (convert) {
            this.newBrokenHandler(template, bj.midlevel(), error.first(), bj);
        }
        return beSilent;
    }

    public void noteDefunctBreakpoint(NativeBreakpoint target, int rt) {
        BreakpointJob bj = new BreakpointJob(BreakpointJob.Kind.DEFUNCT, target, null, null);
        bj.setRoutingToken(rt);
        bj.setFallback(target instanceof FallbackBreakpoint);
        assert (rt != 0);
        this.breakpointJobs.put(rt, bj);
    }

    public ItemSelectorResult noteMultipleBreakpoints(int rt, String title, int nitems, String[] items) {
        BreakpointJob bj = this.getBreakpointJob(rt);
        assert (!bj.isOverload()) : "multipleBreakpoints(): Got OVERLOAD while processing OVERLOAD";
        switch (bj.kind()) {
            case RESTORE1: 
            case RESTORE2: 
            case RESTORE3: {
                return this.chooseAllItems(bj, nitems);
            }
            case NEW: 
            case SPONTANEOUS: 
            case CHANGE: 
            case REPAIR: {
                if (bj.gen().isSecondary()) {
                    return this.chooseAllItems(bj, nitems);
                }
                boolean cancelable = true;
                boolean multiple_selection = true;
                ItemSelectorResult result = this.manager().popupHelp(title, nitems, items, cancelable, multiple_selection);
                if (result.isCancelled()) {
                    if (bj.kind() != BreakpointJob.Kind.SPONTANEOUS) {
                        this.reinstateBreakpointJob(bj);
                    }
                    return result;
                }
                if (result.nSelected() == 1) {
                    if (bj.kind() != BreakpointJob.Kind.SPONTANEOUS) {
                        this.rememberOverloadedBreakpoint(bj, result.nSelected(), true);
                    }
                } else {
                    if (bj.kind() == BreakpointJob.Kind.SPONTANEOUS) {
                        result.setRoutingToken(RoutingToken.BREAKPOINTS.getUniqueRoutingTokenInt());
                        bj.setRoutingToken(result.getRoutingToken());
                    }
                    boolean requiredIntervention = bj.kind() == BreakpointJob.Kind.SPONTANEOUS ? true : result.nSelected() != nitems;
                    this.rememberOverloadedBreakpoint(bj, result.nSelected(), requiredIntervention);
                }
                return result;
            }
        }
        return null;
    }

    public BreakpointBag breakpointBag() {
        return this.manager().breakpointBag();
    }

    public Handler[] getHandlers() {
        return this.handlers.toArray();
    }

    public ModelChangeDelegator breakpointUpdater() {
        return this.manager().breakpointUpdater();
    }

    private String handlerError(NativeBreakpoint b, HandlerCommand hc) {
        String msg = hc.getData() == null ? Catalog.format("FMT_UnsupportedBpt", b.getBreakpointType().getTypeDisplayName(), this.debugger().debuggerType()) : hc.getData();
        return msg;
    }

    public BreakpointPlan getBreakpointPlan(int rt, BreakpointMsg msg) {
        BreakpointPlan bp;
        BreakpointJob bj = this.getBreakpointJob(rt);
        switch (bj.kind()) {
            case RESTORE1: {
                assert (msg == BreakpointMsg.NEW);
                bp = new BreakpointPlan(BreakpointOp.NEW, bj);
                break;
            }
            case RESTORE2: {
                assert (msg == BreakpointMsg.NEW);
                bp = new BreakpointPlan(BreakpointOp.RESTORE, bj);
                break;
            }
            case RESTORE3: {
                assert (msg == BreakpointMsg.NEW);
                bp = new BreakpointPlan(BreakpointOp.NEW, bj);
                break;
            }
            case NEW: 
            case SPONTANEOUS: {
                assert (msg == BreakpointMsg.NEW);
                bp = new BreakpointPlan(BreakpointOp.NEW, bj);
                break;
            }
            case CHANGE: {
                if (msg == BreakpointMsg.NEW && bj.isOverload()) {
                    bp = new BreakpointPlan(BreakpointOp.NEW, bj);
                    break;
                }
                bp = new BreakpointPlan(BreakpointOp.MODIFY, bj);
                break;
            }
            case REPAIR: {
                assert (msg == BreakpointMsg.NEW);
                bp = new BreakpointPlan(BreakpointOp.MODIFY, bj);
                break;
            }
            default: {
                bp = null;
            }
        }
        return bp;
    }

    public void noteReplacedHandler(BreakpointPlan bp, Handler replacementHandler) {
        BreakpointJob bj = bp.job();
        NativeBreakpoint targetBreakpoint = bj.target();
        Handler targetHandler = targetBreakpoint.getHandler();
        if (replacementHandler != null) {
            assert (this.provider().handlerExpert().replacementPolicy() == HandlerExpert.ReplacementPolicy.EXPLICIT);
            targetBreakpoint.setHandler(replacementHandler);
            this.handlers.add(replacementHandler);
        } else assert (this.provider().handlerExpert().replacementPolicy() == HandlerExpert.ReplacementPolicy.INPLACE);
        NativeBreakpoint template = bj.template();
        if (template.isChangeInDefiningProperty()) {
            targetHandler.setFired(false);
        }
        NativeBreakpoint target = targetHandler.breakpoint();
        NativeBreakpoint mid = target.getParent();
        mid.spreadChange(target, template, bj.gen());
    }

    public void noteNewHandler(int rt, BreakpointPlan bp, Handler handler) {
        BreakpointJob bj = bp.job();
        NativeBreakpoint mid = bj.midlevel();
        switch (bj.kind()) {
            case RESTORE1: {
                mid.addSubBreakpoint(handler.breakpoint());
                this.handlers.add(handler);
                break;
            }
            case RESTORE2: {
                NativeBreakpoint restored = bj.template();
                mid.bindTo(this.debugger());
                restored.bindTo(this.debugger());
                this.handlers.add(handler);
                if (!bj.isOverload() || !bj.isFirstOverload()) break;
                bj.mutate(BreakpointJob.Kind.RESTORE3);
                break;
            }
            case RESTORE3: {
                mid.addSubBreakpoint(handler.breakpoint());
                this.handlers.add(handler);
                break;
            }
            case NEW: 
            case SPONTANEOUS: {
                NativeBreakpoint created;
                if (bj.kind() == BreakpointJob.Kind.SPONTANEOUS) {
                    created = bj.template();
                    if (created == null) {
                        created = handler.breakpoint().makeToplevelCopy(bj.isOverload());
                        bj.setTemplate(created);
                    }
                    if (!bj.isOverload() || bj.isFirstOverload()) {
                        mid = created.makeMidlevelCopy();
                        created.setMidBreakpointFor(mid, this.debugger());
                        mid.setAdjusted(bj.isRequiredIntervention());
                    } else {
                        mid = created.getMidlevelFor(this.debugger());
                        assert (mid.isMidlevel());
                    }
                } else {
                    mid = bj.midlevel();
                }
                mid.addSubBreakpoint(handler.breakpoint());
                created = bj.template();
                this.handlers.add(handler);
                if (!bj.isOverload() || bj.isFirstOverload()) {
                    this.breakpointBag().add(created);
                }
                if (bj.kind() == BreakpointJob.Kind.SPONTANEOUS && bj.gen().isPrimary()) {
                    created.seedToplevelAnnotations();
                }
                this.manager().bringDownDialog();
                if (!bj.isOverload()) {
                    this.spreadBreakpointCreation(this.debugger(), handler.breakpoint());
                    break;
                }
                if (!bj.isFirstOverload()) break;
                this.spreadBreakpointCreation(this.debugger(), handler.breakpoint());
                break;
            }
            case CHANGE: {
                assert (bj.isOverload());
                NativeBreakpoint target = bj.target();
                NativeBreakpoint template = bj.template();
                NativeBreakpoint root = bj.target().getParent().getParent();
                mid = root.getMidlevelFor(this.debugger());
                assert (mid.isMidlevel());
                mid.addSubBreakpoint(handler.breakpoint());
                this.handlers.add(handler);
                break;
            }
            case REPAIR: {
                NativeBreakpoint target = bj.target();
                NativeBreakpoint template = bj.template();
                Handler targetHandler = target.getHandler();
                if (this.provider().handlerExpert().replacementPolicy() == HandlerExpert.ReplacementPolicy.INPLACE) {
                    assert (handler == targetHandler);
                } else {
                    assert (handler != bp.originalHandler());
                    this.handlers.remove(bp.originalHandler());
                    this.handlers.add(handler);
                }
                mid = target.getParent();
                mid.spreadChange(target, template, bj.gen());
                if (template.isChangeInDefiningProperty()) {
                    bj.mutate(BreakpointJob.Kind.CHANGE);
                }
                this.manager().bringDownDialog();
            }
        }
    }

    private void rememberOverloadedBreakpoint(BreakpointJob originalJob, int nOverloads, boolean requiredIntervention) {
        int rt = originalJob.getRoutingToken();
        NativeBreakpoint target = originalJob.target();
        NativeBreakpoint mid = originalJob.midlevel();
        NativeBreakpoint template = originalJob.template();
        BreakpointJob bj = null;
        switch (originalJob.kind()) {
            case NEW: 
            case RESTORE1: 
            case RESTORE2: 
            case RESTORE3: 
            case SPONTANEOUS: 
            case CHANGE: 
            case REPAIR: {
                bj = new BreakpointJob(originalJob.kind, target, template, mid);
                break;
            }
            case DELETE: {
                assert (false);
                break;
            }
        }
        if (nOverloads > 1) {
            bj.setExpectedOverloads(nOverloads);
        }
        bj.setGen(originalJob.gen());
        bj.setFallback(originalJob.isFallback());
        bj.setRoutingToken(rt);
        assert (rt != 0);
        this.breakpointJobs.put(rt, bj);
        if (mid == null) {
            bj.setRequiredIntervention(requiredIntervention);
        } else {
            mid.setAdjusted(requiredIntervention);
        }
    }

    private void rememberRestoredBreakpoint(NativeBreakpoint template, NativeBreakpoint mid, int rt) {
        BreakpointJob.Kind kind;
        assert (template.isToplevel() || template.isSubBreakpoint());
        assert (!template.isEditable());
        assert (mid.isMidlevel());
        if (template.isToplevel()) {
            kind = BreakpointJob.Kind.RESTORE1;
        } else if (!template.isBound()) {
            NativeBreakpoint restored = template;
            assert (restored.isSubBreakpoint());
            assert (!restored.isBound());
            kind = BreakpointJob.Kind.RESTORE2;
        } else {
            kind = BreakpointJob.Kind.RESTORE3;
        }
        BreakpointJob bj = new BreakpointJob(kind, null, template, mid);
        bj.setRoutingToken(rt);
        bj.setFallback(template instanceof FallbackBreakpoint);
        assert (rt != 0);
        this.breakpointJobs.put(rt, bj);
    }

    private void rememberNewBreakpoint(NativeBreakpoint template, NativeBreakpoint mid, int rt) {
        assert (template.isToplevel());
        assert (!template.isEditable());
        assert (mid.isMidlevel());
        BreakpointJob bj = new BreakpointJob(BreakpointJob.Kind.NEW, null, template, mid);
        bj.setRoutingToken(rt);
        bj.setFallback(template instanceof FallbackBreakpoint);
        bj.setGen(Gen.primary(null));
        assert (rt != 0);
        this.breakpointJobs.put(rt, bj);
    }

    private void rememberRepairedBreakpoint(NativeBreakpoint target, NativeBreakpoint template, Gen gen) {
        assert (template.isEditable());
        assert (!target.isEditable());
        int rt = target.getRoutingToken();
        BreakpointJob bj = new BreakpointJob(BreakpointJob.Kind.REPAIR, target, template, null);
        bj.setGen(gen);
        bj.setRoutingToken(rt);
        bj.setFallback(target instanceof FallbackBreakpoint);
        assert (rt != 0);
        this.breakpointJobs.put(rt, bj);
    }

    private void rememberChangingBreakpoint(NativeBreakpoint target, NativeBreakpoint template, Gen gen) {
        assert (template.isEditable());
        assert (!target.isEditable());
        int rt = target.getRoutingToken();
        BreakpointJob bj = new BreakpointJob(BreakpointJob.Kind.CHANGE, target, template, null);
        bj.setGen(gen);
        bj.setRoutingToken(rt);
        bj.setFallback(target instanceof FallbackBreakpoint);
        assert (rt != 0);
        this.breakpointJobs.put(rt, bj);
    }

    private void rememberDeletedBreakpoint(NativeBreakpoint target, Gen gen) {
        assert (target.isSubBreakpoint());
        int rt = target.getRoutingToken();
        BreakpointJob bj = new BreakpointJob(BreakpointJob.Kind.DELETE, target, null, null);
        bj.setGen(gen);
        bj.setRoutingToken(rt);
        bj.setFallback(target instanceof FallbackBreakpoint);
        assert (rt != 0);
        this.breakpointJobs.put(rt, bj);
    }

    public void postRestoreBreakpoints(BreakpointBag bb) {
        for (NativeBreakpoint top : bb.getBreakpoints()) {
            NativeBreakpoint mid;
            List<NativeBreakpoint> matches = top.findByContext(this.debugger().context());
            if (matches.isEmpty()) {
                if (NativeDebuggerManager.isPerTargetBpts()) continue;
                mid = top.makeMidlevelCopy();
                top.setMidBreakpointFor(mid, this.debugger());
                this.restoreBreakpoint(top, mid);
                continue;
            }
            NativeBreakpoint match = matches.get(0);
            assert (match.isMidlevel());
            if (!match.isBound()) {
                mid = match;
            } else {
                mid = match.makeMidlevelCopy();
                top.setMidBreakpointFor(mid, this.debugger());
            }
            for (NativeBreakpoint match2 : match.getChildren()) {
                this.restoreBreakpoint(match2, mid);
            }
        }
    }

    private void restoreBreakpoint(NativeBreakpoint template, NativeBreakpoint midLevel) {
        HandlerCommand hc = this.provider().handlerExpert().commandFormNew(template);
        int rt = template.getRoutingToken();
        this.rememberRestoredBreakpoint(template, midLevel, rt);
        if (!hc.isError()) {
            this.provider().postRestoreHandler(rt, hc);
        } else {
            BreakpointJob bj = this.getBreakpointJob(rt);
            this.newBrokenHandler(template, midLevel, this.handlerError(template, hc), bj);
        }
    }

    private void spreadBreakpointCreation(NativeBreakpoint b) {
        NativeBreakpoint topLevel = b.getParent().getParent();
        NativeBreakpoint midLevel = topLevel.makeMidlevelCopy();
        topLevel.setMidBreakpointFor(midLevel, this.debugger());
        int rt = topLevel.getRoutingToken();
        this.rememberRestoredBreakpoint(topLevel, midLevel, rt);
        HandlerCommand hc = this.provider().handlerExpert().commandFormNew(topLevel);
        if (!hc.isError()) {
            this.provider().postRestoreHandler(rt, hc);
        } else {
            BreakpointJob bj = this.getBreakpointJob(rt);
            this.newBrokenHandler(topLevel, midLevel, this.handlerError(topLevel, hc), bj);
        }
    }

    private void spreadBreakpointCreation(NativeDebugger origin, NativeBreakpoint b) {
        if (NativeDebuggerManager.isPerTargetBpts()) {
            return;
        }
        NativeSession[] sessions = NativeDebuggerManager.get().getSessions();
        for (int sx = 0; sx < sessions.length; ++sx) {
            NativeSession s = sessions[sx];
            DebuggerEngine engine = s.coreSession().getCurrentEngine();
            NativeDebugger candidate = (NativeDebugger)engine.lookupFirst(null, NativeDebugger.class);
            if (candidate == null || candidate == origin) continue;
            candidate.bm().spreadBreakpointCreation(b);
        }
    }

    public void postCreateHandler(int routingToken, HandlerCommand hc, NativeBreakpoint template) {
        if (Log.Bpt.pathway) {
            System.out.printf("DbxDebuggerImpl.postCreateHandler(%s)\n", hc);
        }
        assert (template.isToplevel());
        NativeBreakpoint mid = template.makeMidlevelCopy();
        template.setMidBreakpointFor(mid, this.debugger());
        this.rememberNewBreakpoint(template, mid, routingToken);
        if (hc.isError()) {
            BreakpointJob bj = this.getBreakpointJob(routingToken);
            this.newBrokenHandler(template, mid, this.handlerError(template, hc), bj);
        } else {
            this.provider().postCreateHandlerImpl(routingToken, hc);
        }
    }

    public void postChangeHandler(NativeBreakpoint editedBreakpoint, HandlerCommand hc, NativeBreakpoint targetBreakpoint, Gen gen) {
        assert (targetBreakpoint.isSubBreakpoint());
        this.rememberChangingBreakpoint(targetBreakpoint, editedBreakpoint, gen);
        if (!hc.isError()) {
            int rt = targetBreakpoint.getRoutingToken();
            this.provider().postChangeHandlerImpl(rt, hc);
        }
    }

    public void postRepairHandler(NativeBreakpoint editedBreakpoint, HandlerCommand hc, NativeBreakpoint targetBreakpoint, Gen gen) {
        assert (targetBreakpoint.isSubBreakpoint());
        this.rememberRepairedBreakpoint(targetBreakpoint, editedBreakpoint, gen);
        if (!hc.isError()) {
            int rt = targetBreakpoint.getRoutingToken();
            this.provider().postRepairHandlerImpl(rt, hc);
        }
    }

    public void postDeleteHandler(NativeBreakpoint b, Gen gen) {
        if (b.isBroken()) {
            this.deleteHandler(b.getHandler(), gen, false);
        } else {
            this.rememberDeletedBreakpoint(b, gen);
            this.provider().postDeleteHandlerImpl(b.getRoutingToken(), b.getId());
        }
    }

    public Handler findHandler(int id) {
        return this.handlers.byKey(id);
    }

    private void replaceBrokenHandler(NativeBreakpoint template, NativeBreakpoint target, String msg, BreakpointJob bj) {
        assert (target.isSubBreakpoint());
        Handler targetHandler = target.getHandler();
        this.handlers.remove(targetHandler);
        target.copyFrom(template);
        Handler handler = this.provider().handlerExpert().childHandler(target);
        handler.setError(msg);
        this.handlers.add(handler);
        target.setHandler(handler);
        target.update();
        target.getParent().changeOne(template, null);
    }

    private void newBrokenHandler(NativeBreakpoint template, NativeBreakpoint midLevel, String msg, BreakpointJob bj) {
        Handler handler;
        boolean restored;
        NativeBreakpoint subBreakpoint;
        NativeBreakpoint topLevel;
        switch (bj.kind()) {
            case RESTORE1: {
                topLevel = template.isEditable() ? template.original() : template;
                subBreakpoint = null;
                restored = true;
                break;
            }
            case RESTORE2: {
                topLevel = midLevel.getParent();
                subBreakpoint = template;
                restored = true;
                break;
            }
            case RESTORE3: {
                topLevel = template.getParent().getParent();
                subBreakpoint = null;
                restored = true;
                break;
            }
            default: {
                topLevel = template.isEditable() ? template.original() : template;
                subBreakpoint = null;
                restored = false;
            }
        }
        if (subBreakpoint == null) {
            handler = this.provider().handlerExpert().childHandler(topLevel);
            midLevel.addSubBreakpoint(handler.breakpoint());
            if (!restored) {
                this.breakpointBag().add(topLevel);
            }
            this.handlers.add(handler);
            if (handler.breakpoint() instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)handler.breakpoint();
                lb.addAnnotation(lb.getFileName(), lb.getLineNumber(), 0L);
            }
        } else {
            handler = subBreakpoint.getHandler();
            if (handler == null) {
                handler = this.provider().handlerExpert().childHandler(subBreakpoint);
                subBreakpoint.bindTo(this.debugger());
                midLevel.bindTo(this.debugger());
                this.handlers.add(handler);
            }
        }
        handler.setError(msg);
        handler.breakpoint().update();
        if (!restored) {
            this.spreadBreakpointCreation(this.debugger(), handler.breakpoint());
        }
    }

    public void deleteHandlerById(int routingToken, int hid) {
        Handler handler = this.findHandler(hid);
        if (handler != null) {
            BreakpointJob bj = this.getBreakpointJob(routingToken);
            this.deleteHandler(handler, bj.gen(), false);
        }
    }

    public void deleteHandler(Handler h, Gen gen, boolean finishing) {
        h.cleanup();
        this.handlers.remove(h);
        NativeBreakpoint sub = h.breakpoint();
        NativeBreakpoint mid = sub.getParent();
        if (!finishing) {
            sub.primDelete(false, gen);
        } else {
            if (mid == null) {
                return;
            }
            if (!mid.isBound()) {
                return;
            }
            if (mid.isUnique()) {
                mid.unbind();
            } else {
                mid.primDelete(true, gen);
            }
        }
    }

    private ItemSelectorResult chooseAllItems(BreakpointJob bj, int nitems) {
        this.rememberOverloadedBreakpoint(bj, nitems, false);
        return ItemSelectorResult.selectAll(nitems);
    }

    public void removeHandlers() {
        for (Handler h : this.getHandlers()) {
            NativeBreakpoint b = h.breakpoint();
            b.getParent().getParent().showAnnotationsFor(false, this.debugger);
            b.getParent().unbind();
            this.handlers.remove(h);
        }
    }

    public void simpleRemove(Handler h) {
        this.handlers.remove(h);
    }

    public static final class BreakpointPlan {
        private final BreakpointOp op;
        private final BreakpointJob job;
        private final Handler originalHandler;

        BreakpointPlan(BreakpointOp action, BreakpointJob job) {
            this.op = action;
            this.job = job;
            if (job.target() != null) {
                assert (job.target().isSubBreakpoint());
                this.originalHandler = job.target().getHandler();
            } else {
                this.originalHandler = null;
            }
        }

        BreakpointJob job() {
            return this.job;
        }

        public BreakpointOp op() {
            return this.op;
        }

        public boolean isFallback() {
            return this.job.isFallback();
        }

        public NativeBreakpoint restored() {
            assert (this.job.kind() == BreakpointJob.Kind.RESTORE2);
            return this.job.template();
        }

        public NativeBreakpoint template() {
            return this.job.template();
        }

        public NativeBreakpoint target() {
            return this.job.target();
        }

        public Handler originalHandler() {
            return this.originalHandler;
        }
    }

    public static enum BreakpointOp {
        NEW,
        RESTORE,
        MODIFY;

    }

    public static enum BreakpointMsg {
        NEW,
        REPLACE;

    }

    private static final class BreakpointJobs {
        private final Map<Integer, BreakpointJob> map = new ConcurrentHashMap<Integer, BreakpointJob>();

        private BreakpointJobs() {
        }

        public void put(int rt, BreakpointJob bj) {
            bj.print();
            this.map.put(rt, bj);
        }

        public BreakpointJob get(int rt) {
            if (rt == 0) {
                if (Log.Bpt.pathway) {
                    System.out.printf("BreakpointJobs.get(): rt == 0\n", new Object[0]);
                }
                BreakpointJob bj = new BreakpointJob(BreakpointJob.Kind.SPONTANEOUS, null, null, null);
                bj.setGen(Gen.primary(null));
                return bj;
            }
            assert (RoutingToken.BREAKPOINTS.isSameSubsystem(rt));
            BreakpointJob bj = this.map.get(rt);
            assert (bj != null) : "BreakpointJobs.get(): no bpt for rt " + rt;
            if (bj.isOverload()) {
                bj.seeOverload();
                if (bj.isLastOverload()) {
                    this.map.remove(rt);
                }
            } else {
                this.map.remove(rt);
            }
            return bj;
        }
    }

    private static class BreakpointJob {
        private Kind kind;
        private int routingToken;
        private final NativeBreakpoint target;
        private volatile NativeBreakpoint template;
        private final NativeBreakpoint midlevel;
        private Gen gen;
        private boolean overload;
        private int expectedOverloads = 0;
        private int seenOverloads = 0;
        private boolean fallback;
        private boolean requiredIntervention;

        public BreakpointJob(Kind kind, NativeBreakpoint target, NativeBreakpoint template, NativeBreakpoint midlevel) {
            switch (kind) {
                case NEW: 
                case RESTORE1: 
                case RESTORE2: 
                case RESTORE3: {
                    assert (midlevel != null) : "BreakpointJob(): null midlevel";
                    break;
                }
            }
            this.kind = kind;
            this.target = target;
            this.template = template;
            this.midlevel = midlevel;
        }

        public void mutate(Kind kind) {
            this.kind = kind;
        }

        public void print() {
            if (Log.Bpt.pathway) {
                System.out.println("BreakpointJob " + this.routingToken + " " + this.kind.name() + ":");
                System.out.println("\ttarget " + this.target.toString());
                System.out.println("\ttemplt " + this.template.toString());
                System.out.println("\tspread " + this.gen.toString() + " overload " + this.overload + " " + this.expectedOverloads + " " + this.fallback);
            }
        }

        public Kind kind() {
            return this.kind;
        }

        public NativeBreakpoint target() {
            return this.target;
        }

        public NativeBreakpoint template() {
            return this.template;
        }

        public NativeBreakpoint midlevel() {
            return this.midlevel;
        }

        public void setTemplate(NativeBreakpoint template) {
            assert (this.template == null);
            assert (this.kind == Kind.SPONTANEOUS);
            this.template = template;
        }

        public void setGen(Gen gen) {
            this.gen = gen;
        }

        public Gen gen() {
            return this.gen;
        }

        public void setRoutingToken(int routingToken) {
            assert (RoutingToken.BREAKPOINTS.isSameSubsystem(routingToken));
            this.routingToken = routingToken;
        }

        public int getRoutingToken() {
            return this.routingToken;
        }

        public void setExpectedOverloads(int expectedOverloads) {
            assert (expectedOverloads > 0) : "BreakpointJob.setExpecetdOverloads(<= 0)";
            assert (this.expectedOverloads == 0) : "BreakpointJob.setExpecetdOverloads() called more than oncee";
            this.expectedOverloads = expectedOverloads;
            this.overload = true;
        }

        public boolean isOverload() {
            return this.overload;
        }

        public int getOutstandingOverloads() {
            assert (this.isOverload());
            return this.expectedOverloads - this.seenOverloads;
        }

        public boolean isFirstOverload() {
            assert (this.isOverload());
            return this.seenOverloads == 1;
        }

        public boolean isLastOverload() {
            assert (this.isOverload());
            return this.seenOverloads == this.expectedOverloads;
        }

        public void seeOverload() {
            assert (this.isOverload());
            ++this.seenOverloads;
            assert (this.seenOverloads <= this.expectedOverloads) : "BreakpointJob.seeOverload(): seeing more than expected";
        }

        public void setFallback(boolean fallback) {
            this.fallback = fallback;
        }

        public boolean isFallback() {
            return this.fallback;
        }

        public void setRequiredIntervention(boolean requiredIntervention) {
            this.requiredIntervention = requiredIntervention;
        }

        public boolean isRequiredIntervention() {
            return this.requiredIntervention;
        }

        public static enum Kind {
            NEW,
            RESTORE1,
            RESTORE2,
            RESTORE3,
            CHANGE,
            REPAIR,
            SPONTANEOUS,
            DELETE,
            DEFUNCT;

        }
    }

    private static class Handlers
    implements Iterable<Handler> {
        private final ArrayList<Handler> list = new ArrayList();

        private Handlers() {
        }

        private Handler[] toArray() {
            return this.list.toArray(new Handler[this.list.size()]);
        }

        @Override
        public Iterator<Handler> iterator() {
            return this.list.iterator();
        }

        public Handler byKey(int id) {
            for (Handler h : this.list) {
                if (h.getId() != id) continue;
                return h;
            }
            return null;
        }

        public void remove(Handler h) {
            this.list.remove(h);
        }

        public void add(Handler h) {
            this.list.add(h);
        }
    }
}

