/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.io;

import java.io.IOException;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.IOPack;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.TermComponent;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.terminal.api.IOTerm;
import org.openide.util.Exceptions;
import org.openide.windows.InputOutput;

class InternalTerminalPack
extends IOPack {
    private Pty pty = null;
    private final InputOutput io;
    private String slaveName = null;
    private static final Boolean fixEraseKeyInTerminal = Boolean.valueOf(System.getProperty("fixEraseKeyInTerminal", "true"));

    public InternalTerminalPack(TermComponent console, InputOutput io, ExecutionEnvironment exEnv) {
        super(console, exEnv, false);
        this.io = io;
    }

    @Override
    public boolean start() {
        try {
            this.pty = PtySupport.allocate((ExecutionEnvironment)this.exEnv);
        }
        catch (IOException ex) {
            this.slaveName = null;
            return false;
        }
        PtySupport.connect((InputOutput)this.io, (Pty)this.pty);
        this.slaveName = this.pty.getSlaveName();
        if (fixEraseKeyInTerminal.booleanValue()) {
            PtySupport.setBackspaceAsEraseChar((ExecutionEnvironment)this.exEnv, (String)this.slaveName);
        }
        return true;
    }

    @Override
    public String getSlaveName() {
        return this.slaveName;
    }

    @Override
    public void switchTo() {
        super.switchTo();
        this.io.select();
    }

    @Override
    public void close() {
        IOTerm.disconnect((InputOutput)this.io, null);
        if (this.pty != null) {
            try {
                this.pty.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

