/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.insane.impl.SmallObjectMap2;
import org.netbeans.insane.scanner.Filter;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;

public final class InsaneEngine {
    private Filter filter;
    private Visitor visitor;
    private ObjectMap objects;
    private boolean analyzeStaticData;
    private Set<Class> knownClasses = new HashSet<Class>();
    private Queue<Object> queue = new Queue();

    public InsaneEngine(Filter f, Visitor v, boolean analyzeStatic) {
        this(new SmallObjectMap2(), f, v, analyzeStatic);
    }

    public InsaneEngine(ObjectMap backend, Filter f, Visitor v, boolean analyzeStatic) {
        this.objects = backend;
        this.filter = f == null ? ScannerUtils.noFilter() : f;
        this.visitor = v;
        this.analyzeStaticData = analyzeStatic;
    }

    public void traverse(Collection roots) throws Exception {
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            this.recognize(it.next());
        }
        while (!this.queue.isEmpty()) {
            this.process(this.queue.get());
        }
    }

    private void recognize(Object o) {
        assert (o != null) : "Recognize objects, not null";
        if (o instanceof Class) {
            this.recognizeClass((Class)o);
        } else {
            this.recognizeObject(o);
        }
    }

    private void recognizeClass(Class cls) {
        if (this.knownClasses.contains(cls)) {
            return;
        }
        if (cls.getName().startsWith("org.netbeans.insane.scanner")) {
            return;
        }
        if (!this.analyzeStaticData) {
            this.knownClasses.add(cls);
            this.visitor.visitClass(cls);
            return;
        }
        try {
            Class sup = cls.getSuperclass();
            if (sup != null) {
                this.recognizeClass(sup);
            }
            Class<?>[] ifaces = cls.getInterfaces();
            for (int i = 0; i < ifaces.length; ++i) {
                this.recognizeClass(ifaces[i]);
            }
            this.knownClasses.add(cls);
            Field[] fields = cls.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                this.recognizeClass(fields[i].getType());
            }
            Method[] methods = cls.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                this.recognizeClass(methods[i].getReturnType());
                Class<?>[] params = methods[i].getParameterTypes();
                for (int j = 0; j < params.length; ++j) {
                    this.recognizeClass(params[j]);
                }
            }
            Constructor<?>[] cons = cls.getConstructors();
            for (int i = 0; i < cons.length; ++i) {
                Class<?>[] params = cons[i].getParameterTypes();
                for (int j = 0; j < params.length; ++j) {
                    this.recognizeClass(params[j]);
                }
            }
        }
        catch (Error e) {
            System.err.println("Failed analysing class " + cls.getName() + " because of " + e);
        }
        this.queue.add(cls);
        this.visitor.visitClass(cls);
    }

    private void recognizeObject(Object o) {
        if (this.objects.isKnown(o)) {
            return;
        }
        if (o.getClass().getName().startsWith("org.netbeans.insane.scanner")) {
            return;
        }
        assert (!o.getClass().getName().startsWith("sun.reflect."));
        this.recognizeClass(o.getClass());
        this.objects.getID(o);
        this.queue.add(o);
        this.visitor.visitObject(this.objects, o);
    }

    private void process(Object o) throws Exception {
        if (o instanceof Class) {
            this.processClass((Class)o);
        } else {
            this.processObject(o);
        }
    }

    private void processClass(Class cls) throws Exception {
        if (!this.analyzeStaticData) {
            return;
        }
        if (cls.getName().startsWith("java.lang.reflect") || cls.getName().equals("java.lang.Class")) {
            return;
        }
        ClassLoader cl = cls.getClassLoader();
        if (cl != null) {
            this.recognize(cl);
        }
        Field[] flds = null;
        try {
            flds = cls.getDeclaredFields();
        }
        catch (NoClassDefFoundError e) {
            System.err.println("Failed analysing class " + cls.getName() + " because of " + e);
            return;
        }
        catch (Throwable t) {
            System.err.println("Failed analysing class " + cls.getName() + " because of " + t);
            return;
        }
        for (int i = 0; i < flds.length; ++i) {
            Object target;
            Field act = flds[i];
            if ((act.getModifiers() & 8) == 0 || act.getType().isPrimitive()) continue;
            act.setAccessible(true);
            try {
                target = act.get(null);
            }
            catch (Throwable t) {
                System.err.println("Failed to read field " + act + " because of " + t);
                continue;
            }
            if (target == null || target.getClass().getName().startsWith("sun.reflect") || !this.filter.accept(target, null, act)) continue;
            this.recognize(target);
            if (!this.objects.isKnown(target)) continue;
            this.visitor.visitStaticReference(this.objects, target, act);
        }
    }

    private void processObject(Object obj) throws Exception {
        assert (this.objects.isKnown(obj)) : "Objects in queue must be known";
        Class<?> cls = obj.getClass();
        if (cls.getName().startsWith("java.lang.reflect")) {
            return;
        }
        if (cls.isArray() && !cls.getComponentType().isPrimitive()) {
            Object[] arr = (Object[])obj;
            for (int i = 0; i < arr.length; ++i) {
                Object target = arr[i];
                if (target == null || !this.filter.accept(target, arr, null)) continue;
                this.recognize(target);
                if (!this.objects.isKnown(target)) continue;
                this.visitor.visitArrayReference(this.objects, obj, target, i);
            }
        } else {
            while (cls != null) {
                try {
                    Field[] flds = cls.getDeclaredFields();
                    for (int i = 0; i < flds.length; ++i) {
                        Field act = flds[i];
                        if ((act.getModifiers() & 8) != 0 || act.getType().isPrimitive()) continue;
                        act.setAccessible(true);
                        Object target = act.get(obj);
                        if (target == null || !this.filter.accept(target, obj, act)) continue;
                        this.recognize(target);
                        if (!this.objects.isKnown(target)) continue;
                        this.visitor.visitObjectReference(this.objects, obj, target, act);
                    }
                }
                catch (Error e) {
                    System.err.println("Skipped analysing class " + cls.getName() + " because of " + e);
                }
                cls = cls.getSuperclass();
            }
        }
    }

    private static class Queue<T>
    extends ArrayList<T> {
        private int offset = 0;

        public void put(T o) {
            this.add(o);
        }

        @Override
        public boolean isEmpty() {
            return this.offset >= this.size();
        }

        public Object get() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            Object o = this.get(this.offset++);
            if (this.offset > 1000) {
                this.removeRange(0, this.offset);
                this.offset = 0;
            }
            return o;
        }
    }
}

