/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.queries.ColumnResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.queries.ConstructorResult;

public class ConstructorResultMetadata
extends ORMetadata {
    private MetadataClass targetClass;
    private String targetClassName;
    private List<ColumnResultMetadata> columnResults = new ArrayList<ColumnResultMetadata>();

    public ConstructorResultMetadata() {
        super("<constructor-result>");
    }

    public ConstructorResultMetadata(MetadataAnnotation constructorResult, MetadataAccessor accessor) {
        super(constructorResult, accessor);
        this.targetClass = this.getMetadataClass(constructorResult.getAttributeString("targetClass"));
        Object[] objectArray = constructorResult.getAttributeArray("columns");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object columnResult = objectArray[n2];
            this.columnResults.add(new ColumnResultMetadata((MetadataAnnotation)columnResult, accessor));
            ++n2;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ConstructorResultMetadata) {
            ConstructorResultMetadata constructorResult = (ConstructorResultMetadata)objectToCompare;
            if (!this.valuesMatch(this.getTargetClass(), constructorResult.getTargetClass())) {
                return false;
            }
            return this.valuesMatch(this.getColumnResults(), constructorResult.getColumnResults());
        }
        return false;
    }

    public List<ColumnResultMetadata> getColumnResults() {
        return this.columnResults;
    }

    public MetadataClass getTargetClass() {
        return this.targetClass;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.getColumnResults(), accessibleObject);
        this.setTargetClass(this.initXMLClassName(this.getTargetClassName()));
    }

    public ConstructorResult process() {
        ConstructorResult constructorResult = new ConstructorResult(this.getJavaClassName(this.getTargetClass()));
        for (ColumnResultMetadata columnResult : this.getColumnResults()) {
            constructorResult.addColumnResult(columnResult.process());
        }
        return constructorResult;
    }

    public void setColumnResults(List<ColumnResultMetadata> columnResults) {
        this.columnResults = columnResults;
    }

    public void setTargetClass(MetadataClass targetClass) {
        this.targetClass = targetClass;
    }

    public void setTargetClassName(String targetClassName) {
        this.targetClassName = targetClassName;
    }
}

