/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.modules.versioning.ui.diff.DiffActionTooltipWindow;
import org.netbeans.modules.versioning.ui.diff.DiffMark;
import org.netbeans.modules.versioning.ui.diff.DiffSidebarDiffPanel;
import org.netbeans.modules.versioning.ui.diff.DiffSidebarManager;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

class DiffSidebar
extends JPanel
implements DocumentListener,
ComponentListener,
FoldHierarchyListener,
FileChangeListener {
    private static final int BAR_WIDTH = 9;
    private static final Logger LOG = DiffSidebarManager.LOG;
    private final JTextComponent textComponent;
    private FileObject fileObject;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument document;
    private boolean sidebarVisible;
    private boolean sidebarTemporarilyDisabled;
    private boolean sidebarInComponentHierarchy;
    private Difference[] currentDiff;
    private DiffMarkProvider markProvider;
    private Color colorAdded = new Color(150, 255, 150);
    private Color colorChanged = new Color(160, 200, 255);
    private Color colorRemoved = new Color(255, 160, 180);
    private Color colorBorder = new Color(102, 102, 102);
    private int originalContentSerial;
    private int originalContentBufferSerial = -1;
    private String originalContentBuffer;
    private RequestProcessor.Task refreshDiffTask;
    private VCSSystemProvider.VersioningSystem ownerVersioningSystem;

    public DiffSidebar(JTextComponent target, FileObject file) {
        LOG.log(Level.FINE, "creating DiffSideBar for {0}", file != null ? file.getPath() : null);
        this.textComponent = target;
        this.fileObject = file;
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)target);
        this.document = (BaseDocument)this.textComponent.getDocument();
        this.markProvider = new DiffMarkProvider();
        this.setToolTipText("");
        this.refreshDiffTask = DiffSidebarManager.getInstance().createDiffSidebarTask(new RefreshDiffTask());
        this.setMaximumSize(new Dimension(9, Integer.MAX_VALUE));
    }

    FileObject getFileObject() {
        return this.fileObject;
    }

    private void refreshOriginalContent() {
        ++this.originalContentSerial;
        this.sidebarTemporarilyDisabled = false;
        LOG.log(Level.FINE, "refreshOriginalContent(): {0}", this.fileObject != null ? this.fileObject.getPath() : null);
        this.refreshDiff();
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    Difference[] getCurrentDiff() {
        return this.currentDiff;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Difference diff = this.getDifferenceAt(event);
        return DiffSidebar.getShortDescription(diff);
    }

    static String getShortDescription(Difference diff) {
        if (diff == null) {
            return null;
        }
        switch (diff.getType()) {
            case 1: {
                int n = diff.getSecondEnd() - diff.getSecondStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesAdded")).format(n), n);
            }
            case 2: {
                int n = diff.getFirstEnd() - diff.getFirstStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesChanged")).format(n), n);
            }
            case 0: {
                int n = diff.getFirstEnd() - diff.getFirstStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesDeleted")).format(n), n);
            }
        }
        throw new IllegalStateException("Unknown difference type: " + diff.getType());
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        if (event.getID() == 500 || event.isPopupTrigger()) {
            Difference diff = this.getDifferenceAt(event);
            if (diff == null) {
                return;
            }
            this.onClick(event, diff);
        } else {
            super.processMouseEvent(event);
        }
    }

    private void onClick(MouseEvent event, Difference diff) {
        Point p = new Point(event.getPoint());
        SwingUtilities.convertPointToScreen(p, this);
        this.showTooltipWindow(p, diff);
    }

    private void showTooltipWindow(Point p, Difference diff) {
        DiffActionTooltipWindow ttw = new DiffActionTooltipWindow(this, diff);
        ttw.show(new Point(p.x, p.y));
    }

    private Difference getDifferenceAt(MouseEvent event) {
        Difference diffPrev;
        Difference[] paintDiff = this.currentDiff;
        if (paintDiff == null) {
            return null;
        }
        int line = this.getLineFromMouseEvent(event);
        if (line == -1) {
            return null;
        }
        Difference diff = this.getDifference(line + 1, paintDiff);
        if (diff == null) {
            diff = this.getDifference(line, paintDiff);
            if (diff != null && diff.getType() != 0) {
                diff = null;
            }
        } else if (diff.getType() == 0 && (diffPrev = this.getDifference(line, paintDiff)) != null && diffPrev.getType() == 0) {
            diff = this.getCloserDifference(event, diffPrev, diff);
        }
        return diff;
    }

    private Difference getCloserDifference(MouseEvent event, Difference previous, Difference next) {
        Difference returnedDiff = next;
        JTextComponent component = this.textComponent;
        if (component != null) {
            TextUI textUI = component.getUI();
            try {
                Rectangle rec = textUI.modelToView(component, textUI.viewToModel(component, new Point(0, event.getY())));
                if (rec != null && (double)event.getY() < rec.getY() + rec.getHeight() / 2.0) {
                    returnedDiff = previous;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return returnedDiff;
    }

    void onDiff(final Difference diff) {
        try {
            final DiffController view = DiffController.create((StreamSource)new SidebarStreamSource(true), (StreamSource)new SidebarStreamSource(false));
            DiffTopComponent tc = new DiffTopComponent(view);
            tc.setName(NbBundle.getMessage(DiffSidebar.class, (String)"CTL_DiffPanel_Title", (Object[])new Object[]{this.fileObject.getNameExt()}));
            tc.open();
            tc.requestActive();
            PropertyChangeListener list = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("(void) differencesChanged".equals(evt.getPropertyName())) {
                        view.removePropertyChangeListener((PropertyChangeListener)this);
                        int diffIndex = DiffSidebar.this.getDiffIndex(diff);
                        if (diffIndex != -1 && diffIndex < view.getDifferenceCount()) {
                            view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, diffIndex);
                        }
                    }
                }
            };
            view.addPropertyChangeListener(list);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private int getDiffIndex(Difference diff) {
        Difference[] diffs = this.currentDiff;
        if (diffs != null) {
            for (int i = 0; i < diffs.length; ++i) {
                if (diff != diffs[i]) continue;
                return i;
            }
        }
        return -1;
    }

    private int computeDocumentOffset(int lineOffset) {
        int end = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)lineOffset);
        if (end == -1) {
            Element lineRoot = this.document.getParagraphElement(0).getParentElement();
            for (end = lineRoot.getElement(lineOffset - 1).getEndOffset(); end > this.document.getLength(); --end) {
            }
        }
        return end;
    }

    void onRollback(Difference diff) {
        try {
            if (diff.getType() == 1) {
                int start = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(diff.getSecondStart() - 1));
                int end = this.computeDocumentOffset(diff.getSecondEnd());
                this.document.remove(start, end - start);
            } else if (diff.getType() == 2) {
                int start = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(diff.getSecondStart() - 1));
                int end = this.computeDocumentOffset(diff.getSecondEnd());
                this.document.replace(start, end - start, diff.getFirstText(), null);
            } else {
                int start = this.computeDocumentOffset(diff.getSecondStart());
                String newline = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)diff.getSecondStart()) == -1 ? "\n" : "";
                this.document.insertString(start, newline + diff.getFirstText(), null);
            }
            LOG.finer("refreshing diff in onRollback");
            this.refreshDiff();
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    boolean canRollback(final Difference diff) {
        if (!(this.document instanceof GuardedDocument)) {
            return true;
        }
        final boolean[] modifiable = new boolean[1];
        this.document.runAtomic(new Runnable(){

            @Override
            public void run() {
                boolean canModify = DiffSidebar.this.document.isModifiable();
                if (canModify) {
                    int start;
                    int end;
                    if (diff.getType() == 0) {
                        start = end = Utilities.getRowStartFromLineOffset((BaseDocument)DiffSidebar.this.document, (int)diff.getSecondStart());
                    } else {
                        start = Utilities.getRowStartFromLineOffset((BaseDocument)DiffSidebar.this.document, (int)(diff.getSecondStart() - 1));
                        end = Utilities.getRowStartFromLineOffset((BaseDocument)DiffSidebar.this.document, (int)diff.getSecondEnd());
                    }
                    MarkBlockChain mbc = ((GuardedDocument)DiffSidebar.this.document).getGuardedBlockChain();
                    canModify = (mbc.compareBlock(start, end) & 1) == 0;
                }
                modifiable[0] = canModify;
            }
        });
        return modifiable[0];
    }

    void onPrevious(Difference diff) {
        int diffIndex;
        Difference[] diffs = this.currentDiff;
        if (diffs != null && (diffIndex = this.getDiffIndex(diff)) > -1 && diffIndex < diffs.length) {
            diff = diffs[diffIndex - 1];
            Point location = this.scrollToDifference(diff);
            this.showTooltipWindow(location, diff);
            this.textComponent.repaint();
        }
    }

    void onNext(Difference diff) {
        int diffIndex;
        Difference[] diffs = this.currentDiff;
        if (diffs != null && (diffIndex = this.getDiffIndex(diff)) > -1 && diffIndex < diffs.length - 1) {
            diff = diffs[diffIndex + 1];
            Point location = this.scrollToDifference(diff);
            this.showTooltipWindow(location, diff);
            this.textComponent.repaint();
        }
    }

    private Point scrollToDifference(Difference diff) {
        int lineStart = diff.getSecondStart() - 1;
        int lineEnd = diff.getSecondEnd() - 1;
        if (lineStart == -1) {
            lineStart = 0;
        }
        if (diff.getType() == 0) {
            lineEnd = lineStart;
        }
        try {
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.textComponent);
            int visibleBorder = editorUI.getLineHeight() * 5;
            int startOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.textComponent.getDocument()), (int)lineStart);
            int endOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.textComponent.getDocument()), (int)lineEnd);
            Rectangle startRect = this.textComponent.getUI().modelToView(this.textComponent, startOffset);
            Rectangle endRect = this.textComponent.getUI().modelToView(this.textComponent, endOffset);
            Rectangle visibleRect = new Rectangle(startRect.x - visibleBorder, startRect.y - visibleBorder, startRect.x, endRect.y - startRect.y + endRect.height + visibleBorder * 2);
            this.textComponent.scrollRectToVisible(visibleRect);
            Rectangle extent = editorUI.getExtentBounds();
            int maxVisibleY = extent.y + extent.height;
            Point p = new Point(endRect.x, Math.min(maxVisibleY, endRect.y + endRect.height + 1));
            SwingUtilities.convertPointToScreen(p, this.textComponent);
            return p;
        }
        catch (BadLocationException e) {
            LOG.log(Level.WARNING, "scrollToDifference", e);
            return null;
        }
    }

    String getMimeType() {
        if (this.textComponent instanceof JEditorPane) {
            return ((JEditorPane)this.textComponent).getContentType();
        }
        return "text/plain";
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDeleted(FileEvent fe) {
        DataObject dobj;
        if (this.fileObject != null) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this);
            this.fileObject = null;
        }
        if ((dobj = (DataObject)this.document.getProperty((Object)"stream")) != null) {
            this.fileObject = dobj.getPrimaryFile();
        }
        this.fileRenamed(null);
    }

    public void fileRenamed(FileRenameEvent fe) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiffSidebar.this.refresh();
            }
        });
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private int getPosFromY(JTextComponent component, TextUI textUI, int y) throws BadLocationException {
        if (textUI instanceof BaseTextUI) {
            return ((BaseTextUI)textUI).getPosFromY(y);
        }
        return textUI.modelToView((JTextComponent)component, (int)textUI.viewToModel((JTextComponent)component, (Point)new Point((int)0, (int)y))).y;
    }

    private int getLineFromMouseEvent(MouseEvent e) {
        int line = -1;
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.textComponent);
        if (editorUI != null) {
            try {
                JTextComponent component = editorUI.getComponent();
                if (component != null) {
                    TextUI textUI = component.getUI();
                    int clickOffset = textUI.viewToModel(component, new Point(0, e.getY()));
                    line = Utilities.getLineOffset((BaseDocument)this.document, (int)clickOffset);
                }
            }
            catch (BadLocationException ble) {
                LOG.log(Level.WARNING, "getLineFromMouseEvent", ble);
            }
        }
        return line;
    }

    void refresh() {
        if (!this.sidebarInComponentHierarchy) {
            return;
        }
        this.shutdown();
        this.ownerVersioningSystem = null;
        this.initialize();
        LOG.finer("refreshing diff in refresh");
        this.refreshDiff();
        this.revalidate();
    }

    public void setSidebarVisible(boolean visible) {
        if (this.sidebarVisible == visible) {
            return;
        }
        this.sidebarVisible = visible;
        LOG.finer("refreshing diff in setSidebarVisible");
        this.refreshDiff();
        this.revalidate();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.sidebarInComponentHierarchy = true;
        this.initialize();
    }

    @Override
    public void removeNotify() {
        this.shutdown();
        this.sidebarInComponentHierarchy = false;
        super.removeNotify();
    }

    private void initialize() {
        assert (SwingUtilities.isEventDispatchThread());
        this.document.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this);
        this.refreshOriginalContent();
        final FileObject fo = this.fileObject;
        if (fo != null) {
            DiffSidebarManager.getInstance().createDiffSidebarTask(new Runnable(){

                @Override
                public void run() {
                    fo.addFileChangeListener((FileChangeListener)DiffSidebar.this);
                }
            }).schedule(0);
        }
    }

    private void shutdown() {
        assert (SwingUtilities.isEventDispatchThread());
        this.refreshDiffTask.cancel();
        final FileObject fo = this.fileObject;
        if (fo != null) {
            DiffSidebarManager.getInstance().createDiffSidebarTask(new Runnable(){

                @Override
                public void run() {
                    fo.removeFileChangeListener((FileChangeListener)DiffSidebar.this);
                }
            }).schedule(0);
        }
        this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)this);
        this.textComponent.removeComponentListener(this);
        this.document.removeDocumentListener((DocumentListener)this);
    }

    private Reader getDocumentReader() {
        return DiffSidebar.getDocumentReader(this.textComponent.getDocument());
    }

    private void refreshDiff() {
        this.refreshDiffTask.schedule(50);
    }

    MarkProvider getMarkProvider() {
        return this.markProvider;
    }

    static void copyStreamsCloseAll(OutputStream writer, InputStream reader) throws IOException {
        int n;
        byte[] buffer = new byte[2048];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = this.textComponent.getSize();
        dim.width = this.sidebarVisible ? 9 : 0;
        return dim;
    }

    @Override
    public void paintComponent(final Graphics g) {
        super.paintComponent(g);
        Utilities.runViewHierarchyTransaction((JTextComponent)this.textComponent, (boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                DiffSidebar.this.paintComponentUnderLock(g);
            }
        });
    }

    private void paintComponentUnderLock(Graphics g) {
        block15: {
            Rectangle clip = g.getClipBounds();
            if (clip.y >= 16) {
                clip.y -= 16;
                clip.height += 16;
            }
            g.setColor(this.backgroundColor());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            JTextComponent component = this.textComponent;
            TextUI textUI = component.getUI();
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.textComponent);
            if (editorUI == null) {
                LOG.log(Level.WARNING, "No editor UI for file {0}, has {1} text UI", new Object[]{this.fileObject == null ? null : this.fileObject.getPath(), this.textComponent.getUI()});
                return;
            }
            View rootView = Utilities.getDocumentView((JTextComponent)component);
            if (rootView == null) {
                return;
            }
            Difference[] paintDiff = this.currentDiff;
            if (paintDiff == null || paintDiff.length == 0) {
                return;
            }
            try {
                int startPos = this.getPosFromY(component, textUI, clip.y);
                int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                int rootViewCount = rootView.getViewCount();
                if (startViewIndex < 0 || startViewIndex >= rootViewCount) break block15;
                Rectangle rec = textUI.modelToView(component, rootView.getView(startViewIndex).getStartOffset());
                int y = rec == null ? 0 : rec.y;
                int[] yCoords = new int[3];
                int clipEndY = clip.y + clip.height;
                Element rootElem = textUI.getRootView(component).getElement();
                View view = rootView.getView(startViewIndex);
                int line = rootElem.getElementIndex(view.getStartOffset());
                if (++line == 1 && paintDiff[0].getSecondStart() == 0 && paintDiff[0].getType() == 0) {
                    g.setColor(this.getColor(paintDiff[0]));
                    yCoords[0] = y - editorUI.getLineAscent() / 2;
                    yCoords[1] = y;
                    yCoords[2] = y + editorUI.getLineAscent() / 2;
                    g.fillPolygon(new int[]{0, 9, 0}, yCoords, 3);
                }
                for (int i = startViewIndex; i < rootViewCount; ++i) {
                    view = rootView.getView(i);
                    if (view == null) {
                        LOG.log(Level.WARNING, "View {0} null? View count = {1}/{2}. Root view: {3}, root elem: {4}", new Object[]{i, rootView.getViewCount(), rootViewCount, rootView, rootElem});
                    }
                    line = rootElem.getElementIndex(view.getStartOffset());
                    Difference ad = this.getDifference(++line, paintDiff);
                    Rectangle rec1 = component.modelToView(view.getStartOffset());
                    Rectangle rec2 = component.modelToView(view.getEndOffset() - 1);
                    if (rec2 != null && rec1 != null) {
                        y = rec1.y;
                        double height = rec2.getY() + rec2.getHeight() - rec1.getY();
                        if (ad != null) {
                            LOG.log(Level.FINEST, "painting difference {0} on line {1}", new Object[]{ad.getType(), line});
                            g.setColor(this.getColor(ad));
                            if (ad.getType() == 0) {
                                yCoords[0] = (int)rec2.getY() + editorUI.getLineAscent();
                                yCoords[1] = (int)rec2.getY() + editorUI.getLineAscent() * 3 / 2;
                                yCoords[2] = (int)rec2.getY() + editorUI.getLineAscent() * 2;
                                g.fillPolygon(new int[]{2, 9, 2}, yCoords, 3);
                                g.setColor(this.colorBorder);
                                g.drawLine(2, yCoords[0], 2, yCoords[2] - 1);
                            } else {
                                g.fillRect(3, y, 6, (int)height);
                                g.setColor(this.colorBorder);
                                int y1 = (int)((double)y + height);
                                g.drawLine(2, y, 2, y1);
                                if (ad.getSecondStart() == line) {
                                    g.drawLine(2, y, 8, y);
                                }
                                g.drawLine(2, y1, 8, y1);
                            }
                        }
                        if ((y = (int)((double)y + height)) < clipEndY) {
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (BadLocationException ble) {
                LOG.log(Level.INFO, null, ble);
            }
        }
    }

    private Color getColor(Difference ad) {
        if (ad.getType() == 1) {
            return this.colorAdded;
        }
        if (ad.getType() == 2) {
            return this.colorChanged;
        }
        return this.colorRemoved;
    }

    private Difference getDifference(int line, Difference[] paintDiff) {
        if (line < 0 || paintDiff == null) {
            return null;
        }
        for (int i = 0; i < paintDiff.length; ++i) {
            Difference difference = paintDiff[i];
            if (line < difference.getSecondStart()) {
                return null;
            }
            if (difference.getType() == 0 && line == difference.getSecondStart()) {
                return difference;
            }
            if (line > difference.getSecondEnd()) continue;
            return difference;
        }
        return null;
    }

    private Color backgroundColor() {
        Container c = this.getParent();
        if (c == null) {
            return this.defaultBackground();
        }
        return c.getBackground();
    }

    private Color defaultBackground() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return Color.WHITE;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        LOG.finer("refreshing diff in insertUpdate");
        this.refreshDiff();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        LOG.finer("refreshing diff in removeUpdate");
        this.refreshDiff();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        LOG.finer("refreshing diff in changedUpdate");
        this.refreshDiff();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                DiffSidebar.this.revalidate();
            }
        });
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void foldHierarchyChanged(FoldHierarchyEvent evt) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                DiffSidebar.this.repaint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getText(VCSSystemProvider.VersioningSystem vs) {
        if (vs == null) {
            return null;
        }
        Collection<FileObject> filesToCheckout = DiffSidebar.getFiles(this.fileObject);
        if (filesToCheckout.isEmpty()) {
            return null;
        }
        File tempFolder = DiffSidebar.getTempFolder();
        FileObject tempFileObj = null;
        try {
            Collection<File> originalFiles = this.checkoutOriginalFiles(filesToCheckout, tempFolder, vs);
            Charset encoding = FileEncodingQuery.getEncoding((FileObject)this.fileObject);
            for (File f : originalFiles) {
                Utils.associateEncoding((File)f, (Charset)encoding);
            }
            File tempFile = new File(tempFolder, this.fileObject.getNameExt());
            tempFileObj = FileUtil.toFileObject((File)tempFile);
            String string = DiffSidebar.getText(tempFile, tempFileObj, encoding);
            DiffSidebar.deleteTempFolder(tempFolder, tempFileObj);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            DiffSidebar.deleteTempFolder(tempFolder, tempFileObj);
        }
    }

    private static Collection<FileObject> getFiles(FileObject fileObj) {
        Set<FileObject> fileObjects;
        VCSFileProxy proxy = VCSFileProxy.createFileProxy((FileObject)fileObj);
        if (proxy == null) {
            return Collections.emptyList();
        }
        try {
            fileObjects = DataObject.find((FileObject)fileObj).files();
            assert (fileObjects.contains(fileObj));
            if (fileObjects.size() == 1) {
                fileObjects = Collections.singleton(fileObj);
            }
        }
        catch (DataObjectNotFoundException e) {
            fileObjects = Collections.singleton(fileObj);
        }
        return fileObjects;
    }

    private Collection<File> checkoutOriginalFiles(Collection<FileObject> filesToCheckout, File targetTempFolder, VCSSystemProvider.VersioningSystem vs) {
        ArrayList<File> originalFiles = new ArrayList<File>(filesToCheckout.size());
        for (FileObject fo : filesToCheckout) {
            LOG.log(Level.FINE, "checking out original file {0}", fo != null ? fo.getPath() : null);
            File originalFile = new File(targetTempFolder, fo.getNameExt());
            vs.getOriginalFile(VCSFileProxy.createFileProxy((FileObject)fo), VCSFileProxy.createFileProxy((File)originalFile));
            originalFiles.add(originalFile);
        }
        return originalFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getText(File file, FileObject fileObj, Charset charset) throws IOException {
        if (fileObj == null) return DiffSidebar.getRawText(file, charset);
        try {
            EditorCookie edCookie = DiffSidebar.getEditorCookie(fileObj);
            if (edCookie == null) return DiffSidebar.getRawText(fileObj, charset);
            try {
                StyledDocument doc;
                try {
                    doc = edCookie.openDocument();
                }
                catch (UserQuestionException ex) {
                    ex.confirmed();
                    doc = edCookie.openDocument();
                }
                String string = doc.getText(0, doc.getLength());
                return string;
            }
            finally {
                edCookie.close();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DiffSidebar.getRawText(file, charset);
    }

    private static EditorCookie getEditorCookie(FileObject fileObj) throws IOException {
        MultiDataObject.Entry entry;
        DataObject dao;
        try {
            dao = DataObject.find((FileObject)fileObj);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        if (dao instanceof MultiDataObject && (entry = DiffSidebar.findEntryForFile((MultiDataObject)dao, fileObj)) != null && entry instanceof CookieSet.Factory) {
            CookieSet.Factory factory = (CookieSet.Factory)entry;
            return (EditorCookie)factory.createCookie(EditorCookie.class);
        }
        return (EditorCookie)dao.getCookie(EditorCookie.class);
    }

    private static MultiDataObject.Entry findEntryForFile(MultiDataObject dataObj, FileObject fileObj) {
        MultiDataObject.Entry primaryEntry = dataObj.getPrimaryEntry();
        if (fileObj.equals(primaryEntry.getFile())) {
            return primaryEntry;
        }
        for (MultiDataObject.Entry entry : dataObj.secondaryEntries()) {
            if (!fileObj.equals(entry.getFile())) continue;
            return primaryEntry;
        }
        return null;
    }

    private static String getRawText(FileObject fileObj, Charset charset) throws IOException {
        char[] chars = new StringDecoder(charset).decode(fileObj.asBytes());
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRawText(File file, Charset charset) throws IOException {
        long size = file.length();
        if (size == 0L) {
            return file.exists() ? "" : null;
        }
        FileInputStream inputStream = new FileInputStream(file);
        FileChannel inputChannel = inputStream.getChannel();
        try {
            int inputSize = (int)inputChannel.size();
            ByteBuffer inBuf = ByteBuffer.allocate(inputSize);
            inputChannel.read(inBuf);
            char[] chars = new StringDecoder(charset).decode(inBuf);
            String string = new String(chars);
            return string;
        }
        finally {
            inputChannel.close();
        }
    }

    private static void deleteTempFolder(File tempFolder, FileObject tempFileObj) {
        boolean fullyDeleted = false;
        if (tempFileObj != null) {
            try {
                FileObject tempFolderObj = tempFileObj.getParent();
                if (tempFolderObj != null) {
                    tempFolderObj.delete();
                    fullyDeleted = true;
                } else {
                    tempFileObj.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!fullyDeleted) {
            DiffSidebar.deleteRecursively(tempFolder);
        }
    }

    private static Reader getDocumentReader(final Document doc) {
        final String[] str = new String[1];
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    str[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    DiffSidebarManager.LOG.log(Level.WARNING, null, e);
                }
            }
        };
        doc.render(run);
        return new StringReader(str[0]);
    }

    private static void deleteRecursively(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return;
        }
        try {
            fo.delete();
        }
        catch (IOException e) {
            DiffSidebarManager.LOG.log(Level.INFO, "", e);
            file.deleteOnExit();
        }
    }

    private static File getTempFolder() {
        File dir;
        File tmpDir = DiffSidebarManager.getInstance().getMainTempDir();
        while ((dir = new File(tmpDir, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !dir.mkdirs()) {
        }
        dir.deleteOnExit();
        return FileUtil.normalizeFile((File)dir);
    }

    static /* synthetic */ Difference[] access$502(DiffSidebar x0, Difference[] x1) {
        x0.currentDiff = x1;
        return x1;
    }

    private class SidebarStreamSource
    extends StreamSource {
        private final boolean isFirst;

        public SidebarStreamSource(boolean isFirst) {
            this.isFirst = isFirst;
        }

        public boolean isEditable() {
            return !this.isFirst;
        }

        public Lookup getLookup() {
            if (this.isFirst) {
                return super.getLookup();
            }
            return Lookups.fixed((Object[])new Object[]{DiffSidebar.this.document});
        }

        public String getName() {
            return DiffSidebar.this.fileObject.getNameExt();
        }

        public String getTitle() {
            if (this.isFirst) {
                return NbBundle.getMessage(DiffSidebar.class, (String)"LBL_DiffPane_Original");
            }
            return NbBundle.getMessage(DiffSidebar.class, (String)"LBL_DiffPane_WorkingCopy");
        }

        public String getMIMEType() {
            return DiffSidebar.this.getMimeType();
        }

        public Reader createReader() throws IOException {
            return this.isFirst ? new StringReader(DiffSidebar.this.originalContentBuffer) : DiffSidebar.this.getDocumentReader();
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            return null;
        }
    }

    private static final class StringDecoder {
        private final CharsetDecoder charsetDecoder;

        StringDecoder(Charset charset) {
            this.charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        char[] decode(byte[] bytes) {
            if (bytes.length == 0) {
                return new char[0];
            }
            return this.decode(ByteBuffer.wrap(bytes));
        }

        char[] decode(ByteBuffer inBuf) {
            char[] chars = new char[this.computeOutBufSize(inBuf.limit())];
            CharBuffer outBuf = CharBuffer.wrap(chars);
            this.charsetDecoder.reset();
            try {
                CoderResult result = this.charsetDecoder.decode(inBuf, outBuf, true);
                if (!result.isUnderflow()) {
                    result.throwException();
                }
                if (!(result = this.charsetDecoder.flush(outBuf)).isUnderflow()) {
                    result.throwException();
                }
            }
            catch (CharacterCodingException x) {
                assert (false);
                throw new Error(x);
            }
            if (chars.length != outBuf.position()) {
                chars = StringDecoder.trimToSize(chars, outBuf.position());
            }
            return chars;
        }

        private int computeOutBufSize(int inBufSize) {
            float ratio = this.charsetDecoder.maxCharsPerByte();
            return (int)Math.ceil((double)inBufSize * (double)ratio);
        }

        private static char[] trimToSize(char[] chars, int requestedLength) {
            if (requestedLength > chars.length) {
                throw new IllegalArgumentException();
            }
            if (requestedLength == chars.length) {
                return chars;
            }
            char[] result = new char[requestedLength];
            System.arraycopy(chars, 0, result, 0, requestedLength);
            return result;
        }
    }

    public class RefreshDiffTask
    implements Runnable {
        @Override
        public void run() {
            if (DiffSidebar.this.ownerVersioningSystem == null) {
                VCSFileProxy file = DiffSidebar.this.fileObject != null ? VCSFileProxy.createFileProxy((FileObject)DiffSidebar.this.fileObject) : null;
                DiffSidebar.this.ownerVersioningSystem = file != null ? org.netbeans.modules.versioning.core.util.Utils.getOwner((VCSFileProxy)file) : null;
                LOG.log(Level.FINE, "owner for file {0} is {1}", new Object[]{DiffSidebar.this.fileObject != null ? DiffSidebar.this.fileObject.getPath() : null, DiffSidebar.this.ownerVersioningSystem != null ? DiffSidebar.this.ownerVersioningSystem.getDisplayName() : "null"});
            }
            this.computeDiff();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DiffSidebar.this.repaint();
                    DiffSidebar.this.markProvider.refresh();
                }
            });
        }

        private void computeDiff() {
            if (!DiffSidebar.this.sidebarVisible || DiffSidebar.this.sidebarTemporarilyDisabled || !DiffSidebar.this.sidebarInComponentHierarchy) {
                DiffSidebar.access$502(DiffSidebar.this, null);
                return;
            }
            this.fetchOriginalContent();
            if (DiffSidebar.this.originalContentBuffer == null) {
                DiffSidebar.access$502(DiffSidebar.this, null);
                return;
            }
            Reader working = DiffSidebar.this.getDocumentReader();
            if (working == null) {
                return;
            }
            DiffProvider diff = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
            if (diff == null) {
                LOG.log(Level.WARNING, "no diff provider found for {0}", DiffSidebar.this.fileObject != null ? DiffSidebar.this.fileObject.getPath() : null);
                DiffSidebar.access$502(DiffSidebar.this, null);
                return;
            }
            try {
                DiffSidebar.access$502(DiffSidebar.this, diff.computeDiff((Reader)new StringReader(DiffSidebar.this.originalContentBuffer), working));
            }
            catch (IOException e) {
                DiffSidebar.access$502(DiffSidebar.this, null);
            }
        }

        private void fetchOriginalContent() {
            int serial = DiffSidebar.this.originalContentSerial;
            if (DiffSidebar.this.originalContentBuffer != null && DiffSidebar.this.originalContentBufferSerial == serial) {
                return;
            }
            DiffSidebar.this.originalContentBufferSerial = serial;
            LOG.log(Level.FINER, "fetching original contet for {0}", DiffSidebar.this.fileObject != null ? DiffSidebar.this.fileObject.getPath() : null);
            DiffSidebar.this.originalContentBuffer = DiffSidebar.this.getText(DiffSidebar.this.ownerVersioningSystem);
            if (DiffSidebar.this.originalContentBuffer == null) {
                DiffSidebar.this.sidebarTemporarilyDisabled = true;
                LOG.log(Level.FINE, "Disabling diffsidebar for {0}, no content available", DiffSidebar.this.fileObject != null ? DiffSidebar.this.fileObject.getPath() : null);
            }
        }
    }

    private class DiffMarkProvider
    extends MarkProvider {
        private List<DiffMark> marks = this.getMarksForDifferences();

        public List getMarks() {
            return this.marks;
        }

        void refresh() {
            List<DiffMark> oldMarks = this.marks;
            this.marks = this.getMarksForDifferences();
            LOG.log(Level.FINER, "refreshing marks for {0}", DiffSidebar.this.fileObject != null ? DiffSidebar.this.fileObject.getPath() : null);
            this.firePropertyChange("marks", oldMarks, this.marks);
        }

        private List<DiffMark> getMarksForDifferences() {
            Difference[] diffs = DiffSidebar.this.currentDiff;
            if (diffs == null || !DiffSidebar.this.isVisible() || DiffSidebar.this.getWidth() <= 0) {
                return Collections.emptyList();
            }
            ArrayList<DiffMark> marksList = new ArrayList<DiffMark>(diffs.length);
            for (int i = 0; i < diffs.length; ++i) {
                Difference difference = diffs[i];
                marksList.add(new DiffMark(difference, DiffSidebar.this.getColor(difference)));
            }
            return marksList;
        }
    }

    private static class DiffTopComponent
    extends TopComponent {
        private JComponent diffView;

        public DiffTopComponent() {
        }

        public DiffTopComponent(DiffController c) {
            this.diffView = c.getJComponent();
            this.setLayout(new BorderLayout());
            this.diffView.putClientProperty(TopComponent.class, (Object)this);
            DiffSidebarDiffPanel dsdp = new DiffSidebarDiffPanel(c);
            this.add(dsdp);
        }

        public UndoRedo getUndoRedo() {
            UndoRedo undoredo = (UndoRedo)this.diffView.getClientProperty(UndoRedo.class);
            return undoredo == null ? UndoRedo.NONE : undoredo;
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return "DiffSidebarTopComponent";
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(((Object)((Object)this)).getClass());
        }
    }
}

