/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner.ui.api;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.ui.api.TestsuiteNode;
import org.netbeans.modules.java.testrunner.JavaRegexpUtils;
import org.netbeans.modules.java.testrunner.ui.api.NodeOpener;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public final class UIJavaUtils {
    private static final Logger LOGGER = Logger.getLogger(UIJavaUtils.class.getName());
    static final Action[] NO_ACTIONS = new Action[0];

    public static void openTestsuite(TestsuiteNode node, String projectType, String testingFramework) {
        NodeOpener nodeOpener = UIJavaUtils.getNodeOpener(projectType, testingFramework);
        if (nodeOpener != null) {
            nodeOpener.openTestsuite(node);
        }
    }

    public static void openTestMethod(TestMethodNode node, String projectType, String testingFramework) {
        NodeOpener nodeOpener = UIJavaUtils.getNodeOpener(projectType, testingFramework);
        if (nodeOpener != null) {
            nodeOpener.openTestMethod(node);
        }
    }

    public static void openCallstackFrame(Node node, @NonNull String frameInfo, String projectType, String testingFramework) {
        NodeOpener nodeOpener = UIJavaUtils.getNodeOpener(projectType, testingFramework);
        if (nodeOpener != null) {
            nodeOpener.openCallstackFrame(node, frameInfo);
        }
    }

    private static NodeOpener getNodeOpener(String projectType, String testingFramework) {
        Collection providers = Lookup.getDefault().lookupResult(NodeOpener.class).allItems();
        for (Lookup.Item provider : providers) {
            if (!provider.getDisplayName().equals(projectType.concat("_").concat(testingFramework))) continue;
            return (NodeOpener)provider.getInstance();
        }
        return null;
    }

    public static void searchAllMethods(final TestMethodNode node, final FileObject[] fo2open, final long[] line, CompilationController compilationController, Element element) {
        HashSet s = new HashSet();
        Collections.addAll(s, element);
        Set<TypeElement> typeElements = ElementFilter.typesIn(s);
        block4: for (TypeElement typeElement : typeElements) {
            List<? extends Element> allMethods = compilationController.getElements().getAllMembers(typeElement);
            for (Element element2 : allMethods) {
                if (!node.getTestcase().getName().endsWith(element2.getSimpleName().toString())) continue;
                try {
                    TypeElement enclosingTypeElement = compilationController.getElementUtilities().enclosingTypeElement(element2);
                    String originalPath = FileUtil.toFile((FileObject)fo2open[0]).getAbsolutePath();
                    String elementFQP = element.toString().replaceAll("\\.", Matcher.quoteReplacement(File.separator));
                    String newPath = originalPath.substring(0, originalPath.indexOf(elementFQP)) + enclosingTypeElement.getQualifiedName().toString().replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + ".java";
                    fo2open[0] = FileUtil.toFileObject((File)new File(newPath));
                    if (fo2open[0] == null) {
                        LOGGER.log(Level.INFO, "Could not locate FO for path: {0}", newPath);
                        return;
                    }
                    JavaSource javaSource = JavaSource.forFileObject((FileObject)fo2open[0]);
                    if (javaSource == null) continue block4;
                    try {
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                Trees trees = compilationController.getTrees();
                                CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                                List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                                block0: for (Tree tree : typeDecls) {
                                    Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                                    if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fo2open[0].getName())) continue;
                                    List<ExecutableElement> methodElements = ElementFilter.methodsIn(element.getEnclosedElements());
                                    for (Element element2 : methodElements) {
                                        if (!node.getTestcase().getName().endsWith(element2.getSimpleName().toString())) continue;
                                        long pos = trees.getSourcePositions().getStartPosition(compilationUnitTree, trees.getTree(element2));
                                        line[0] = compilationUnitTree.getLineMap().getLineNumber(pos);
                                        break block0;
                                    }
                                }
                            }
                        }, true);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    continue block4;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public static String determineStackFrame(Trouble trouble) {
        String[] frames = trouble.getStackTrace();
        return frames != null && frames.length != 0 ? frames[frames.length - 1] : null;
    }

    public static TestMethodNode getTestMethodNode(Node node) {
        while (!(node instanceof TestMethodNode)) {
            node = node.getParentNode();
        }
        return (TestMethodNode)node;
    }

    public static FileObject getFile(String callstackLine, int[] lineNumStorage, LineConvertors.FileLocator locator) {
        String ending;
        String slashName;
        int lastSlashIndex;
        int lineNum;
        String fileName;
        String clsName;
        block15: {
            String methodName;
            int bracketIndex;
            String line = JavaRegexpUtils.specialTrim((String)callstackLine);
            if (line.startsWith("[catch] ")) {
                line = line.substring("[catch] ".length());
            }
            if (line.startsWith("at ")) {
                line = line.substring("at ".length());
            }
            String beforeBrackets = (bracketIndex = line.indexOf(40)) == -1 ? line : line.substring(0, bracketIndex).trim();
            int endBracketIndex = line.lastIndexOf(41);
            String inBrackets = bracketIndex == -1 || endBracketIndex < bracketIndex ? (String)null : line.substring(bracketIndex + 1, endBracketIndex);
            int lastDotIndex = beforeBrackets.lastIndexOf(46);
            if (lastDotIndex != -1) {
                clsName = beforeBrackets.substring(0, lastDotIndex);
                methodName = beforeBrackets.substring(lastDotIndex + 1);
            } else {
                clsName = beforeBrackets;
                methodName = "";
            }
            fileName = null;
            lineNum = -1;
            if (inBrackets != null && JavaRegexpUtils.getInstance().getLocationInFilePattern().matcher(inBrackets).matches()) {
                int ddotIndex = inBrackets.lastIndexOf(58);
                if (ddotIndex == -1) {
                    fileName = inBrackets;
                } else {
                    fileName = inBrackets.substring(0, ddotIndex);
                    try {
                        lineNum = Integer.parseInt(inBrackets.substring(ddotIndex + 1));
                        if (lineNum <= 0) {
                            lineNum = 1;
                        }
                    }
                    catch (NumberFormatException ex) {
                        if ($assertionsDisabled) break block15;
                        throw new AssertionError();
                    }
                }
            }
        }
        String clsNameSlash = clsName.replace('.', '/');
        if (fileName == null) {
            lastSlashIndex = clsNameSlash.length();
            slashName = clsNameSlash;
            ending = ".java";
        } else {
            lastSlashIndex = clsNameSlash.lastIndexOf(47);
            slashName = lastSlashIndex != -1 ? clsNameSlash.substring(0, lastSlashIndex) : clsNameSlash;
            ending = '/' + fileName;
        }
        String thePath = slashName + ending;
        FileObject file = locator.find(thePath);
        while (file == null && lastSlashIndex != -1) {
            thePath = (slashName = slashName.substring(0, lastSlashIndex)) + ending;
            file = locator.find(thePath);
            if (file != null) continue;
            lastSlashIndex = slashName.lastIndexOf(47, lastSlashIndex - 1);
        }
        if (file == null && fileName != null) {
            thePath = fileName;
            file = locator.find(thePath);
        }
        if (file == null) {
            lineNum = -1;
        }
        lineNumStorage[0] = lineNum;
        return file;
    }

    public static void openFile(FileObject file, int lineNum) {
        UIJavaUtils.openFile(file, lineNum, Integer.MIN_VALUE);
    }

    public static void openFile(final FileObject file, final int lineNum, final int columnNum) {
        if (file == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        EditorCookie ed = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                        if (ed != null) {
                            if (lineNum == -1) {
                                ed.open();
                                break block7;
                            }
                            ed.openDocument();
                            try {
                                Line l = ed.getLineSet().getOriginal(lineNum - 1);
                                if (l.isDeleted()) break block7;
                                if (columnNum != Integer.MIN_VALUE) {
                                    l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, columnNum);
                                    break block7;
                                }
                                l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                            }
                            catch (IndexOutOfBoundsException ioobe) {
                                ed.open();
                            }
                            break block7;
                        }
                        Toolkit.getDefaultToolkit().beep();
                    }
                    catch (IOException ex2) {
                        ErrorManager.getDefault().notify(16, (Throwable)ex2);
                    }
                }
            }
        });
    }
}

