/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import java.util.LinkedList;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranBracesStack;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranContextDetector;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranDiffLinkedList;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranPreprocessorFormatter;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranReformatter;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranStackEntry;

public class FortranReformatterImpl {
    final FortranContextDetector ts;
    final FortranCodeStyle codeStyle;
    final FortranDiffLinkedList diffs = new FortranDiffLinkedList();
    final FortranBracesStack braces;
    private final FortranPreprocessorFormatter preprocessorFormatter;
    private final int startOffset;
    private final int endOffset;
    final int tabSize;
    final boolean expandTabToSpaces;
    private int indentAfterLabel;

    FortranReformatterImpl(TokenSequence<FortranTokenId> ts, int startOffset, int endOffset, FortranCodeStyle codeStyle) {
        this.braces = new FortranBracesStack(codeStyle);
        int aTabSize = codeStyle.getTabSize();
        if (aTabSize <= 1) {
            aTabSize = 8;
        }
        this.tabSize = aTabSize;
        this.expandTabToSpaces = codeStyle.expandTabToSpaces();
        this.ts = new FortranContextDetector(ts, this.diffs, this.braces, this.tabSize, this.expandTabToSpaces);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.codeStyle = codeStyle;
        this.preprocessorFormatter = new FortranPreprocessorFormatter(this);
    }

    LinkedList<FortranReformatter.Diff> reformat() {
        this.ts.moveStart();
        Token<FortranTokenId> previous = this.ts.lookPrevious();
        boolean isFirst = true;
        while (this.ts.moveNext() && this.ts.offset() <= this.endOffset) {
            Token<FortranTokenId> current = this.ts.token();
            FortranTokenId id = (FortranTokenId)current.id();
            if (previous != null && previous.id() == FortranTokenId.PREPROCESSOR_DIRECTIVE && id != FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                this.analyzeLine(previous, current);
            }
            if (isFirst && current.id() != FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                this.analyzeLine(previous, current);
            }
            isFirst = false;
            switch (id) {
                case PREPROCESSOR_DIRECTIVE: {
                    this.preprocessorFormatter.indentPreprocessor(current);
                    break;
                }
                case NEW_LINE: {
                    this.analyzeLine(previous, current);
                    break;
                }
                case WHITESPACE: {
                    if (!this.doFormat()) break;
                    this.whiteSpaceFormat(previous, current);
                    break;
                }
                case LINE_COMMENT_FIXED: 
                case LINE_COMMENT_FREE: {
                    if (!this.doFormat()) break;
                    this.reformatBlockComment(previous, current);
                    break;
                }
                case LPAREN: {
                    ++this.braces.parenDepth;
                    if (!this.doFormat()) break;
                    this.formatLeftParen(previous, current);
                    if (previous == null || previous.id() != FortranTokenId.RPAREN) break;
                    this.spaceBefore(current, true);
                    break;
                }
                case RPAREN: {
                    --this.braces.parenDepth;
                    if (this.braces.parenDepth < 0) {
                        this.braces.parenDepth = 0;
                    }
                    if (!this.doFormat()) break;
                    this.formatRightParen(previous, current);
                    break;
                }
                case IDENTIFIER: {
                    if (!this.doFormat()) break;
                    Token<FortranTokenId> next = this.ts.lookNextImportant();
                    if (next != null && next.id() == FortranTokenId.COLON && this.braces.parenDepth == 0) {
                        this.indentLabel(previous);
                    }
                    if (previous == null || previous.id() != FortranTokenId.RPAREN) break;
                    this.spaceBefore(current, true);
                    break;
                }
                case STRING_LITERAL: {
                    if (!this.doFormat() || previous == null || previous.id() != FortranTokenId.RPAREN) break;
                    this.spaceBefore(current, true);
                    break;
                }
                case COMMA: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(previous, this.codeStyle.spaceBeforeComma());
                    this.spaceAfter(current, this.codeStyle.spaceAfterComma());
                    break;
                }
                case COLON: {
                    if (!this.doFormat()) break;
                    this.processColumn(previous, current);
                    break;
                }
                case KWOP_NOT: {
                    if (!this.doFormat()) break;
                    this.spaceAfter(current, this.codeStyle.spaceAroundUnaryOps());
                    break;
                }
                case OP_PLUS: 
                case OP_MINUS: {
                    if (!this.doFormat()) break;
                    FortranContextDetector.OperatorKind kind = this.ts.getOperatorKind(current);
                    if (kind == FortranContextDetector.OperatorKind.BINARY) {
                        this.spaceBefore(previous, this.codeStyle.spaceAroundBinaryOps());
                        this.spaceAfter(current, this.codeStyle.spaceAroundBinaryOps());
                        break;
                    }
                    if (kind != FortranContextDetector.OperatorKind.UNARY) break;
                    this.spaceAfter(current, this.codeStyle.spaceAroundUnaryOps());
                    break;
                }
                case OP_MUL: {
                    if (!this.doFormat()) break;
                    FortranContextDetector.OperatorKind kind = this.ts.getOperatorKind(current);
                    if (kind == FortranContextDetector.OperatorKind.BINARY) {
                        this.spaceBefore(previous, this.codeStyle.spaceAroundBinaryOps());
                        this.spaceAfter(current, this.codeStyle.spaceAroundBinaryOps());
                        break;
                    }
                    if (kind != FortranContextDetector.OperatorKind.UNARY) break;
                    this.spaceAfter(current, this.codeStyle.spaceAroundUnaryOps());
                    break;
                }
                case OP_CONCAT: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(previous, this.codeStyle.spaceAroundBinaryOps());
                    this.spaceAfter(current, this.codeStyle.spaceAroundBinaryOps());
                    break;
                }
                case KWOP_GT: 
                case KWOP_GE: 
                case OP_GT_EQ: 
                case KWOP_LT: 
                case OP_LT: 
                case KWOP_LE: 
                case OP_LT_EQ: 
                case KWOP_EQ: 
                case OP_LOG_EQ: 
                case KWOP_NE: 
                case OP_NOT_EQ: 
                case OP_LT_GT: 
                case PERCENT: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(previous, this.codeStyle.spaceAroundBinaryOps());
                    this.spaceAfter(current, this.codeStyle.spaceAroundBinaryOps());
                    break;
                }
                case OP_GT: {
                    if (!this.doFormat()) break;
                    if (previous == null || previous.id() != FortranTokenId.EQ) {
                        this.spaceBefore(previous, this.codeStyle.spaceAroundBinaryOps());
                    }
                    this.spaceAfter(current, this.codeStyle.spaceAroundBinaryOps());
                    break;
                }
                case EQ: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(previous, this.codeStyle.spaceAroundAssignOps());
                    Token<FortranTokenId> next = this.ts.lookNext();
                    if (next != null && next.id() == FortranTokenId.OP_GT) break;
                    this.spaceAfter(current, this.codeStyle.spaceAroundAssignOps());
                    break;
                }
                case KW_IF: {
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(current, this.codeStyle.spaceBeforeIfParen(), FortranTokenId.LPAREN);
                    break;
                }
                case KW_ELSEIF: {
                    if (!this.doFormat()) break;
                    this.formatElse(previous);
                    this.spaceAfterBefore(current, this.codeStyle.spaceBeforeIfParen(), FortranTokenId.LPAREN);
                    break;
                }
                case KW_ELSEWHERE: 
                case KW_ELSE: {
                    if (!this.doFormat()) break;
                    this.formatElse(previous);
                    break;
                }
                case KW_WHILE: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(previous, this.codeStyle.spaceBeforeWhile());
                    this.spaceAfterBefore(current, this.codeStyle.spaceBeforeWhileParen(), FortranTokenId.LPAREN);
                    break;
                }
                case KW_FORALL: {
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(current, this.codeStyle.spaceBeforeForParen(), FortranTokenId.LPAREN);
                    break;
                }
                case KW_SELECT: 
                case KW_SELECTCASE: 
                case KW_SELECTTYPE: {
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(current, this.codeStyle.spaceBeforeSwitchParen(), FortranTokenId.LPAREN);
                    break;
                }
                case KW_DEFAULT: 
                case KW_CASE: {
                    break;
                }
                case KW_CONTINUE: {
                    break;
                }
                case LINE_CONTINUATION_FIXED: {
                    int space;
                    if (!this.doFormat() || (space = this.getIndent() + this.codeStyle.indentSize() - this.ts.getTokenPosition() - this.ts.token().length()) <= 0) break;
                    Token<FortranTokenId> next = this.ts.lookNext();
                    if (next == null) {
                        this.ts.addAfterCurrent(current, 0, space, true);
                        break;
                    }
                    if (next.id() == FortranTokenId.WHITESPACE) {
                        this.ts.replaceNext(current, next, 0, space, true);
                        this.ts.moveNext();
                        current = this.ts.token();
                        break;
                    }
                    this.ts.addAfterCurrent(current, 0, space, true);
                    break;
                }
                case NUM_LITERAL_INT: {
                    int space;
                    if (this.codeStyle.getFormatFortran() != CndLexerUtilities.FortranFormat.FIXED || !this.ts.isFirstLineToken()) break;
                    int pos = this.ts.getTokenPosition();
                    if (pos != 5) {
                        FortranStackEntry top;
                        while ((top = this.braces.peek()) != null && top.getKind() == FortranTokenId.KW_DO && top.getLabel() == Integer.parseInt(current.text().toString())) {
                            this.braces.pop(this.ts);
                        }
                    }
                    if (!this.doFormat() || (space = this.indentAfterLabel - this.ts.getTokenPosition() - this.ts.token().length()) <= 0) break;
                    Token<FortranTokenId> next = this.ts.lookNext();
                    if (next == null) {
                        this.ts.addAfterCurrent(current, 0, space, true);
                        break;
                    }
                    if (next.id() == FortranTokenId.WHITESPACE) {
                        this.ts.replaceNext(current, next, 0, space, true);
                        this.ts.moveNext();
                        current = this.ts.token();
                        break;
                    }
                    this.ts.addAfterCurrent(current, 0, space, true);
                    break;
                }
                case SEMICOLON: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(previous, false);
                    this.spaceAfter(current, true);
                    break;
                }
                case DOUBLECOLON: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(previous, true);
                    this.spaceAfter(current, true);
                }
            }
            previous = current;
        }
        return this.diffs.getStorage();
    }

    int getParentIndent() {
        return this.continuationIndent(this.braces.getSelfIndent());
    }

    int getCaseIndent() {
        if (this.codeStyle.indentCasesFromSwitch()) {
            return this.getParentIndent() + this.codeStyle.indentSize();
        }
        return this.getParentIndent();
    }

    int getIndent() {
        return this.continuationIndent(this.braces.getIndent());
    }

    int continuationIndent(int shift) {
        return shift;
    }

    private void analyzeLine(Token<FortranTokenId> previous, Token<FortranTokenId> current) {
        Token<FortranTokenId> next = null;
        if (previous == null || previous.id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) {
            switch ((FortranTokenId)current.id()) {
                case PREPROCESSOR_DIRECTIVE: 
                case NEW_LINE: 
                case LINE_COMMENT_FIXED: 
                case LINE_COMMENT_FREE: {
                    break;
                }
                case WHITESPACE: {
                    next = this.ts.lookNextLineImportant();
                    break;
                }
                default: {
                    next = current;
                    break;
                }
            }
        } else {
            next = this.ts.lookNextLineImportant();
        }
        boolean isEnd = false;
        if (next != null) {
            switch ((FortranTokenId)next.id()) {
                case KW_ENDASSOCIATE: 
                case KW_ENDBLOCK: 
                case KW_ENDBLOCKDATA: 
                case KW_ENDDO: 
                case KW_ENDENUM: 
                case KW_ENDFILE: 
                case KW_ENDFORALL: 
                case KW_ENDFUNCTION: 
                case KW_ENDIF: 
                case KW_ENDINTERFACE: 
                case KW_ENDMAP: 
                case KW_ENDMODULE: 
                case KW_ENDPROGRAM: 
                case KW_ENDSELECT: 
                case KW_ENDSTRUCTURE: 
                case KW_ENDSUBROUTINE: 
                case KW_ENDTYPE: 
                case KW_ENDUNION: 
                case KW_ENDWHERE: 
                case KW_ENDWHILE: 
                case KW_END: {
                    this.braces.pop(this.ts);
                    isEnd = true;
                }
            }
        }
        if (this.doFormat()) {
            this.newLineFormat(previous, current, next);
        }
        if (next != null) {
            Token<FortranTokenId> next2;
            if (this.codeStyle.getFormatFortran() == CndLexerUtilities.FortranFormat.FIXED && next.id() == FortranTokenId.NUM_LITERAL_INT && (next2 = this.ts.lookNextLineImportant(2)) != null) {
                next = next2;
            }
            switch ((FortranTokenId)next.id()) {
                case KW_INTERFACE: 
                case KW_STRUCTURE: 
                case KW_UNION: 
                case KW_ENUM: 
                case KW_TYPE: {
                    FortranTokenId head = this.ts.lookNextLineImportantAfter((FortranTokenId)next.id());
                    if (head != null && head.id() == FortranTokenId.LPAREN) break;
                    this.braces.push(next, this.ts);
                    break;
                }
                case KW_PROCEDURE: 
                case KW_SUBROUTINE: 
                case KW_FUNCTION: {
                    FortranTokenId head = this.ts.lookNextLineImportantAfter((FortranTokenId)next.id());
                    if (head == null || head.id() != FortranTokenId.IDENTIFIER || (head = this.ts.lookPreviousLineImportant()) != null && head.id() == FortranTokenId.KW_MODULE) break;
                    this.braces.push(next, this.ts);
                    break;
                }
                case KW_MODULE: {
                    FortranTokenId head = this.ts.hasLineToken(FortranTokenId.KW_FUNCTION, FortranTokenId.KW_SUBROUTINE, FortranTokenId.KW_PROCEDURE);
                    if (head != null) break;
                    this.braces.push(next, this.ts);
                    break;
                }
                case KW_PROGRAM: 
                case KW_BLOCK: 
                case KW_BLOCKDATA: 
                case KW_MAP: {
                    this.braces.push(next, this.ts);
                    break;
                }
                case KW_IF: {
                    if (!this.ts.hasLineToken(FortranTokenId.KW_THEN)) break;
                    this.braces.push(next, this.ts);
                    break;
                }
                case KW_ELSEIF: 
                case KW_ELSE: 
                case KW_WHILE: 
                case KW_FORALL: 
                case KW_SELECT: 
                case KW_SELECTCASE: 
                case KW_SELECTTYPE: 
                case KW_WHERE: 
                case KW_DO: {
                    this.braces.push(next, this.ts);
                    break;
                }
                default: {
                    FortranTokenId head;
                    if (isEnd || (head = this.ts.hasLineToken(FortranTokenId.KW_FUNCTION, FortranTokenId.KW_SUBROUTINE)) == null) break;
                    this.braces.push(head);
                    break;
                }
            }
        }
    }

    private void formatElse(Token<FortranTokenId> previous) {
        if (this.ts.isFirstLineToken()) {
            FortranDiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
            if (diff != null) {
                boolean done = false;
                if (diff.after != null) {
                    diff.after.replaceSpaces(this.getParentIndent(), true);
                    done = true;
                }
                if (diff.replace != null && previous.id() == FortranTokenId.WHITESPACE) {
                    if (!done) {
                        diff.replace.replaceSpaces(this.getParentIndent(), true);
                        done = true;
                    } else {
                        diff.replace.replaceSpaces(0, false);
                    }
                }
                if (diff.before != null && previous.id() == FortranTokenId.WHITESPACE) {
                    if (!done) {
                        diff.before.replaceSpaces(this.getParentIndent(), true);
                        done = true;
                    } else {
                        diff.before.replaceSpaces(0, false);
                    }
                }
                if (done) {
                    return;
                }
            }
            if (previous.id() == FortranTokenId.WHITESPACE) {
                Token<FortranTokenId> p2 = this.ts.lookPrevious(2);
                if (p2 != null && p2.id() == FortranTokenId.NEW_LINE) {
                    this.ts.replacePrevious(previous, 0, this.getParentIndent(), true);
                } else {
                    this.ts.replacePrevious(previous, 0, 0, false);
                }
            } else if (previous.id() == FortranTokenId.NEW_LINE || previous.id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                this.ts.addBeforeCurrent(0, this.getParentIndent(), true);
            }
        }
    }

    private void indentLabel(Token<FortranTokenId> previous) {
        int indent = 0;
        if (!this.codeStyle.absoluteLabelIndent()) {
            indent = this.braces.getSelfIndent();
        }
        if (this.doFormat()) {
            if (!this.ts.isFirstLineToken()) {
                this.ts.addBeforeCurrent(1, 0, true);
            } else {
                FortranDiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
                if (diff == null) {
                    if (previous != null && previous.id() == FortranTokenId.WHITESPACE) {
                        this.ts.replacePrevious(previous, 0, indent, true);
                    }
                } else {
                    if (diff.after != null) {
                        diff.after.replaceSpaces(indent, true);
                    }
                    if (diff.replace != null) {
                        diff.replace.replaceSpaces(indent, true);
                    }
                }
            }
        }
    }

    private void newLineFormat(Token<FortranTokenId> previous, Token<FortranTokenId> current, Token<FortranTokenId> firstImportant) {
        boolean fixedLabel = firstImportant != null && firstImportant.id() == FortranTokenId.NUM_LITERAL_INT && this.codeStyle.getFormatFortran() == CndLexerUtilities.FortranFormat.FIXED;
        int pos = this.ts.getFirstLineTokenPosition();
        if (pos == 5 && this.codeStyle.getFormatFortran() == CndLexerUtilities.FortranFormat.FIXED) {
            return;
        }
        if (previous != null && previous.id() != FortranTokenId.PREPROCESSOR_DIRECTIVE) {
            boolean done = false;
            FortranDiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
            if (diff != null) {
                if (diff.after != null) {
                    diff.after.replaceSpaces(0, false);
                    if (diff.replace != null) {
                        diff.replace.replaceSpaces(0, false);
                    }
                    done = true;
                } else if (diff.replace != null) {
                    diff.replace.replaceSpaces(0, false);
                    done = true;
                }
            }
            if (!done && previous.id() == FortranTokenId.WHITESPACE) {
                this.ts.replacePrevious(previous, 0, 0, false);
            }
        } else {
            int space;
            if (fixedLabel) {
                space = 1;
                this.indentAfterLabel = this.getIndent();
            } else {
                space = this.getIndent();
            }
            if (current.id() == FortranTokenId.WHITESPACE) {
                this.ts.replaceCurrent(current, 0, space, true);
            } else if (current.id() != FortranTokenId.LINE_COMMENT_FIXED) {
                if (current.id() == FortranTokenId.LINE_COMMENT_FREE) {
                    if (this.codeStyle.getFormatFortran() == CndLexerUtilities.FortranFormat.FREE) {
                        if (space > 0) {
                            this.ts.addBeforeCurrent(0, space, true);
                        }
                    } else if (space <= 6) {
                        this.ts.addBeforeCurrent(0, 0, true);
                    } else {
                        this.ts.addBeforeCurrent(0, space, true);
                    }
                } else if (space > 0) {
                    this.ts.addBeforeCurrent(0, space, true);
                }
            }
            return;
        }
        Token<FortranTokenId> next = this.ts.lookNext();
        if (next != null) {
            if (next.id() == FortranTokenId.NEW_LINE || next.id() == FortranTokenId.LINE_COMMENT_FIXED) {
                return;
            }
            if (next.id() == FortranTokenId.LINE_COMMENT_FREE && this.codeStyle.getFormatFortran() == CndLexerUtilities.FortranFormat.FIXED && this.getIndent() <= 6) {
                this.ts.addAfterCurrent(current, 0, 0, true);
                return;
            }
            int space = -1;
            if (firstImportant != null) {
                switch ((FortranTokenId)firstImportant.id()) {
                    case KW_DEFAULT: 
                    case KW_CASE: {
                        space = this.getCaseIndent();
                        break;
                    }
                    case KW_CONTAINS: {
                        space = this.getParentIndent();
                    }
                }
            }
            if (space < 0) {
                if (fixedLabel) {
                    space = 1;
                    this.indentAfterLabel = this.getIndent();
                } else {
                    space = this.getIndent();
                }
            }
            if (next.id() == FortranTokenId.WHITESPACE) {
                this.ts.replaceNext(current, next, 0, space, true);
            } else if (space > 0) {
                this.ts.addAfterCurrent(current, 0, space, true);
            }
        }
    }

    private void indentNewLine(Token<FortranTokenId> current) {
        if (current.id() == FortranTokenId.NEW_LINE) {
            return;
        }
        Token<FortranTokenId> first = this.ts.lookNextLineImportant();
        int space = first != null && (first.id() == FortranTokenId.KW_CASE || first.id() == FortranTokenId.KW_DEFAULT) ? this.getCaseIndent() : this.getIndent();
        if (current.id() == FortranTokenId.WHITESPACE) {
            this.ts.replaceCurrent(current, 0, space, true);
        } else {
            this.ts.addBeforeCurrent(0, space, true);
        }
    }

    private void processColumn(Token<FortranTokenId> previous, Token<FortranTokenId> current) {
        Token<FortranTokenId> p = this.ts.lookPreviousImportant();
        if (p != null && p.id() == FortranTokenId.KW_DEFAULT) {
            this.spaceBefore(previous, false);
            return;
        }
        Token<FortranTokenId> p2 = this.ts.lookPreviousImportant(2);
        if (p2 != null && p2.id() == FortranTokenId.KW_CASE) {
            this.spaceBefore(previous, false);
            return;
        }
        this.spaceBefore(previous, false);
    }

    private void reformatBlockComment(Token<FortranTokenId> previous, Token<FortranTokenId> current) {
        if (!this.ts.isFirstLineToken()) {
            return;
        }
        int originalIndent = 0;
        if (previous == null || previous.id() == FortranTokenId.NEW_LINE || previous.id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) {
            originalIndent = 0;
        } else if (previous.id() == FortranTokenId.WHITESPACE) {
            CharSequence s = previous.text();
            for (int i = 0; i < previous.length(); ++i) {
                if (s.charAt(i) == ' ') {
                    ++originalIndent;
                    continue;
                }
                if (s.charAt(i) != '\t') continue;
                originalIndent = (originalIndent / this.tabSize + 1) * this.tabSize;
            }
        }
        int requiredIndent = this.getIndent();
        int start = -1;
        int end = -1;
        int currentIndent = 0;
        CharSequence s = current.text();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                start = i;
                end = i;
                currentIndent = 0;
                continue;
            }
            if (s.charAt(i) == ' ' || s.charAt(i) == '\t') {
                end = i;
                if (s.charAt(i) == ' ') {
                    ++currentIndent;
                    continue;
                }
                if (s.charAt(i) != '\t') continue;
                currentIndent = (currentIndent / this.tabSize + 1) * this.tabSize;
                continue;
            }
            if (start >= 0) {
                this.addCommentIndent(start, end, s.charAt(i), requiredIndent, originalIndent, currentIndent);
            }
            start = -1;
        }
        this.addCommentIndent(start, end, '*', requiredIndent, originalIndent, currentIndent);
    }

    private void addCommentIndent(int start, int end, char c, int requiredIndent, int originalIndent, int currentIndent) {
        if (start >= 0 && end >= start) {
            if (c == '*') {
                this.diffs.addFirst(this.ts.offset() + start + 1, this.ts.offset() + end + 1, 0, 1 + requiredIndent, true);
            } else {
                int indent = requiredIndent + currentIndent - originalIndent;
                if (indent < 0) {
                    indent = requiredIndent;
                }
                this.diffs.addFirst(this.ts.offset() + start + 1, this.ts.offset() + end + 1, 0, indent, true);
            }
        }
    }

    private void whiteSpaceFormat(Token<FortranTokenId> previous, Token<FortranTokenId> current) {
        Token<FortranTokenId> next;
        if (previous != null) {
            FortranDiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, 0);
            if (diff != null) {
                if (diff.replace != null) {
                    return;
                }
                if (diff.before != null) {
                    this.ts.replaceCurrent(current, 0, 0, false);
                    return;
                }
            }
            if (previous.id() == FortranTokenId.NEW_LINE || previous.id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                return;
            }
        }
        if ((next = this.ts.lookNext()) != null && next.id() == FortranTokenId.NEW_LINE) {
            return;
        }
        if (previous != null) {
            this.ts.replaceCurrent(current, 0, 1, false);
        }
    }

    private void spaceBefore(Token<FortranTokenId> previous, boolean add) {
        if (previous != null && !this.ts.isFirstLineToken()) {
            if (add) {
                FortranDiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
                if (diff != null) {
                    if (diff.after != null && !diff.after.hasNewLine()) {
                        diff.after.replaceSpaces(1, false);
                        if (diff.replace != null && !diff.replace.hasNewLine()) {
                            diff.replace.replaceSpaces(0, false);
                        }
                        return;
                    }
                    if (diff.replace != null && !diff.replace.hasNewLine()) {
                        diff.replace.replaceSpaces(1, false);
                        return;
                    }
                }
                if (previous.id() != FortranTokenId.WHITESPACE && previous.id() != FortranTokenId.NEW_LINE && previous.id() != FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                    this.ts.addBeforeCurrent(0, 1, false);
                }
            } else if (this.canRemoveSpaceBefore(previous)) {
                FortranDiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
                if (diff != null) {
                    if (diff.after != null && !diff.after.hasNewLine()) {
                        diff.after.replaceSpaces(0, false);
                        if (diff.replace != null && !diff.replace.hasNewLine()) {
                            diff.replace.replaceSpaces(0, false);
                        }
                        return;
                    }
                    if (diff.replace != null && !diff.replace.hasNewLine()) {
                        diff.replace.replaceSpaces(0, false);
                        return;
                    }
                }
                if (previous.id() == FortranTokenId.WHITESPACE) {
                    this.ts.replacePrevious(previous, 0, 0, false);
                }
            }
        }
    }

    private boolean canRemoveSpaceBefore(Token<FortranTokenId> previous) {
        if (previous == null) {
            return false;
        }
        if (previous.id() == FortranTokenId.WHITESPACE) {
            Token<FortranTokenId> p2 = this.ts.lookPrevious(2);
            if (p2 == null) {
                return true;
            }
            previous = p2;
        }
        FortranTokenId prev = (FortranTokenId)previous.id();
        FortranTokenId curr = (FortranTokenId)this.ts.token().id();
        return this.canRemoveSpace(prev, curr);
    }

    private boolean canRemoveSpace(FortranTokenId prev, FortranTokenId curr) {
        if (prev == FortranTokenId.IDENTIFIER && curr == FortranTokenId.IDENTIFIER) {
            return false;
        }
        String currCategory = curr.primaryCategory();
        String prevCategory = prev.primaryCategory();
        if ("keyword".equals(prevCategory)) {
            if ("special".equals(currCategory)) {
                return true;
            }
            return curr == FortranTokenId.COLON;
        }
        if ("operator".equals(prevCategory)) {
            if ("operator".equals(currCategory)) {
                return prev == FortranTokenId.COLON || curr == FortranTokenId.COLON;
            }
            return true;
        }
        return prev != FortranTokenId.IDENTIFIER || !"number".equals(currCategory) && !"literal".equals(currCategory) && !"string".equals(currCategory);
    }

    private boolean canRemoveSpaceAfter(Token<FortranTokenId> current) {
        Token<FortranTokenId> next = this.ts.lookNext();
        if (next == null) {
            return false;
        }
        if (next.id() == FortranTokenId.WHITESPACE) {
            Token<FortranTokenId> n2 = this.ts.lookNext(2);
            if (n2 == null) {
                return true;
            }
            next = n2;
        }
        FortranTokenId curr = (FortranTokenId)next.id();
        FortranTokenId prev = (FortranTokenId)current.id();
        return this.canRemoveSpace(prev, curr);
    }

    private void spaceAfter(Token<FortranTokenId> current, boolean add) {
        Token<FortranTokenId> next = this.ts.lookNext();
        if (next != null) {
            if (add) {
                if (next.id() != FortranTokenId.WHITESPACE && next.id() != FortranTokenId.NEW_LINE) {
                    this.ts.addAfterCurrent(current, 0, 1, false);
                }
            } else if (this.canRemoveSpaceAfter(current) && next.id() == FortranTokenId.WHITESPACE) {
                this.ts.replaceNext(current, next, 0, 0, false);
            }
        }
    }

    private void spaceAfterBefore(Token<FortranTokenId> current, boolean add, FortranTokenId before) {
        Token<FortranTokenId> next = this.ts.lookNext();
        if (next != null) {
            if (next.id() == FortranTokenId.WHITESPACE) {
                Token<FortranTokenId> p = this.ts.lookNext(2);
                if (p != null && p.id() == before && !add) {
                    this.ts.replaceNext(current, next, 0, 0, false);
                }
            } else if (next.id() == before && add) {
                this.ts.addAfterCurrent(current, 0, 1, false);
            }
        }
    }

    private void formatLeftParen(Token<FortranTokenId> previous, Token<FortranTokenId> current) {
        if (previous != null) {
            Token<FortranTokenId> p = this.ts.lookPreviousStatement();
            if (p != null) {
                switch ((FortranTokenId)p.id()) {
                    case KW_IF: 
                    case KW_ELSEIF: {
                        this.spaceAfter(current, this.codeStyle.spaceWithinIfParens());
                        return;
                    }
                    case KW_FORALL: {
                        this.spaceAfter(current, this.codeStyle.spaceWithinForParens());
                        return;
                    }
                    case KW_WHILE: {
                        this.spaceAfter(current, this.codeStyle.spaceWithinWhileParens());
                        return;
                    }
                    case KW_SELECT: 
                    case KW_SELECTCASE: 
                    case KW_SELECTTYPE: {
                        this.spaceAfter(current, this.codeStyle.spaceWithinSwitchParens());
                        return;
                    }
                }
            }
            if ((p = this.ts.lookPreviousImportant()) != null && p.id() == FortranTokenId.IDENTIFIER) {
                FortranStackEntry entry = this.braces.peek();
                if (entry == null) {
                    this.spaceBefore(previous, this.codeStyle.spaceBeforeMethodDeclParen());
                    this.spaceAfter(current, this.codeStyle.spaceWithinMethodDeclParens());
                    return;
                }
                switch (entry.getKind()) {
                    case KW_UNION: 
                    case KW_ENUM: 
                    case KW_TYPE: {
                        this.spaceBefore(previous, this.codeStyle.spaceBeforeMethodDeclParen());
                        this.spaceAfter(current, this.codeStyle.spaceWithinMethodDeclParens());
                        return;
                    }
                }
                this.spaceBefore(previous, this.codeStyle.spaceBeforeMethodCallParen());
                this.spaceAfter(current, this.codeStyle.spaceWithinMethodCallParens());
            } else if (p != null && "keyword".equals(((FortranTokenId)p.id()).primaryCategory())) {
                switch ((FortranTokenId)p.id()) {
                    case KW_RETURN: {
                        this.spaceBefore(previous, this.codeStyle.spaceBeforeKeywordParen());
                        return;
                    }
                }
            } else {
                this.spaceAfter(current, this.codeStyle.spaceWithinParens());
            }
        }
    }

    private void formatRightParen(Token<FortranTokenId> previous, Token<FortranTokenId> current) {
        if (previous != null) {
            Token<FortranTokenId> p = this.ts.lookPreviousStatement();
            if (p != null) {
                switch ((FortranTokenId)p.id()) {
                    case KW_IF: 
                    case KW_ELSEIF: {
                        this.spaceBefore(previous, this.codeStyle.spaceWithinIfParens());
                        return;
                    }
                    case KW_FORALL: {
                        this.spaceBefore(previous, this.codeStyle.spaceWithinForParens());
                        return;
                    }
                    case KW_WHILE: {
                        this.spaceBefore(previous, this.codeStyle.spaceWithinWhileParens());
                        return;
                    }
                    case KW_SELECT: 
                    case KW_SELECTCASE: 
                    case KW_SELECTTYPE: {
                        this.spaceBefore(previous, this.codeStyle.spaceWithinSwitchParens());
                        return;
                    }
                }
            }
            if ((p = this.getImportantBeforeBrace()) != null && p.id() == FortranTokenId.IDENTIFIER) {
                FortranStackEntry entry = this.braces.peek();
                if (entry == null) {
                    this.spaceBefore(previous, this.codeStyle.spaceWithinMethodDeclParens());
                    return;
                }
                switch (entry.getKind()) {
                    case KW_TYPE: {
                        this.spaceBefore(previous, this.codeStyle.spaceWithinMethodDeclParens());
                        return;
                    }
                }
                this.spaceBefore(previous, this.codeStyle.spaceWithinMethodCallParens());
            } else {
                this.spaceBefore(previous, this.codeStyle.spaceWithinParens());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token<FortranTokenId> getImportantBeforeBrace() {
        int index = this.ts.index();
        try {
            if (this.ts.token().id() == FortranTokenId.RPAREN) {
                int depth = 1;
                while (this.ts.movePrevious()) {
                    switch ((FortranTokenId)this.ts.token().id()) {
                        case RPAREN: {
                            ++depth;
                            break;
                        }
                        case LPAREN: {
                            if (--depth > 0) break;
                            Token<FortranTokenId> token = this.ts.lookPreviousImportant();
                            return token;
                        }
                    }
                }
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    boolean doFormat() {
        return this.ts.offset() >= this.startOffset;
    }
}

