/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.nodes.AddDependencyPanel;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.modules.maven.nodes.DependencyNode;
import org.netbeans.modules.maven.nodes.PathFinders;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class DependenciesNode
extends AbstractNode {
    public static final String PREF_DEPENDENCIES_UI = "org/netbeans/modules/maven/dependencies/ui";
    private static final String LIBS_BADGE = "org/netbeans/modules/maven/libraries-badge.png";
    private static final String DEF_FOLDER = "org/netbeans/modules/maven/defaultFolder.gif";
    private final DependenciesSet dependencies;
    private static final RequestProcessor RP = new RequestProcessor(DependenciesNode.class);
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final String ICON_PATH = "org/netbeans/modules/maven/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/maven/defaultFolderOpen.gif";

    DependenciesNode(DependenciesSet dependencies) {
        super(Children.create((ChildFactory)new DependenciesChildren(dependencies), (boolean)true), Lookups.fixed((Object[])new Object[]{dependencies.project, PathFinders.createPathFinder()}));
        this.dependencies = dependencies;
        this.setName("Dependencies" + (Object)((Object)dependencies.type));
        switch (dependencies.type) {
            case COMPILE: {
                this.setDisplayName(Bundle.LBL_Libraries());
                break;
            }
            case TEST: {
                this.setDisplayName(Bundle.LBL_Test_Libraries());
                break;
            }
            case RUNTIME: {
                this.setDisplayName(Bundle.LBL_Runtime_Libraries());
                break;
            }
            default: {
                this.setDisplayName(Bundle.LBL_non_cp_libraries());
            }
        }
        this.setIconBaseWithExtension("org/netbeans/modules/maven/defaultFolder.gif");
    }

    public Image getIcon(int param) {
        Image retValue = ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(false), (Image)ImageUtilities.loadImage((String)LIBS_BADGE), (int)8, (int)8);
        return retValue;
    }

    public Image getOpenedIcon(int param) {
        Image retValue = ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(true), (Image)ImageUtilities.loadImage((String)LIBS_BADGE), (int)8, (int)8);
        return retValue;
    }

    public Action[] getActions(boolean context) {
        ArrayList<AbstractAction> toRet = new ArrayList<AbstractAction>();
        toRet.add(new AddDependencyAction());
        toRet.add(null);
        toRet.add(new ResolveDepsAction(this.dependencies.project));
        toRet.add(new DownloadJavadocSrcAction(true));
        toRet.add(new DownloadJavadocSrcAction(false));
        toRet.addAll(Utilities.actionsForPath((String)"Projects/org-netbeans-modules-maven/DependenciesActions"));
        toRet.add(null);
        toRet.add(new DependencyNode.ShowManagedStateAction());
        return toRet.toArray(new Action[toRet.size()]);
    }

    public static Image getTreeFolderIcon(boolean opened) {
        Image base;
        Icon baseIcon = UIManager.getIcon(opened ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
        if (baseIcon != null) {
            base = ImageUtilities.icon2Image((Icon)baseIcon);
        } else {
            base = (Image)UIManager.get(opened ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
            if (base == null) {
                base = ImageUtilities.loadImage((String)(opened ? OPENED_ICON_PATH : ICON_PATH), (boolean)true);
            }
        }
        assert (base != null);
        return base;
    }

    static Preferences prefs() {
        return NbPreferences.root().node(PREF_DEPENDENCIES_UI);
    }

    private static class DependenciesComparator
    implements Comparator<DependencyWrapper> {
        private DependenciesComparator() {
        }

        @Override
        public int compare(DependencyWrapper art1, DependencyWrapper art2) {
            boolean transitive2;
            boolean transitive1 = art1.getDependencyTrailSize() > 2;
            boolean bl = transitive2 = art2.getDependencyTrailSize() > 2;
            if (transitive1 && !transitive2) {
                return 1;
            }
            if (!transitive1 && transitive2) {
                return -1;
            }
            int ret = art1.getArtifactId().compareTo(art2.getArtifactId());
            if (ret != 0) {
                return ret;
            }
            return art1.getArtifactString().compareTo(art2.getArtifactString());
        }
    }

    private static class ResolveDepsAction
    extends AbstractAction {
        private final Project project;

        ResolveDepsAction(Project prj) {
            this.putValue("Name", Bundle.LBL_Download());
            this.project = prj;
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            this.setEnabled(false);
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource(false);
        }
    }

    private class DownloadJavadocSrcAction
    extends AbstractAction {
        private boolean javadoc;

        DownloadJavadocSrcAction(boolean javadoc) {
            this.putValue("Name", javadoc ? Bundle.LBL_Download_Javadoc() : Bundle.LBL_Download__Sources());
            this.javadoc = javadoc;
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Node[] nds = DependenciesNode.this.getChildren().getNodes(true);
                    ProgressContributor[] contribs = new ProgressContributor[nds.length];
                    for (int i = 0; i < nds.length; ++i) {
                        contribs[i] = AggregateProgressFactory.createProgressContributor((String)("multi-" + i));
                    }
                    String label = DownloadJavadocSrcAction.this.javadoc ? Bundle.Progress_Javadoc() : Bundle.Progress_Source();
                    AggregateProgressHandle handle = AggregateProgressFactory.createHandle((String)label, (ProgressContributor[])contribs, (Cancellable)ProgressTransferListener.cancellable(), null);
                    handle.start();
                    try {
                        ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)handle);
                        for (int i = 0; i < nds.length; ++i) {
                            AtomicBoolean cancel = ProgressTransferListener.activeListener().cancel;
                            if (cancel != null && cancel.get()) {
                                return;
                            }
                            if (!(nds[i] instanceof DependencyNode)) continue;
                            DependencyNode nd = (DependencyNode)nds[i];
                            if (DownloadJavadocSrcAction.this.javadoc && !nd.data.hasJavadocInRepository()) {
                                nd.downloadJavadocSources(contribs[i], DownloadJavadocSrcAction.this.javadoc);
                                continue;
                            }
                            if (!DownloadJavadocSrcAction.this.javadoc && !nd.data.hasSourceInRepository()) {
                                nd.downloadJavadocSources(contribs[i], DownloadJavadocSrcAction.this.javadoc);
                                continue;
                            }
                            contribs[i].finish();
                        }
                    }
                    catch (ThreadDeath i) {
                    }
                    catch (IllegalStateException ise) {
                        if (!(ise.getCause() instanceof ThreadDeath)) {
                            throw ise;
                        }
                    }
                    finally {
                        handle.finish();
                        ProgressTransferListener.clearAggregateHandle();
                    }
                }
            });
        }
    }

    private class AddDependencyAction
    extends AbstractAction {
        AddDependencyAction() {
            this.putValue("Name", Bundle.BTN_Add_Library());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String typeString = DependenciesNode.this.dependencies.type == Type.RUNTIME ? "runtime" : (DependenciesNode.this.dependencies.type == Type.TEST ? "test" : "compile");
            final String[] data = AddDependencyPanel.show(DependenciesNode.this.dependencies.project, true, typeString);
            if (data != null) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        ModelUtils.addDependency(DependenciesNode.this.dependencies.project.getProjectDirectory().getFileObject("pom.xml"), data[0], data[1], data[2], data[4], data[3], data[5], false);
                        ((NbMavenProject)DependenciesNode.this.dependencies.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource(false);
                    }
                });
            }
        }
    }

    private static final class DependencyWrapper {
        private final Artifact artifact;
        private final FileObject fileObject;
        private final Node nodeDelegate;
        private final String artifactString;
        private final String depenencyTrailString;
        private final String filePath;
        private final int dependencyTrailSize;
        private final String artifactId;

        public DependencyWrapper(Artifact artifact, boolean longLiving) {
            this.artifact = artifact;
            assert (artifact.getFile() != null) : "#200927 Artifact.getFile() is null: " + artifact;
            assert (artifact.getDependencyTrail() != null) : "#200927 Artifact.getDependencyTrail() is null:" + artifact;
            assert (artifact.getVersion() != null) : "200927 Artifact.getVersion() is null: " + artifact;
            this.artifactId = artifact.getArtifactId();
            this.artifactString = artifact.toString();
            StringBuilder sb = new StringBuilder();
            ArrayList dependencyTrail = new ArrayList(artifact.getDependencyTrail());
            Collections.sort(dependencyTrail);
            this.dependencyTrailSize = dependencyTrail.size();
            Iterator it = dependencyTrail.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(";");
            }
            this.depenencyTrailString = sb.toString();
            this.filePath = artifact.getFile().getAbsolutePath();
            this.fileObject = FileUtil.toFileObject((File)artifact.getFile());
            this.nodeDelegate = DependencyNode.createNodeDelegate(artifact, this.fileObject, longLiving);
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public Node getNodeDelegate() {
            return this.nodeDelegate;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyWrapper other = (DependencyWrapper)obj;
            if (!this.artifactString.equals(other.artifactString)) {
                return false;
            }
            if (!this.depenencyTrailString.equals(other.depenencyTrailString)) {
                return false;
            }
            return this.filePath.equals(other.filePath);
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.artifactString.hashCode();
            hash = 31 * hash + this.depenencyTrailString.hashCode();
            hash = 31 * hash + this.filePath.hashCode();
            return hash;
        }

        private int getDependencyTrailSize() {
            return this.dependencyTrailSize;
        }

        private String getArtifactId() {
            return this.artifactId;
        }

        private String getArtifactString() {
            return this.artifactString;
        }
    }

    static final class DependenciesSet
    implements PropertyChangeListener {
        private NbMavenProjectImpl project;
        private final Type type;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        DependenciesSet(NbMavenProjectImpl project, Type type) {
            this.project = project;
            this.type = type;
            NbMavenProject nbmp = project.getProjectWatcher();
            nbmp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)nbmp));
        }

        Collection<DependencyWrapper> list(boolean longLiving) {
            HashSet<DependencyWrapper> lst = new HashSet<DependencyWrapper>();
            MavenProject mp = this.project.getOriginalMavenProject();
            Set arts = mp.getArtifacts();
            switch (this.type) {
                case COMPILE: {
                    this.create(lst, arts, longLiving, "compile", "provided", "system");
                    break;
                }
                case TEST: {
                    this.create(lst, arts, longLiving, "test");
                    break;
                }
                case RUNTIME: {
                    this.create(lst, arts, longLiving, "runtime");
                    break;
                }
                default: {
                    for (Artifact a : arts) {
                        if (a.getArtifactHandler().isAddedToClasspath()) continue;
                        lst.add(new DependencyWrapper(a, longLiving));
                    }
                }
            }
            ArrayList<DependencyWrapper> l = new ArrayList<DependencyWrapper>(lst);
            Collections.sort(l, new DependenciesComparator());
            return l;
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.cs.fireChange();
            }
        }

        private void create(Set<DependencyWrapper> lst, Collection<Artifact> arts, boolean longLiving, String ... scopes) {
            List<String> scopesList = Arrays.asList(scopes);
            for (Artifact a : arts) {
                if (!scopesList.contains(a.getScope()) || !a.getArtifactHandler().isAddedToClasspath()) continue;
                lst.add(new DependencyWrapper(a, longLiving));
            }
        }
    }

    private static class DependenciesChildren
    extends ChildFactory<DependencyWrapper>
    implements ChangeListener {
        private final DependenciesSet dependencies;

        DependenciesChildren(DependenciesSet dependencies) {
            this.dependencies = dependencies;
            dependencies.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)dependencies));
        }

        protected Node createNodeForKey(DependencyWrapper wr) {
            return new DependencyNode(this.dependencies.project, wr.getArtifact(), wr.getFileObject(), true, wr.getNodeDelegate());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }

        protected boolean createKeys(List<DependencyWrapper> toPopulate) {
            toPopulate.addAll(this.dependencies.list(true));
            return true;
        }
    }

    static enum Type {
        COMPILE,
        TEST,
        RUNTIME,
        NONCP;

    }
}

