/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.runjar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.maven.runjar.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class MainClassChooser
extends JPanel {
    private ChangeListener changeListener;
    private Collection<ElementHandle<TypeElement>> possibleMainClasses;
    public static Boolean unitTestingSupport_hasMainMethodResult = null;
    private ButtonGroup buttonGroup1;
    private JList jMainClassList;
    private JScrollPane jScrollPane1;
    private JLabel lblMainClass;
    JRadioButton rbPermanent;
    JRadioButton rbSession;

    MainClassChooser(FileObject ... sourcesRoots) {
        this.initComponents();
        this.jMainClassList.setCellRenderer(new MainClassRenderer());
        this.initClassesView(sourcesRoots);
    }

    private void initClassesView(final FileObject ... sourcesRoots) {
        this.possibleMainClasses = null;
        this.jMainClassList.setSelectionMode(0);
        this.jMainClassList.setListData(this.getWarmupList());
        this.jMainClassList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(evt));
                }
            }
        });
        this.jMainClassList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && MainClassChooser.this.getSelectedMainClass() != null && MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(e));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MainClassChooser.this.possibleMainClasses = SourceUtils.getMainClasses((FileObject[])sourcesRoots);
                if (MainClassChooser.this.possibleMainClasses.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainClassChooser.this.jMainClassList.setListData(new String[]{Bundle.LBL_ChooseMainClass_NO_CLASSES_NODE()});
                        }
                    });
                } else {
                    final ElementHandle[] arr = MainClassChooser.this.possibleMainClasses.toArray(new ElementHandle[MainClassChooser.this.possibleMainClasses.size()]);
                    Arrays.sort(arr, new MainClassComparator());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainClassChooser.this.jMainClassList.setListData(arr);
                            MainClassChooser.this.jMainClassList.setSelectedIndex(0);
                        }
                    });
                }
            }
        });
    }

    private Object[] getWarmupList() {
        return new Object[]{Bundle.LBL_ChooseMainClass_WARMUP_MESSAGE()};
    }

    private boolean isValidMainClassName(Object value) {
        return this.possibleMainClasses != null && this.possibleMainClasses.contains(value);
    }

    String getSelectedMainClass() {
        if (this.isValidMainClassName(this.jMainClassList.getSelectedValue())) {
            return ((ElementHandle)this.jMainClassList.getSelectedValue()).getQualifiedName();
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListener = null;
    }

    public static boolean hasMainMethod(FileObject fo) {
        if (unitTestingSupport_hasMainMethodResult != null) {
            return unitTestingSupport_hasMainMethodResult;
        }
        if (fo == null) {
            return false;
        }
        return !SourceUtils.getMainClasses((FileObject)fo).isEmpty();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblMainClass = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jMainClassList = new JList();
        this.rbSession = new JRadioButton();
        this.rbPermanent = new JRadioButton();
        this.setPreferredSize(new Dimension(380, 300));
        this.lblMainClass.setLabelFor(this.jMainClassList);
        Mnemonics.setLocalizedText((JLabel)this.lblMainClass, (String)NbBundle.getMessage(MainClassChooser.class, (String)"CTL_AvaialableMainClasses"));
        this.jScrollPane1.setMinimumSize(new Dimension(100, 200));
        this.jScrollPane1.setViewportView(this.jMainClassList);
        this.jMainClassList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooser.class, (String)"AD_jMainClassList"));
        this.buttonGroup1.add(this.rbSession);
        this.rbSession.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSession, (String)NbBundle.getMessage(MainClassChooser.class, (String)"MainClassChooser.rbSession.text"));
        this.buttonGroup1.add(this.rbPermanent);
        Mnemonics.setLocalizedText((AbstractButton)this.rbPermanent, (String)NbBundle.getMessage(MainClassChooser.class, (String)"MainClassChooser.rbPermanent.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbPermanent).addComponent(this.rbSession).addComponent(this.jScrollPane1, -1, 356, Short.MAX_VALUE).addComponent(this.lblMainClass)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblMainClass, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 205, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbSession).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbPermanent).addContainerGap()));
        this.lblMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooser.class, (String)"AD_jMainClassList"));
    }

    private static class MainClassComparator
    implements Comparator<ElementHandle> {
        private MainClassComparator() {
        }

        @Override
        public int compare(ElementHandle arg0, ElementHandle arg1) {
            return arg0.getQualifiedName().compareTo(arg1.getQualifiedName());
        }
    }

    private static final class MainClassRenderer
    extends DefaultListCellRenderer {
        private MainClassRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayName = value instanceof ElementHandle ? ((ElementHandle)value).getQualifiedName() : value.toString();
            return super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
        }
    }
}

