/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.MapSnapshot;
import org.openide.util.WeakSet;

public abstract class SnapshotHolderCache {
    private static final int MACRO_MANAGER_DEFAULT_CAPACITY;
    private static final int MACRO_MANAGER_DEFAULT_SLICED_NUMBER;
    private static final SnapshotHolderCache instance;

    private SnapshotHolderCache() {
    }

    abstract MapSnapshot.Holder getHolder(MapSnapshot.Holder var1);

    public abstract void dispose();

    private static SnapshotHolderCache create(boolean single) {
        if (single) {
            return new APTSingleHolderManager(MACRO_MANAGER_DEFAULT_CAPACITY);
        }
        return new APTCompoundHolderManager(MACRO_MANAGER_DEFAULT_SLICED_NUMBER, MACRO_MANAGER_DEFAULT_CAPACITY);
    }

    public static SnapshotHolderCache getManager() {
        return instance;
    }

    static {
        int nrProc = CndUtils.getConcurrencyLevel();
        if (nrProc <= 4) {
            MACRO_MANAGER_DEFAULT_SLICED_NUMBER = 32;
            MACRO_MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            MACRO_MANAGER_DEFAULT_SLICED_NUMBER = 128;
            MACRO_MANAGER_DEFAULT_CAPACITY = 128;
        }
        instance = SnapshotHolderCache.create(false);
    }

    private static final class APTCompoundHolderManager
    extends SnapshotHolderCache {
        private final SnapshotHolderCache[] instances;
        private final int segmentMask;

        private APTCompoundHolderManager(int sliceNumber) {
            this(sliceNumber, MACRO_MANAGER_DEFAULT_CAPACITY);
        }

        private APTCompoundHolderManager(int sliceNumber, int initialCapacity) {
            int ssize;
            for (ssize = 1; ssize < sliceNumber; ssize <<= 1) {
            }
            this.segmentMask = ssize - 1;
            this.instances = new SnapshotHolderCache[ssize];
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i] = new APTSingleHolderManager(initialCapacity);
            }
        }

        private SnapshotHolderCache getDelegate(MapSnapshot.Holder macro) {
            if (macro == null) {
                throw new NullPointerException("null macro is illegal to share");
            }
            int index = macro.hashCode() & this.segmentMask;
            return this.instances[index];
        }

        @Override
        public MapSnapshot.Holder getHolder(MapSnapshot.Holder macro) {
            return this.getDelegate(macro).getHolder(macro);
        }

        @Override
        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i].dispose();
            }
        }
    }

    private static final class APTSingleHolderManager
    extends SnapshotHolderCache {
        private final WeakSet<MapSnapshot.Holder> storage;
        private final int initialCapacity;
        private final Object lock = new Lock();

        private APTSingleHolderManager(int initialCapacity) {
            this.storage = new WeakSet(initialCapacity);
            this.initialCapacity = initialCapacity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MapSnapshot.Holder getHolder(MapSnapshot.Holder arr) {
            if (arr == null) {
                throw new NullPointerException("null string is illegal to share");
            }
            MapSnapshot.Holder outHolder = null;
            Object object = this.lock;
            synchronized (object) {
                outHolder = (MapSnapshot.Holder)this.storage.putIfAbsent((Object)arr);
            }
            assert (outHolder != null);
            assert (outHolder.equals((Object)arr));
            return outHolder;
        }

        @Override
        public final void dispose() {
            if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                Object[] arr = this.storage.toArray();
                System.out.println("Dispose macro cache " + arr.length + " " + this.getClass().getName());
                HashMap classes = new HashMap();
                for (Object o : arr) {
                    if (o == null) continue;
                    Integer i = (Integer)classes.get(o.getClass());
                    i = i != null ? Integer.valueOf(i + 1) : Integer.valueOf(1);
                    classes.put(o.getClass(), i);
                }
                for (Map.Entry entry : classes.entrySet()) {
                    System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                }
            }
            if (this.storage.size() > 0) {
                this.storage.clear();
                this.storage.resize(this.initialCapacity);
            }
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }

    public static enum CacheKind {
        Single,
        Sliced;

    }
}

