/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.support;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.clang.lex.PPCallbacks;
import org.clang.lex.Token;
import org.clank.support.Casts;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.aliases.SmallVectorInt;

final class SkippedRangeBuilder {
    private static final boolean TEMPORARY_DISABLE_CHECK_IN_PTH_MODE = false;
    private static final int ERROR_DIRECTIVE_MARKER = Integer.MAX_VALUE;
    private static final int PRAGMA_ONCE_DIRECTIVE_MARKER = 0x7FFFFFFE;
    private final SortedSet<int[]> blocks = new TreeSet<int[]>(COMPARATOR);
    private final char.ptr name;
    private static final Comparator<int[]> COMPARATOR = new Comparator<int[]>(){

        @Override
        public int compare(int[] segment1, int[] segment2) {
            return segment1[0] - segment2[0];
        }
    };
    private final SmallVectorInt someBlocksWithState = new SmallVectorInt(16);
    private static final int DEAD = 0;
    private static final int LIVE = 1;
    private static final int SEEN_LIVE = 2;
    private static final int SEEN_ONLY_DEAD = 3;

    SkippedRangeBuilder(char.ptr name) {
        this.name = name;
    }

    final SkippedRangeBuilder addBlockImpl(int startDeadBlock, int endDeadBlock) {
        assert (endDeadBlock >= startDeadBlock) : "incorrect offsets " + startDeadBlock + " and " + endDeadBlock;
        if (endDeadBlock > startDeadBlock) {
            this.blocks.add(new int[]{startDeadBlock, endDeadBlock});
        }
        return this;
    }

    public void onErrorDirective(Token tok2) {
    }

    public void onPragmaOnceDirective(Token tok2) {
    }

    public int[] build() {
        int size = 0;
        for (int[] deadInterval : this.blocks) {
            ++size;
            if (deadInterval[1] != Integer.MAX_VALUE) continue;
            break;
        }
        int[] offsets = new int[size * 2];
        int index = 0;
        for (int[] deadInterval : this.blocks) {
            offsets[index++] = deadInterval[0];
            offsets[index++] = deadInterval[1];
            if (deadInterval[1] != Integer.MAX_VALUE) continue;
            break;
        }
        assert (this.checkConsistency(offsets));
        return offsets;
    }

    private boolean checkConsistency(int[] offsets) {
        boolean ok = true;
        for (int i = 0; i < offsets.length; ++i) {
            if (i + 1 >= offsets.length || offsets[i] < offsets[i + 1]) continue;
            ok = false;
            assert (false) : "inconsistent state " + this;
        }
        return ok;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withName) {
        StringBuilder sb = new StringBuilder();
        if (withName && this.name != null) {
            sb.append(Casts.toJavaString((char.ptr)this.name));
        }
        sb.append("[");
        int i = 0;
        for (int[] deadInterval : this.blocks) {
            if (i++ > 0) {
                sb.append("][");
            }
            if (deadInterval[1] == Integer.MAX_VALUE) {
                sb.append(Integer.MAX_VALUE - deadInterval[0]);
                sb.append("#error");
                continue;
            }
            if (deadInterval[1] == 0x7FFFFFFE) {
                sb.append(deadInterval[0]);
                sb.append("#pragma once");
                continue;
            }
            sb.append(deadInterval[0]);
            sb.append("-");
            sb.append(deadInterval[1]);
        }
        sb.append("]");
        return sb.toString();
    }

    void startIf(int hash, int eod, int ifOffset, PPCallbacks.ConditionValueKind ConditionValue) {
        if (NativeTrace.isDebugMode()) {
            NativeTrace.assertTrueInConsole((eod >= hash ? 1 : 0) != 0, (String)("error in " + Casts.toJavaString((char.ptr)this.name) + " for #=" + hash + "; EOD=" + eod + "; if=" + ifOffset));
        }
        int blockState = ConditionValue == PPCallbacks.ConditionValueKind.CVK_True ? 1 : 0;
        int seenLiveState = ConditionValue == PPCallbacks.ConditionValueKind.CVK_True ? 2 : 3;
        this.pushBlockState(ifOffset, seenLiveState, blockState, eod);
    }

    void handleElif(int hash, int eod, int ifOffset, PPCallbacks.ConditionValueKind ConditionValue) {
        int IfLocMarker;
        int seenLiveState;
        int blockState;
        int prevEOD;
        boolean recoveredFromError = false;
        if (this.someBlocksWithState.empty()) {
            recoveredFromError = true;
        } else if (this.someBlocksWithState.$at(this.someBlocksWithState.size() - 4) != ifOffset) {
            recoveredFromError = true;
        } else if (hash > eod) {
            recoveredFromError = true;
        }
        if (recoveredFromError) {
            NativeTrace.assertTrueInConsole((boolean)false, (String)("error in " + Casts.toJavaString((char.ptr)this.name) + " for #=" + hash + "; EOD=" + eod + "; if=" + ifOffset));
        }
        if (!recoveredFromError) {
            prevEOD = this.someBlocksWithState.pop_back_val();
            blockState = this.someBlocksWithState.pop_back_val();
            seenLiveState = this.someBlocksWithState.pop_back_val();
            IfLocMarker = this.someBlocksWithState.pop_back_val();
        } else {
            prevEOD = ifOffset;
            blockState = 0;
            seenLiveState = 3;
            IfLocMarker = ifOffset;
        }
        assert (IfLocMarker == ifOffset) : IfLocMarker + " vs. " + ifOffset;
        assert (blockState == 1 || blockState == 0);
        assert (seenLiveState == 2 || seenLiveState == 3);
        this.finishPrevBlock(blockState, prevEOD, hash);
        if (ConditionValue == PPCallbacks.ConditionValueKind.CVK_True && seenLiveState == 3) {
            blockState = 1;
            seenLiveState = 2;
        } else {
            blockState = 0;
        }
        this.pushBlockState(ifOffset, seenLiveState, blockState, eod);
    }

    void handleElse(int hash, int eod, int ifOffset) {
        int IfLocMarker;
        int seenLiveState;
        int blockState;
        int prevEOD;
        boolean recoveredFromError = false;
        if (this.someBlocksWithState.empty()) {
            recoveredFromError = true;
        } else if (this.someBlocksWithState.$at(this.someBlocksWithState.size() - 4) != ifOffset) {
            recoveredFromError = true;
        } else if (hash > eod) {
            recoveredFromError = true;
        }
        if (recoveredFromError) {
            NativeTrace.assertTrueInConsole((boolean)false, (String)("error in " + Casts.toJavaString((char.ptr)this.name) + " for #=" + hash + "; EOD=" + eod + "; if=" + ifOffset));
        }
        if (!recoveredFromError) {
            prevEOD = this.someBlocksWithState.pop_back_val();
            blockState = this.someBlocksWithState.pop_back_val();
            seenLiveState = this.someBlocksWithState.pop_back_val();
            IfLocMarker = this.someBlocksWithState.pop_back_val();
        } else {
            prevEOD = ifOffset;
            blockState = 0;
            seenLiveState = 3;
            IfLocMarker = ifOffset;
        }
        assert (IfLocMarker == ifOffset) : IfLocMarker + " vs. " + ifOffset;
        assert (blockState == 1 || blockState == 0);
        assert (seenLiveState == 2 || seenLiveState == 3);
        this.finishPrevBlock(blockState, prevEOD, hash);
        if (seenLiveState == 2) {
            blockState = 0;
        } else {
            blockState = 1;
            seenLiveState = 2;
        }
        this.pushBlockState(ifOffset, seenLiveState, blockState, eod);
    }

    void handleEndif(int hash, int eod, int ifOffset) {
        boolean recoveredFromError = false;
        if (this.someBlocksWithState.empty()) {
            recoveredFromError = true;
        } else if (this.someBlocksWithState.$at(this.someBlocksWithState.size() - 4) != ifOffset) {
            recoveredFromError = true;
        } else if (hash > eod) {
            recoveredFromError = true;
        }
        if (recoveredFromError) {
            NativeTrace.assertTrueInConsole((boolean)false, (String)("error in " + Casts.toJavaString((char.ptr)this.name) + " for #=" + hash + "; EOD=" + eod + "; if=" + ifOffset));
        }
        if (!this.someBlocksWithState.empty()) {
            int prevEOD = this.someBlocksWithState.pop_back_val();
            int blockState = this.someBlocksWithState.pop_back_val();
            int seenLiveState = this.someBlocksWithState.pop_back_val();
            int IfLocMarker = this.someBlocksWithState.pop_back_val();
            assert (IfLocMarker == ifOffset) : IfLocMarker + " vs. " + ifOffset;
            assert (blockState == 1 || blockState == 0);
            assert (seenLiveState == 2 || seenLiveState == 3);
            this.finishPrevBlock(blockState, prevEOD, hash);
        }
    }

    void handleErrorDiagnostic(int hash, int eod) {
        assert (eod >= hash) : "incorrect offsets " + hash + " and " + eod;
        this.addBlockImpl(Integer.MAX_VALUE - hash, Integer.MAX_VALUE);
    }

    private void pushBlockState(int ifOffsetMarker, int seenLiveState, int blockState, int eod) {
        assert (blockState == 1 || blockState == 0);
        assert (seenLiveState == 2 || seenLiveState == 3);
        assert (ifOffsetMarker <= eod);
        this.someBlocksWithState.push_back(ifOffsetMarker);
        this.someBlocksWithState.push_back(seenLiveState);
        this.someBlocksWithState.push_back(blockState);
        this.someBlocksWithState.push_back(eod);
    }

    private void finishPrevBlock(int blockState, int prevEOD, int stopAtHash) {
        if (blockState == 0) {
            this.addBlockImpl(prevEOD, stopAtHash - 1);
        }
    }
}

