/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.java.source.ui.AsyncJavaSymbolDescriptor;
import org.netbeans.modules.java.source.ui.JavaTypeProvider;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.netbeans.spi.jumpto.symbol.SymbolProvider;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class JavaSymbolProvider
implements SymbolProvider {
    private static final Logger LOGGER = Logger.getLogger(JavaSymbolProvider.class.getName());
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";
    private static final String UNKNOWN = "<unknown>";
    private volatile boolean canceled;

    public String name() {
        return "java symbols";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(JavaTypeProvider.class, (String)"MSG_JavaSymbols");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeSymbolNames(SymbolProvider.Context context, final SymbolProvider.Result result) {
        try {
            Pair<NameMatcher, Boolean> restriction;
            boolean _caseSensitive;
            ClassIndex.NameKind _kind;
            SearchType st = context.getSearchType();
            String textToSearch = context.getText();
            boolean scanInProgress = SourceUtils.isScanInProgress();
            if (scanInProgress) {
                String warningKind = NbBundle.getMessage(JavaSymbolProvider.class, (String)"LBL_SymbolKind");
                String message = NbBundle.getMessage(JavaSymbolProvider.class, (String)"LBL_ScanInProgress_warning", (Object)warningKind);
                result.setMessage(message);
                result.pendingResult();
                Cache cache = Cache.get(textToSearch, st);
                if (cache != null) {
                    cache.populateResult(result);
                    return;
                }
            } else {
                Cache.clear();
            }
            final Cache cache = scanInProgress ? Cache.create(textToSearch, st) : null;
            String prefix = null;
            int dotIndex = textToSearch.lastIndexOf(46);
            if (dotIndex > 0 && dotIndex != textToSearch.length() - 1) {
                prefix = textToSearch.substring(0, dotIndex);
                textToSearch = textToSearch.substring(dotIndex + 1);
            }
            String textToHighLight = textToSearch;
            switch (st) {
                case PREFIX: {
                    _kind = ClassIndex.NameKind.PREFIX;
                    _caseSensitive = true;
                    break;
                }
                case REGEXP: {
                    _kind = ClassIndex.NameKind.REGEXP;
                    textToSearch = NameMatcherFactory.wildcardsToRegexp((String)JavaSymbolProvider.removeNonJavaChars(textToSearch), (boolean)true);
                    _caseSensitive = true;
                    break;
                }
                case CAMEL_CASE: {
                    _kind = ClassIndex.NameKind.CAMEL_CASE;
                    _caseSensitive = true;
                    break;
                }
                case CASE_INSENSITIVE_CAMEL_CASE: {
                    _kind = ClassIndex.NameKind.CAMEL_CASE_INSENSITIVE;
                    _caseSensitive = false;
                    break;
                }
                case EXACT_NAME: {
                    _kind = ClassIndex.NameKind.SIMPLE_NAME;
                    _caseSensitive = true;
                    break;
                }
                case CASE_INSENSITIVE_PREFIX: {
                    _kind = ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
                    _caseSensitive = false;
                    break;
                }
                case CASE_INSENSITIVE_EXACT_NAME: {
                    _kind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                    _caseSensitive = false;
                    break;
                }
                case CASE_INSENSITIVE_REGEXP: {
                    _kind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                    textToSearch = NameMatcherFactory.wildcardsToRegexp((String)JavaSymbolProvider.removeNonJavaChars(textToSearch), (boolean)true);
                    _caseSensitive = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            final String ident = textToSearch;
            final ClassIndex.NameKind kind = _kind;
            final boolean caseSensitive = _caseSensitive;
            if (prefix != null) {
                restriction = JavaSymbolProvider.compileName(prefix, caseSensitive);
                result.setHighlightText(textToHighLight);
            } else {
                restriction = null;
            }
            try {
                final ClassIndexManager manager = ClassIndexManager.getDefault();
                Collection roots = QuerySupport.findRoots((Project)null, Collections.singleton("classpath/source"), Collections.emptySet(), Collections.emptySet());
                final HashSet<URL> rootUrls = new HashSet<URL>();
                for (FileObject root : roots) {
                    if (this.canceled) {
                        return;
                    }
                    rootUrls.add(root.toURL());
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Querying following roots:");
                    for (URL url : rootUrls) {
                        LOGGER.log(Level.FINE, "  {0}", url);
                    }
                    LOGGER.log(Level.FINE, "-------------------------");
                }
                IndexManager.priorityAccess((IndexManager.Action)new IndexManager.Action<Void>(){

                    public Void run() throws IOException, InterruptedException {
                        for (URL url : rootUrls) {
                            ProjectInformation projectInfo;
                            if (JavaSymbolProvider.this.canceled) {
                                return null;
                            }
                            FileObject root = URLMapper.findFileObject((URL)url);
                            if (root == null) continue;
                            Project project = FileOwnerQuery.getOwner((FileObject)root);
                            ProjectInformation projectInformation = projectInfo = project == null ? null : (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
                            ClassIndexImpl impl = manager.getUsagesQuery(root.toURL(), true);
                            if (impl == null) continue;
                            HashMap r = new HashMap();
                            impl.getDeclaredElements(ident, kind, DocumentUtil.elementHandleConvertor(), r);
                            if (r.isEmpty()) continue;
                            for (Map.Entry p : r.entrySet()) {
                                ElementHandle owner = (ElementHandle)p.getKey();
                                for (String symbol : (Set)p.getValue()) {
                                    if (!JavaSymbolProvider.matchesRestrictions(owner.getQualifiedName(), symbol, (Pair<NameMatcher, Boolean>)restriction, caseSensitive)) continue;
                                    AsyncJavaSymbolDescriptor d = new AsyncJavaSymbolDescriptor(projectInfo, root, impl, (ElementHandle<TypeElement>)owner, symbol, caseSensitive);
                                    result.addResult((SymbolDescriptor)d);
                                    if (cache == null) continue;
                                    cache.offer(d);
                                }
                            }
                        }
                        return null;
                    }
                });
                return;
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                return;
            }
            catch (InterruptedException ie) {
                this.clearCancel();
                return;
            }
        }
        finally {
            this.clearCancel();
        }
    }

    private static boolean matchesRestrictions(@NonNull String fqn, @NonNull String ident, @NullAllowed Pair<NameMatcher, Boolean> restriction, boolean caseSensitive) {
        return JavaSymbolProvider.matchesRestrictionsImpl(fqn, ident, restriction, caseSensitive, false);
    }

    private static boolean matchesRestrictionsImpl(@NonNull String fqn, @NonNull String ident, @NullAllowed Pair<NameMatcher, Boolean> restriction, boolean caseSensitive, boolean enclosing) {
        if (restriction == null) {
            return true;
        }
        String simpleName = JavaSymbolProvider.getSimpleName(fqn);
        return ((NameMatcher)restriction.first()).accept((Boolean)restriction.second() != false ? fqn : simpleName) || !enclosing && (caseSensitive ? ident.equals(simpleName) : ident.equalsIgnoreCase(simpleName)) && JavaSymbolProvider.matchesRestrictionsImpl(JavaSymbolProvider.getOwner(fqn), ident, restriction, caseSensitive, true);
    }

    @NonNull
    private static String getSimpleName(@NonNull String fqn) {
        int index = fqn.lastIndexOf(46);
        return index < 0 ? fqn : fqn.substring(index + 1);
    }

    @NonNull
    private static String getOwner(@NonNull String fqn) {
        int index = fqn.lastIndexOf(46);
        return index < 0 ? "" : fqn.substring(0, index);
    }

    private static Pair<NameMatcher, Boolean> compileName(@NonNull String prefix, boolean caseSensitive) {
        boolean fqn;
        boolean bl = fqn = prefix.indexOf(46) > 0;
        SearchType searchType = JavaSymbolProvider.containsWildCard(prefix) ? (caseSensitive ? SearchType.REGEXP : SearchType.CASE_INSENSITIVE_REGEXP) : (caseSensitive ? SearchType.PREFIX : SearchType.CASE_INSENSITIVE_PREFIX);
        return Pair.of((Object)NameMatcherFactory.createNameMatcher((String)prefix, (SearchType)searchType), (Object)fqn);
    }

    private static boolean containsWildCard(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return true;
        }
        return false;
    }

    @NonNull
    static Pair<String, String> getDisplayName(@NonNull Element e, @NonNull Element enclosingElement) {
        String name;
        assert (e != null);
        String suffix = null;
        if (e.getKind() == ElementKind.METHOD || e.getKind() == ElementKind.CONSTRUCTOR) {
            name = (e.getKind() == ElementKind.CONSTRUCTOR ? enclosingElement.getSimpleName() : e.getSimpleName()).toString();
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            ExecutableElement ee = (ExecutableElement)e;
            List<? extends VariableElement> vl = ee.getParameters();
            Iterator<? extends VariableElement> it = vl.iterator();
            while (it.hasNext()) {
                VariableElement v = it.next();
                TypeMirror tm = v.asType();
                sb.append(JavaSymbolProvider.getTypeName(tm, false, true));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(')');
            suffix = sb.toString();
        } else {
            name = e.getSimpleName().toString();
        }
        return Pair.of((Object)name, suffix);
    }

    private static CharSequence getTypeName(TypeMirror type, boolean fqn, boolean varArg) {
        if (type == null) {
            return "";
        }
        return (CharSequence)new TypeNameVisitor(varArg).visit(type, fqn);
    }

    private static String removeNonJavaChars(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public void cancel() {
        this.canceled = true;
    }

    public void cleanup() {
        this.clearCancel();
        Cache.clear();
    }

    private void clearCancel() {
        this.canceled = false;
    }

    private static final class Cache {
        private static Cache instance;
        private final String text;
        private final SearchType type;
        private final Collection<SymbolDescriptor> descriptors;

        private Cache(@NonNull String text, @NonNull SearchType type) {
            this.text = text;
            this.type = type;
            this.descriptors = Collections.synchronizedSet(new HashSet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void populateResult(@NonNull SymbolProvider.Result result) {
            Collection<SymbolDescriptor> collection = this.descriptors;
            synchronized (collection) {
                for (SymbolDescriptor d : this.descriptors) {
                    result.addResult(d);
                }
            }
        }

        void offer(@NonNull AsyncJavaSymbolDescriptor d) {
            this.descriptors.add(d);
        }

        static void clear() {
            instance = null;
        }

        @CheckForNull
        static Cache get(@NonNull String text, @NonNull SearchType type) {
            Cache res = instance;
            if (!(res == null || res.text.equals(text) && res.type == type)) {
                instance = null;
                res = null;
            }
            return res;
        }

        @NonNull
        static Cache create(@NonNull String text, @NonNull SearchType type) {
            instance = new Cache(text, type);
            return instance;
        }
    }

    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;
        private boolean insideCapturedWildcard = false;

        private TypeNameVisitor(boolean varArg) {
            super(new StringBuilder());
            this.varArg = varArg;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror t, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(t);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
                Iterator<? extends TypeMirror> it = t.getTypeArguments().iterator();
                if (it.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (it.hasNext()) {
                        this.visit(it.next(), p);
                        if (!it.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(JavaSymbolProvider.UNKNOWN);
        }

        @Override
        public StringBuilder visitArray(ArrayType t, Boolean p) {
            boolean isVarArg = this.varArg;
            this.varArg = false;
            this.visit(t.getComponentType(), p);
            return ((StringBuilder)this.DEFAULT_VALUE).append(isVarArg ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable t, Boolean p) {
            String name;
            Element e = t.asElement();
            if (e != null && !JavaSymbolProvider.CAPTURED_WILDCARD.equals(name = e.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append(name);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            if (!this.insideCapturedWildcard) {
                this.insideCapturedWildcard = true;
                TypeMirror bound = t.getLowerBound();
                if (bound != null && bound.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                    this.visit(bound, p);
                } else {
                    bound = t.getUpperBound();
                    if (bound != null && bound.getKind() != TypeKind.NULL) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        if (bound.getKind() == TypeKind.TYPEVAR) {
                            bound = ((TypeVariable)bound).getLowerBound();
                        }
                        this.visit(bound, p);
                    }
                }
                this.insideCapturedWildcard = false;
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType t, Boolean p) {
            int len = ((StringBuilder)this.DEFAULT_VALUE).length();
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror bound = t.getSuperBound();
            if (bound == null) {
                bound = t.getExtendsBound();
                if (bound != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (bound.getKind() == TypeKind.WILDCARD) {
                        bound = ((WildcardType)bound).getSuperBound();
                    }
                    this.visit(bound, p);
                } else if (!(len != 0 || (bound = SourceUtils.getBound((WildcardType)t)) == null || bound.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)bound).asElement()).getQualifiedName().contentEquals("java.lang.Object"))) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    this.visit(bound, p);
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(bound, p);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }
}

