/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.ui.clone.CloneAction;
import org.netbeans.modules.mercurial.remote.ui.repository.HgURL;
import org.netbeans.modules.mercurial.remote.ui.wizards.CloneDestinationDirectoryWizardPanel;
import org.netbeans.modules.mercurial.remote.ui.wizards.ClonePathsWizardPanel;
import org.netbeans.modules.mercurial.remote.ui.wizards.CloneRepositoryWizardPanel;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;

public final class CloneWizardAction
extends CallableSystemAction
implements ChangeListener {
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private static CloneWizardAction instance;
    private WizardDescriptor wizardDescriptor;
    private CloneRepositoryWizardPanel cloneRepositoryWizardPanel;
    private CloneDestinationDirectoryWizardPanel cloneDestinationDirectoryWizardPanel;
    private ClonePathsWizardPanel clonePathsWizardPanel;
    private PanelsIterator wizardIterator;
    private String errorMessage;
    private VCSFileProxy root;

    public static synchronized CloneWizardAction getInstance() {
        if (instance == null) {
            instance = new CloneWizardAction();
        }
        return instance;
    }

    public void setRoot(VCSFileProxy root) {
        this.root = root;
    }

    public VCSFileProxy getRoot() {
        return this.root;
    }

    public void performAction() {
        this.performClone(false);
    }

    public VCSFileProxy performClone(boolean waitFinished) throws MissingResourceException {
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(CloneWizardAction.class, (String)"CTL_Clone"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean cancelled = this.wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        VCSFileProxy cloneFile = null;
        if (!cancelled) {
            String targetFolderPath = (String)this.wizardDescriptor.getProperty("directory");
            HgModuleConfig.getDefault(this.root).getPreferences().put("cloneDestinationStep.cloneDirectory", targetFolderPath);
            HgURL repository = (HgURL)this.wizardDescriptor.getProperty("repository");
            VCSFileProxy directory = VCSFileProxySupport.getResource((VCSFileProxy)this.root, (String)targetFolderPath);
            String cloneName = (String)this.wizardDescriptor.getProperty("cloneName");
            HgURL pullPath = (HgURL)this.wizardDescriptor.getProperty("defaultPullPath");
            HgURL pushPath = (HgURL)this.wizardDescriptor.getProperty("defaultPushPath");
            cloneFile = VCSFileProxy.createFileProxy((VCSFileProxy)directory, (String)cloneName);
            RequestProcessor.Task t = CloneAction.performClone(repository, cloneFile, true, null, pullPath, pushPath, HgModuleConfig.getDefault(this.root).getShowCloneCompleted());
            if (waitFinished) {
                t.waitFinished();
            }
        }
        return cloneFile;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.wizardIterator == null) {
            return;
        }
        WizardDescriptor.Panel step = this.wizardIterator.current();
        if (step == null) {
            return;
        }
        if (step == this.cloneRepositoryWizardPanel) {
            this.errorMessage = this.cloneRepositoryWizardPanel.getErrorMessage();
        } else if (step != this.clonePathsWizardPanel && step == this.cloneDestinationDirectoryWizardPanel) {
            this.errorMessage = this.cloneDestinationDirectoryWizardPanel.getErrorMessage();
        }
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.errorMessage);
        }
    }

    public String getName() {
        return "Start Sample Wizard";
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CloneWizardAction.class);
    }

    protected boolean asynchronous() {
        return false;
    }

    static /* synthetic */ WizardDescriptor.Panel[] access$402(CloneWizardAction x0, WizardDescriptor.Panel[] x1) {
        x0.panels = x1;
        return x1;
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator {
        PanelsIterator() {
        }

        protected WizardDescriptor.Panel[] initializePanels() {
            CloneWizardAction.this.root = CloneWizardAction.getInstance().getRoot();
            CloneWizardAction.this.cloneRepositoryWizardPanel = new CloneRepositoryWizardPanel(CloneWizardAction.this.root);
            CloneWizardAction.this.clonePathsWizardPanel = new ClonePathsWizardPanel(CloneWizardAction.this.root);
            CloneWizardAction.this.cloneDestinationDirectoryWizardPanel = new CloneDestinationDirectoryWizardPanel(CloneWizardAction.this.root);
            CloneWizardAction.access$402(CloneWizardAction.this, new WizardDescriptor.Panel[]{CloneWizardAction.this.cloneRepositoryWizardPanel, CloneWizardAction.this.clonePathsWizardPanel, CloneWizardAction.this.cloneDestinationDirectoryWizardPanel});
            for (int i = 0; i < CloneWizardAction.this.panels.length; ++i) {
                CloneWizardAction.this.panels[i].addChangeListener((ChangeListener)CloneWizardAction.this);
            }
            String[] steps = new String[CloneWizardAction.this.panels.length];
            for (int i = 0; i < CloneWizardAction.this.panels.length; ++i) {
                Component c = CloneWizardAction.this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return CloneWizardAction.this.panels;
        }
    }
}

