/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.projectimport.ImportExecutable;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.support.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.ui.wizard.IteratorExtension;
import org.netbeans.modules.cnd.makeproject.api.wizards.CommonUtilities;
import org.netbeans.modules.cnd.makeproject.api.wizards.DefaultMakeProjectLocationProvider;
import org.netbeans.modules.cnd.makeproject.api.wizards.ProjectGenerator;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateDependencies
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(ImportExecutable.class.getName(), 1);
    private final Project mainProject;
    private final List<String> dependencies;
    private List<String> paths;
    private final List<String> searchPaths;
    private final String binary;
    private final Map<Project, String> createdProjects = new HashMap<Project, String>();
    private MakeConfigurationDescriptor mainConfigurationDescriptor;
    private final CsmModel model = CsmModelAccessor.getModel();
    private final IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
    private final FileSystem sourceFileSystem;
    private static final List<CsmProgressListener> listeners = new ArrayList<CsmProgressListener>(1);

    public CreateDependencies(Project mainProject, FileSystem sourceFileSystem, List<String> dependencies, List<String> paths, List<String> searchPaths, String binary) {
        this.mainProject = mainProject;
        this.dependencies = dependencies;
        this.paths = paths;
        this.searchPaths = searchPaths;
        this.binary = binary;
        this.sourceFileSystem = sourceFileSystem;
    }

    /*
     * WARNING - void declaration
     */
    public void create() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.mainProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (!pdp.gotDescriptor()) {
            return;
        }
        this.mainConfigurationDescriptor = pdp.getConfigurationDescriptor();
        if (this.paths == null) {
            if (this.dependencies == null || this.dependencies.isEmpty()) {
                return;
            }
            HashSet checkedDll = new HashSet();
            checkedDll.add(this.binary);
            HashMap<String, String> dllPaths = new HashMap<String, String>();
            String root = ImportExecutable.findFolderPath(this.mainConfigurationDescriptor, ImportExecutable.getRoot(this.mainConfigurationDescriptor));
            if (root != null) {
                ArrayList<String> secondary;
                int search;
                void var9_16;
                MakeConfiguration activeConfiguration = this.mainConfigurationDescriptor.getActiveConfiguration();
                String string2 = CommonUtilities.getLdLibraryPath((MakeConfiguration)activeConfiguration);
                string2 = CommonUtilities.addSearchPaths((String)string2, this.searchPaths, (String)this.binary);
                for (String dll : this.dependencies) {
                    dllPaths.put(dll, ImportExecutable.findLocation(this.sourceFileSystem, dll, string2));
                }
                do {
                    FileObject fileObject;
                    secondary = new ArrayList<String>();
                    for (Map.Entry entry : dllPaths.entrySet()) {
                        if (entry.getValue() == null || checkedDll.contains(entry.getValue())) continue;
                        checkedDll.add(entry.getValue());
                        HashMap extMap = new HashMap();
                        DiscoveryDescriptor.BUILD_RESULT.toMap(extMap, entry.getValue());
                        DiscoveryDescriptor.RESOLVE_SYMBOLIC_LINKS.toMap(extMap, (Object)MakeProjectOptions.getResolveSymbolicLinks());
                        if (this.extension == null) continue;
                        this.extension.discoverArtifacts(extMap);
                        List dlls = (List)DiscoveryDescriptor.DEPENDENCIES.fromMap(extMap);
                        if (dlls == null) continue;
                        for (String so2 : dlls) {
                            if (dllPaths.containsKey(so2)) continue;
                            secondary.add(so2);
                        }
                    }
                    for (String string3 : secondary) {
                        dllPaths.put(string3, ImportExecutable.findLocation(this.sourceFileSystem, string3, string2));
                    }
                    search = 0;
                    for (Map.Entry entry : dllPaths.entrySet()) {
                        if (entry.getValue() != null) continue;
                        ++search;
                    }
                    if (search > 0 && root.length() > 1 && (fileObject = this.sourceFileSystem.findResource(root)) != null && fileObject.isValid()) {
                        ImportExecutable.gatherSubFolders(fileObject, new HashSet<String>(), dllPaths);
                    }
                    boolean bl = false;
                    for (Map.Entry entry : dllPaths.entrySet()) {
                        if (entry.getValue() != null) continue;
                        ++var9_16;
                    }
                } while (var9_16 != search || !secondary.isEmpty());
            }
            this.paths = new ArrayList<String>();
            for (Map.Entry entry : dllPaths.entrySet()) {
                if (entry.getValue() == null || !ImportExecutable.isMyDll((String)entry.getValue(), root)) continue;
                this.paths.add((String)entry.getValue());
            }
        }
        for (String entry : this.paths) {
            try {
                Project createProject = this.createProject(entry, "", "", "");
                this.createdProjects.put(createProject, entry);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (!this.createdProjects.isEmpty()) {
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            Project[] toOpen = new Project[this.createdProjects.size()];
            int i = 0;
            Iterator<Project> iterator = this.createdProjects.keySet().iterator();
            while (iterator.hasNext()) {
                Project p;
                toOpen[i] = p = iterator.next();
                ImportExecutable.switchModel(this.model, false, p);
                ++i;
            }
            OpenProjects.getDefault().open(toOpen, false);
        }
    }

    private static void updateRunProfile(String baseDir, RunProfile runProfile, String arguments, String dir, String envText) {
        runProfile.setArgs(arguments);
        String wd = dir;
        wd = CndPathUtilities.toRelativePath((String)baseDir, (String)wd);
        wd = CndPathUtilities.normalizeSlashes((String)wd);
        runProfile.setRunDirectory(wd);
        Env env = runProfile.getEnvironment();
        env.removeAll();
        env.decode(envText);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
            Project[] projects = (Project[])evt.getNewValue();
            if (projects.length == 0) {
                return;
            }
            for (Project aProject : projects) {
                if (!this.createdProjects.containsKey(aProject)) continue;
                this.addReqProject(aProject);
            }
            DiscoveryProjectGenerator.saveMakeConfigurationDescriptor(this.mainProject, null);
            for (Project aProject : projects) {
                void var7_7;
                if (!this.createdProjects.containsKey(aProject)) continue;
                String executable = this.createdProjects.get(aProject);
                this.createdProjects.remove(aProject);
                if (this.extension == null) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                DiscoveryDescriptor.BUILD_RESULT.toMap(map, (Object)var7_7);
                DiscoveryDescriptor.ROOT_FOLDER.toMap(map, (Object)aProject.getProjectDirectory().getPath());
                DiscoveryDescriptor.RESOLVE_SYMBOLIC_LINKS.toMap(map, (Object)MakeProjectOptions.getResolveSymbolicLinks());
                this.process((DiscoveryExtension)this.extension, aProject, map);
            }
            if (this.createdProjects.isEmpty()) {
                OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    private void addReqProject(Project lastSelectedProject) {
        ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)lastSelectedProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor configurationDescriptor = provider.getConfigurationDescriptor();
        this.mainConfigurationDescriptor.getActiveConfiguration().getRequiredProjectsConfiguration().add((Object)new LibraryItem.ProjectItem(new MakeArtifact(configurationDescriptor, configurationDescriptor.getActiveConfiguration())));
    }

    private void process(final DiscoveryExtension extension, final Project lastSelectedProject, final Map<String, Object> map) {
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportExecutable.class, (String)"ImportExecutable.Progress"));
                progress.start();
                try {
                    ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)lastSelectedProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
                    MakeConfigurationDescriptor configurationDescriptor = provider.getConfigurationDescriptor();
                    for (Folder folder : configurationDescriptor.getLogicalFolders().getFolders()) {
                        if (!"HeaderFiles".equals(folder.getName()) && !"ResourceFiles".equals(folder.getName())) continue;
                        configurationDescriptor.getLogicalFolders().removeFolderAction(folder);
                    }
                    DiscoveryExtensionInterface.Applicable applicable = extension.isApplicable(map, lastSelectedProject, false);
                    if (applicable.isApplicable()) {
                        ImportExecutable.resetCompilerSet(configurationDescriptor.getActiveConfiguration(), applicable);
                        configurationDescriptor.getActiveConfiguration().getCodeAssistanceConfiguration().getResolveSymbolicLinks().setValue(MakeProjectOptions.getResolveSymbolicLinks());
                        if (extension.canApply(map, lastSelectedProject, null)) {
                            try {
                                extension.apply(map, lastSelectedProject, null);
                                DiscoveryProjectGenerator.saveMakeConfigurationDescriptor(lastSelectedProject, null);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace(System.err);
                            }
                        }
                    }
                    CreateDependencies.this.onProjectParsingFinished(lastSelectedProject);
                }
                catch (Throwable ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    progress.finish();
                }
            }
        });
    }

    private void onProjectParsingFinished(final Project makeProject) {
        if (makeProject != null) {
            final NativeProject np = (NativeProject)makeProject.getLookup().lookup(NativeProject.class);
            CsmProgressAdapter listener = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject project) {
                    Object id = project.getPlatformProject();
                    if (id != null && id.equals(np)) {
                        CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                        listeners.remove((Object)this);
                        DiscoveryProjectGenerator.fixExcludedHeaderFiles(makeProject, ImportProject.logger);
                    }
                }
            };
            listeners.add((CsmProgressListener)listener);
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
            ImportExecutable.switchModel(this.model, true, makeProject);
        }
    }

    private Project createProject(String executablePath, String arguments, String dir, String envText) throws IOException {
        String projectParentFolder = DefaultMakeProjectLocationProvider.getDefault().getDefaultProjectFolder();
        String projectName = ProjectGenerator.getDefault().getValidProjectName(projectParentFolder, CndPathUtilities.getBaseName((String)executablePath));
        String baseDir = projectParentFolder + CndFileUtils.getFileSeparatorChar((FileSystem)this.sourceFileSystem) + projectName;
        MakeConfiguration conf = MakeConfiguration.createDefaultHostMakefileConfiguration((String)baseDir, (String)"Default");
        String wd = CndPathUtilities.getDirName((String)executablePath);
        wd = CndPathUtilities.toRelativePath((String)baseDir, (String)wd);
        wd = CndPathUtilities.normalizeSlashes((String)wd);
        conf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(wd);
        String exe = executablePath;
        exe = CndPathUtilities.toRelativePath((String)baseDir, (String)exe);
        exe = CndPathUtilities.normalizeSlashes((String)exe);
        conf.getMakefileConfiguration().getOutput().setValue(exe);
        CreateDependencies.updateRunProfile(baseDir, conf.getProfile(), arguments, dir, envText);
        FSPath projectFolder = new FSPath(this.sourceFileSystem, projectParentFolder + CndFileUtils.getFileSeparatorChar((FileSystem)this.sourceFileSystem) + projectName);
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(projectName, projectFolder);
        prjParams.setOpenFlag(false).setConfiguration(conf).setImportantFiles(Collections.singletonList(exe).iterator());
        Project project = ProjectGenerator.getDefault().createBlankProject(prjParams);
        return project;
    }
}

