/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.classview.ChildrenUpdater;
import org.netbeans.modules.cnd.classview.Diagnostic;
import org.netbeans.modules.cnd.classview.HostKeyArray;
import org.netbeans.modules.cnd.classview.NamespaceKeyArray;
import org.netbeans.modules.cnd.classview.SortedName;
import org.netbeans.modules.cnd.classview.model.CVUtil;
import org.netbeans.modules.cnd.classview.model.ProjectNode;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class ProjectsKeyArray
extends Children.Keys<CsmProject> {
    private Map<CsmProject, SortedName> myProjects;
    private ChildrenUpdater childrenUpdater;
    private static Comparator<Map.Entry<CsmProject, SortedName>> COMARATOR = new ProjectComparator();
    private final Object myProjectsLock = new Object();
    private final CsmProject libOwnerProject;
    private static final RequestProcessor RP = new RequestProcessor(ProjectsKeyArray.class.getName(), 1);

    public ProjectsKeyArray(CsmProject libOwnerProject, ChildrenUpdater childrenUpdater) {
        this.childrenUpdater = childrenUpdater;
        this.libOwnerProject = libOwnerProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetKeys() {
        CndUtils.assertFalse((boolean)Thread.holdsLock(this.myProjectsLock), (String)"resetKeys should never be caled under the lock");
        ArrayList<CsmProject> res = new ArrayList<CsmProject>();
        Object object = this.myProjectsLock;
        synchronized (object) {
            if (this.myProjects != null) {
                ArrayList<Map.Entry<CsmProject, SortedName>> list = new ArrayList<Map.Entry<CsmProject, SortedName>>(this.myProjects.entrySet());
                Collections.sort(list, COMARATOR);
                for (Map.Entry entry : list) {
                    CsmProject key = (CsmProject)entry.getKey();
                    res.add(key);
                }
            }
        }
        this.setKeys(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectLibsChanged(CsmProject owner) {
        if (owner == this.libOwnerProject) {
            Object object = this.myProjectsLock;
            synchronized (object) {
                if (this.myProjects == null) {
                    this.myProjects = this.createProjectsMap();
                } else {
                    this.myProjects.clear();
                }
                for (CsmProject p : owner.getLibraries()) {
                    this.myProjects.put(p, this.getSortedName(p, true));
                }
            }
            this.resetKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myProjectsLock;
        synchronized (object) {
            if (this.myProjects != null) {
                this.myProjects.clear();
            }
        }
        this.childrenUpdater = null;
        this.setKeys(new CsmProject[0]);
    }

    private Set<CsmProject> getProjects() {
        HashSet<CsmProject> projects = new HashSet<CsmProject>();
        if (this.libOwnerProject == null) {
            for (CsmProject p : CsmModelAccessor.getModel().projects()) {
                projects.add(p);
            }
        } else {
            for (CsmProject lib : this.libOwnerProject.getLibraries()) {
                projects.add(lib);
            }
        }
        return projects;
    }

    private SortedName getSortedName(CsmProject project, boolean isLibrary) {
        if (isLibrary) {
            return new IgnoreCaseSortedName(1, project.getName(), 0);
        }
        return new IgnoreCaseSortedName(0, project.getName(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myProjectsLock;
        synchronized (object) {
            return this.myProjects == null || this.myProjects.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openProject(CsmProject project) {
        if (project.isArtificial()) {
            if (this.libOwnerProject == null) {
                return;
            }
            if (!this.libOwnerProject.getLibraries().contains(project)) {
                return;
            }
        }
        Object object = this.myProjectsLock;
        synchronized (object) {
            if (this.myProjects == null) {
                return;
            }
            for (Map.Entry<CsmProject, SortedName> entry : this.myProjects.entrySet()) {
                if (!(entry.getKey() instanceof DummyProject)) continue;
                this.myProjects.clear();
                break;
            }
            if (this.myProjects.containsKey(project)) {
                return;
            }
            this.myProjects.put(project, this.getSortedName(project, false));
        }
        this.resetKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProject(CsmProject project) {
        Object object = this.myProjectsLock;
        synchronized (object) {
            if (this.myProjects == null || this.myProjects.isEmpty()) {
                return;
            }
            if (!this.myProjects.containsKey(project)) {
                return;
            }
            this.myProjects.remove(project);
            this.childrenUpdater.unregister(project);
            boolean removeAll = true;
            for (CsmProject p : this.myProjects.keySet()) {
                SortedName name = this.myProjects.get(p);
                if (name == null || name.getPrefix() != 0) continue;
                removeAll = false;
                break;
            }
            if (removeAll) {
                for (CsmProject p : this.myProjects.keySet()) {
                    this.childrenUpdater.unregister(p);
                }
                this.myProjects.clear();
            }
        }
        this.resetKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetProjects() {
        Object object = this.myProjectsLock;
        synchronized (object) {
            if (this.myProjects != null) {
                for (CsmProject p : this.myProjects.keySet()) {
                    this.childrenUpdater.unregister(p);
                }
            }
            this.myProjects = this.createProjectsMap();
            this.myProjects.put(new DummyProject(), new SortedName(0, "", 0));
        }
        this.resetKeys();
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set newProjects = ProjectsKeyArray.this.getProjects();
                Object object = ProjectsKeyArray.this.myProjectsLock;
                synchronized (object) {
                    if (ProjectsKeyArray.this.myProjects != null) {
                        for (CsmProject p : ProjectsKeyArray.this.myProjects.keySet()) {
                            if (newProjects.contains(p)) continue;
                            ProjectsKeyArray.this.childrenUpdater.unregister(p);
                        }
                    }
                    ProjectsKeyArray.this.myProjects = ProjectsKeyArray.this.createProjectsMap();
                    for (CsmProject p : newProjects) {
                        if (!p.isValid()) continue;
                        ProjectsKeyArray.this.myProjects.put(p, ProjectsKeyArray.this.getSortedName(p, false));
                    }
                }
                ProjectsKeyArray.this.resetKeys();
            }
        });
    }

    private Map<CsmProject, SortedName> createProjectsMap() {
        return new ConcurrentHashMap<CsmProject, SortedName>();
    }

    protected Node[] createNodes(CsmProject project) {
        Object node = null;
        try {
            node = project instanceof DummyProject ? CVUtil.createLoadingNode() : new ProjectNode(project, (Children.Array)new NamespaceKeyArray(this.childrenUpdater, project));
        }
        catch (AssertionError ex) {
            ((Throwable)((Object)ex)).printStackTrace(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        if (node != null) {
            return new Node[]{node};
        }
        return new Node[0];
    }

    protected void destroyNodes(Node[] node) {
        for (Node n : node) {
            Children children = n.getChildren();
            if (!(children instanceof HostKeyArray)) continue;
            ((HostKeyArray)children).dispose();
        }
        super.destroyNodes(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureAddNotify() {
        boolean nullProjects;
        Object object = this.myProjectsLock;
        synchronized (object) {
            nullProjects = this.myProjects == null;
        }
        if (nullProjects) {
            this.addNotify();
        }
    }

    protected void addNotify() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesP: addNotify()");
        }
        this.resetProjects();
        super.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        super.removeNotify();
        Object object = this.myProjectsLock;
        synchronized (object) {
            if (this.myProjects != null) {
                this.myProjects.clear();
            }
            this.myProjects = null;
        }
        this.resetKeys();
    }

    private static final class DummyProject
    implements CsmProject {
        private DummyProject() {
        }

        public CsmNamespace getGlobalNamespace() {
            throw new UnsupportedOperationException();
        }

        public void waitParse() {
            throw new UnsupportedOperationException();
        }

        public Object getPlatformProject() {
            throw new UnsupportedOperationException();
        }

        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        public FileSystem getFileSystem() {
            throw new UnsupportedOperationException();
        }

        public String getHtmlDisplayName() {
            throw new UnsupportedOperationException();
        }

        public CsmNamespace findNamespace(CharSequence qualifiedName) {
            throw new UnsupportedOperationException();
        }

        public CsmClassifier findClassifier(CharSequence qualifiedName) {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmClassifier> findClassifiers(CharSequence qualifiedName) {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmInheritance> findInheritances(CharSequence name) {
            throw new UnsupportedOperationException();
        }

        public CsmDeclaration findDeclaration(CharSequence uniqueName) {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence uniqueName) {
            throw new UnsupportedOperationException();
        }

        public CsmFile findFile(Object absolutePathOrNativeFileItem, boolean createIfPossible, boolean snapShot) {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmFile> getSourceFiles() {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmFile> getHeaderFiles() {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmFile> getAllFiles() {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmProject> getLibraries() {
            throw new UnsupportedOperationException();
        }

        public boolean isStable(CsmFile skipFile) {
            throw new UnsupportedOperationException();
        }

        public boolean isArtificial() {
            return false;
        }

        public CharSequence getName() {
            throw new UnsupportedOperationException();
        }

        public boolean isValid() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ProjectComparator
    implements Comparator<Map.Entry<CsmProject, SortedName>>,
    Serializable {
        private ProjectComparator() {
        }

        @Override
        public int compare(Map.Entry<CsmProject, SortedName> o1, Map.Entry<CsmProject, SortedName> o2) {
            if (o1.getKey().isArtificial() != o2.getKey().isArtificial()) {
                return o1.getKey().isArtificial() ? 1 : -1;
            }
            return o1.getValue().compareTo(o2.getValue());
        }
    }

    private static class IgnoreCaseSortedName
    extends SortedName {
        public IgnoreCaseSortedName(int prefix, CharSequence name, int suffix) {
            super(prefix, name, suffix);
        }

        @Override
        protected Comparator<CharSequence> getCharSequenceComparator() {
            return CharSequenceUtils.ComparatorIgnoreCase;
        }
    }
}

