/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spellchecker.bindings;

import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.cnd.api.script.BatTokenId;
import org.netbeans.modules.cnd.api.script.CMakeTokenId;
import org.netbeans.modules.cnd.api.script.MakefileTokenId;
import org.netbeans.modules.cnd.api.script.ShTokenId;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ScriptAndMakeTokenList
implements TokenList {
    private Document doc;
    private boolean hidden = false;
    private int currentBlockStart;
    private int nextBlockStart;
    private String currentBlockText;
    private int currentOffsetInComment;
    private int currentWordOffset;
    private CharSequence currentWord;
    private int startOffset;

    public ScriptAndMakeTokenList(Document doc) {
        this.doc = doc;
    }

    public void setStartOffset(int offset) {
        this.currentBlockText = null;
        this.currentOffsetInComment = -1;
        this.startOffset = offset;
        this.nextBlockStart = offset;
        FileObject fileObject = FileUtil.getConfigFile((String)"Spellcheckers/ScriptComments");
        Boolean b = (Boolean)fileObject.getAttribute("Hidden");
        this.hidden = Boolean.TRUE.equals(b);
    }

    public int getCurrentWordStartOffset() {
        return this.currentWordOffset;
    }

    public CharSequence getCurrentWordText() {
        return this.currentWord;
    }

    public boolean nextWord() {
        if (this.hidden) {
            return false;
        }
        boolean hasNext = this.nextWordImpl();
        while (hasNext && this.currentWordOffset + this.currentWord.length() < this.startOffset) {
            hasNext = this.nextWordImpl();
        }
        return hasNext;
    }

    private int[] findNextComment() throws BadLocationException {
        TokenHierarchy h = TokenHierarchy.get((Document)this.doc);
        TokenSequence ts = h.tokenSequence(MakefileTokenId.language());
        if (ts == null) {
            ts = h.tokenSequence(BatTokenId.language());
        }
        if (ts == null) {
            ts = h.tokenSequence(ShTokenId.language());
        }
        if (ts == null) {
            ts = h.tokenSequence(CMakeTokenId.languageMake());
        }
        if (ts == null) {
            ts = h.tokenSequence(CMakeTokenId.languageInc());
        }
        if (ts == null) {
            return new int[]{-1, -1};
        }
        int diff = ts.move(this.nextBlockStart);
        while (ts.moveNext()) {
            TokenId id = ts.token().id();
            if (!"comment".equals(id.primaryCategory())) continue;
            return new int[]{ts.offset(), ts.offset() + ts.token().length()};
        }
        return new int[]{-1, -1};
    }

    private boolean nextWordImpl() {
        try {
            while (true) {
                if (this.currentBlockText == null) {
                    int[] span = this.findNextComment();
                    if (span[0] == -1) {
                        return false;
                    }
                    this.currentBlockStart = span[0];
                    this.currentBlockText = this.doc.getText(span[0], span[1] - span[0]);
                    this.currentOffsetInComment = 0;
                    this.nextBlockStart = span[1];
                }
                String pairTag = null;
                Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment);
                while (data != null) {
                    this.currentOffsetInComment = (Integer)((Pair)data).b + ((CharSequence)((Pair)data).a).length();
                    if (pairTag == null) {
                        if (Character.isLetter(((CharSequence)((Pair)data).a).charAt(0)) && !ScriptAndMakeTokenList.isIdentifierLike((CharSequence)((Pair)data).a)) {
                            this.currentWordOffset = this.currentBlockStart + (Integer)((Pair)data).b;
                            this.currentWord = (CharSequence)((Pair)data).a;
                            return true;
                        }
                        switch (((CharSequence)((Pair)data).a).charAt(0)) {
                            case '{': {
                                pairTag = "}";
                            }
                        }
                    } else if (pairTag.contentEquals((CharSequence)((Pair)data).a)) {
                        pairTag = null;
                    }
                    data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment);
                }
                this.currentBlockText = null;
            }
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    static boolean isIdentifierLike(CharSequence s) {
        boolean hasCapitalsInside = false;
        for (int offset = 1; offset < s.length() && !hasCapitalsInside; hasCapitalsInside |= Character.isUpperCase(s.charAt(offset)), ++offset) {
        }
        return hasCapitalsInside;
    }

    private boolean isLetter(char c) {
        return Character.isLetter(c) || c == '\'';
    }

    private Pair<CharSequence, Integer> wordBroker(CharSequence start, int offset) {
        State state = State.INIT;
        int offsetStart = offset;
        while (start.length() > offset) {
            char current = start.charAt(offset);
            switch (state) {
                case INIT: {
                    if (this.isLetter(current)) {
                        state = State.AFTER_LETTER;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '<') {
                        state = State.AFTER_LESS;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '\n' || current == '}') {
                        return new Pair<CharSequence, Integer>(start.subSequence(offset, offset + 1), offset);
                    }
                    if (current != '{') break;
                    state = State.AFTER_LCURLY;
                    offsetStart = offset;
                    break;
                }
                case AFTER_LETTER: {
                    if (this.isLetter(current)) break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
                }
                case AFTER_LESS: {
                    if (current != '>') break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset + 1), offsetStart);
                }
                case AFTER_LCURLY: {
                    --offset;
                    state = State.INIT;
                }
            }
            ++offset;
        }
        if (offset > offsetStart) {
            return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static class Pair<A, B> {
        private final A a;
        private final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    private static enum State {
        INIT,
        AFTER_LETTER,
        AFTER_LESS,
        AFTER_LCURLY;

    }
}

