/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;

public class WebSocketExtension {
    private final String name;
    private final Map<String, String> parameters;

    public WebSocketExtension(String name) {
        this(name, null);
    }

    public WebSocketExtension(String name, Map<String, String> parameters) {
        Assert.hasLength((String)name, (String)"extension name must not be empty");
        this.name = name;
        if (!CollectionUtils.isEmpty(parameters)) {
            LinkedCaseInsensitiveMap m = new LinkedCaseInsensitiveMap(parameters.size(), Locale.ENGLISH);
            m.putAll(parameters);
            this.parameters = Collections.unmodifiableMap(m);
        } else {
            this.parameters = Collections.emptyMap();
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public static List<WebSocketExtension> parseExtensions(String extensions) {
        if (extensions == null || !StringUtils.hasText((String)extensions)) {
            return Collections.emptyList();
        }
        ArrayList<WebSocketExtension> result = new ArrayList<WebSocketExtension>();
        for (String token : extensions.split(",")) {
            result.add(WebSocketExtension.parseExtension(token));
        }
        return result;
    }

    private static WebSocketExtension parseExtension(String extension) {
        Assert.doesNotContain((String)extension, (String)",", (String)("Expected a single extension value: " + extension));
        String[] parts = StringUtils.tokenizeToStringArray((String)extension, (String)";");
        String name = parts[0].trim();
        LinkedHashMap<String, String> parameters = null;
        if (parts.length > 1) {
            parameters = new LinkedHashMap<String, String>(parts.length - 1);
            for (int i = 1; i < parts.length; ++i) {
                String parameter = parts[i];
                int eqIndex = parameter.indexOf(61);
                if (eqIndex == -1) continue;
                String attribute = parameter.substring(0, eqIndex);
                String value = parameter.substring(eqIndex + 1, parameter.length());
                parameters.put(attribute, value);
            }
        }
        return new WebSocketExtension(name, parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketExtension that = (WebSocketExtension)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.name);
        for (String param : this.parameters.keySet()) {
            str.append(';');
            str.append(param);
            str.append('=');
            str.append(this.parameters.get(param));
        }
        return str.toString();
    }
}

