/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.io.IOException;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.netbeans.modules.db.sql.loader.SQLNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;

public class SQLDataObject
extends MultiDataObject {
    public SQLDataObject(FileObject primaryFile, MultiFileLoader loader) throws DataObjectExistsException {
        super(primaryFile, loader);
        CookieSet cookies = this.getCookieSet();
        final SQLEditorSupport sqlEditorSupport = new SQLEditorSupport(this);
        cookies.add((Node.Cookie)sqlEditorSupport);
        cookies.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                sqlEditorSupport.saveAs(folder, fileName);
            }
        }});
    }

    protected Node createNodeDelegate() {
        return new SQLNode(this, this.getLookup());
    }

    public boolean isConsole() {
        try {
            return "nbfs".equals(this.getPrimaryFile().getURL().getProtocol()) && !this.isTemplate();
        }
        catch (FileStateInvalidException e) {
            return false;
        }
    }

    void addCookie(Node.Cookie cookie) {
        this.getCookieSet().add(cookie);
    }

    void removeCookie(Node.Cookie cookie) {
        this.getCookieSet().remove(cookie);
    }

    protected int associateLookup() {
        return 1;
    }
}

