/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.j2ee;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.weblogic9.j2ee.Bundle;
import org.netbeans.modules.j2ee.weblogic9.j2ee.JaxRsStackSupportImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JerseyLibraryHelper {
    private static final String LIBRARY_PROVIDER_TYPE = "j2se";
    private static final String LIBRARY_TYPE = "wl_jersey";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    static Library getJerseyLibrary(Version serverVersion, FileObject modulesFolder) {
        if (serverVersion == null) {
            return null;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            LibraryHandler handler = new LibraryHandler();
            InputStream is = JaxRsStackSupportImpl.class.getClassLoader().getResourceAsStream("org/netbeans/modules/j2ee/weblogic9/resources/netbeans-jersey.xml");
            try {
                parser.parse(is, (DefaultHandler)handler);
                Server serverToUse = null;
                for (Server server : handler.getServers()) {
                    if (!serverVersion.isAboveOrEqual(server.getVersion()) || serverToUse != null && !serverToUse.getVersion().isBelowOrEqual(server.getVersion())) continue;
                    serverToUse = server;
                }
                if (serverToUse == null) return null;
                Library lib = LibraryManager.getDefault().getLibrary("wl_jersey_" + serverToUse.getVersion());
                if (lib != null) {
                    Server server;
                    server = lib;
                    return server;
                }
                StringBuilder mavenDeps = new StringBuilder();
                ArrayList<URL> cp = new ArrayList<URL>();
                for (ServerJar jar : serverToUse.getServerJars()) {
                    FileObject fo = JerseyLibraryHelper.getJarFile(modulesFolder, jar.getFilename());
                    if (fo != null) {
                        cp.add(URLMapper.findURL((FileObject)fo, (int)1));
                    }
                    mavenDeps.append(jar.getGroupId()).append(':').append(jar.getArtifactId()).append(':').append(jar.getVersion()).append(":jar");
                    mavenDeps.append(' ');
                }
                if (mavenDeps.length() > 0) {
                    mavenDeps.setLength(mavenDeps.length() - 1);
                }
                HashMap<String, ArrayList<URL>> contents = new HashMap<String, ArrayList<URL>>(1);
                contents.put("classpath", cp);
                HashMap<String, String> properties = new HashMap<String, String>(2);
                properties.put("maven-dependencies", mavenDeps.toString());
                properties.put("maven-repositories", "default");
                Library library = lib = LibraryManager.getDefault().createLibrary(LIBRARY_PROVIDER_TYPE, "wl_jersey_" + serverToUse.getVersion(), Bundle.library_displayName(serverToUse.getVersion()), null, contents, properties);
                return library;
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JerseyLibraryHelper.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
        catch (SAXException ex) {
            Logger.getLogger(JerseyLibraryHelper.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(JerseyLibraryHelper.class.getName()).log(Level.WARNING, null, ex);
        }
        return null;
    }

    private static FileObject getJarFile(FileObject modulesFolder, String jarName) {
        FileObject[] children;
        if (modulesFolder == null) {
            return null;
        }
        for (FileObject child : children = modulesFolder.getChildren()) {
            if (!child.getNameExt().equals(jarName)) continue;
            return child;
        }
        return null;
    }

    private static class ServerJar {
        private final String filename;
        private final String groupId;
        private final String artifactId;
        private final String version;

        public ServerJar(String filename, String groupId, String artifactId, String version) {
            this.filename = filename;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "ServerJar{filename=" + this.filename + ", groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + '}';
        }
    }

    private static class Server {
        private final Version version;
        private final List<ServerJar> serverJars;

        public Server(Version version, List<ServerJar> serverJars) {
            this.version = version;
            this.serverJars = serverJars;
        }

        public Version getVersion() {
            return this.version;
        }

        public List<ServerJar> getServerJars() {
            return this.serverJars;
        }
    }

    private static class LibraryHandler
    extends DefaultHandler {
        private final List<Server> servers = new ArrayList<Server>();
        private Version version;
        private List<ServerJar> serverJars;
        private boolean isServer;

        private LibraryHandler() {
        }

        public List<Server> getServers() {
            if (this.servers != null) {
                return this.servers;
            }
            return Collections.emptyList();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("server".equals(qName)) {
                this.isServer = true;
                this.version = Version.fromDottedNotationWithFallback((String)attributes.getValue("version"));
                this.serverJars = new ArrayList<ServerJar>();
            } else if ("jar".equals(qName)) {
                String filename = attributes.getValue("name");
                String groupId = attributes.getValue("groupId");
                String artifactId = attributes.getValue("artifactId");
                String jarVersion = attributes.getValue("version");
                this.serverJars.add(new ServerJar(filename, groupId, artifactId, jarVersion));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.isServer && "server".equals(qName)) {
                this.servers.add(new Server(this.version, this.serverJars));
                this.isServer = false;
                this.serverJars = null;
            }
        }
    }
}

