/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Image;
import java.util.Iterator;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

class AnnotatedNode
extends AbstractNode
implements Runnable,
FileStatusListener {
    private Set<FileObject> files;
    private RequestProcessor.Task task;
    private final RequestProcessor rp;
    private volatile boolean iconChange;
    private volatile boolean nameChange;
    private boolean forceAnnotation;
    private FileStatusListener fsl = null;
    private FileSystem fs = null;

    protected AnnotatedNode(Children children, Lookup lookup, RequestProcessor rp) {
        super(children, lookup);
        assert (rp != null);
        this.rp = rp;
    }

    protected final void setFiles(Set<FileObject> files) {
        if (this.fs != null && this.fsl != null) {
            this.fs.removeFileStatusListener(this.fsl);
        }
        this.files = files;
        if (files == null) {
            return;
        }
        if (files.isEmpty()) {
            return;
        }
        FileObject fo = files.iterator().next();
        if (fo == null) {
            return;
        }
        try {
            this.fs = fo.getFileSystem();
            this.fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)this.fs);
            this.fs.addFileStatusListener(this.fsl);
        }
        catch (FileStateInvalidException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate((Throwable)e, "Cannot get " + fo + " filesystem, ignoring...");
            err.notify(1, (Throwable)e);
        }
    }

    protected final Set<FileObject> getFiles() {
        return this.files;
    }

    protected void setForceAnnotation(boolean forceAnnotation) {
        this.forceAnnotation = forceAnnotation;
    }

    protected final Image annotateIcon(Image img, int type) {
        Image annotatedImg = img;
        if (this.files != null && !this.files.isEmpty()) {
            Iterator<FileObject> it = this.files.iterator();
            try {
                FileObject fo = it.next();
                if (fo.isValid()) {
                    annotatedImg = FileUIUtils.getImageDecorator((FileSystem)fo.getFileSystem()).annotateIcon(img, type, this.files);
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return annotatedImg;
    }

    protected final String annotateName(String name) {
        String annotatedName = name;
        if (this.files != null && !this.files.isEmpty()) {
            Iterator<FileObject> it = this.files.iterator();
            try {
                FileObject fo = it.next();
                if (fo.isValid()) {
                    annotatedName = fo.getFileSystem().getDecorator().annotateName(name, this.files);
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return annotatedName;
    }

    public final void annotationChanged(FileStatusEvent event) {
        if (this.files == null) {
            return;
        }
        boolean changed = false;
        if (this.forceAnnotation || !this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
            for (FileObject fo : this.files) {
                if (!event.hasChanged(fo)) continue;
                this.iconChange |= event.isIconChange();
                this.nameChange |= event.isNameChange();
                changed = true;
            }
        }
        if (changed) {
            if (this.task == null) {
                this.task = this.rp.create((Runnable)this);
            }
            this.task.schedule(50);
        }
    }

    @Override
    public final void run() {
        if (this.forceAnnotation || this.iconChange) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.iconChange = false;
        }
        if (this.forceAnnotation || this.nameChange) {
            this.fireDisplayNameChange(null, null);
            this.nameChange = false;
        }
    }
}

