/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.util.ArrayList;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.ui.configurations.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.customizer.BasicCompilerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.SharedItemConfiguration;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class FortranCompilerCustomizerNode
extends CustomizerNode {
    public FortranCompilerCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
        super(name, displayName, children, lookup);
    }

    @Override
    public Sheet[] getSheets(Configuration configuration) {
        if (((MakeConfiguration)configuration).isCompileConfiguration()) {
            switch (this.getContext().getKind()) {
                case Item: {
                    SharedItemConfiguration[] sharedConfigurations = this.getContext().getItems();
                    ArrayList<Sheet> out = new ArrayList<Sheet>();
                    for (SharedItemConfiguration cfg : sharedConfigurations) {
                        ItemConfiguration itemConfiguration = cfg.getItemConfiguration(configuration);
                        if (itemConfiguration == null) continue;
                        out.add(this.getGeneralSheet((MakeConfiguration)configuration, itemConfiguration.getFortranCompilerConfiguration()));
                    }
                    return out.isEmpty() ? null : out.toArray(new Sheet[out.size()]);
                }
                case Project: {
                    Sheet generalSheet = this.getGeneralSheet((MakeConfiguration)configuration, ((MakeConfiguration)configuration).getFortranCompilerConfiguration());
                    return new Sheet[]{generalSheet};
                }
            }
        }
        return null;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("ProjectPropsCompiling");
    }

    private static String getString(String s) {
        return NbBundle.getMessage(FortranCompilerCustomizerNode.class, (String)s);
    }

    private Sheet getGeneralSheet(MakeConfiguration conf, FortranCompilerConfiguration cconf) {
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        AbstractCompiler fortranCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.FortranCompiler);
        sheet.put(BasicCompilerCustomizerNode.getBasicSet((BasicCompilerConfiguration)cconf));
        if (cconf.getMaster() != null) {
            sheet.put(BasicCompilerCustomizerNode.getInputSet((BasicCompilerConfiguration)cconf));
        }
        if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler()) {
            Sheet.Set set2 = new Sheet.Set();
            set2.setName("OtherOptions");
            set2.setDisplayName(FortranCompilerCustomizerNode.getString("OtherOptionsTxt"));
            set2.setShortDescription(FortranCompilerCustomizerNode.getString("OtherOptionsHint"));
            set2.put((Node.Property)new IntNodeProp(cconf.getMTLevel(), cconf.getMaster() == null, "MultithreadingLevel", FortranCompilerCustomizerNode.getString("MultithreadingLevelTxt"), FortranCompilerCustomizerNode.getString("MultithreadingLevelHint")));
            sheet.put(set2);
        }
        Sheet.Set set4 = new Sheet.Set();
        set4.setName("Tool");
        set4.setDisplayName(FortranCompilerCustomizerNode.getString("ToolTxt1"));
        set4.setShortDescription(FortranCompilerCustomizerNode.getString("ToolHint1"));
        if (fortranCompiler != null) {
            set4.put((Node.Property)new StringNodeProp(cconf.getTool(), fortranCompiler.getName(), false, "Tool", FortranCompilerCustomizerNode.getString("ToolTxt2"), FortranCompilerCustomizerNode.getString("ToolHint2")));
        }
        sheet.put(set4);
        String[] texts = new String[]{FortranCompilerCustomizerNode.getString("AdditionalOptionsTxt1"), FortranCompilerCustomizerNode.getString("AdditionalOptionsHint"), FortranCompilerCustomizerNode.getString("AdditionalOptionsTxt2"), FortranCompilerCustomizerNode.getString("AllOptionsTxt")};
        Sheet.Set set2 = new Sheet.Set();
        set2.setName("CommandLine");
        set2.setDisplayName(FortranCompilerCustomizerNode.getString("CommandLineTxt"));
        set2.setShortDescription(FortranCompilerCustomizerNode.getString("CommandLineHint"));
        if (fortranCompiler != null) {
            set2.put((Node.Property)new OptionsNodeProp(cconf.getCommandLineConfiguration(), null, (AllOptionsProvider)cconf, fortranCompiler, null, texts));
        }
        sheet.put(set2);
        return sheet;
    }
}

