/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jsdoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.jsdoc.JsDocComment;
import org.netbeans.modules.javascript2.jsdoc.JsDocCommentType;
import org.netbeans.modules.javascript2.jsdoc.model.DescriptionElement;
import org.netbeans.modules.javascript2.jsdoc.model.JsDocElement;
import org.netbeans.modules.javascript2.jsdoc.model.JsDocElementType;
import org.netbeans.modules.javascript2.jsdoc.model.JsDocElementUtils;
import org.netbeans.modules.javascript2.lexer.api.JsDocumentationTokenId;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.parsing.api.Snapshot;

public class JsDocParser {
    private static final Logger LOGGER = Logger.getLogger(JsDocParser.class.getName());

    public static Map<Integer, JsDocComment> parse(Snapshot snapshot) {
        HashMap<Integer, JsDocComment> blocks = new HashMap<Integer, JsDocComment>();
        if (snapshot == null || snapshot.getTokenHierarchy() == null) {
            return blocks;
        }
        TokenSequence tokenSequence = snapshot.getTokenHierarchy().tokenSequence(JsTokenId.javascriptLanguage());
        if (tokenSequence == null) {
            return blocks;
        }
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() != JsTokenId.DOC_COMMENT) continue;
            JsDocCommentType commentType = JsDocParser.getCommentType(tokenSequence.token().text());
            LOGGER.log(Level.FINEST, "JsDocParser:comment block offset=[{0}-{1}],type={2},text={3}", new Object[]{tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length(), commentType, tokenSequence.token().text()});
            OffsetRange offsetRange = new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length());
            if (commentType == JsDocCommentType.DOC_NO_CODE_START || commentType == JsDocCommentType.DOC_NO_CODE_END || commentType == JsDocCommentType.DOC_SHARED_TAG_END) {
                blocks.put(offsetRange.getEnd(), new JsDocComment(offsetRange, commentType, Collections.emptyList()));
                continue;
            }
            blocks.put(offsetRange.getEnd(), JsDocParser.parseCommentBlock(tokenSequence, offsetRange, commentType));
        }
        return blocks;
    }

    private static boolean isTextToken(Token<? extends JsDocumentationTokenId> token) {
        return token.id() != JsDocumentationTokenId.ASTERISK && token.id() != JsDocumentationTokenId.COMMENT_DOC_START;
    }

    private static TokenSequence getEmbeddedJsDocTS(TokenSequence ts) {
        return ts.embedded(JsDocumentationTokenId.language());
    }

    private static JsDocComment parseCommentBlock(TokenSequence ts, OffsetRange range, JsDocCommentType commentType) {
        TokenSequence ets = JsDocParser.getEmbeddedJsDocTS(ts);
        ArrayList<JsDocElement> jsDocElements = new ArrayList<JsDocElement>();
        JsDocElementType type = null;
        boolean afterDescription = false;
        StringBuilder sb = new StringBuilder();
        int offset = ts.offset();
        while (ets.moveNext()) {
            Token token = ets.token();
            if (!JsDocParser.isTextToken((Token<? extends JsDocumentationTokenId>)token)) {
                String afterText;
                String currentText;
                int curlyOpen;
                boolean isAsterixType = false;
                if (token.id() == JsDocumentationTokenId.ASTERISK && (curlyOpen = (currentText = sb.toString()).lastIndexOf(123)) > -1 && (afterText = currentText.substring(curlyOpen + 1)).trim().isEmpty() && afterText.indexOf(10) == -1) {
                    isAsterixType = true;
                }
                if (!isAsterixType) continue;
            }
            CharSequence text = token.text();
            JsDocElementType elementType = JsDocParser.getJsDocKeywordType(new StringBuilder(text.length()).append(text).toString());
            if (token.id() == JsDocumentationTokenId.KEYWORD && elementType != JsDocElementType.UNKNOWN && elementType != JsDocElementType.LINK || token.id() == JsDocumentationTokenId.COMMENT_END) {
                if (sb.toString().trim().isEmpty()) {
                    if (type != null) {
                        jsDocElements.add(JsDocElementUtils.createElementForType(type, "", -1));
                    }
                } else {
                    if (!afterDescription) {
                        jsDocElements.add(DescriptionElement.create(JsDocElementType.CONTEXT_SENSITIVE, sb.toString().trim()));
                    } else {
                        jsDocElements.add(JsDocElementUtils.createElementForType(type, sb.toString().trim(), offset));
                    }
                    sb = new StringBuilder();
                }
                while (ets.moveNext() && ets.token().id() == JsDocumentationTokenId.WHITESPACE) {
                }
                offset = ets.offset();
                if (token.id() != JsDocumentationTokenId.COMMENT_END) {
                    ets.movePrevious();
                }
                afterDescription = true;
                text = token.text();
                type = JsDocElementType.fromString(new StringBuilder(text.length()).append(text).toString());
                continue;
            }
            sb.append(token.text());
        }
        return new JsDocComment(range, commentType, jsDocElements);
    }

    private static JsDocCommentType getCommentType(CharSequence text) {
        if (JsDocParser.startsWith(text, "/**#")) {
            if (JsDocParser.textEquals(text, "/**#nocode+*/")) {
                return JsDocCommentType.DOC_NO_CODE_START;
            }
            if (JsDocParser.textEquals(text, "/**#nocode-*/")) {
                return JsDocCommentType.DOC_NO_CODE_END;
            }
            if (JsDocParser.startsWith(text, "/**#@+")) {
                return JsDocCommentType.DOC_SHARED_TAG_START;
            }
            if (JsDocParser.textEquals(text, "/**#@-*/")) {
                return JsDocCommentType.DOC_SHARED_TAG_END;
            }
        }
        return JsDocCommentType.DOC_COMMON;
    }

    private static JsDocElementType getJsDocKeywordType(String string) {
        return JsDocElementType.fromString(string);
    }

    private static boolean textEquals(CharSequence text1, CharSequence text2) {
        if (text1 == text2) {
            return true;
        }
        int len = text1.length();
        if (len == text2.length()) {
            for (int i = len - 1; i >= 0; --i) {
                if (text1.charAt(i) == text2.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean startsWith(CharSequence text, CharSequence prefix) {
        int p_length = prefix.length();
        if (p_length > text.length()) {
            return false;
        }
        for (int x = 0; x < p_length; ++x) {
            if (text.charAt(x) == prefix.charAt(x)) continue;
            return false;
        }
        return true;
    }
}

