/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.filesearch.impl;

import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchParams;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearcher;

public class RemoteFileSearcherImpl
implements FileSearcher {
    private static final java.util.logging.Logger log = Logger.getInstance();

    @Override
    public String searchFile(FileSearchParams fileSearchParams) {
        ExecutionEnvironment execEnv = fileSearchParams.getExecEnv();
        if (execEnv.isLocal()) {
            return null;
        }
        try {
            String path;
            HostInfo hostInfo = HostInfoUtils.getHostInfo(execEnv);
            if (hostInfo == null) {
                return null;
            }
            ArrayList<String> sp = new ArrayList<String>(fileSearchParams.getSearchPaths());
            if (fileSearchParams.isSearchInUserPaths() && (path = hostInfo.getEnvironment().get("PATH")) != null) {
                sp.addAll(Arrays.asList(path.split(":")));
            }
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(execEnv);
            npb.setExecutable(hostInfo.getShell()).setArguments("-s");
            NativeProcess p = npb.call();
            ProcessUtils.ignoreProcessError(p);
            OutputStreamWriter os = new OutputStreamWriter(p.getOutputStream());
            for (String path2 : sp) {
                if (path2.indexOf(34) >= 0) continue;
                os.append("/bin/ls \"").append(path2);
                os.append("/" + fileSearchParams.getFilename() + "\" 2>/dev/null || \\\n");
            }
            os.append("(echo \"Not Found\" && exit 1)\n");
            os.append("exit $?\n");
            os.flush();
            os.close();
            String line = ProcessUtils.readProcessOutputLine(p);
            int result = p.waitFor();
            return result != 0 || line == null || "".equals(line.trim()) ? null : line.trim();
        }
        catch (Throwable th) {
            log.log(Level.FINE, "Execption in UnixFileSearcherImpl:", th);
            return null;
        }
    }
}

