/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.ResourceWrapperEditor;

public final class FormPropertyEditorManager {
    private static Map<String, Map<Class, Class>> editorClassCache;
    private static Map<Class, List<Class>> expliciteEditors;
    private static final String[] DEFAULT_EDITOR_SEARCH_PATH;
    private static Logger logger;

    public static synchronized PropertyEditor findEditor(FormProperty property) {
        FormModel form;
        Class type = property.getValueType();
        List<PropertyEditor> list = FormPropertyEditorManager.findEditors(type, form = property.getPropertyContext().getFormModel(), false);
        return list.isEmpty() ? null : list.get(0);
    }

    public static synchronized PropertyEditor[] getAllEditors(FormProperty property) {
        Class type = property.getValueType();
        FormModel form = property.getPropertyContext().getFormModel();
        List<PropertyEditor> list = FormPropertyEditorManager.findEditors(type, form, true);
        return list.toArray(new PropertyEditor[list.size()]);
    }

    public static synchronized void registerEditor(Class propertyType, Class editorClass) {
        List<Class> classList;
        if (expliciteEditors != null) {
            classList = expliciteEditors.get(propertyType);
        } else {
            classList = null;
            expliciteEditors = new HashMap<Class, List<Class>>();
        }
        if (classList == null) {
            classList = new LinkedList<Class>();
            classList.add(editorClass);
            expliciteEditors.put(propertyType, classList);
        } else if (!classList.contains(editorClass)) {
            classList.add(editorClass);
        }
    }

    private static List<Class> getRegisteredEditorClasses(Class propertyType) {
        List classList = expliciteEditors != null ? expliciteEditors.get(propertyType) : null;
        return classList != null ? classList : Collections.EMPTY_LIST;
    }

    public static PropertyEditor findBasicEditor(Class type) {
        return FormPropertyEditorManager.findPrimaryEditor(type, false);
    }

    private static List<PropertyEditor> findEditors(Class type, FormModel targetForm, boolean all) {
        ArrayList<PropertyEditor> editorList = new ArrayList<PropertyEditor>(5);
        PropertyEditor prEd = FormPropertyEditorManager.findPrimaryEditor(type, true);
        if (prEd != null) {
            editorList.add(prEd);
            if (!all) {
                return editorList;
            }
        }
        if (FormPropertyEditorManager.isEditorInCache(type, "2")) {
            prEd = FormPropertyEditorManager.createEditorFromCache(type, "2");
        } else {
            prEd = null;
            String typeName = type.getSimpleName();
            if (!typeName.contains("[")) {
                Class editorClass = null;
                List<String> defaultSearchPath = Arrays.asList(DEFAULT_EDITOR_SEARCH_PATH);
                for (String path : FormLoaderSettings.getInstance().getEditorSearchPath()) {
                    if (path == null || path.length() <= 0 || defaultSearchPath.contains(path)) continue;
                    String name = path + "." + typeName + "Editor";
                    try {
                        editorClass = FormUtils.loadClass(name, targetForm);
                        prEd = FormPropertyEditorManager.createEditorInstance(editorClass);
                        if (prEd != null) {
                            break;
                        }
                    }
                    catch (Exception exception) {
                    }
                    catch (LinkageError linkageError) {
                        // empty catch block
                    }
                    editorClass = null;
                }
                FormPropertyEditorManager.addEditorClassToCache(type, editorClass, "2");
            }
        }
        if (prEd != null) {
            editorList.add(prEd);
            if (!all) {
                return editorList;
            }
        }
        for (Class cls : FormPropertyEditorManager.getRegisteredEditorClasses(type)) {
            prEd = FormPropertyEditorManager.createEditorInstance(cls);
            if (prEd == null) continue;
            editorList.add(prEd);
            if (all) continue;
            return editorList;
        }
        if (editorList.isEmpty() && FormPropertyEditorManager.isComponentType(type)) {
            editorList.add(new ComponentChooserEditor(new Class[]{type}));
            if (!all) {
                return editorList;
            }
        }
        editorList.add(new RADConnectionPropertyEditor(type, RADConnectionPropertyEditor.Type.FormConnection));
        editorList.add(new RADConnectionPropertyEditor(type, RADConnectionPropertyEditor.Type.CustomCode));
        return editorList;
    }

    private static PropertyEditor findPrimaryEditor(Class type, boolean wrapperAllowed) {
        String cacheKey;
        PropertyEditor prEd = null;
        String string = cacheKey = wrapperAllowed ? "1a" : "1b";
        if (FormPropertyEditorManager.isEditorInCache(type, cacheKey)) {
            prEd = FormPropertyEditorManager.createEditorFromCache(type, cacheKey);
        } else {
            String typeName = type.getSimpleName();
            if (!typeName.contains("[") && !type.equals(Object.class)) {
                Class editorClass = null;
                for (String path : DEFAULT_EDITOR_SEARCH_PATH) {
                    String name = path + "." + typeName + "Editor";
                    try {
                        editorClass = FormUtils.loadSystemClass(name);
                        if ((wrapperAllowed || !ResourceWrapperEditor.class.isAssignableFrom(editorClass)) && (prEd = FormPropertyEditorManager.createEditorInstance(editorClass)) != null) {
                            break;
                        }
                    }
                    catch (Exception exception) {
                    }
                    catch (LinkageError linkageError) {
                        // empty catch block
                    }
                    editorClass = null;
                }
                FormPropertyEditorManager.addEditorClassToCache(type, editorClass, cacheKey);
            }
        }
        if (prEd == null) {
            cacheKey = "1c";
            if (FormPropertyEditorManager.isEditorInCache(type, cacheKey)) {
                prEd = FormPropertyEditorManager.createEditorFromCache(type, cacheKey);
            } else {
                prEd = type != Object.class ? PropertyEditorManager.findEditor(type) : null;
                FormPropertyEditorManager.addEditorToCache(type, prEd, cacheKey);
            }
        }
        return prEd;
    }

    private static boolean isEditorInCache(Class propertyType, String key) {
        return FormPropertyEditorManager.getEditorClassCache(key).containsKey(propertyType);
    }

    private static PropertyEditor createEditorFromCache(Class propertyType, String key) {
        Class editorClass = FormPropertyEditorManager.getEditorClassCache(key).get(propertyType);
        return editorClass != null ? FormPropertyEditorManager.createEditorInstance(editorClass) : null;
    }

    private static void addEditorToCache(Class propertyType, PropertyEditor editor, String key) {
        if (editor == null) {
            FormPropertyEditorManager.addEditorClassToCache(propertyType, null, key);
        } else {
            Class<?> editorClass = editor.getClass();
            try {
                Constructor<?> ctor = editorClass.getConstructor(new Class[0]);
                if (ctor != null && (ctor.getModifiers() & 1) == 1) {
                    FormPropertyEditorManager.addEditorClassToCache(propertyType, editorClass, key);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private static void addEditorClassToCache(Class propertyType, Class editorClass, String key) {
        FormPropertyEditorManager.getEditorClassCache(key).put(propertyType, editorClass);
    }

    private static Map<Class, Class> getEditorClassCache(String key) {
        Map<Class, Class> classCache;
        if (editorClassCache == null) {
            editorClassCache = new HashMap<String, Map<Class, Class>>();
        }
        if ((classCache = editorClassCache.get(key)) == null) {
            classCache = new WeakHashMap<Class, Class>();
            editorClassCache.put(key, classCache);
        }
        return classCache;
    }

    private static boolean isComponentType(Class type) {
        return !type.equals(Object.class) && !type.equals(String.class) && !type.isEnum() && !type.isPrimitive() && !Number.class.isAssignableFrom(type);
    }

    private static PropertyEditor createEditorInstance(Class cls) {
        try {
            return (PropertyEditor)cls.newInstance();
        }
        catch (Exception ex) {
            FormPropertyEditorManager.log(ex, "Error instantiating property editor: " + cls.getName());
        }
        catch (LinkageError ex) {
            FormPropertyEditorManager.log(ex, "Error instantiating property editor: " + cls.getName());
        }
        return null;
    }

    private static void log(Throwable ex, String msg) {
        if (logger == null) {
            logger = Logger.getLogger(FormPropertyEditorManager.class.getName());
        }
        logger.log(Level.INFO, msg, ex);
    }

    static {
        DEFAULT_EDITOR_SEARCH_PATH = new String[]{"org.netbeans.modules.form.editors2", "org.netbeans.beaninfo.editors", "org.netbeans.modules.swingapp"};
    }
}

