/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.actions.AlignAction;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AddSubItemAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(AddSubItemAction.class, (String)"ACT_AddFromPalette");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] activatedNodes) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu popupMenu = new JMenu(NbBundle.getMessage(AddSubItemAction.class, (String)"ACT_AddFromPalette"));
        popupMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)popupMenu, (String)AlignAction.class.getName());
        popupMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JMenu menu = (JMenu)e.getSource();
                AddSubItemAction.this.createInsertSubmenu(menu);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return popupMenu;
    }

    private void createInsertSubmenu(JMenu menu) {
        if (menu.getMenuComponentCount() <= 0) {
            HashSet<Class> classes = new HashSet<Class>();
            TreeSet<PaletteItem> items = new TreeSet<PaletteItem>(new Comparator<PaletteItem>(){

                @Override
                public int compare(PaletteItem item1, PaletteItem item2) {
                    String name1 = item1.getNode().getDisplayName();
                    String name2 = item2.getNode().getDisplayName();
                    return name1.compareTo(name2);
                }
            });
            for (PaletteItem item : PaletteUtils.getAllItems()) {
                Class clazz = item.getComponentClass();
                if (clazz == null || classes.contains(clazz) || !JMenuItem.class.isAssignableFrom(clazz) && !JSeparator.class.isAssignableFrom(clazz)) continue;
                classes.add(clazz);
                items.add(item);
            }
            for (PaletteItem item : items) {
                JMenuItem menuitem = new JMenuItem(item.getNode().getDisplayName());
                menuitem.addActionListener(new AddListener(item));
                menu.add(menuitem);
            }
        }
    }

    private static Node[] getNodes() {
        return ComponentInspector.getInstance().getExplorerManager().getSelectedNodes();
    }

    private class AddListener
    implements ActionListener {
        private PaletteItem pItem;

        public AddListener(PaletteItem pItem) {
            this.pItem = pItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Node[] nds;
            for (Node nd : nds = AddSubItemAction.getNodes()) {
                if (!(nd instanceof RADComponentNode)) continue;
                RADComponentNode rnode = (RADComponentNode)nd;
                RADComponent comp = rnode.getRADComponent();
                MenuEditLayer.addComponentToEndOfMenu(comp, this.pItem);
            }
        }
    }
}

