/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.json.spi.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class JsonPreferences {
    public static final String PROP_COMMENT_SUPPORTED = "commentSupported";
    private static final String PREF_JSON_COMMENTS = "json.comments";
    private final Project project;
    private final PropertyChangeSupport listeners;
    private final PreferenceChangeListener pcl = e -> this.fireChange(e.getKey());
    private final AtomicReference<Preferences> prefsRef;
    private final AtomicBoolean listens;

    private JsonPreferences(@NonNull Project project) {
        this.project = project;
        this.listeners = new PropertyChangeSupport(this);
        this.prefsRef = new AtomicReference();
        this.listens = new AtomicBoolean();
    }

    public boolean isCommentSupported() {
        Preferences prefs = this.getPreferences();
        return prefs.getBoolean(PREF_JSON_COMMENTS, false);
    }

    public void setCommentSupported(boolean supported) {
        Preferences prefs = this.getPreferences();
        if (supported) {
            prefs.putBoolean(PREF_JSON_COMMENTS, supported);
        } else {
            prefs.remove(PREF_JSON_COMMENTS);
        }
    }

    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        if (!this.listens.get() && this.listens.compareAndSet(false, true)) {
            Preferences p = this.getPreferences();
            p.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.pcl, (Object)p));
        }
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.removePropertyChangeListener(listener);
    }

    private Preferences getPreferences() {
        Preferences pref = this.prefsRef.get();
        if (pref == null && !this.prefsRef.compareAndSet(null, pref = ProjectUtils.getPreferences((Project)this.project, JsonPreferences.class, (boolean)true))) {
            pref = this.prefsRef.get();
            assert (pref != null);
        }
        return pref;
    }

    private void fireChange(@NonNull String key) {
        String prop = null;
        switch (key) {
            case "json.comments": {
                prop = PROP_COMMENT_SUPPORTED;
            }
        }
        if (prop != null) {
            this.listeners.firePropertyChange(key, null, null);
        }
    }

    @NonNull
    public static JsonPreferences forProject(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return new JsonPreferences(project);
    }
}

