/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.context.FacesContext;
import org.primefaces.context.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogNavigationHandler
extends ConfigurableNavigationHandler {
    private ConfigurableNavigationHandler base;

    public DialogNavigationHandler(ConfigurableNavigationHandler base) {
        this.base = base;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        RequestContext requestContext = RequestContext.getCurrentInstance();
        Map<Object, Object> attrs = requestContext.getAttributes();
        String dialogOutcome = (String)attrs.get("dialog.outcome");
        if (dialogOutcome != null) {
            NavigationCase navCase = this.getNavigationCase(context, fromAction, dialogOutcome);
            String toViewId = navCase.getToViewId(context);
            Map params = (Map)attrs.get("dialog.params");
            if (params == null) {
                params = Collections.emptyMap();
            }
            String url = context.getApplication().getViewHandler().getBookmarkableURL(context, toViewId, params, false);
            Map options = (Map)attrs.get("dialog.options");
            StringBuilder sb = new StringBuilder();
            String sourceComponentId = (String)attrs.get("dialog.source.component");
            String sourceWidget = (String)attrs.get("dialog.source.widget");
            String pfdlgcid = UUID.randomUUID().toString();
            sb.append("PrimeFaces.openDialog({url:'").append(url).append("',pfdlgcid:'").append(pfdlgcid).append("',sourceComponentId:'").append(sourceComponentId).append("'");
            if (sourceWidget != null) {
                sb.append(",sourceWidget:PF('").append(sourceWidget).append("')");
            }
            sb.append(",options:{");
            if (options != null && options.size() > 0) {
                Iterator it = options.keySet().iterator();
                while (it.hasNext()) {
                    String optionName = (String)it.next();
                    Object optionValue = options.get(optionName);
                    sb.append(optionName).append(":").append(optionValue);
                    if (!it.hasNext()) continue;
                    sb.append(",");
                }
            }
            sb.append("}});");
            requestContext.execute(sb.toString());
            sb.setLength(0);
        } else {
            this.base.handleNavigation(context, fromAction, outcome);
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        return this.base.getNavigationCase(context, fromAction, outcome);
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this.base.getNavigationCases();
    }
}

